/*
 * Decompiled with CFR 0.152.
 */
package com.alet.common.structure.type.programable.advanced;

import com.alet.client.gui.controls.programmable.functions.GuiFunction;
import com.alet.client.gui.controls.programmable.nodes.GuiNodeValue;
import com.alet.common.structure.type.programable.advanced.LittleProgramableStructureALET;
import com.alet.common.structure.type.programable.advanced.nodes.values.NodeFunction;
import com.alet.common.structure.type.programable.advanced.nodes.values.NodeValue;
import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class Function {
    public LittleProgramableStructureALET structure;
    private final String NAME;
    public int id;
    public NodeFunction methodSender;
    public NodeFunction methodReciever;
    public List<NodeValue> senderNodes = new ArrayList<NodeValue>();
    public List<NodeValue> recieverNodes = new ArrayList<NodeValue>();
    private boolean isMethodSender;
    private boolean isMethodReciever;
    private final int COLOR;
    protected static final int ACTIVATOR_COLOR = 0xFFFFFF;
    protected static final int EVENT_COLOR = 0xFFFFFF;
    protected static final int CONDITION_COLOR = 0xFFFFFF;
    protected static final int GETTER_COLOR = 0xFFFFFF;
    protected static final int VALUE_COLOR = 0xFFFFFF;
    protected static final int CAST_COLOR = 0xFFFFFF;
    protected static final int FLOW_COLOR = 0xFFFFFF;

    public Function(String name, int id, int color) {
        this.NAME = name;
        this.id = id;
        this.COLOR = color;
        this.isMethodReciever = false;
        this.isMethodSender = false;
        this.setMethodNodes();
        this.setFunctionNodes();
    }

    public Function setAsSender() {
        this.isMethodSender = true;
        return this;
    }

    public Function setAsReciever() {
        this.isMethodReciever = true;
        return this;
    }

    public static Function guiToFunction(GuiFunction guiFunction) {
        return null;
    }

    private void setMethodNodes() {
        if (this.isMethodSender()) {
            this.methodSender = new NodeFunction("method_sender", "", false);
        }
        if (this.isMethodReciever()) {
            this.methodReciever = new NodeFunction("method_reciever", "", false);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public List<GuiNodeValue> setGuiNodes() {
        ArrayList<GuiNodeValue> nodes = new ArrayList<GuiNodeValue>();
        try {
            for (NodeValue node : this.senderNodes) {
                nodes.add(node.getGuiNode());
            }
            for (NodeValue node : this.recieverNodes) {
                nodes.add(node.getGuiNode());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return nodes;
    }

    public abstract void setFunctionNodes();

    @SideOnly(value=Side.SERVER)
    public abstract void setValues();

    @SideOnly(value=Side.SERVER)
    public Function getNextFunction() {
        return (Function)this.methodReciever.getNodeValue();
    }

    public String getName() {
        return this.NAME;
    }

    public int getColor() {
        return this.COLOR;
    }

    public boolean isMethodReciever() {
        return this.isMethodReciever;
    }

    public boolean isMethodSender() {
        return this.isMethodSender;
    }

    public static enum FunctionType {
        ACTIVATOR,
        EVENTS,
        CONDITION,
        FLOW,
        GETTER;

    }
}

