/*
 * Decompiled with CFR 0.152.
 */
package com.alet.common.structure.type.premade.transfer;

import com.alet.client.container.SubContainerLittleHopper;
import com.alet.common.utils.StructureUtils;
import com.creativemd.creativecore.common.utils.mc.InventoryUtils;
import com.creativemd.creativecore.common.utils.type.HashMapList;
import com.creativemd.littletiles.client.gui.handler.LittleStructureGuiHandler;
import com.creativemd.littletiles.common.action.LittleActionException;
import com.creativemd.littletiles.common.action.block.LittleActionActivated;
import com.creativemd.littletiles.common.structure.LittleStructure;
import com.creativemd.littletiles.common.structure.directional.StructureDirectional;
import com.creativemd.littletiles.common.structure.exception.CorruptedConnectionException;
import com.creativemd.littletiles.common.structure.exception.NotYetConnectedException;
import com.creativemd.littletiles.common.structure.registry.LittleStructureType;
import com.creativemd.littletiles.common.structure.relative.StructureRelative;
import com.creativemd.littletiles.common.structure.signal.output.InternalSignalOutput;
import com.creativemd.littletiles.common.structure.type.LittleNoClipStructure;
import com.creativemd.littletiles.common.structure.type.LittleStorage;
import com.creativemd.littletiles.common.structure.type.premade.LittleStructurePremade;
import com.creativemd.littletiles.common.tile.LittleTile;
import com.creativemd.littletiles.common.tile.math.box.LittleBox;
import com.creativemd.littletiles.common.tile.parent.IStructureTileList;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;

public class LittleTransferLittleHopper
extends LittleStructurePremade {
    @StructureDirectional(color=-16776961)
    public StructureRelative input;
    @StructureDirectional(color=-23296)
    public StructureRelative output;
    @StructureDirectional
    public EnumFacing facing;
    private LittleStructure listeningInputStructure;
    private LittleStructure listeningOutputStructure;
    public boolean active = true;
    public boolean trigger = false;
    private boolean hasInputNeigborCache = false;
    private boolean hasOutputNeigborCache = false;
    public HashSet<Entity> entities = new HashSet();
    int counter = 0;
    private List<SubContainerLittleHopper> openContainers = new ArrayList<SubContainerLittleHopper>();
    public InventoryBasic inventory = new InventoryBasic("basic", false, 5);

    public LittleTransferLittleHopper(LittleStructureType type, IStructureTileList mainBlock) {
        super(type, mainBlock);
    }

    public void neighbourChanged() {
        if (this.isClient()) {
            return;
        }
        this.listeningInputStructure = null;
        this.listeningOutputStructure = null;
        this.hasInputNeigborCache = false;
        this.hasOutputNeigborCache = false;
    }

    public boolean onBlockActivated(World worldIn, LittleTile tile, BlockPos pos, EntityPlayer playerIn, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ, LittleActionActivated action) throws LittleActionException {
        if (playerIn.func_70093_af()) {
            if (this.listeningOutputStructure != null && this.listeningInputStructure != null) {
                playerIn.func_146105_b((ITextComponent)new TextComponentString("Input/Output succesfully found."), true);
            } else if (this.listeningOutputStructure == null && this.listeningInputStructure == null) {
                playerIn.func_146105_b((ITextComponent)new TextComponentString("Input/Output failed to be found."), true);
            } else if (this.listeningOutputStructure == null) {
                if (this.listeningInputStructure != null) {
                    playerIn.func_146105_b((ITextComponent)new TextComponentString("Input succesfully found."), true);
                } else {
                    playerIn.func_146105_b((ITextComponent)new TextComponentString("Input failed to be found."), true);
                }
            } else if (this.listeningInputStructure == null) {
                if (this.listeningOutputStructure != null) {
                    playerIn.func_146105_b((ITextComponent)new TextComponentString("Output succesfully found."), true);
                } else {
                    playerIn.func_146105_b((ITextComponent)new TextComponentString("Output failed to be found."), true);
                }
            }
        } else if (!worldIn.field_72995_K && !this.hasPlayerOpened(playerIn)) {
            LittleStructureGuiHandler.openGui((String)"little_hopper", (NBTTagCompound)new NBTTagCompound(), (EntityPlayer)playerIn, (LittleStructure)this);
        }
        return true;
    }

    public LittleStructure findConnection(StructureRelative searchArea) {
        World worldIn = this.getWorld();
        LittleBox foundBox = searchArea.getBox().copy();
        double searchX = searchArea.getCenter().x;
        double searchY = searchArea.getCenter().y;
        double searchZ = searchArea.getCenter().z;
        BlockPos structurePos = this.getStructureLocation().pos;
        BlockPos posSearch = new BlockPos((double)structurePos.func_177958_n() + searchX, (double)structurePos.func_177956_o() + searchY, (double)structurePos.func_177952_p() + searchZ);
        HashMapList boxesSearch = new HashMapList();
        foundBox.split(searchArea.getContext(), structurePos, boxesSearch, null);
        for (Map.Entry b : boxesSearch.entrySet()) {
            if (!((BlockPos)b.getKey()).equals((Object)posSearch)) continue;
            foundBox = (LittleBox)((ArrayList)b.getValue()).get(0);
        }
        return StructureUtils.getStructureAt(worldIn, foundBox, posSearch, searchArea.getContext(), (LittleStructure)this, LittleStorage.class);
    }

    protected void loadFromNBTExtra(NBTTagCompound nbt) {
        if (nbt.func_74764_b("inventory")) {
            this.inventory = InventoryUtils.loadInventoryBasic((NBTTagCompound)nbt.func_74775_l("inventory"));
        }
    }

    protected void writeToNBTExtra(NBTTagCompound nbt) {
        if (this.inventory != null) {
            nbt.func_74782_a("inventory", (NBTBase)InventoryUtils.saveInventoryBasic((IInventory)this.inventory));
        }
    }

    public void hopperToStorage() {
        LittleStorage storage = (LittleStorage)this.listeningOutputStructure;
        for (int i = 0; i < 5; ++i) {
            ItemStack stack = this.inventory.func_70301_a(i).func_77946_l();
            if (!this.roomForInStorage(stack)) continue;
            this.inventory.func_70298_a(i, 1);
            stack.func_190920_e(1);
            storage.inventory.func_174894_a(stack);
            if (!stack.func_77973_b().equals(Items.field_190931_a)) break;
        }
    }

    public void storageToHopper() {
        LittleStorage storage = (LittleStorage)this.listeningInputStructure;
        for (int i = 0; i < storage.inventorySize; ++i) {
            ItemStack stack = storage.inventory.func_70301_a(i).func_77946_l();
            if (!this.roomForInHopper(stack)) continue;
            storage.inventory.func_70298_a(i, 1);
            stack.func_190920_e(1);
            this.inventory.func_174894_a(stack);
            if (!stack.func_77973_b().equals(Items.field_190931_a)) break;
        }
    }

    public void itemToHopper(List<EntityItem> entityList) {
        if (!entityList.isEmpty()) {
            for (EntityItem entityItem : entityList) {
                ItemStack stack = entityItem.func_92059_d().func_77946_l();
                if (!this.roomForInHopper(stack)) continue;
                stack = this.inventory.func_174894_a(entityItem.func_92059_d());
                if (stack.func_190926_b()) {
                    entityItem.func_92058_a(stack);
                    entityItem.func_70106_y();
                    break;
                }
                if (stack.func_190916_E() >= 64) break;
                entityItem.func_92058_a(stack);
                break;
            }
            entityList.clear();
        }
    }

    public boolean roomForInHopper(ItemStack item) {
        for (int i = 0; i < 5; ++i) {
            ItemStack stack = this.inventory.func_70301_a(i);
            if (stack.func_77973_b().equals(Items.field_190931_a)) {
                return true;
            }
            if (stack.func_190916_E() >= 64 || !item.func_77973_b().equals(stack.func_77973_b()) || item.func_77960_j() != stack.func_77960_j()) continue;
            return true;
        }
        return false;
    }

    public boolean roomForInStorage(ItemStack item) {
        LittleStorage storage = (LittleStorage)this.listeningOutputStructure;
        for (int i = 0; i < storage.numberOfSlots; ++i) {
            ItemStack stack = storage.inventory.func_70301_a(i);
            if (stack.func_77973_b().equals(Items.field_190931_a)) {
                return true;
            }
            if (stack.func_190916_E() >= 64 || !item.func_77973_b().equals(stack.func_77973_b()) || item.func_77960_j() != stack.func_77960_j()) continue;
            return true;
        }
        return false;
    }

    public void dropItemFromStorage() {
        for (int i = 0; i < 5; ++i) {
            if (this.inventory.func_70301_a(i).func_77973_b().equals(Items.field_190931_a)) continue;
            ItemStack stack = this.inventory.func_70301_a(i).func_77946_l();
            stack.func_190920_e(1);
            double x = this.output.getCenter().x;
            double y = this.output.getCenter().y - 0.5;
            double z = this.output.getCenter().z;
            EntityItem item = new EntityItem(this.getWorld(), (double)this.getStructureLocation().pos.func_177958_n() + x, (double)this.getStructureLocation().pos.func_177956_o() + y, (double)this.getStructureLocation().pos.func_177952_p() + z, stack);
            item.field_70159_w = 0.0;
            item.field_70181_x = 0.0;
            item.field_70179_y = 0.0;
            this.getWorld().func_72838_d((Entity)item);
            if (!this.isStillAvailable()) break;
            this.inventory.func_70298_a(i, 1);
            break;
        }
    }

    public void addItemToStorage(EntityItem itemToAdd) {
        LittleStorage storage = (LittleStorage)this.listeningOutputStructure;
        for (int i = 0; i < storage.inventorySize; ++i) {
            if (!storage.inventory.func_70301_a(i).func_77973_b().equals(Items.field_190931_a) && !storage.inventory.func_70301_a(i).func_77973_b().equals(itemToAdd.func_92059_d().func_77973_b())) continue;
            ItemStack stack = storage.inventory.func_174894_a(itemToAdd.func_92059_d());
            if (stack.func_190926_b()) {
                itemToAdd.func_92058_a(stack);
                itemToAdd.func_70106_y();
                break;
            }
            if (stack.func_190916_E() >= 64) break;
            itemToAdd.func_92058_a(stack);
            break;
        }
    }

    public List<EntityItem> collectItems() {
        try {
            LittleNoClipStructure noclip = (LittleNoClipStructure)this.children.get(0).getStructure();
            return this.getWorld().func_72872_a(EntityItem.class, noclip.getSurroundingBox().getAABB());
        }
        catch (CorruptedConnectionException | NotYetConnectedException e) {
            e.printStackTrace();
            return new ArrayList<EntityItem>();
        }
    }

    public void performInternalOutputChange(InternalSignalOutput output) {
        if (((LittleStructureType.InternalComponentOutput)output.component).is("active")) {
            this.active = !output.getState()[0];
        }
    }

    public void tick() {
        if (!this.isClient() && this.active) {
            ++this.counter;
            if (this.counter >= 11) {
                this.counter = 0;
                this.trigger = true;
            }
            if (this.trigger) {
                if (!this.hasInputNeigborCache) {
                    this.listeningInputStructure = this.findConnection(this.input);
                    this.hasInputNeigborCache = true;
                }
                if (!this.hasOutputNeigborCache) {
                    this.listeningOutputStructure = this.findConnection(this.output);
                    this.hasOutputNeigborCache = true;
                }
                if (this.listeningOutputStructure != null) {
                    this.hopperToStorage();
                } else {
                    this.dropItemFromStorage();
                }
                this.itemToHopper(this.collectItems());
                if (this.listeningInputStructure != null) {
                    this.storageToHopper();
                }
            }
            this.trigger = false;
        }
    }

    public boolean hasPlayerOpened(EntityPlayer player) {
        for (SubContainerLittleHopper container : this.openContainers) {
            if (container.getPlayer() != player) continue;
            return true;
        }
        return false;
    }

    public void openContainer(SubContainerLittleHopper container) {
        this.openContainers.add(container);
    }

    public void closeContainer(SubContainerLittleHopper container) {
        this.openContainers.remove((Object)container);
    }
}

