/*
 * Decompiled with CFR 0.152.
 */
package com.alet.common.structure.type.premade.transfer;

import com.creativemd.creativecore.common.utils.math.BooleanUtils;
import com.creativemd.littletiles.client.gui.handler.LittleStructureGuiHandler;
import com.creativemd.littletiles.common.action.LittleActionException;
import com.creativemd.littletiles.common.action.block.LittleActionActivated;
import com.creativemd.littletiles.common.structure.LittleStructure;
import com.creativemd.littletiles.common.structure.exception.CorruptedConnectionException;
import com.creativemd.littletiles.common.structure.exception.NotYetConnectedException;
import com.creativemd.littletiles.common.structure.registry.LittleStructureType;
import com.creativemd.littletiles.common.structure.type.LittleNoClipStructure;
import com.creativemd.littletiles.common.structure.type.premade.LittleStructurePremade;
import com.creativemd.littletiles.common.structure.type.premade.signal.LittleSignalOutput;
import com.creativemd.littletiles.common.tile.LittleTile;
import com.creativemd.littletiles.common.tile.parent.IStructureTileList;
import java.util.ArrayList;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class LittleTransferItemScanner
extends LittleStructurePremade {
    private ItemStack stack;
    private boolean matched;
    private boolean itemExists;
    private boolean hasMultiply;

    public LittleTransferItemScanner(LittleStructureType type, IStructureTileList mainBlock) {
        super(type, mainBlock);
    }

    public void tick() {
        if (!this.isClient()) {
            try {
                LittleSignalOutput itemStack = (LittleSignalOutput)this.children.get(0).getStructure();
                LittleSignalOutput multiplyItems = (LittleSignalOutput)this.children.get(3).getStructure();
                LittleNoClipStructure noClip = (LittleNoClipStructure)this.children.get(2).getStructure();
                ArrayList<EntityItem> items = new ArrayList<EntityItem>();
                if (!noClip.entities.isEmpty()) {
                    for (Entity entity : noClip.entities) {
                        if (!(entity instanceof EntityItem)) continue;
                        items.add((EntityItem)entity);
                    }
                }
                if (!items.isEmpty()) {
                    if (items.size() == 1) {
                        this.stack = ((EntityItem)items.get(0)).func_92059_d();
                        multiplyItems.updateState(BooleanUtils.SINGLE_TRUE);
                        itemStack.updateState(BooleanUtils.toBits((int)this.stack.func_190916_E(), (int)16));
                    } else {
                        multiplyItems.updateState(BooleanUtils.SINGLE_FALSE);
                        itemStack.updateState(BooleanUtils.toBits((int)0, (int)16));
                    }
                } else {
                    multiplyItems.updateState(BooleanUtils.SINGLE_FALSE);
                    itemStack.updateState(BooleanUtils.toBits((int)0, (int)16));
                }
            }
            catch (CorruptedConnectionException | NotYetConnectedException throwable) {
                // empty catch block
            }
        }
    }

    public boolean onBlockActivated(World worldIn, LittleTile tile, BlockPos pos, EntityPlayer playerIn, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ, LittleActionActivated action) throws LittleActionException {
        if (!worldIn.field_72995_K) {
            LittleStructureGuiHandler.openGui((String)"item_scanner", (NBTTagCompound)new NBTTagCompound(), (EntityPlayer)playerIn, (LittleStructure)this);
        }
        return true;
    }

    protected void loadFromNBTExtra(NBTTagCompound nbt) {
        if (nbt.func_74764_b("matched")) {
            this.matched = nbt.func_74767_n("matched");
        }
        if (nbt.func_74764_b("itemExists")) {
            this.itemExists = nbt.func_74767_n("itemExists");
        }
        if (nbt.func_74764_b("hasMultiply")) {
            this.hasMultiply = nbt.func_74767_n("hasMultiply");
        }
    }

    protected void writeToNBTExtra(NBTTagCompound nbt) {
        nbt.func_74757_a("matched", this.matched);
        nbt.func_74757_a("itemExists", this.itemExists);
        nbt.func_74757_a("hasMultiply", this.hasMultiply);
    }
}

