/*
 * Decompiled with CFR 0.152.
 */
package com.alet.common.structure.type.premade.signal;

import com.alet.common.utils.StructureUtils;
import com.creativemd.creativecore.client.rendering.RenderBox;
import com.creativemd.creativecore.common.utils.math.RotationUtils;
import com.creativemd.creativecore.common.utils.math.box.AlignedBox;
import com.creativemd.littletiles.LittleTiles;
import com.creativemd.littletiles.client.gui.handler.LittleStructureGuiHandler;
import com.creativemd.littletiles.client.render.tile.LittleRenderBox;
import com.creativemd.littletiles.common.action.LittleActionException;
import com.creativemd.littletiles.common.action.block.LittleActionActivated;
import com.creativemd.littletiles.common.structure.LittleStructure;
import com.creativemd.littletiles.common.structure.directional.StructureDirectional;
import com.creativemd.littletiles.common.structure.registry.LittleStructureType;
import com.creativemd.littletiles.common.structure.relative.StructureRelative;
import com.creativemd.littletiles.common.structure.signal.component.SignalComponentType;
import com.creativemd.littletiles.common.structure.type.premade.signal.LittleSignalCableBase;
import com.creativemd.littletiles.common.structure.type.premade.signal.LittleSignalOutput;
import com.creativemd.littletiles.common.tile.LittleTile;
import com.creativemd.littletiles.common.tile.math.box.LittleBox;
import com.creativemd.littletiles.common.tile.math.vec.LittleVec;
import com.creativemd.littletiles.common.tile.parent.IStructureTileList;
import com.creativemd.littletiles.common.tile.place.PlacePreview;
import com.creativemd.littletiles.common.tile.place.PlacePreviewFacing;
import com.creativemd.littletiles.common.tile.preview.LittlePreviews;
import com.creativemd.littletiles.common.util.grid.LittleGridContext;
import com.creativemd.littletiles.common.util.vec.SurroundingBox;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class LittleSignalOutputQuick
extends LittleSignalOutput {
    @StructureDirectional(color=-16711936)
    public StructureRelative frame;
    private LittleStructure listeningStructure;

    public LittleSignalOutputQuick(LittleStructureType type, IStructureTileList mainBlock) {
        super(type, mainBlock);
    }

    public boolean onBlockActivated(World worldIn, LittleTile tile, BlockPos pos, EntityPlayer playerIn, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ, LittleActionActivated action) throws LittleActionException {
        if (this.getParent() == null) {
            this.listeningStructure = StructureUtils.findConnection(this.getWorld(), this.getStructureLocation().pos, this.frame, (LittleStructure)this, null);
            if (this.listeningStructure != null && StructureUtils.mergeChildToStructure((LittleStructure)this, this.listeningStructure, true, this.getWorld(), new LittleVec(0, 0, 0), side, playerIn)) {
                playerIn.func_146105_b((ITextComponent)new TextComponentString("Connection was succesful, right to open interface."), true);
            }
        }
        if (!playerIn.func_70093_af()) {
            if (!worldIn.field_72995_K && this.getParent() != null) {
                LittleStructureGuiHandler.openGui((String)"signal_interface", (NBTTagCompound)new NBTTagCompound(), (EntityPlayer)playerIn, (LittleStructure)this);
            }
        } else if (this.getParent() != null) {
            if (StructureUtils.removeThisDynamicChild((LittleStructure)this)) {
                playerIn.func_146105_b((ITextComponent)new TextComponentString("Connection succesfully disconnected."), true);
            } else {
                playerIn.func_146105_b((ITextComponent)new TextComponentString("Connection failed to disconnected."), true);
            }
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void renderFace(EnumFacing facing, LittleGridContext context, LittleBox renderBox, int distance, EnumFacing.Axis axis, EnumFacing.Axis one, EnumFacing.Axis two, boolean positive, boolean oneSidedRenderer, List<LittleRenderBox> cubes) {
        super.renderFace(facing, context, renderBox.copy(), distance, axis, one, two, positive, oneSidedRenderer, cubes);
        LittleRenderBox cube = renderBox.getRenderingCube(context, LittleTiles.outputArrow, facing.ordinal());
        cube.keepVU = true;
        cube.allowOverlap = true;
        if (positive) {
            cube.setMin(axis, cube.getMax(axis));
            cube.setMax(axis, cube.getMax(axis) + (float)context.toVanillaGrid(renderBox.getSize(axis)) * 0.7f);
        } else {
            cube.setMax(axis, cube.getMin(axis));
            cube.setMin(axis, cube.getMin(axis) - (float)context.toVanillaGrid(renderBox.getSize(axis)) * 0.7f);
        }
        float shrink = 0.14f;
        float shrinkOne = cube.getSize(one) * shrink;
        float shrinkTwo = cube.getSize(two) * shrink;
        cube.setMin(one, cube.getMin(one) + shrinkOne);
        cube.setMax(one, cube.getMax(one) - shrinkOne);
        cube.setMin(two, cube.getMin(two) + shrinkTwo);
        cube.setMax(two, cube.getMax(two) - shrinkTwo);
        cubes.add(cube);
    }

    @SideOnly(value=Side.CLIENT)
    public void render(SurroundingBox box, LittleBox overallBox, List<LittleRenderBox> cubes) {
        for (int i = 0; i < this.faces.length; ++i) {
            if (this.faces[i] == null) continue;
            int distance = this.faces[i].distance;
            EnumFacing facing = this.getFacing(i);
            EnumFacing.Axis axis = facing.func_176740_k();
            EnumFacing.Axis one = RotationUtils.getOne((EnumFacing.Axis)axis);
            EnumFacing.Axis two = RotationUtils.getTwo((EnumFacing.Axis)axis);
            boolean positive = facing.func_176743_c() == EnumFacing.AxisDirection.POSITIVE;
            LittleGridContext context = this.faces[i].context;
            LittleBox renderBox = overallBox.copy();
            if (box.getContext().size > context.size) {
                distance *= box.getContext().size / context.size;
                context = box.getContext();
            } else if (context.size > box.getContext().size) {
                renderBox.convertTo(box.getContext(), context);
            }
            this.renderFace(facing, context, renderBox, distance, axis, one, two, positive, this.faces[i].oneSidedRenderer, cubes);
        }
        AlignedBox structureBox = new AlignedBox(overallBox.getBox(box.getContext()));
        LittleRenderBox block = new LittleRenderBox(structureBox, null, (Block)LittleTiles.dyeableBlock, 0).setColor(this.color);
        block.allowOverlap = true;
        cubes.add(block);
        EnumFacing.Axis axis = this.facing.func_176740_k();
        RenderBox cube = new RenderBox(structureBox, (Block)LittleTiles.dyeableBlock, 0);
        float thickness = cube.getSize(axis) * 0.12f;
        float sizePercentage = 0.25f;
        EnumFacing.Axis one = RotationUtils.getOne((EnumFacing.Axis)axis);
        EnumFacing.Axis two = RotationUtils.getTwo((EnumFacing.Axis)axis);
        float sizeOne = cube.getSize(one);
        float sizeTwo = cube.getSize(two);
        float middlePart = 0.1f;
        float sizeOneInside = sizeOne - sizeOne * sizePercentage * 2.0f;
        float sizeTwoInside = sizeTwo - sizeTwo * sizePercentage * 2.0f;
        if (this.facing.func_176743_c() == EnumFacing.AxisDirection.POSITIVE) {
            cube.setMin(axis, cube.getMax(axis));
            cube.setMax(axis, cube.getMax(axis) + thickness);
        } else {
            cube.setMax(axis, cube.getMin(axis));
            cube.setMin(axis, cube.getMin(axis) - thickness);
        }
        LittleRenderBox left = new LittleRenderBox((AlignedBox)cube, null, (Block)LittleTiles.dyeableBlock, 0).setColor(-23296);
        left.setMin(one, left.getMin(one) + sizeOne * sizePercentage);
        left.setMax(one, left.getMin(one) + sizeOneInside * middlePart);
        left.setMin(two, left.getMin(two) + sizeTwo * sizePercentage);
        left.setMax(two, left.getMax(two) - sizeTwo * sizePercentage);
        cubes.add(left);
        LittleRenderBox right = new LittleRenderBox((AlignedBox)cube, null, (Block)LittleTiles.dyeableBlock, 0).setColor(-23296);
        right.setMax(one, right.getMax(one) - sizeOne * sizePercentage);
        right.setMin(one, right.getMax(one) - sizeOneInside * middlePart);
        right.setMin(two, right.getMin(two) + sizeTwo * sizePercentage);
        right.setMax(two, right.getMax(two) - sizeTwo * sizePercentage);
        cubes.add(right);
        LittleRenderBox bottom = new LittleRenderBox((AlignedBox)cube, null, (Block)LittleTiles.dyeableBlock, 0).setColor(-23296);
        bottom.setMin(one, bottom.getMin(one) + sizeOne * sizePercentage);
        bottom.setMax(one, bottom.getMax(one) - sizeOne * sizePercentage);
        bottom.setMin(two, bottom.getMin(two) + sizeTwo * sizePercentage);
        bottom.setMax(two, bottom.getMin(two) + sizeTwoInside * middlePart);
        cubes.add(bottom);
        LittleRenderBox top = new LittleRenderBox((AlignedBox)cube, null, (Block)LittleTiles.dyeableBlock, 0).setColor(-23296);
        top.setMin(one, top.getMin(one) + sizeOne * sizePercentage);
        top.setMax(one, top.getMax(one) - sizeOne * sizePercentage);
        top.setMax(two, top.getMax(two) - sizeTwo * sizePercentage);
        top.setMin(two, top.getMax(two) - sizeTwoInside * middlePart);
        cubes.add(top);
    }

    @SideOnly(value=Side.CLIENT)
    public void initRenderFace(EnumFacing facing, LittleGridContext context, LittleBox renderBox, int distance, EnumFacing.Axis axis, EnumFacing.Axis one, EnumFacing.Axis two, boolean positive, boolean oneSidedRenderer, List<LittleRenderBox> cubes) {
        if (positive) {
            renderBox.setMin(axis, renderBox.getMax(axis));
            renderBox.setMax(axis, renderBox.getMax(axis) + distance);
        } else {
            renderBox.setMax(axis, renderBox.getMin(axis));
            renderBox.setMin(axis, renderBox.getMin(axis) - distance);
        }
        LittleRenderBox cube = renderBox.getRenderingCube(context, LittleTiles.singleCable, axis.ordinal());
        if (!oneSidedRenderer) {
            if (positive) {
                cube.setMax(axis, cube.getMin(axis) + cube.getSize(axis) / 2.0f);
            } else {
                cube.setMin(axis, cube.getMax(axis) - cube.getSize(axis) / 2.0f);
            }
        }
        cube.color = this.color;
        cube.keepVU = true;
        cube.allowOverlap = true;
        float shrink = 0.18f;
        float shrinkOne = cube.getSize(one) * shrink;
        float shrinkTwo = cube.getSize(two) * shrink;
        cube.setMin(one, cube.getMin(one) + shrinkOne);
        cube.setMax(one, cube.getMax(one) - shrinkOne);
        cube.setMin(two, cube.getMin(two) + shrinkTwo);
        cube.setMax(two, cube.getMax(two) - shrinkTwo);
        cubes.add(cube);
    }

    @SideOnly(value=Side.CLIENT)
    public void initRender(SurroundingBox box, LittleBox overallBox, List<LittleRenderBox> cubes) {
        for (int i = 0; i < this.faces.length; ++i) {
            if (this.faces[i] == null) continue;
            int distance = this.faces[i].distance;
            EnumFacing facing = this.getFacing(i);
            EnumFacing.Axis axis = facing.func_176740_k();
            EnumFacing.Axis one = RotationUtils.getOne((EnumFacing.Axis)axis);
            EnumFacing.Axis two = RotationUtils.getTwo((EnumFacing.Axis)axis);
            boolean positive = facing.func_176743_c() == EnumFacing.AxisDirection.POSITIVE;
            LittleGridContext context = this.faces[i].context;
            LittleBox renderBox = overallBox.copy();
            if (box.getContext().size > context.size) {
                distance *= box.getContext().size / context.size;
                context = box.getContext();
            } else if (context.size > box.getContext().size) {
                renderBox.convertTo(box.getContext(), context);
            }
            this.initRenderFace(facing, context, renderBox, distance, axis, one, two, positive, this.faces[i].oneSidedRenderer, cubes);
        }
    }

    public static class LittleStructureTypeOutputQuick
    extends LittleSignalCableBase.LittleStructureTypeNetwork {
        public LittleStructureTypeOutputQuick(String id, String category, Class<? extends LittleStructure> structureClass, int attribute, String modid, int bandwidth) {
            super(id, category, structureClass, attribute, modid, bandwidth, 1);
        }

        public List<PlacePreview> getSpecialTiles(LittlePreviews previews) {
            List result = super.getSpecialTiles(previews);
            EnumFacing facing = (EnumFacing)this.loadDirectional(previews, "facing");
            LittleBox box = previews.getSurroundingBox();
            result.add(new PlacePreviewFacing(box, facing, -65536));
            return result;
        }

        @SideOnly(value=Side.CLIENT)
        public List<RenderBox> getRenderingCubes(LittlePreviews previews) {
            ArrayList<RenderBox> cubes = new ArrayList<RenderBox>();
            float size = (float)((Math.sqrt(this.bandwidth) * 1.0 / 32.0 + 0.05) * 1.4);
            cubes = new ArrayList();
            cubes.add(new RenderBox(0.0f, 0.5f - size, 0.5f - size, size * 2.0f, 0.5f + size, 0.5f + size, (Block)LittleTiles.dyeableBlock).setColor(this.getColor(previews)));
            cubes.add(new RenderBox(size * 2.0f, 0.5f - size, 0.5f - size, size * 2.5f, 0.5f + size, 0.5f + size, (Block)LittleTiles.dyeableBlock).setColor(-65536));
            return cubes;
        }

        public int getBandwidth() {
            return this.bandwidth;
        }

        public void changed() {
        }

        public boolean[] getState() {
            return null;
        }

        public SignalComponentType getType() {
            return SignalComponentType.OUTPUT;
        }
    }
}

