/*
 * Decompiled with CFR 0.152.
 */
package com.alet.common.structure.type.premade.signal;

import com.alet.common.utils.StructureUtils;
import com.creativemd.creativecore.client.rendering.RenderBox;
import com.creativemd.creativecore.common.utils.math.RotationUtils;
import com.creativemd.creativecore.common.utils.math.box.AlignedBox;
import com.creativemd.littletiles.LittleTiles;
import com.creativemd.littletiles.client.gui.handler.LittleStructureGuiHandler;
import com.creativemd.littletiles.client.render.tile.LittleRenderBox;
import com.creativemd.littletiles.common.action.LittleActionException;
import com.creativemd.littletiles.common.action.block.LittleActionActivated;
import com.creativemd.littletiles.common.structure.LittleStructure;
import com.creativemd.littletiles.common.structure.directional.StructureDirectional;
import com.creativemd.littletiles.common.structure.registry.LittleStructureType;
import com.creativemd.littletiles.common.structure.relative.StructureRelative;
import com.creativemd.littletiles.common.structure.signal.component.SignalComponentType;
import com.creativemd.littletiles.common.structure.type.premade.signal.LittleSignalCableBase;
import com.creativemd.littletiles.common.structure.type.premade.signal.LittleSignalInput;
import com.creativemd.littletiles.common.tile.LittleTile;
import com.creativemd.littletiles.common.tile.math.box.LittleBox;
import com.creativemd.littletiles.common.tile.math.vec.LittleVec;
import com.creativemd.littletiles.common.tile.parent.IStructureTileList;
import com.creativemd.littletiles.common.tile.place.PlacePreview;
import com.creativemd.littletiles.common.tile.place.PlacePreviewFacing;
import com.creativemd.littletiles.common.tile.preview.LittlePreviews;
import com.creativemd.littletiles.common.util.grid.LittleGridContext;
import com.creativemd.littletiles.common.util.vec.SurroundingBox;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class LittleSignalInputQuick
extends LittleSignalInput {
    private boolean hasConnectionCache = false;
    @StructureDirectional(color=-16711936)
    public StructureRelative frame;
    private LittleStructure listeningStructure;

    public LittleSignalInputQuick(LittleStructureType type, IStructureTileList mainBlock) {
        super(type, mainBlock);
    }

    public boolean onBlockActivated(World worldIn, LittleTile tile, BlockPos pos, EntityPlayer playerIn, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ, LittleActionActivated action) throws LittleActionException {
        if (this.getParent() == null) {
            this.listeningStructure = StructureUtils.findConnection(this.getWorld(), this.getStructureLocation().pos, this.frame, (LittleStructure)this, null);
            if (this.listeningStructure != null && StructureUtils.mergeChildToStructure((LittleStructure)this, this.listeningStructure, true, worldIn, new LittleVec(0, 0, 0), side, playerIn)) {
                playerIn.func_146105_b((ITextComponent)new TextComponentString("Connection was succesful, right click to open interface."), true);
            }
        }
        if (!playerIn.func_70093_af()) {
            if (!worldIn.field_72995_K && this.getParent() != null) {
                LittleStructureGuiHandler.openGui((String)"signal_interface", (NBTTagCompound)new NBTTagCompound(), (EntityPlayer)playerIn, (LittleStructure)this);
            }
        } else if (this.getParent() != null) {
            if (StructureUtils.removeThisDynamicChild((LittleStructure)this)) {
                playerIn.func_146105_b((ITextComponent)new TextComponentString("Connection succesfully disconnected."), true);
            } else {
                playerIn.func_146105_b((ITextComponent)new TextComponentString("Connection failed to disconnected."), true);
            }
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void renderFace(EnumFacing facing, LittleGridContext context, LittleBox renderBox, int distance, EnumFacing.Axis axis, EnumFacing.Axis one, EnumFacing.Axis two, boolean positive, boolean oneSidedRenderer, List<LittleRenderBox> cubes) {
        super.renderFace(facing, context, renderBox.copy(), distance, axis, one, two, positive, oneSidedRenderer, cubes);
        LittleRenderBox cube = renderBox.getRenderingCube(context, LittleTiles.inputArrow, facing.ordinal());
        cube.keepVU = true;
        cube.allowOverlap = true;
        if (positive) {
            cube.setMin(axis, cube.getMax(axis));
            cube.setMax(axis, cube.getMax(axis) + (float)context.toVanillaGrid(renderBox.getSize(axis)) * 0.7f);
        } else {
            cube.setMax(axis, cube.getMin(axis));
            cube.setMin(axis, cube.getMin(axis) - (float)context.toVanillaGrid(renderBox.getSize(axis)) * 0.7f);
        }
        float shrink = 0.14f;
        float shrinkOne = cube.getSize(one) * shrink;
        float shrinkTwo = cube.getSize(two) * shrink;
        cube.setMin(one, cube.getMin(one) + shrinkOne);
        cube.setMax(one, cube.getMax(one) - shrinkOne);
        cube.setMin(two, cube.getMin(two) + shrinkTwo);
        cube.setMax(two, cube.getMax(two) - shrinkTwo);
        cubes.add(cube);
    }

    @SideOnly(value=Side.CLIENT)
    public void render(SurroundingBox box, LittleBox overallBox, List<LittleRenderBox> cubes) {
        for (int i = 0; i < this.faces.length; ++i) {
            if (this.faces[i] == null) continue;
            int distance = this.faces[i].distance;
            EnumFacing facing = this.getFacing(i);
            EnumFacing.Axis axis = facing.func_176740_k();
            EnumFacing.Axis one = RotationUtils.getOne((EnumFacing.Axis)axis);
            EnumFacing.Axis two = RotationUtils.getTwo((EnumFacing.Axis)axis);
            boolean positive = facing.func_176743_c() == EnumFacing.AxisDirection.POSITIVE;
            LittleGridContext context = this.faces[i].context;
            LittleBox renderBox = overallBox.copy();
            if (box.getContext().size > context.size) {
                distance *= box.getContext().size / context.size;
                context = box.getContext();
            } else if (context.size > box.getContext().size) {
                renderBox.convertTo(box.getContext(), context);
            }
            this.renderFace(facing, context, renderBox, distance, axis, one, two, positive, this.faces[i].oneSidedRenderer, cubes);
        }
        AlignedBox cube = new AlignedBox(overallBox.getBox(box.getContext()));
        EnumFacing.Axis axis = this.facing.func_176740_k();
        float sizePercentage = 0.25f;
        EnumFacing.Axis one = RotationUtils.getOne((EnumFacing.Axis)axis);
        EnumFacing.Axis two = RotationUtils.getTwo((EnumFacing.Axis)axis);
        float sizeOne = cube.getSize(one);
        float sizeTwo = cube.getSize(two);
        float sizeAxis = cube.getSize(axis);
        LittleRenderBox top = new LittleRenderBox(cube, null, (Block)LittleTiles.dyeableBlock, 0).setColor(this.color);
        top.allowOverlap = true;
        top.setMin(one, top.getMax(one) - sizeOne * sizePercentage);
        cubes.add(top);
        LittleRenderBox bottom = new LittleRenderBox(cube, null, (Block)LittleTiles.dyeableBlock, 0).setColor(this.color);
        bottom.allowOverlap = true;
        bottom.setMax(one, bottom.getMin(one) + sizeOne * sizePercentage);
        cubes.add(bottom);
        LittleRenderBox left = new LittleRenderBox(cube, null, (Block)LittleTiles.dyeableBlock, 0).setColor(this.color);
        left.allowOverlap = true;
        left.setMin(two, top.getMax(two) - sizeTwo * sizePercentage);
        cubes.add(left);
        LittleRenderBox right = new LittleRenderBox(cube, null, (Block)LittleTiles.dyeableBlock, 0).setColor(this.color);
        right.allowOverlap = true;
        right.setMax(two, right.getMin(two) + sizeTwo * sizePercentage);
        cubes.add(right);
        LittleRenderBox behind = new LittleRenderBox(cube, null, (Block)LittleTiles.dyeableBlock, 0).setColor(this.color);
        behind.allowOverlap = true;
        float depth = sizeAxis * 0.12f;
        behind.setMin(one, behind.getMin(one) + sizeOne * sizePercentage);
        behind.setMax(one, behind.getMax(one) - sizeOne * sizePercentage);
        behind.setMin(two, behind.getMin(two) + sizeTwo * sizePercentage);
        behind.setMax(two, behind.getMax(two) - sizeTwo * sizePercentage);
        if (this.facing.func_176743_c() == EnumFacing.AxisDirection.POSITIVE) {
            behind.setMax(axis, behind.getMin(axis) + sizeAxis * 0.5f);
        } else {
            behind.setMin(axis, behind.getMax(axis) - sizeAxis * 0.5f);
        }
        cubes.add(behind);
        LittleRenderBox front = new LittleRenderBox(cube, null, (Block)LittleTiles.dyeableBlock, 0).setColor(-16740609);
        front.allowOverlap = true;
        front.setMin(one, front.getMin(one) + sizeOne * sizePercentage);
        front.setMax(one, front.getMax(one) - sizeOne * sizePercentage);
        front.setMin(two, front.getMin(two) + sizeTwo * sizePercentage);
        front.setMax(two, front.getMax(two) - sizeTwo * sizePercentage);
        if (this.facing.func_176743_c() == EnumFacing.AxisDirection.POSITIVE) {
            front.setMin(axis, front.getMax(axis) - sizeAxis * 0.5f);
            front.setMax(axis, front.getMax(axis) - depth);
        } else {
            front.setMax(axis, front.getMin(axis) + sizeAxis * 0.5f);
            front.setMin(axis, front.getMin(axis) + depth);
        }
        cubes.add(front);
        float thickness = 1.0E-4f;
        LittleRenderBox frontTop = new LittleRenderBox(cube, null, (Block)LittleTiles.dyeableBlock, 0).setColor(-16740609);
        frontTop.allowOverlap = true;
        frontTop.setMin(one, frontTop.getMin(one) + sizeOne * sizePercentage);
        frontTop.setMax(one, frontTop.getMin(one) + thickness);
        frontTop.setMin(two, frontTop.getMin(two) + sizeTwo * sizePercentage);
        frontTop.setMax(two, frontTop.getMax(two) - sizeTwo * sizePercentage);
        if (this.facing.func_176743_c() == EnumFacing.AxisDirection.POSITIVE) {
            frontTop.setMin(axis, frontTop.getMax(axis) - sizeAxis * sizePercentage);
        } else {
            frontTop.setMax(axis, frontTop.getMin(axis) + sizeAxis * sizePercentage);
        }
        cubes.add(frontTop);
        LittleRenderBox frontBottom = new LittleRenderBox(cube, null, (Block)LittleTiles.dyeableBlock, 0).setColor(-16740609);
        frontBottom.allowOverlap = true;
        frontBottom.setMax(one, frontBottom.getMax(one) - sizeOne * sizePercentage);
        frontBottom.setMin(one, frontBottom.getMax(one) - thickness);
        frontBottom.setMin(two, frontBottom.getMin(two) + sizeTwo * sizePercentage);
        frontBottom.setMax(two, frontBottom.getMax(two) - sizeTwo * sizePercentage);
        if (this.facing.func_176743_c() == EnumFacing.AxisDirection.POSITIVE) {
            frontBottom.setMin(axis, frontBottom.getMax(axis) - sizeAxis * sizePercentage);
        } else {
            frontBottom.setMax(axis, frontBottom.getMin(axis) + sizeAxis * sizePercentage);
        }
        cubes.add(frontBottom);
        LittleRenderBox frontRight = new LittleRenderBox(cube, null, (Block)LittleTiles.dyeableBlock, 0).setColor(-16740609);
        frontRight.allowOverlap = true;
        frontRight.setMin(one, frontRight.getMin(one) + sizeOne * sizePercentage);
        frontRight.setMax(one, frontRight.getMax(one) - sizeOne * sizePercentage);
        frontRight.setMin(two, frontRight.getMin(two) + sizeTwo * sizePercentage);
        frontRight.setMax(two, frontRight.getMin(two) + thickness);
        if (this.facing.func_176743_c() == EnumFacing.AxisDirection.POSITIVE) {
            frontRight.setMin(axis, frontRight.getMax(axis) - sizeAxis * sizePercentage);
        } else {
            frontRight.setMax(axis, frontRight.getMin(axis) + sizeAxis * sizePercentage);
        }
        cubes.add(frontRight);
        LittleRenderBox frontLeft = new LittleRenderBox(cube, null, (Block)LittleTiles.dyeableBlock, 0).setColor(-16740609);
        frontLeft.allowOverlap = true;
        frontLeft.setMin(one, frontLeft.getMin(one) + sizeOne * sizePercentage);
        frontLeft.setMax(one, frontLeft.getMax(one) - sizeOne * sizePercentage);
        frontLeft.setMax(two, frontLeft.getMax(two) - sizeTwo * sizePercentage);
        frontLeft.setMin(two, frontLeft.getMax(two) - thickness);
        if (this.facing.func_176743_c() == EnumFacing.AxisDirection.POSITIVE) {
            frontLeft.setMin(axis, frontLeft.getMax(axis) - sizeAxis * sizePercentage);
        } else {
            frontLeft.setMax(axis, frontLeft.getMin(axis) + sizeAxis * sizePercentage);
        }
        cubes.add(frontLeft);
        float middlePart = 0.1f;
        float sizeOneInside = sizeOne - sizeOne * sizePercentage * 2.0f;
        float sizeTwoInside = sizeTwo - sizeTwo * sizePercentage * 2.0f;
        LittleRenderBox middleBack = new LittleRenderBox(cube, null, (Block)LittleTiles.dyeableBlock, 0).setColor(-16740609);
        middleBack.allowOverlap = true;
        middleBack.setMin(one, middleBack.getMin(one) + sizeOne * sizePercentage + sizeOneInside * middlePart);
        middleBack.setMax(one, middleBack.getMax(one) - sizeOne * sizePercentage - sizeOneInside * middlePart);
        middleBack.setMin(two, middleBack.getMin(two) + sizeTwo * sizePercentage + sizeTwoInside * middlePart);
        middleBack.setMax(two, middleBack.getMax(two) - sizeTwo * sizePercentage - sizeTwoInside * middlePart);
        if (this.facing.func_176743_c() == EnumFacing.AxisDirection.POSITIVE) {
            middleBack.setMin(axis, middleBack.getMax(axis) - sizeAxis * sizePercentage);
            middleBack.setMax(axis, middleBack.getMax(axis) - thickness);
        } else {
            middleBack.setMin(axis, middleBack.getMin(axis) + thickness);
            middleBack.setMax(axis, middleBack.getMin(axis) + sizeAxis * sizePercentage);
        }
        cubes.add(middleBack);
        LittleRenderBox middleFront = new LittleRenderBox((AlignedBox)middleBack, null, (Block)LittleTiles.dyeableBlock, 0).setColor(this.color);
        middleFront.allowOverlap = true;
        if (this.facing.func_176743_c() == EnumFacing.AxisDirection.POSITIVE) {
            middleFront.setMin(axis, middleFront.getMax(axis) - thickness);
        } else {
            middleFront.setMax(axis, middleFront.getMin(axis) + thickness);
        }
        cubes.add(middleFront);
    }

    @SideOnly(value=Side.CLIENT)
    public void initRenderFace(EnumFacing facing, LittleGridContext context, LittleBox renderBox, int distance, EnumFacing.Axis axis, EnumFacing.Axis one, EnumFacing.Axis two, boolean positive, boolean oneSidedRenderer, List<LittleRenderBox> cubes) {
        if (positive) {
            renderBox.setMin(axis, renderBox.getMax(axis));
            renderBox.setMax(axis, renderBox.getMax(axis) + distance);
        } else {
            renderBox.setMax(axis, renderBox.getMin(axis));
            renderBox.setMin(axis, renderBox.getMin(axis) - distance);
        }
        LittleRenderBox cube = renderBox.getRenderingCube(context, LittleTiles.singleCable, axis.ordinal());
        if (!oneSidedRenderer) {
            if (positive) {
                cube.setMax(axis, cube.getMin(axis) + cube.getSize(axis) / 2.0f);
            } else {
                cube.setMin(axis, cube.getMax(axis) - cube.getSize(axis) / 2.0f);
            }
        }
        cube.color = this.color;
        cube.keepVU = true;
        cube.allowOverlap = true;
        float shrink = 0.18f;
        float shrinkOne = cube.getSize(one) * shrink;
        float shrinkTwo = cube.getSize(two) * shrink;
        cube.setMin(one, cube.getMin(one) + shrinkOne);
        cube.setMax(one, cube.getMax(one) - shrinkOne);
        cube.setMin(two, cube.getMin(two) + shrinkTwo);
        cube.setMax(two, cube.getMax(two) - shrinkTwo);
        cubes.add(cube);
    }

    @SideOnly(value=Side.CLIENT)
    public void initRender(SurroundingBox box, LittleBox overallBox, List<LittleRenderBox> cubes) {
        for (int i = 0; i < this.faces.length; ++i) {
            if (this.faces[i] == null) continue;
            int distance = this.faces[i].distance;
            EnumFacing facing = this.getFacing(i);
            EnumFacing.Axis axis = facing.func_176740_k();
            EnumFacing.Axis one = RotationUtils.getOne((EnumFacing.Axis)axis);
            EnumFacing.Axis two = RotationUtils.getTwo((EnumFacing.Axis)axis);
            boolean positive = facing.func_176743_c() == EnumFacing.AxisDirection.POSITIVE;
            LittleGridContext context = this.faces[i].context;
            LittleBox renderBox = overallBox.copy();
            if (box.getContext().size > context.size) {
                distance *= box.getContext().size / context.size;
                context = box.getContext();
            } else if (context.size > box.getContext().size) {
                renderBox.convertTo(box.getContext(), context);
            }
            this.initRenderFace(facing, context, renderBox, distance, axis, one, two, positive, this.faces[i].oneSidedRenderer, cubes);
        }
    }

    public static class LittleStructureTypeInputQuick
    extends LittleSignalCableBase.LittleStructureTypeNetwork {
        public LittleStructureTypeInputQuick(String id, String category, Class<? extends LittleStructure> structureClass, int attribute, String modid, int bandwidth) {
            super(id, category, structureClass, attribute, modid, bandwidth, 1);
        }

        public List<PlacePreview> getSpecialTiles(LittlePreviews previews) {
            List result = super.getSpecialTiles(previews);
            EnumFacing facing = (EnumFacing)this.loadDirectional(previews, "facing");
            LittleBox box = previews.getSurroundingBox();
            result.add(new PlacePreviewFacing(box, facing, 0x800080));
            return result;
        }

        @SideOnly(value=Side.CLIENT)
        public List<RenderBox> getRenderingCubes(LittlePreviews previews) {
            ArrayList<RenderBox> cubes = new ArrayList<RenderBox>();
            float size = (float)((Math.sqrt(this.bandwidth) * 1.0 / 32.0 + 0.05) * 1.4);
            cubes = new ArrayList();
            cubes.add(new RenderBox(0.0f, 0.5f - size, 0.5f - size, size * 2.0f, 0.5f + size, 0.5f + size, (Block)LittleTiles.dyeableBlock).setColor(this.getColor(previews)));
            cubes.add(new RenderBox(size * 2.0f, 0.5f - size, 0.5f - size, size * 2.5f, 0.5f + size, 0.5f + size, (Block)LittleTiles.dyeableBlock).setColor(0x800080));
            return cubes;
        }

        public int getBandwidth() {
            return this.bandwidth;
        }

        public void changed() {
        }

        public boolean[] getState() {
            return null;
        }

        public SignalComponentType getType() {
            return SignalComponentType.INPUT;
        }
    }
}

