/*
 * Decompiled with CFR 0.152.
 */
package com.alet.common.structure.type.premade.signal;

import com.alet.common.structure.type.premade.signal.LittleCircuitPremade;
import com.alet.common.utils.SignalingUtils;
import com.creativemd.littletiles.common.structure.exception.CorruptedConnectionException;
import com.creativemd.littletiles.common.structure.exception.NotYetConnectedException;
import com.creativemd.littletiles.common.structure.registry.LittleStructureType;
import com.creativemd.littletiles.common.structure.type.premade.signal.LittleSignalInput;
import com.creativemd.littletiles.common.structure.type.premade.signal.LittleSignalOutput;
import com.creativemd.littletiles.common.tile.parent.IStructureTileList;
import net.minecraft.nbt.NBTTagCompound;

public class LittleCircuitPulser
extends LittleCircuitPremade {
    private boolean start = false;
    private int max = 0;
    private int tickCount = 0;

    public LittleCircuitPulser(LittleStructureType type, IStructureTileList mainBlock) {
        super(type, mainBlock, 1);
        this.setInputIndexes(0);
    }

    private boolean tickCounting() {
        ++this.tickCount;
        if (this.tickCount >= this.max + 1) {
            this.tickCount = 0;
            this.start = false;
            return false;
        }
        return this.tickCount >= this.max;
    }

    protected void loadFromNBTExtra(NBTTagCompound nbt) {
        this.start = nbt.func_74767_n("start");
        this.max = nbt.func_74762_e("max");
        this.tickCount = nbt.func_74762_e("tickCount");
    }

    protected void writeToNBTExtra(NBTTagCompound nbt) {
        nbt.func_74757_a("start", this.start);
        nbt.func_74768_a("max", this.max);
        nbt.func_74768_a("tickCount", this.tickCount);
    }

    public void tick() {
        if (!this.isClient() && this.start) {
            try {
                LittleSignalOutput pulse = (LittleSignalOutput)this.children.get(2).getStructure();
                pulse.updateState(new boolean[]{this.tickCounting()});
            }
            catch (CorruptedConnectionException | NotYetConnectedException throwable) {
                // empty catch block
            }
        }
    }

    @Override
    public void trigger(int clockValue) {
        if (!this.start) {
            try {
                LittleSignalInput count = (LittleSignalInput)this.children.get(0).getStructure();
                this.max = SignalingUtils.boolToInt((boolean[])count.getState().clone());
                this.start = true;
            }
            catch (CorruptedConnectionException | NotYetConnectedException e) {
                e.printStackTrace();
            }
        }
    }
}

