/*
 * Decompiled with CFR 0.152.
 */
package com.alet.common.structure.type.premade.signal;

import com.alet.common.utils.SignalingUtils;
import com.creativemd.littletiles.common.structure.exception.CorruptedConnectionException;
import com.creativemd.littletiles.common.structure.exception.NotYetConnectedException;
import com.creativemd.littletiles.common.structure.registry.LittleStructureType;
import com.creativemd.littletiles.common.structure.signal.component.ISignalComponent;
import com.creativemd.littletiles.common.structure.type.premade.LittleStructurePremade;
import com.creativemd.littletiles.common.structure.type.premade.signal.LittleSignalInput;
import com.creativemd.littletiles.common.structure.type.premade.signal.LittleSignalOutput;
import com.creativemd.littletiles.common.tile.parent.IStructureTileList;
import net.minecraft.util.text.translation.I18n;

public abstract class LittleCircuitPremade
extends LittleStructurePremade {
    private final int clockIndex;
    private int[] inputIndexes;
    private int[] outputIndexes;
    public boolean checkForZero = false;

    public LittleCircuitPremade(LittleStructureType type, IStructureTileList mainBlock, int clockIndex) {
        super(type, mainBlock);
        this.clockIndex = clockIndex;
    }

    public void setInputIndexes(int ... inputIndexes) {
        int[] temp = new int[inputIndexes.length + 2];
        for (int i = 0; i < inputIndexes.length; ++i) {
            temp[i] = inputIndexes[i];
        }
        temp[inputIndexes.length + 1] = this.clockIndex;
        this.inputIndexes = temp;
    }

    public void setOutputIndexes(int ... outputIndexes) {
        this.outputIndexes = outputIndexes;
    }

    public String info() {
        return I18n.func_74838_a((String)("item.LTPremade." + this.type.id + ".name"));
    }

    public void afterPlaced() {
        this.activate();
    }

    public boolean queueTick() {
        this.activate();
        return false;
    }

    public void activate() {
        if (!this.isClient()) {
            try {
                LittleSignalInput clock = (LittleSignalInput)this.children.get(this.clockIndex).getStructure();
                if (clock.getState()[0]) {
                    this.trigger(1);
                } else {
                    if (this.outputIndexes != null) {
                        for (int ouputIndex : this.outputIndexes) {
                            LittleSignalOutput output = (LittleSignalOutput)this.children.get(ouputIndex).getStructure();
                            output.updateState(SignalingUtils.allFalse(output.getBandwidth()));
                        }
                    }
                    if (this.checkForZero) {
                        this.trigger(0);
                    }
                }
            }
            catch (CorruptedConnectionException | NotYetConnectedException e) {
                e.printStackTrace();
            }
        }
    }

    public abstract void trigger(int var1);

    public void changed(ISignalComponent changed) {
        block9: {
            super.changed(changed);
            if (!this.isClient()) {
                try {
                    if (this.clockIndex == -1) break block9;
                    boolean flag1 = false;
                    if (this.inputIndexes != null) {
                        for (int x : this.inputIndexes) {
                            if (x == -1) {
                                flag1 = true;
                            } else {
                                if (this.getChild(x) == null || !this.getChild(x).getStructure().equals(changed)) continue;
                                flag1 = true;
                            }
                            break;
                        }
                    } else {
                        flag1 = true;
                    }
                    if (flag1) {
                        this.queueForNextTick();
                    }
                }
                catch (CorruptedConnectionException | NotYetConnectedException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

