/*
 * Decompiled with CFR 0.152.
 */
package com.alet.common.structure.type.premade.signal;

import com.alet.common.structure.type.premade.signal.LittleCircuitPremade;
import com.alet.common.utils.SignalingUtils;
import com.creativemd.creativecore.common.utils.math.BooleanUtils;
import com.creativemd.littletiles.common.structure.exception.CorruptedConnectionException;
import com.creativemd.littletiles.common.structure.exception.NotYetConnectedException;
import com.creativemd.littletiles.common.structure.registry.LittleStructureType;
import com.creativemd.littletiles.common.structure.type.premade.signal.LittleSignalInput;
import com.creativemd.littletiles.common.structure.type.premade.signal.LittleSignalOutput;
import com.creativemd.littletiles.common.tile.parent.IStructureTileList;
import net.minecraft.nbt.NBTTagCompound;

public class LittleCircuitMath
extends LittleCircuitPremade {
    public LittleCircuitMath(LittleStructureType type, IStructureTileList mainBlock) {
        super(type, mainBlock, 4);
        this.setInputIndexes(0, 1, 3);
        this.setOutputIndexes(2);
    }

    public void math(char operator) throws CorruptedConnectionException, NotYetConnectedException {
        LittleSignalInput in1 = (LittleSignalInput)this.children.get(0).getStructure();
        LittleSignalInput in2 = (LittleSignalInput)this.children.get(1).getStructure();
        LittleSignalOutput out1 = (LittleSignalOutput)this.children.get(2).getStructure();
        int x1 = SignalingUtils.boolToInt(in1.getState());
        int x2 = SignalingUtils.boolToInt(in2.getState());
        if (operator == '+') {
            out1.updateState(BooleanUtils.toBits((int)(x1 + x2), (int)out1.getBandwidth()));
        } else if (operator == '-') {
            out1.updateState(BooleanUtils.toBits((int)(x1 - x2), (int)out1.getBandwidth()));
        } else if (operator == '*') {
            out1.updateState(BooleanUtils.toBits((int)(x1 * x2), (int)out1.getBandwidth()));
        } else if (operator == '/' && x2 != 0) {
            out1.updateState(BooleanUtils.toBits((int)(x1 / x2), (int)out1.getBandwidth()));
        }
    }

    protected void loadFromNBTExtra(NBTTagCompound nbt) {
    }

    protected void writeToNBTExtra(NBTTagCompound nbt) {
    }

    @Override
    public void trigger(int clockValue) {
        try {
            LittleSignalInput math = (LittleSignalInput)this.children.get(3).getStructure();
            int logic = SignalingUtils.boolToInt(math.getState());
            switch (logic) {
                case 0: {
                    this.math('+');
                    break;
                }
                case 1: {
                    this.math('-');
                    break;
                }
                case 2: {
                    this.math('*');
                    break;
                }
                case 3: {
                    this.math('/');
                    break;
                }
            }
        }
        catch (CorruptedConnectionException | NotYetConnectedException e) {
            e.printStackTrace();
        }
    }
}

