/*
 * Decompiled with CFR 0.152.
 */
package com.alet.common.structure.type.premade.signal;

import com.alet.common.utils.SignalingUtils;
import com.alet.font.FontReader;
import com.creativemd.littletiles.common.structure.LittleStructure;
import com.creativemd.littletiles.common.structure.exception.CorruptedConnectionException;
import com.creativemd.littletiles.common.structure.exception.NotYetConnectedException;
import com.creativemd.littletiles.common.structure.registry.LittleStructureType;
import com.creativemd.littletiles.common.structure.type.premade.LittleStructurePremade;
import com.creativemd.littletiles.common.structure.type.premade.signal.LittleSignalInput;
import com.creativemd.littletiles.common.tile.parent.IStructureTileList;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.NBTTagCompound;

public class LittleCircuitDisplay16
extends LittleStructurePremade {
    public List<Boolean> imageBitsTL = new ArrayList<Boolean>();
    public List<Boolean> imageBitsTR = new ArrayList<Boolean>();
    public List<Boolean> imageBitsBL = new ArrayList<Boolean>();
    public List<Boolean> imageBitsBR = new ArrayList<Boolean>();
    public String charDisplayed = "";

    public LittleCircuitDisplay16(LittleStructureType type, IStructureTileList mainBlock) {
        super(type, mainBlock);
    }

    public void tick() {
        if (!this.isClient()) {
            try {
                boolean[] b = ((LittleSignalInput)this.children.get(4).getStructure()).getState();
                boolean[] displayData = new boolean[]{b[0], b[1], b[2], b[3], b[4], b[5], b[6], b[7]};
                boolean[] colorData = new boolean[]{b[8], b[9], b[10], b[11]};
                boolean[] empty = new boolean[]{false, false, false, false};
                displayData = SignalingUtils.mirrorState(displayData);
                colorData = SignalingUtils.mirrorState(colorData);
                String binary = "";
                for (int i = 0; i < 8; ++i) {
                    binary = binary + (displayData[i] ? "1" : "0");
                }
                LittleStructure topLeft = this.getChild(0).getStructure();
                LittleStructure topRight = this.getChild(1).getStructure();
                LittleStructure bottomLeft = this.getChild(2).getStructure();
                LittleStructure bottomRight = this.getChild(3).getStructure();
                int parseInt = Integer.parseInt(binary, 2);
                String c = (char)parseInt + "";
                if (!c.equals(this.charDisplayed)) {
                    this.imageBitsTL.clear();
                    this.imageBitsTR.clear();
                    this.imageBitsBL.clear();
                    this.imageBitsBR.clear();
                    this.decodeImageToBits(c);
                }
                int x = 0;
                for (Boolean bits : this.imageBitsTL) {
                    if (bits.booleanValue()) {
                        topLeft.getOutput(x).updateState(colorData);
                    } else {
                        topLeft.getOutput(x).updateState(empty);
                    }
                    ++x;
                }
                x = 0;
                for (Boolean bits : this.imageBitsTR) {
                    if (bits.booleanValue()) {
                        topRight.getOutput(x).updateState(colorData);
                    } else {
                        topRight.getOutput(x).updateState(empty);
                    }
                    ++x;
                }
                x = 0;
                for (Boolean bits : this.imageBitsBL) {
                    if (bits.booleanValue()) {
                        bottomLeft.getOutput(x).updateState(colorData);
                    } else {
                        bottomLeft.getOutput(x).updateState(empty);
                    }
                    ++x;
                }
                x = 0;
                for (Boolean bits : this.imageBitsBR) {
                    if (bits.booleanValue()) {
                        bottomRight.getOutput(x).updateState(colorData);
                    } else {
                        bottomRight.getOutput(x).updateState(empty);
                    }
                    ++x;
                }
                this.charDisplayed = c;
            }
            catch (CorruptedConnectionException | NotYetConnectedException e) {
                e.printStackTrace();
            }
        }
    }

    public void decodeImageToBits(String character) {
        BufferedImage image = FontReader.fontToPhoto(character, "Press Start 2P", null, 8, -1, 0.0);
        for (int y = 0; y < image.getHeight(); ++y) {
            for (int x = 0; x < image.getWidth(); ++x) {
                if (y >= 0 && y < 4 && x >= 0 && x < 4) {
                    this.imageBitsTL.add(image.getRGB(x, y) != 0);
                }
                if (y >= 0 && y < 4 && x >= 4 && x < 8) {
                    this.imageBitsTR.add(image.getRGB(x, y) != 0);
                }
                if (y >= 4 && y < 8 && x >= 0 && x < 4) {
                    this.imageBitsBL.add(image.getRGB(x, y) != 0);
                }
                if (y < 4 || y >= 8 || x < 4 || x >= 8) continue;
                this.imageBitsBR.add(image.getRGB(x, y) != 0);
            }
        }
    }

    protected void loadFromNBTExtra(NBTTagCompound nbt) {
    }

    protected void writeToNBTExtra(NBTTagCompound nbt) {
    }
}

