/*
 * Decompiled with CFR 0.152.
 */
package com.alet.common.structure.type.premade.signal;

import com.creativemd.littletiles.common.structure.exception.CorruptedConnectionException;
import com.creativemd.littletiles.common.structure.exception.NotYetConnectedException;
import com.creativemd.littletiles.common.structure.registry.LittleStructureType;
import com.creativemd.littletiles.common.structure.type.premade.LittleStructurePremade;
import com.creativemd.littletiles.common.structure.type.premade.signal.LittleSignalOutput;
import com.creativemd.littletiles.common.tile.parent.IStructureTileList;
import net.minecraft.nbt.NBTTagCompound;

public class LittleCircuitClock
extends LittleStructurePremade {
    private boolean pulse = false;
    private int tickCount = 1;

    public LittleCircuitClock(LittleStructureType type, IStructureTileList mainBlock) {
        super(type, mainBlock);
    }

    public void tick() {
        if (!this.isClient()) {
            try {
                LittleSignalOutput out = (LittleSignalOutput)this.children.get(0).getStructure();
                this.pulse = this.tickCounting();
                boolean[] state = new boolean[]{this.pulse};
                out.updateState(state);
            }
            catch (CorruptedConnectionException | NotYetConnectedException e) {
                e.printStackTrace();
            }
        }
    }

    private boolean tickCounting() {
        String id = this.type.id;
        ++this.tickCount;
        if (id.equals("clock_10hz")) {
            if (this.tickCount < 1) {
                return false;
            }
            if (this.tickCount >= 1) {
                if (this.tickCount >= 2) {
                    this.tickCount = 0;
                    return false;
                }
                return true;
            }
        } else if (id.equals("clock_5hz")) {
            if (this.tickCount < 5) {
                return false;
            }
            if (this.tickCount >= 5) {
                if (this.tickCount >= 10) {
                    this.tickCount = 0;
                    return false;
                }
                return true;
            }
        } else if (id.equals("clock_2hz")) {
            if (this.tickCount < 4) {
                return false;
            }
            if (this.tickCount >= 4) {
                if (this.tickCount >= 8) {
                    this.tickCount = 0;
                    return false;
                }
                return true;
            }
        } else if (id.equals("clock_1hz")) {
            if (this.tickCount < 10) {
                return false;
            }
            if (this.tickCount >= 10) {
                if (this.tickCount >= 20) {
                    this.tickCount = 0;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    protected void loadFromNBTExtra(NBTTagCompound nbt) {
        if (nbt.func_74764_b("pulse")) {
            this.pulse = nbt.func_74767_n("pulse");
        }
        if (nbt.func_74764_b("tick")) {
            this.tickCount = nbt.func_74762_e("tick");
        }
    }

    protected void writeToNBTExtra(NBTTagCompound nbt) {
        nbt.func_74757_a("pulse", this.pulse);
        nbt.func_74768_a("tick", this.tickCount);
    }
}

