/*
 * Decompiled with CFR 0.152.
 */
package com.alet.common.structure.type.premade;

import com.alet.client.container.SubContainerFillingCabinet;
import com.creativemd.littletiles.client.gui.handler.LittleStructureGuiHandler;
import com.creativemd.littletiles.common.action.LittleActionException;
import com.creativemd.littletiles.common.action.block.LittleActionActivated;
import com.creativemd.littletiles.common.structure.LittleStructure;
import com.creativemd.littletiles.common.structure.exception.CorruptedConnectionException;
import com.creativemd.littletiles.common.structure.exception.NotYetConnectedException;
import com.creativemd.littletiles.common.structure.registry.LittleStructureType;
import com.creativemd.littletiles.common.structure.type.door.LittleDoorBase;
import com.creativemd.littletiles.common.structure.type.premade.LittleStructurePremade;
import com.creativemd.littletiles.common.tile.LittleTile;
import com.creativemd.littletiles.common.tile.parent.IStructureTileList;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class LittleFillingCabinet
extends LittleStructurePremade {
    private List<SubContainerFillingCabinet> openContainers = new ArrayList<SubContainerFillingCabinet>();

    public LittleFillingCabinet(LittleStructureType type, IStructureTileList mainBlock) {
        super(type, mainBlock);
    }

    protected void loadFromNBTExtra(NBTTagCompound nbt) {
    }

    protected void writeToNBTExtra(NBTTagCompound nbt) {
    }

    public void tick() {
        if (!this.getWorld().field_72995_K) {
            try {
                LittleDoorBase door = (LittleDoorBase)this.getChild(0).getStructure();
                door.getOutput(0).updateState(this.getInput(0).getState());
            }
            catch (CorruptedConnectionException | NotYetConnectedException throwable) {
                // empty catch block
            }
        }
    }

    public void openContainer(SubContainerFillingCabinet container) {
        this.openContainers.add(container);
        this.updateInput();
    }

    public void closeContainer(SubContainerFillingCabinet container) {
        this.openContainers.remove((Object)container);
        this.updateInput();
    }

    public boolean hasPlayerOpened(EntityPlayer player) {
        for (SubContainerFillingCabinet container : this.openContainers) {
            if (container.getPlayer() != player) continue;
            return true;
        }
        return false;
    }

    protected void updateInput() {
        this.getInput(0).updateState(new boolean[]{!this.openContainers.isEmpty()});
    }

    public boolean onBlockActivated(World worldIn, LittleTile tile, BlockPos pos, EntityPlayer player, EnumHand hand, @Nullable ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ, LittleActionActivated action) throws LittleActionException {
        if (!worldIn.field_72995_K && !this.hasPlayerOpened(player)) {
            LittleStructureGuiHandler.openGui((String)"filling_cabinet", (NBTTagCompound)new NBTTagCompound(), (EntityPlayer)player, (LittleStructure)this);
        }
        return true;
    }
}

