/*
 * Decompiled with CFR 0.152.
 */
package com.alet.common.structure.type.premade;

import com.creativemd.littletiles.common.action.LittleActionException;
import com.creativemd.littletiles.common.action.block.LittleActionActivated;
import com.creativemd.littletiles.common.structure.LittleStructure;
import com.creativemd.littletiles.common.structure.directional.StructureDirectional;
import com.creativemd.littletiles.common.structure.directional.StructureDirectionalField;
import com.creativemd.littletiles.common.structure.exception.CorruptedConnectionException;
import com.creativemd.littletiles.common.structure.exception.NotYetConnectedException;
import com.creativemd.littletiles.common.structure.registry.LittleStructureType;
import com.creativemd.littletiles.common.structure.type.premade.LittleStructurePremade;
import com.creativemd.littletiles.common.tile.LittleTile;
import com.creativemd.littletiles.common.tile.math.box.LittleBox;
import com.creativemd.littletiles.common.tile.math.vec.LittleVec;
import com.creativemd.littletiles.common.tile.parent.IStructureTileList;
import com.creativemd.littletiles.common.tile.parent.StructureTileList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;

public abstract class InteractivePremade
extends LittleStructurePremade {
    protected int seriesMaxium;
    protected int seriesAt = 0;
    protected Map<LittleBox, LittleTile> tilePosList = new HashMap<LittleBox, LittleTile>();
    protected LittleBox editArea;
    public AxisAlignedBB absolutePos;
    public LittleBox relativeBox;
    public LittleBox linkedBox;
    @StructureDirectional
    public EnumFacing direction;
    @StructureDirectional
    public EnumFacing facing;

    public InteractivePremade(LittleStructureType type, IStructureTileList mainBlock) {
        super(type, mainBlock);
    }

    public void linkStructure(LittleStructure structure, EnumFacing direction) throws CorruptedConnectionException, NotYetConnectedException {
        int childIndex = this.children.findFreeIndex();
        this.updateChildConnection(childIndex, structure, true);
        structure.updateParentConnection(childIndex, (LittleStructure)this, true);
    }

    protected void loadFromNBTExtra(NBTTagCompound nbt) {
    }

    protected void writeToNBTExtra(NBTTagCompound nbt) {
    }

    public void setEditArea(int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        this.editArea = new LittleBox(minX, minY, minZ, maxX, maxY, maxZ);
    }

    private Vec3d[] adjustRelativeTileVec(BlockPos pos, LittleBox box) {
        return InteractivePremade.adjustRelativeTileVec(pos, box, this.absolutePos, this.direction);
    }

    public static Vec3d[] adjustRelativeTileVec(BlockPos pos, LittleBox box, AxisAlignedBB absolutePos, EnumFacing direction) {
        Vec3d[] relativeVec = new Vec3d[2];
        double aMinX = 0.0;
        double aMinY = 0.0;
        double aMinZ = 0.0;
        double aMaxX = 0.0;
        double aMaxY = 0.0;
        double aMaxZ = 0.0;
        switch (direction) {
            case NORTH: {
                aMinX = (double)box.maxZ / 16.0 + (double)pos.func_177952_p() - absolutePos.field_72334_f;
                aMinY = (double)box.minY / 16.0 + (double)pos.func_177956_o() - absolutePos.field_72338_b;
                aMinZ = (double)box.minX / 16.0 + (double)pos.func_177958_n() - absolutePos.field_72340_a;
                aMaxX = (double)box.minZ / 16.0 + (double)pos.func_177952_p() - absolutePos.field_72334_f;
                aMaxY = (double)box.maxY / 16.0 + (double)pos.func_177956_o() - absolutePos.field_72338_b;
                aMaxZ = (double)box.maxX / 16.0 + (double)pos.func_177958_n() - absolutePos.field_72340_a;
                break;
            }
            case EAST: {
                aMinX = (double)box.minX / 16.0 + (double)pos.func_177958_n() - absolutePos.field_72340_a;
                aMinY = (double)box.minY / 16.0 + (double)pos.func_177956_o() - absolutePos.field_72338_b;
                aMinZ = (double)box.minZ / 16.0 + (double)pos.func_177952_p() - absolutePos.field_72339_c;
                aMaxX = (double)box.maxX / 16.0 + (double)pos.func_177958_n() - absolutePos.field_72340_a;
                aMaxY = (double)box.maxY / 16.0 + (double)pos.func_177956_o() - absolutePos.field_72338_b;
                aMaxZ = (double)box.maxZ / 16.0 + (double)pos.func_177952_p() - absolutePos.field_72339_c;
                break;
            }
            case SOUTH: {
                aMinX = (double)box.minZ / 16.0 + (double)pos.func_177952_p() - absolutePos.field_72339_c;
                aMinY = (double)box.minY / 16.0 + (double)pos.func_177956_o() - absolutePos.field_72338_b;
                aMinZ = (double)box.maxX / 16.0 + (double)pos.func_177958_n() - absolutePos.field_72336_d;
                aMaxX = (double)box.maxZ / 16.0 + (double)pos.func_177952_p() - absolutePos.field_72339_c;
                aMaxY = (double)box.maxY / 16.0 + (double)pos.func_177956_o() - absolutePos.field_72338_b;
                aMaxZ = (double)box.minX / 16.0 + (double)pos.func_177958_n() - absolutePos.field_72336_d;
                break;
            }
            case WEST: {
                aMinX = (double)box.maxX / 16.0 + (double)pos.func_177958_n() - absolutePos.field_72336_d;
                aMinY = (double)box.minY / 16.0 + (double)pos.func_177956_o() - absolutePos.field_72338_b;
                aMinZ = (double)box.maxZ / 16.0 + (double)pos.func_177952_p() - absolutePos.field_72334_f;
                aMaxX = (double)box.minX / 16.0 + (double)pos.func_177958_n() - absolutePos.field_72336_d;
                aMaxY = (double)box.maxY / 16.0 + (double)pos.func_177956_o() - absolutePos.field_72338_b;
                aMaxZ = (double)box.minZ / 16.0 + (double)pos.func_177952_p() - absolutePos.field_72334_f;
                break;
            }
        }
        relativeVec[0] = new Vec3d(Math.abs(aMinX), Math.abs(aMinY), Math.abs(aMinZ));
        relativeVec[1] = new Vec3d(Math.abs(aMaxX), Math.abs(aMaxY), Math.abs(aMaxZ));
        return relativeVec;
    }

    public void collectAllTiles() throws CorruptedConnectionException, NotYetConnectedException {
        for (IStructureTileList iStructureTileList : this.blocksList()) {
            iStructureTileList.getTe().updateTiles(a -> {
                StructureTileList list = a.get(iStructureTileList);
                ArrayList tileLs = new ArrayList();
                BlockPos pos = iStructureTileList.getTe().func_174877_v();
                for (LittleTile littleTile : list) {
                    Vec3d[] relativeVec = this.adjustRelativeTileVec(pos, littleTile.getBox());
                    Vec3d relativeMin = relativeVec[0];
                    Vec3d relativeMax = relativeVec[1];
                    LittleBox relativeBox = new LittleBox(new LittleVec((int)(relativeMin.field_72450_a * 16.0), (int)(relativeMin.field_72448_b * 16.0), (int)(relativeMin.field_72449_c * 16.0)), new LittleVec((int)(relativeMax.field_72450_a * 16.0), (int)(relativeMax.field_72448_b * 16.0), (int)(relativeMax.field_72449_c * 16.0)));
                    this.tilePosList.put(relativeBox, littleTile);
                }
            });
        }
    }

    public void getRelativeBox() throws CorruptedConnectionException, NotYetConnectedException {
        for (IStructureTileList iStructureTileList : this.blocksList()) {
            iStructureTileList.getTe().updateTiles(a -> {
                StructureTileList list = a.get(iStructureTileList);
                ArrayList tileLs = new ArrayList();
                BlockPos pos = iStructureTileList.getTe().func_174877_v();
                for (LittleTile littleTile : list) {
                    Vec3d[] relativeVec = this.adjustRelativeTileVec(pos, littleTile.getBox());
                    Vec3d relativeMin = relativeVec[0];
                    Vec3d relativeMax = relativeVec[1];
                    this.relativeBox = new LittleBox(new LittleVec((int)(relativeMin.field_72450_a * 16.0), (int)(relativeMin.field_72448_b * 16.0), (int)(relativeMin.field_72449_c * 16.0)), new LittleVec((int)(relativeMax.field_72450_a * 16.0), (int)(relativeMax.field_72448_b * 16.0), (int)(relativeMax.field_72449_c * 16.0)));
                }
            });
        }
    }

    protected Object failedLoadingRelative(NBTTagCompound nbt, StructureDirectionalField field) {
        if (field.key.equals("facing")) {
            return EnumFacing.UP;
        }
        if (field.key.equals("east")) {
            return EnumFacing.EAST;
        }
        if (field.key.equals("west")) {
            return EnumFacing.WEST;
        }
        return super.failedLoadingRelative(nbt, field);
    }

    protected String nextSeries() {
        return "";
    }

    public void tick() {
    }

    public boolean onBlockActivated(World worldIn, LittleTile tile, BlockPos pos, EntityPlayer playerIn, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ, LittleActionActivated action) throws LittleActionException {
        if (worldIn.field_72995_K) {
            return true;
        }
        if (this.facing != EnumFacing.UP) {
            playerIn.func_146105_b((ITextComponent)new TextComponentTranslation("structure.interaction.wrongfacing", new Object[0]), true);
            return true;
        }
        this.absolutePos = this.getSurroundingBox().getAABB();
        try {
            this.collectAllTiles();
        }
        catch (CorruptedConnectionException | NotYetConnectedException e) {
            e.printStackTrace();
        }
        this.onPremadeActivated(heldItem);
        return true;
    }

    public abstract void onPremadeActivated(ItemStack var1);

    public LittleBox getEditArea() {
        return this.editArea;
    }

    public Map<LittleBox, LittleTile> getTilePosList() {
        return this.tilePosList;
    }

    public int getSeriesAt() {
        return this.seriesAt;
    }

    public int getSeriesMaxium() {
        return this.seriesMaxium;
    }
}

