/*
 * Decompiled with CFR 0.152.
 */
package com.alet.common.structure.type.door;

import com.creativemd.creativecore.common.gui.container.GuiParent;
import com.creativemd.creativecore.common.gui.controls.gui.GuiPanel;
import com.creativemd.creativecore.common.gui.controls.gui.GuiStateButton;
import com.creativemd.creativecore.common.gui.controls.gui.GuiTabStateButton;
import com.creativemd.creativecore.common.gui.controls.gui.GuiTextfield;
import com.creativemd.creativecore.common.packet.CreativeCorePacket;
import com.creativemd.creativecore.common.packet.PacketHandler;
import com.creativemd.creativecore.common.utils.type.HashMapList;
import com.creativemd.creativecore.common.utils.type.UUIDSupplier;
import com.creativemd.creativecore.common.world.SubWorld;
import com.creativemd.littletiles.client.gui.controls.GuiTileViewer;
import com.creativemd.littletiles.client.render.world.LittleRenderChunkSuppilier;
import com.creativemd.littletiles.common.action.LittleActionException;
import com.creativemd.littletiles.common.action.block.LittleActionActivated;
import com.creativemd.littletiles.common.entity.DoorController;
import com.creativemd.littletiles.common.entity.EntityAnimation;
import com.creativemd.littletiles.common.packet.LittleAnimationControllerPacket;
import com.creativemd.littletiles.common.packet.LittleAnimationDataPacket;
import com.creativemd.littletiles.common.structure.animation.AnimationGuiHandler;
import com.creativemd.littletiles.common.structure.registry.LittleStructureType;
import com.creativemd.littletiles.common.structure.relative.StructureAbsolute;
import com.creativemd.littletiles.common.structure.relative.StructureRelative;
import com.creativemd.littletiles.common.structure.type.door.LittleAxisDoor;
import com.creativemd.littletiles.common.tile.LittleTile;
import com.creativemd.littletiles.common.tile.parent.IStructureTileList;
import com.creativemd.littletiles.common.tile.preview.LittleAbsolutePreviews;
import com.creativemd.littletiles.common.tile.preview.LittlePreviews;
import com.creativemd.littletiles.common.tileentity.TileEntityLittleTiles;
import com.creativemd.littletiles.common.util.place.Placement;
import com.creativemd.littletiles.common.util.place.PlacementHelper;
import com.creativemd.littletiles.common.util.place.PlacementMode;
import java.util.ArrayList;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class LittleAxisLoopDoor
extends LittleAxisDoor {
    public LittleAxisLoopDoor(LittleStructureType type, IStructureTileList mainBlock) {
        super(type, mainBlock);
    }

    public boolean onBlockActivated(World worldIn, LittleTile tile, BlockPos pos, EntityPlayer playerIn, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ, LittleActionActivated action) throws LittleActionException {
        boolean result = super.onBlockActivated(worldIn, tile, pos, playerIn, hand, heldItem, side, hitX, hitY, hitZ, action);
        return result;
    }

    public EntityAnimation openDoor(EntityPlayer player, UUIDSupplier uuid, boolean tickOnce) throws LittleActionException {
        if (this.isAnimated()) {
            NBTTagCompound n = ((DoorController)this.animation.controller).writeToNBT(new NBTTagCompound());
            n.func_74768_a("duration", 0);
            DoorController cfr_ignored_0 = (DoorController)this.animation.controller;
            this.animation.controller = DoorController.parseController((EntityAnimation)this.animation, (NBTTagCompound)n);
            System.out.println();
            ((DoorController)this.animation.controller).activate();
            if (tickOnce) {
                this.animation.onUpdateForReal();
            }
            PacketHandler.sendPacketToTrackingPlayers((CreativeCorePacket)new LittleAnimationControllerPacket(this.animation), (Entity)this.animation, null);
            return this.animation;
        }
        LittleAbsolutePreviews previews = this.getDoorPreviews();
        World world = this.getWorld();
        SubWorld fakeWorld = SubWorld.createFakeWorld((World)world);
        if (world.field_72995_K) {
            fakeWorld.renderChunkSupplier = new LittleRenderChunkSuppilier();
        }
        Placement placement = new Placement(player, PlacementHelper.getAbsolutePreviews((World)fakeWorld, (LittlePreviews)previews, (BlockPos)previews.pos, (PlacementMode)PlacementMode.all)).setIgnoreWorldBoundaries(false);
        StructureAbsolute absolute = this.getAbsoluteAxis();
        HashMapList blocks = this.collectAllBlocksListSameWorld();
        EntityAnimation animation = this.place(this.getWorld(), fakeWorld, player, placement, uuid, absolute, tickOnce);
        System.out.println(((DoorController)animation.controller).writeToNBT(new NBTTagCompound()));
        boolean sendUpdate = !world.field_72995_K;
        EntityAnimation topAnimation = world instanceof WorldServer ? null : (EntityAnimation)fakeWorld.getTopEntity();
        for (Map.Entry entry : blocks.entrySet()) {
            if (((ArrayList)entry.getValue()).isEmpty()) continue;
            TileEntityLittleTiles te = ((IStructureTileList)((ArrayList)entry.getValue()).get(0)).getTe();
            te.updateTiles(x -> {
                for (IStructureTileList list : (ArrayList)entry.getValue()) {
                    x.get(list).remove();
                }
            });
            if (!sendUpdate) continue;
            if (topAnimation == null) {
                ((WorldServer)world).func_184164_w().func_180244_a(te.func_174877_v());
                continue;
            }
            PacketHandler.sendPacketToTrackingPlayers((CreativeCorePacket)new LittleAnimationDataPacket(topAnimation), (Entity)topAnimation, null);
        }
        return animation;
    }

    public static class LittleAxisLoopDoorParser
    extends LittleAxisDoor.LittleAxisDoorParser {
        public LittleAxisLoopDoorParser(GuiParent parent, AnimationGuiHandler handler) {
            super(parent, handler);
        }

        @SideOnly(value=Side.CLIENT)
        public LittleAxisDoor parseStructure() {
            LittleAxisLoopDoor door = (LittleAxisLoopDoor)this.createStructure(LittleAxisLoopDoor.class, null);
            GuiTileViewer viewer = (GuiTileViewer)this.parent.get("tileviewer");
            door.axisCenter = new StructureRelative(viewer.getBox(), viewer.getAxisContext());
            door.axis = viewer.getAxis();
            GuiPanel typePanel = (GuiPanel)this.parent.get("typePanel");
            door.doorRotation = LittleAxisLoopDoor.createRotation((int)((GuiTabStateButton)this.parent.get("doorRotation")).getState());
            if (door.doorRotation instanceof LittleAxisDoor.FixedRotation) {
                float degree;
                LittleAxisDoor.FixedRotation doorRotation = (LittleAxisDoor.FixedRotation)door.doorRotation;
                try {
                    degree = Float.parseFloat(((GuiTextfield)this.parent.get((String)"degree")).text);
                }
                catch (NumberFormatException e) {
                    degree = 0.0f;
                }
                doorRotation.degree = degree;
            } else if (door.doorRotation instanceof LittleAxisDoor.DirectionRotation) {
                LittleAxisDoor.DirectionRotation doorRotation = (LittleAxisDoor.DirectionRotation)door.doorRotation;
                doorRotation.clockwise = ((GuiStateButton)this.parent.get("direction")).getState() == 0;
            }
            return door;
        }
    }
}

