/*
 * Decompiled with CFR 0.152.
 */
package com.alet.common.structure.type;

import com.alet.client.gui.controls.GuiStackSelectorAllMutator;
import com.alet.client.gui.controls.GuiStackSelectorExtensionMutator;
import com.alet.client.gui.controls.menu.GuiMenu;
import com.alet.client.gui.controls.menu.GuiMenuPart;
import com.alet.client.gui.controls.menu.GuiPopupMenu;
import com.alet.client.gui.controls.menu.GuiTreePart;
import com.alet.common.structure.type.MutatorData;
import com.alet.littletiles.common.utils.mc.ColorUtilsAlet;
import com.alet.littletiles.gui.controls.GuiColorPickerAlet;
import com.creativemd.creativecore.common.gui.CoreControl;
import com.creativemd.creativecore.common.gui.GuiControl;
import com.creativemd.creativecore.common.gui.container.GuiParent;
import com.creativemd.creativecore.common.gui.controls.gui.GuiButton;
import com.creativemd.creativecore.common.gui.controls.gui.GuiCheckBox;
import com.creativemd.creativecore.common.gui.controls.gui.GuiLabel;
import com.creativemd.creativecore.common.gui.controls.gui.GuiPanel;
import com.creativemd.creativecore.common.gui.controls.gui.GuiScrollBox;
import com.creativemd.creativecore.common.gui.controls.gui.GuiTextBox;
import com.creativemd.creativecore.common.gui.controls.gui.custom.GuiStackSelectorAll;
import com.creativemd.creativecore.common.gui.event.ControlEvent;
import com.creativemd.creativecore.common.gui.event.gui.GuiControlChangedEvent;
import com.creativemd.creativecore.common.gui.event.gui.GuiControlClickEvent;
import com.creativemd.creativecore.common.utils.mc.BlockUtils;
import com.creativemd.littletiles.client.gui.LittleSubGuiUtils;
import com.creativemd.littletiles.client.gui.dialogs.SubGuiSignalEvents;
import com.creativemd.littletiles.common.action.LittleActionException;
import com.creativemd.littletiles.common.action.block.LittleActionActivated;
import com.creativemd.littletiles.common.structure.LittleStructure;
import com.creativemd.littletiles.common.structure.animation.AnimationGuiHandler;
import com.creativemd.littletiles.common.structure.exception.CorruptedConnectionException;
import com.creativemd.littletiles.common.structure.exception.NotYetConnectedException;
import com.creativemd.littletiles.common.structure.registry.LittleStructureGuiParser;
import com.creativemd.littletiles.common.structure.registry.LittleStructureRegistry;
import com.creativemd.littletiles.common.structure.registry.LittleStructureType;
import com.creativemd.littletiles.common.structure.signal.output.InternalSignalOutput;
import com.creativemd.littletiles.common.tile.LittleTile;
import com.creativemd.littletiles.common.tile.LittleTileColored;
import com.creativemd.littletiles.common.tile.parent.IStructureTileList;
import com.creativemd.littletiles.common.tile.parent.StructureTileList;
import com.creativemd.littletiles.common.tile.preview.LittlePreviews;
import com.n247s.api.eventapi.eventsystem.CustomEventSubscribe;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.util.Color;

public class LittleStateMutatorALET
extends LittleStructure {
    public int attributeMod = 0;
    public LinkedHashMap<String, MutatorData> mutateMaterial = new LinkedHashMap();
    public boolean activated = false;
    public boolean allowRightClick = true;

    public LittleStateMutatorALET(LittleStructureType type, IStructureTileList mainBlock) {
        super(type, mainBlock);
    }

    protected void loadFromNBTExtra(NBTTagCompound nbt) {
        this.attributeMod = nbt.func_74762_e("attributeMod");
        if (nbt.func_74764_b("mutater")) {
            NBTTagList mutateList = nbt.func_150295_c("mutater", 9);
            int counter = 0;
            for (int i = 0; i < mutateList.func_74745_c(); i += 3) {
                MutatorData dataA = new MutatorData();
                MutatorData dataB = new MutatorData();
                NBTTagList states = (NBTTagList)mutateList.func_179238_g(i);
                dataA.state = NBTUtil.func_190008_d((NBTTagCompound)states.func_150305_b(0));
                dataB.state = NBTUtil.func_190008_d((NBTTagCompound)states.func_150305_b(1));
                NBTTagList colors = (NBTTagList)mutateList.func_179238_g(i + 1);
                dataA.color = colors.func_150305_b(0).func_74762_e("color_a");
                dataB.color = colors.func_150305_b(1).func_74762_e("color_b");
                NBTTagList colisions = (NBTTagList)mutateList.func_179238_g(i + 2);
                dataA.colision = colisions.func_150305_b(0).func_74767_n("colision_a");
                dataB.colision = colisions.func_150305_b(1).func_74767_n("colision_b");
                this.mutateMaterial.put("a" + counter, dataA);
                this.mutateMaterial.put("b" + counter, dataB);
                ++counter;
            }
        }
        if (nbt.func_74764_b("allowRightClick")) {
            this.allowRightClick = nbt.func_74767_n("allowRightClick");
        }
    }

    protected void writeToNBTExtra(NBTTagCompound nbt) {
        nbt.func_74768_a("attributeMod", this.attributeMod);
        nbt.func_74757_a("allowRightClick", this.allowRightClick);
        if (!this.mutateMaterial.isEmpty()) {
            NBTTagList mutate = new NBTTagList();
            for (int i = 0; i < this.mutateMaterial.size() / 2; ++i) {
                NBTTagList mutateList = new NBTTagList();
                NBTTagList colorList = new NBTTagList();
                NBTTagList colisionList = new NBTTagList();
                NBTTagCompound colorA = new NBTTagCompound();
                colorA.func_74768_a("color_a", this.mutateMaterial.get((Object)new StringBuilder().append((String)"a").append((int)i).toString()).color);
                NBTTagCompound colorB = new NBTTagCompound();
                colorB.func_74768_a("color_b", this.mutateMaterial.get((Object)new StringBuilder().append((String)"b").append((int)i).toString()).color);
                NBTTagCompound colisionA = new NBTTagCompound();
                colisionA.func_74757_a("colision_a", this.mutateMaterial.get((Object)new StringBuilder().append((String)"a").append((int)i).toString()).colision);
                NBTTagCompound colisionB = new NBTTagCompound();
                colisionB.func_74757_a("colision_b", this.mutateMaterial.get((Object)new StringBuilder().append((String)"b").append((int)i).toString()).colision);
                mutateList.func_74742_a((NBTBase)NBTUtil.func_190009_a((NBTTagCompound)new NBTTagCompound(), (IBlockState)this.mutateMaterial.get((Object)new StringBuilder().append((String)"a").append((int)i).toString()).state));
                mutateList.func_74742_a((NBTBase)NBTUtil.func_190009_a((NBTTagCompound)new NBTTagCompound(), (IBlockState)this.mutateMaterial.get((Object)new StringBuilder().append((String)"b").append((int)i).toString()).state));
                colorList.func_74742_a((NBTBase)colorA);
                colorList.func_74742_a((NBTBase)colorB);
                colisionList.func_74742_a((NBTBase)colisionA);
                colisionList.func_74742_a((NBTBase)colisionB);
                mutate.func_74742_a((NBTBase)mutateList);
                mutate.func_74742_a((NBTBase)colorList);
                mutate.func_74742_a((NBTBase)colisionList);
            }
            nbt.func_74782_a("mutater", (NBTBase)mutate);
        }
    }

    public void performInternalOutputChange(InternalSignalOutput output) {
        if (((LittleStructureType.InternalComponentOutput)output.component).is("activate")) {
            try {
                this.changeMaterialState();
            }
            catch (CorruptedConnectionException | NotYetConnectedException e) {
                e.printStackTrace();
            }
        }
    }

    public void changeMaterialState() throws CorruptedConnectionException, NotYetConnectedException {
        for (IStructureTileList tileList : this.blocksList()) {
            tileList.getTe().updateTiles(x -> {
                StructureTileList s = x.get(tileList);
                block0: for (LittleTile tile : tileList) {
                    for (int i = 0; i < this.mutateMaterial.size() / 2; ++i) {
                        LittleTileColored coloredTile;
                        MutatorData dataA = this.mutateMaterial.get("a" + i);
                        MutatorData dataB = this.mutateMaterial.get("b" + i);
                        int colorA = dataA.color;
                        int colorB = dataB.color;
                        if (tile instanceof LittleTileColored) {
                            coloredTile = (LittleTileColored)tile;
                            if (!coloredTile.getBlockState().equals(dataA.state) || coloredTile.color != dataA.color) continue;
                            LittleTile temp = LittleTileColored.setColor((LittleTile)tile.copy(), (int)dataB.color);
                            temp.setBlock(dataB.state.func_177230_c(), dataB.state.func_177230_c().func_176201_c(dataB.state));
                            s.remove((Object)coloredTile);
                            s.add(temp);
                            continue;
                        }
                        if (!tile.getBlockState().equals(dataA.state)) continue;
                        coloredTile = LittleTileColored.setColor((LittleTile)tile.copy(), (int)dataB.color);
                        coloredTile.setBlock(dataB.state.func_177230_c(), dataB.state.func_177230_c().func_176201_c(dataB.state));
                        s.remove((Object)tile);
                        s.add((LittleTile)coloredTile);
                        continue block0;
                    }
                }
            });
        }
    }

    public void changeCollisionState() throws CorruptedConnectionException, NotYetConnectedException {
        NBTTagCompound nbt = new NBTTagCompound();
        if (this.attributeMod == 2) {
            this.attributeMod = 0;
        } else if (this.attributeMod == 0) {
            this.attributeMod = 2;
        }
        this.tryAttributeChangeForBlocks();
        World world = this.getWorld();
        for (IStructureTileList list : this.blocksList()) {
            IBlockState state = world.func_180495_p(list.getPos());
            world.func_184138_a(list.getPos(), state, state, 2);
        }
        this.mainBlock.getTe().updateBlock();
        this.mainBlock.getTe().updateNeighbour();
        this.updateStructure();
    }

    public boolean onBlockActivated(World worldIn, LittleTile tile, BlockPos pos, EntityPlayer playerIn, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ, LittleActionActivated action) throws LittleActionException {
        if (this.allowRightClick && !worldIn.field_72995_K) {
            this.getOutput(0).toggle();
        }
        return true;
    }

    public int getAttribute() {
        return super.getAttribute() | this.attributeMod;
    }

    public static class LittleStateMutatorParserALET
    extends LittleStructureGuiParser {
        public LinkedHashMap<String, MutatorData> mutateMaterial = new LinkedHashMap();
        protected CoreControl rightClickedControl;

        public LittleStateMutatorParserALET(GuiParent parent, AnimationGuiHandler handler) {
            super(parent, handler);
        }

        @SideOnly(value=Side.CLIENT)
        public void create(LittlePreviews previews, @Nullable LittleStructure structure) {
            this.createControls(previews, structure);
            this.parent.controls.add(new SubGuiSignalEvents.GuiSignalEventsButton("signal", 0, 122, previews, structure, this.getStructureType()));
        }

        protected void createControls(LittlePreviews previews, LittleStructure structure) {
            LittleStateMutatorALET mutator = (LittleStateMutatorALET)structure;
            EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
            if (player.func_184812_l_()) {
                GuiScrollBox box = new GuiScrollBox("box", 0, 0, 294, 100);
                ArrayList<GuiTreePart> listOfMenus = new ArrayList<GuiTreePart>();
                GuiMenuPart moveUp = new GuiMenuPart("", "Move Up", GuiTreePart.EnumPartType.Leaf);
                GuiMenuPart moveDown = new GuiMenuPart("", "Move Down", GuiTreePart.EnumPartType.Leaf);
                GuiMenuPart swap = new GuiMenuPart("", "Swap States", GuiTreePart.EnumPartType.Leaf);
                GuiMenuPart delete = new GuiMenuPart("", "Delete", GuiTreePart.EnumPartType.Leaf);
                listOfMenus.add(moveUp);
                listOfMenus.add(moveDown);
                listOfMenus.add(swap);
                listOfMenus.add(delete);
                GuiMenu menu = new GuiMenu("", 0, 0, 68, listOfMenus);
                menu.height = 100;
                GuiPopupMenu popup = new GuiPopupMenu("popup", menu, 0, 0, 0, 0);
                box.addControl((GuiControl)popup);
                GuiCheckBox check = new GuiCheckBox("check", "Allow Right Click", 0, 107, mutator != null ? mutator.allowRightClick : true);
                GuiButton add = new GuiButton("Add Mutation", 234, 111, 60){

                    public void onClicked(int x, int y, int button) {
                        int size = mutateMaterial.size() / 2;
                        this.addMutations(size, new MutatorData(Blocks.field_150348_b.func_176223_P(), -1, true), new MutatorData(Blocks.field_150348_b.func_176223_P(), -1, true));
                    }
                };
                this.parent.controls.add(box);
                if (mutator != null && !mutator.mutateMaterial.isEmpty()) {
                    this.mutateMaterial = mutator.mutateMaterial;
                    this.showExistingMutations();
                }
                this.parent.controls.add(add);
                this.parent.controls.add(check);
            } else {
                this.parent.controls.add(new GuiTextBox("message", "These settings are only avalible in creative mode", 0, 0, 100));
            }
        }

        protected void showExistingMutations() {
            int i = 0;
            for (Map.Entry<String, MutatorData> entry : this.mutateMaterial.entrySet()) {
                if (entry.getKey().contains("a")) {
                    this.addMutations(i, entry.getValue(), null);
                    continue;
                }
                if (!entry.getKey().contains("b")) continue;
                this.addMutations(i, null, entry.getValue());
                ++i;
            }
        }

        protected void swapMutations(int position) {
            ArrayList<MutatorData> tempList = new ArrayList<MutatorData>();
            for (Map.Entry<String, MutatorData> entry : this.mutateMaterial.entrySet()) {
                tempList.add(entry.getValue());
            }
            Collections.swap(tempList, position * 2, position * 2 + 1);
            LinkedHashMap<String, MutatorData> mutateMaterialTemp = new LinkedHashMap<String, MutatorData>();
            int i = 0;
            int step = 0;
            for (MutatorData data : tempList) {
                if (step == 0) {
                    mutateMaterialTemp.put("a" + i, data);
                    ++step;
                    continue;
                }
                if (step != true) continue;
                mutateMaterialTemp.put("b" + i, data);
                step = 0;
                ++i;
            }
            this.mutateMaterial = mutateMaterialTemp;
            this.refreshMutations();
        }

        protected void moveMutations(int distance, int position) {
            ArrayList<MutatorData> tempList = new ArrayList<MutatorData>();
            for (Map.Entry<String, MutatorData> entry : this.mutateMaterial.entrySet()) {
                tempList.add(entry.getValue());
            }
            Collections.swap(tempList, position * 2, position * 2 + distance * 2);
            Collections.swap(tempList, position * 2 + 1, position * 2 + distance * 2 + 1);
            LinkedHashMap<String, MutatorData> mutateMaterialTemp = new LinkedHashMap<String, MutatorData>();
            int i = 0;
            int step = 0;
            for (MutatorData data : tempList) {
                if (step == 0) {
                    mutateMaterialTemp.put("a" + i, data);
                    ++step;
                    continue;
                }
                if (step != true) continue;
                mutateMaterialTemp.put("b" + i, data);
                step = 0;
                ++i;
            }
            this.mutateMaterial = mutateMaterialTemp;
            this.refreshMutations();
        }

        protected void refreshMutations() {
            int i = 0;
            GuiScrollBox box = (GuiScrollBox)this.parent.get("box");
            box.removeControls(new String[]{"popup"});
            LinkedHashMap<String, MutatorData> mutateMaterialTemp = new LinkedHashMap<String, MutatorData>();
            for (Map.Entry<String, MutatorData> entry : this.mutateMaterial.entrySet()) {
                if (entry.getKey().contains("a")) {
                    mutateMaterialTemp.put("a" + i, entry.getValue());
                    continue;
                }
                if (!entry.getKey().contains("b")) continue;
                mutateMaterialTemp.put("b" + i, entry.getValue());
                ++i;
            }
            this.mutateMaterial = mutateMaterialTemp;
            this.showExistingMutations();
        }

        protected void addMutations(int position, @Nullable MutatorData value1, @Nullable MutatorData value2) {
            GuiScrollBox box = (GuiScrollBox)this.parent.get("box");
            GuiMutatorPanel panel = new GuiMutatorPanel(position + "", 0, 28 * position, 286, 21);
            if (value1 != null) {
                this.mutateMaterial.put("a" + position, value1);
                GuiStackSelectorAllMutator a = new GuiStackSelectorAllMutator("a" + position, 0, 0, 105, null, (GuiStackSelectorAll.StackCollector)new GuiStackSelectorAll.CreativeCollector((GuiStackSelectorAll.StackSelector)new LittleSubGuiUtils.LittleBlockSelector()), true);
                panel.controls.add(a);
                IBlockState materialA = value1.state;
                a.setSelectedForce(materialA.func_177230_c().getPickBlock(materialA, null, null, null, null));
                a.color = value1.color;
                this.mutateMaterial.put("a" + position, value1);
            }
            if (value2 != null) {
                this.mutateMaterial.put("b" + position, value2);
                GuiStackSelectorAllMutator b = new GuiStackSelectorAllMutator("b" + position, 153, 0, 105, null, (GuiStackSelectorAll.StackCollector)new GuiStackSelectorAll.CreativeCollector((GuiStackSelectorAll.StackSelector)new LittleSubGuiUtils.LittleBlockSelector()), true);
                panel.controls.add(b);
                IBlockState materialB = value2.state;
                b.setSelectedForce(materialB.func_177230_c().getPickBlock(materialB, null, null, null, null));
                b.color = value2.color;
                this.mutateMaterial.put("b" + position, value2);
            }
            panel.controls.add(new GuiLabel("To", 134, 2));
            panel.refreshControls();
            box.controls.add(panel);
            box.refreshControls();
        }

        @CustomEventSubscribe
        public void controlClicked(GuiControlClickEvent event) {
            if (event.button == 1 && event.source instanceof GuiMutatorPanel) {
                this.rightClickedControl = event.source;
            }
        }

        @CustomEventSubscribe
        public void controlChanged(GuiControlChangedEvent event) {
            if (event.source instanceof GuiStackSelectorAllMutator) {
                GuiStackSelectorAllMutator mutator = (GuiStackSelectorAllMutator)event.source;
                this.mutateMaterial.put(mutator.name, new MutatorData(BlockUtils.getState((ItemStack)mutator.getSelected()), mutator.color, true));
            }
            if (event.source instanceof GuiColorPickerAlet) {
                GuiColorPickerAlet color = (GuiColorPickerAlet)event.source;
                GuiStackSelectorAllMutator mutator = (GuiStackSelectorAllMutator)((GuiStackSelectorExtensionMutator)event.source.parent).comboBox;
                mutator.color = ColorUtilsAlet.RGBAToInt((Color)color.color);
                this.mutateMaterial.put(mutator.name, new MutatorData(BlockUtils.getState((ItemStack)mutator.getSelected()), ColorUtilsAlet.RGBAToInt((Color)color.color), true));
            }
            if (event.source instanceof GuiMenuPart) {
                String caption = ((GuiMenuPart)event.source).caption;
                if (caption.equals("Move Up")) {
                    this.moveMutations(-1, Integer.parseInt(this.rightClickedControl.name));
                } else if (caption.equals("Move Down")) {
                    this.moveMutations(1, Integer.parseInt(this.rightClickedControl.name));
                } else if (caption.equals("Delete")) {
                    this.mutateMaterial.remove("a" + this.rightClickedControl.name);
                    this.mutateMaterial.remove("b" + this.rightClickedControl.name);
                    this.refreshMutations();
                } else if (caption.equals("Swap States")) {
                    this.swapMutations(Integer.parseInt(this.rightClickedControl.name));
                }
            }
        }

        protected LittleStructure parseStructure(LittlePreviews previews) {
            LittleStateMutatorALET structure = (LittleStateMutatorALET)this.createStructure(LittleStateMutatorALET.class, null);
            structure.mutateMaterial = this.mutateMaterial;
            structure.allowRightClick = ((GuiCheckBox)this.parent.get((String)"check")).value;
            return structure;
        }

        protected LittleStructureType getStructureType() {
            return LittleStructureRegistry.getStructureType(LittleStateMutatorALET.class);
        }

        public class GuiMutatorPanel
        extends GuiPanel {
            public GuiMutatorPanel(String name, int x, int y, int width, int height) {
                super(name, x, y, width, height);
            }

            public void mouseReleased(int x, int y, int button) {
                if (this.isMouseOver(x, y) && button == 1) {
                    this.getParent().raiseEvent((ControlEvent)new GuiControlClickEvent((GuiControl)this, x, y, button));
                }
            }
        }
    }
}

