/*
 * Decompiled with CFR 0.152.
 */
package com.alet.common.structure.type;

import com.alet.common.entity.RopeData;
import com.alet.common.structure.connection.RopeConnection;
import com.alet.items.ItemLittleRope;
import com.creativemd.creativecore.common.gui.container.GuiParent;
import com.creativemd.creativecore.common.gui.controls.gui.GuiCheckBox;
import com.creativemd.creativecore.common.gui.controls.gui.GuiIconButton;
import com.creativemd.creativecore.common.gui.controls.gui.GuiStateButton;
import com.creativemd.creativecore.common.gui.event.gui.GuiControlChangedEvent;
import com.creativemd.creativecore.common.gui.event.gui.GuiControlClickEvent;
import com.creativemd.creativecore.common.utils.math.vec.Vec;
import com.creativemd.creativecore.common.utils.math.vec.Vec3;
import com.creativemd.creativecore.common.utils.mc.ColorUtils;
import com.creativemd.creativecore.common.world.IOrientatedWorld;
import com.creativemd.littletiles.client.gui.controls.GuiTileViewer;
import com.creativemd.littletiles.common.action.LittleActionException;
import com.creativemd.littletiles.common.action.block.LittleActionActivated;
import com.creativemd.littletiles.common.structure.LittleStructure;
import com.creativemd.littletiles.common.structure.animation.AnimationGuiHandler;
import com.creativemd.littletiles.common.structure.connection.IWorldPositionProvider;
import com.creativemd.littletiles.common.structure.directional.StructureDirectional;
import com.creativemd.littletiles.common.structure.exception.CorruptedConnectionException;
import com.creativemd.littletiles.common.structure.exception.NotYetConnectedException;
import com.creativemd.littletiles.common.structure.registry.LittleStructureGuiParser;
import com.creativemd.littletiles.common.structure.registry.LittleStructureRegistry;
import com.creativemd.littletiles.common.structure.registry.LittleStructureType;
import com.creativemd.littletiles.common.structure.relative.StructureAbsolute;
import com.creativemd.littletiles.common.structure.relative.StructureRelative;
import com.creativemd.littletiles.common.structure.type.door.LittleAdvancedDoor;
import com.creativemd.littletiles.common.tile.LittleTile;
import com.creativemd.littletiles.common.tile.math.box.LittleBox;
import com.creativemd.littletiles.common.tile.math.location.StructureLocation;
import com.creativemd.littletiles.common.tile.parent.IStructureTileList;
import com.creativemd.littletiles.common.tile.preview.LittlePreviews;
import com.creativemd.littletiles.common.util.grid.LittleGridContext;
import com.creativemd.littletiles.common.util.place.Placement;
import com.n247s.api.eventapi.eventsystem.CustomEventSubscribe;
import java.util.ArrayList;
import java.util.List;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.util.Color;

public class LittleRopeConnectionALET
extends LittleAdvancedDoor {
    @StructureDirectional(saveKey="conList")
    public List<RopeConnection> connections = new ArrayList<RopeConnection>();
    public int prevStructureIndex = -1;
    public BlockPos prevBlockPosition;

    public LittleRopeConnectionALET(LittleStructureType type, IStructureTileList mainBlock) {
        super(type, mainBlock);
    }

    protected void loadFromNBTExtra(NBTTagCompound nbt) {
        if (nbt.func_74764_b("prev_data")) {
            int[] data = nbt.func_74759_k("prev_data");
            if (data.length == 4) {
                this.prevBlockPosition = new BlockPos(data[0], data[1], data[2]);
                this.prevStructureIndex = data[3];
            } else {
                this.prevBlockPosition = null;
                this.prevStructureIndex = -1;
            }
        } else {
            this.prevBlockPosition = null;
            this.prevStructureIndex = -1;
        }
    }

    protected void writeToNBTExtra(NBTTagCompound nbt) {
    }

    public NBTTagCompound writeToNBTPreview(NBTTagCompound nbt, BlockPos newCenter) {
        nbt.func_74783_a("prev_data", new int[]{this.getPos().func_177958_n(), this.getPos().func_177956_o(), this.getPos().func_177952_p(), this.getIndex()});
        return super.writeToNBTPreview(nbt, newCenter);
    }

    public void afterPlaced() {
        super.afterPlaced();
        ArrayList<RopeConnection> connectionsToRemove = new ArrayList<RopeConnection>();
        for (RopeConnection con : this.connections) {
            try {
                LittleRopeConnectionALET littleRopeConnectionALET = con.scanAfterPlace();
            }
            catch (CorruptedConnectionException | NotYetConnectedException e) {
                connectionsToRemove.add(con);
            }
        }
        this.connections.removeAll(connectionsToRemove);
    }

    public void finishedPlacement(Placement placement) {
        this.prevStructureIndex = -1;
        this.prevBlockPosition = null;
    }

    public void bezier(Vec3 pFinal, Vec3 p0, Vec3 p1, Vec3 p2, float t) {
        pFinal.x = Math.pow(1.0f - t, 2.0) * p0.x + (double)((1.0f - t) * 2.0f * t) * p1.x + (double)(t * t) * p2.x;
        pFinal.y = Math.pow(1.0f - t, 2.0) * p0.y + (double)((1.0f - t) * 2.0f * t) * p1.y + (double)(t * t) * p2.y;
        pFinal.z = Math.pow(1.0f - t, 2.0) * p0.z + (double)((1.0f - t) * 2.0f * t) * p1.z + (double)(t * t) * p2.z;
    }

    public double getMaxRenderDistanceSquared() {
        return 2500.0;
    }

    public boolean onBlockActivated(World world, LittleTile tile, BlockPos pos, EntityPlayer player, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ, LittleActionActivated action) {
        if (this.isClient()) {
            return true;
        }
        if (heldItem.func_77973_b() instanceof ItemLittleRope) {
            if (!ItemLittleRope.hasSelected(heldItem)) {
                ItemLittleRope.addSelected(heldItem, this.getStructureLocation());
            } else {
                try {
                    StructureLocation tailLocation = ItemLittleRope.getSelectedLocation(heldItem);
                    World w = this.getWorld();
                    if (w instanceof IOrientatedWorld) {
                        w = ((IOrientatedWorld)w).getRealWorld();
                    }
                    LittleRopeConnectionALET tail = (LittleRopeConnectionALET)tailLocation.find(w);
                    RopeData data = ItemLittleRope.writeDataFromNBT(heldItem.func_77978_p());
                    tail.connections.add(new RopeConnection((IWorldPositionProvider)tail, this.getStructureLocation(), this.getIndex(), false, null));
                    this.connections.add(new RopeConnection((IWorldPositionProvider)this, tailLocation, tail.getIndex(), true, data));
                    this.updateStructure();
                    tail.updateStructure();
                }
                catch (LittleActionException e) {
                    e.printStackTrace();
                }
                ItemLittleRope.removeSelected(heldItem);
            }
        }
        return true;
    }

    public boolean matchingConnection(RopeData data, LittleRopeConnectionALET otherStructure) {
        for (RopeConnection con : otherStructure.connections) {
            try {
                RopeData otherData;
                if (con.getStructure() != this || !(otherData = con.IS_HEAD ? con.ropeData : this.connections.get((int)con.targetStructureIndex).ropeData).equals(data)) continue;
                return true;
            }
            catch (CorruptedConnectionException | NotYetConnectedException e) {
                e.printStackTrace();
            }
        }
        for (RopeConnection con : this.connections) {
            try {
                RopeData thisData;
                if (con.getStructure() != this || !(thisData = con.IS_HEAD ? con.ropeData : otherStructure.connections.get((int)con.targetStructureIndex).ropeData).equals(data)) continue;
                return true;
            }
            catch (CorruptedConnectionException | NotYetConnectedException e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    public void unload() {
        this.connections.clear();
        super.unload();
    }

    public void onStructureDestroyed() {
        super.onStructureDestroyed();
        for (RopeConnection con : this.connections) {
            try {
                LittleRopeConnectionALET structure = (LittleRopeConnectionALET)con.getStructure();
                structure.connections.remove(con.targetStructureIndex);
                structure.updateStructure();
            }
            catch (CorruptedConnectionException | NotYetConnectedException e) {
                e.printStackTrace();
            }
        }
    }

    public AxisAlignedBB getRenderBoundingBox() {
        Vector3d center = this.axisCenter.getCenter();
        center.x += (double)this.getPos().func_177958_n();
        center.y += (double)this.getPos().func_177956_o();
        center.z += (double)this.getPos().func_177952_p();
        double minX = center.x - 0.5;
        double minY = center.y - 0.5;
        double minZ = center.z - 0.5;
        double maxX = center.x + 0.5;
        double maxY = center.y + 0.5;
        double maxZ = center.z + 0.5;
        for (RopeConnection con : this.connections) {
            if (!con.IS_HEAD) continue;
            RopeData data = con.ropeData;
            Vector3d vecCenter = con.getTargetCenter();
            if (vecCenter == null || data == null) continue;
            minX = Math.min(vecCenter.x - data.thickness, minX);
            minY = Math.min(vecCenter.y - data.thickness, minY);
            minZ = Math.min(vecCenter.z - data.thickness, minZ);
            maxX = Math.max(vecCenter.x + data.thickness, maxX);
            maxY = Math.max(vecCenter.y + data.thickness, maxY);
            maxZ = Math.max(vecCenter.z + data.thickness, maxZ);
        }
        return new AxisAlignedBB(minX -= (double)this.getPos().func_177958_n(), minY -= (double)this.getPos().func_177956_o(), minZ -= (double)this.getPos().func_177952_p(), maxX -= (double)this.getPos().func_177958_n(), maxY -= (double)this.getPos().func_177956_o(), maxZ -= (double)this.getPos().func_177952_p());
    }

    public void renderTick(BlockPos pos, double x, double y, double z, float partialTickTime) {
        for (RopeConnection con : this.connections) {
            float b;
            float g;
            float r;
            float f3;
            int j;
            if (!con.IS_HEAD || con.getTarget() == null) continue;
            RopeData data = con.ropeData;
            Vector3d headPos = this.axisCenter.getCenter();
            Vector3d vecPos = new Vector3d((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
            Vector3d tailPos = con.getTargetCenter();
            if (tailPos == null || data == null) continue;
            if (con.hasMoved(tailPos = (Vector3d)tailPos.clone())) {
                this.mainBlock.getTe().render.markRenderBoundingBoxDirty();
            }
            tailPos.sub((Tuple3d)vecPos);
            double p0x = headPos.x;
            double p0y = headPos.y;
            double p0z = headPos.z;
            double p2x = tailPos.x;
            double p2y = tailPos.y;
            double p2z = tailPos.z;
            double p1x = (p0x + p2x) / 2.0;
            double p1y = (p0y + p2y) / 2.0 - data.tautness;
            double p1z = (p0z + p2z) / 2.0;
            Vec3 startPoint = new Vec3(p0x, p0y, p0z);
            Vec3 midPoint = new Vec3(p1x, p1y, p1z);
            Vec3 endPoint = new Vec3(p2x, p2y, p2z);
            Vec3 drawPoint = new Vec3(0.0, 0.0, 0.0);
            Color c = ColorUtils.IntToRGBA((int)data.color);
            float red = (float)c.getRed() / 255.0f;
            float green = (float)c.getGreen() / 255.0f;
            float blue = (float)c.getBlue() / 255.0f;
            float alpha = (float)c.getAlpha() / 255.0f;
            GlStateManager.func_179094_E();
            GlStateManager.func_179147_l();
            GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            GlStateManager.func_179131_c((float)red, (float)green, (float)blue, (float)alpha);
            GlStateManager.func_179090_x();
            GlStateManager.func_179141_d();
            GlStateManager.func_179129_p();
            GlStateManager.func_179140_f();
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder bufferbuilder = tessellator.func_178180_c();
            GlStateManager.func_179137_b((double)x, (double)y, (double)z);
            int count = (int)(startPoint.distance((Vec)endPoint) * 10.0);
            bufferbuilder.func_181668_a(5, DefaultVertexFormats.field_181706_f);
            for (j = 0; j <= count; ++j) {
                f3 = (float)j / (float)count;
                this.bezier(drawPoint, startPoint, midPoint, endPoint, f3);
                r = red;
                g = green;
                b = blue;
                if (j % 2 == 0) {
                    r = Math.max(0.0f, red - 0.1f);
                    g = Math.max(0.0f, green - 0.1f);
                    b = Math.max(0.0f, blue - 0.1f);
                }
                bufferbuilder.func_181662_b(drawPoint.x - data.thickness, drawPoint.y, drawPoint.z).func_181666_a(r, g, b, alpha).func_181675_d();
                bufferbuilder.func_181662_b(drawPoint.x + data.thickness, drawPoint.y, drawPoint.z).func_181666_a(r, g, b, alpha).func_181675_d();
            }
            tessellator.func_78381_a();
            bufferbuilder.func_181668_a(5, DefaultVertexFormats.field_181706_f);
            for (j = 0; j <= count; ++j) {
                f3 = (float)j / (float)count;
                this.bezier(drawPoint, startPoint, midPoint, endPoint, f3);
                r = red;
                g = green;
                b = blue;
                if (j % 2 == 0) {
                    r = Math.max(0.0f, red - 0.1f);
                    g = Math.max(0.0f, green - 0.1f);
                    b = Math.max(0.0f, blue - 0.1f);
                }
                bufferbuilder.func_181662_b(drawPoint.x, drawPoint.y, drawPoint.z - data.thickness).func_181666_a(r, g, b, alpha).func_181675_d();
                bufferbuilder.func_181662_b(drawPoint.x, drawPoint.y, drawPoint.z + data.thickness).func_181666_a(r, g, b, alpha).func_181675_d();
            }
            tessellator.func_78381_a();
            bufferbuilder.func_181668_a(5, DefaultVertexFormats.field_181706_f);
            for (j = 0; j <= count; ++j) {
                f3 = (float)j / (float)count;
                this.bezier(drawPoint, startPoint, midPoint, endPoint, f3);
                r = red;
                g = green;
                b = blue;
                if (j % 2 == 0) {
                    r = Math.max(0.0f, red - 0.1f);
                    g = Math.max(0.0f, green - 0.1f);
                    b = Math.max(0.0f, blue - 0.1f);
                }
                bufferbuilder.func_181662_b(drawPoint.x, drawPoint.y - data.thickness, drawPoint.z).func_181666_a(r, g, b, alpha).func_181675_d();
                bufferbuilder.func_181662_b(drawPoint.x, drawPoint.y + data.thickness, drawPoint.z).func_181666_a(r, g, b, alpha).func_181675_d();
            }
            tessellator.func_78381_a();
            GlStateManager.func_179121_F();
            GlStateManager.func_179098_w();
        }
    }

    public static class LittleLeadConnectionParserALET
    extends LittleStructureGuiParser {
        public LittleLeadConnectionParserALET(GuiParent parent, AnimationGuiHandler handler) {
            super(parent, handler);
        }

        protected void createControls(LittlePreviews previews, LittleStructure structure) {
            LittleAdvancedDoor door = structure instanceof LittleAdvancedDoor ? (LittleAdvancedDoor)structure : null;
            final GuiTileViewer viewer = new GuiTileViewer("tileviewer", 0, 0, 100, 100, previews.getContext());
            this.setViewer(viewer, door, previews.getContext());
            this.parent.controls.add(viewer);
            this.parent.controls.add(new GuiIconButton("reset view", 20, 107, 8){

                public void onClicked(int x, int y, int button) {
                    viewer.offsetX.set(0.0);
                    viewer.offsetY.set(0.0);
                    viewer.scale.set(40.0);
                }
            }.setCustomTooltip(new String[]{"reset view"}));
            this.parent.controls.add(new GuiIconButton("change view", 40, 107, 7){

                public void onClicked(int x, int y, int button) {
                    switch (viewer.getAxis()) {
                        case X: {
                            viewer.setViewAxis(EnumFacing.Axis.Y);
                            break;
                        }
                        case Y: {
                            viewer.setViewAxis(EnumFacing.Axis.Z);
                            break;
                        }
                        case Z: {
                            viewer.setViewAxis(EnumFacing.Axis.X);
                            break;
                        }
                    }
                }
            }.setCustomTooltip(new String[]{"change view"}));
            this.parent.controls.add(new GuiIconButton("flip view", 60, 107, 4){

                public void onClicked(int x, int y, int button) {
                    viewer.setViewDirection(viewer.getViewDirection().func_176734_d());
                }
            }.setCustomTooltip(new String[]{"flip view"}));
            this.parent.controls.add(new GuiIconButton("up", 124, 33, 1){

                public void onClicked(int x, int y, int button) {
                    viewer.moveY(GuiScreen.func_146271_m() ? viewer.context.size : 1);
                }
            });
            this.parent.controls.add(new GuiIconButton("right", 141, 50, 0){

                public void onClicked(int x, int y, int button) {
                    viewer.moveX(GuiScreen.func_146271_m() ? viewer.context.size : 1);
                }
            });
            this.parent.controls.add(new GuiIconButton("left", 107, 50, 2){

                public void onClicked(int x, int y, int button) {
                    viewer.moveX(-(GuiScreen.func_146271_m() ? viewer.context.size : 1));
                }
            });
            this.parent.controls.add(new GuiIconButton("down", 124, 50, 3){

                public void onClicked(int x, int y, int button) {
                    viewer.moveY(-(GuiScreen.func_146271_m() ? viewer.context.size : 1));
                }
            });
            this.parent.controls.add(new GuiCheckBox("even", 107, 0, viewer.isEven()));
            GuiStateButton contextBox = new GuiStateButton("grid", LittleGridContext.getNames().indexOf(viewer.getAxisContext() + ""), 107, 80, 20, 12, LittleGridContext.getNames().toArray(new String[0]));
            this.parent.controls.add(contextBox);
        }

        private void setViewer(GuiTileViewer viewer, LittleAdvancedDoor door, LittleGridContext axisContext) {
            viewer.visibleAxis = true;
            if (door != null) {
                viewer.setEven(door.axisCenter.isEven());
                door.axisCenter.convertToSmallest();
                axisContext = door.axisCenter.getContext();
                viewer.setAxis(door.axisCenter.getBox(), axisContext);
            } else {
                viewer.setEven(false);
                viewer.setAxis(new LittleBox(0, 0, 0, 1, 1, 1), viewer.context);
            }
            this.handler.setCenter(new StructureAbsolute(new BlockPos(0, 75, 0), viewer.getBox().copy(), viewer.getAxisContext()));
        }

        @CustomEventSubscribe
        @SideOnly(value=Side.CLIENT)
        public void onButtonClicked(GuiControlClickEvent event) {
            GuiTileViewer viewer = (GuiTileViewer)event.source.parent.get("tileviewer");
            if (event.source.is(new String[]{"even"})) {
                viewer.setEven(((GuiCheckBox)event.source).value);
            }
        }

        @CustomEventSubscribe
        @SideOnly(value=Side.CLIENT)
        public void onStateChange(GuiControlChangedEvent event) {
            if (event.source.is(new String[]{"grid"})) {
                LittleGridContext context;
                GuiStateButton contextBox = (GuiStateButton)event.source;
                try {
                    context = LittleGridContext.get((int)Integer.parseInt(contextBox.getCaption()));
                }
                catch (NumberFormatException e) {
                    context = LittleGridContext.get();
                }
                GuiTileViewer viewer = (GuiTileViewer)event.source.parent.get("tileviewer");
                LittleBox box = viewer.getBox();
                box.convertTo(viewer.getAxisContext(), context);
                box.maxX = viewer.isEven() ? box.minX + 2 : box.minX + 1;
                box.maxY = viewer.isEven() ? box.minY + 2 : box.minY + 1;
                box.maxZ = viewer.isEven() ? box.minZ + 2 : box.minZ + 1;
                viewer.setAxis(box, context);
            }
        }

        protected LittleStructure parseStructure(LittlePreviews previews) {
            LittleRopeConnectionALET structure = (LittleRopeConnectionALET)this.createStructure(LittleRopeConnectionALET.class, null);
            GuiTileViewer viewer = (GuiTileViewer)this.parent.get("tileviewer");
            structure.axisCenter = new StructureRelative(viewer.getBox(), viewer.getAxisContext());
            return structure;
        }

        protected LittleStructureType getStructureType() {
            return LittleStructureRegistry.getStructureType(LittleRopeConnectionALET.class);
        }
    }
}

