/*
 * Decompiled with CFR 0.152.
 */
package com.alet.common.structure.type;

import com.alet.client.gui.controls.GuiConnectedCheckBoxes;
import com.creativemd.creativecore.common.gui.GuiControl;
import com.creativemd.creativecore.common.gui.container.GuiParent;
import com.creativemd.creativecore.common.gui.controls.gui.GuiCheckBox;
import com.creativemd.creativecore.common.gui.controls.gui.GuiLabel;
import com.creativemd.creativecore.common.gui.controls.gui.GuiTextfield;
import com.creativemd.littletiles.common.action.block.LittleActionActivated;
import com.creativemd.littletiles.common.structure.LittleStructure;
import com.creativemd.littletiles.common.structure.animation.AnimationGuiHandler;
import com.creativemd.littletiles.common.structure.registry.LittleStructureGuiParser;
import com.creativemd.littletiles.common.structure.registry.LittleStructureRegistry;
import com.creativemd.littletiles.common.structure.registry.LittleStructureType;
import com.creativemd.littletiles.common.tile.LittleTile;
import com.creativemd.littletiles.common.tile.parent.IStructureTileList;
import com.creativemd.littletiles.common.tile.preview.LittlePreviews;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;

public class LittleRemoteActivatorALET
extends LittleStructure {
    public BlockPos linkedBlock = new BlockPos(0, 0, 0);
    public boolean useAbsolutePos = false;

    public LittleRemoteActivatorALET(LittleStructureType type, IStructureTileList mainBlock) {
        super(type, mainBlock);
    }

    protected void loadFromNBTExtra(NBTTagCompound nbt) {
        if (nbt.func_74764_b("linkedBlock")) {
            NBTTagCompound n = nbt.func_74775_l("linkedBlock");
            this.linkedBlock = NBTUtil.func_186861_c((NBTTagCompound)n);
        }
        if (nbt.func_74764_b("useAbsolutePos")) {
            this.useAbsolutePos = nbt.func_74767_n("useAbsolutePos");
        }
    }

    protected void writeToNBTExtra(NBTTagCompound nbt) {
        nbt.func_74782_a("linkedBlock", (NBTBase)NBTUtil.func_186859_a((BlockPos)this.linkedBlock));
        nbt.func_74757_a("useAbsolutePos", this.useAbsolutePos);
    }

    public boolean onBlockActivated(World worldIn, LittleTile tile, BlockPos pos, EntityPlayer playerIn, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ, LittleActionActivated action) {
        if (worldIn.field_72995_K) {
            return true;
        }
        BlockPos newPos = this.useAbsolutePos ? new BlockPos(this.linkedBlock.func_177958_n(), this.linkedBlock.func_177956_o(), this.linkedBlock.func_177952_p()) : new BlockPos(this.linkedBlock.func_177958_n() + this.getPos().func_177958_n(), this.linkedBlock.func_177956_o() + this.getPos().func_177956_o(), this.linkedBlock.func_177952_p() + this.getPos().func_177952_p());
        float f = (float)((double)hitX - (double)newPos.func_177958_n());
        float f1 = (float)((double)hitY - (double)newPos.func_177956_o());
        float f2 = (float)((double)hitZ - (double)newPos.func_177952_p());
        IBlockState iblockstate = worldIn.func_180495_p(newPos);
        TileEntity tileentity = worldIn.func_175625_s(newPos);
        if (tileentity != null) {
            double distance = new Vec3d(playerIn.field_70165_t, playerIn.field_70163_u, playerIn.field_70161_v).func_72438_d(new Vec3d((double)newPos.func_177958_n(), (double)newPos.func_177956_o(), (double)newPos.func_177952_p()));
            if (distance <= 8.5) {
                if (!iblockstate.func_177230_c().func_180639_a(worldIn, newPos, iblockstate, playerIn, hand, side, f, f1, f2)) {
                    playerIn.func_145747_a((ITextComponent)new TextComponentString("Block: " + iblockstate + " at " + newPos + " failed to activate."));
                }
            } else {
                playerIn.func_145747_a((ITextComponent)new TextComponentString("Block: " + iblockstate + " at " + newPos + " is to farway. Must be within 8.5 blocks player."));
            }
        }
        if (tileentity == null) {
            playerIn.func_145747_a((ITextComponent)new TextComponentString("Block: " + iblockstate + " at " + newPos + " doesn't have a tile entity."));
        }
        return true;
    }

    public static class LittleRemoteActivatorParserALET
    extends LittleStructureGuiParser {
        public LittleRemoteActivatorParserALET(GuiParent parent, AnimationGuiHandler handler) {
            super(parent, handler);
        }

        protected void createControls(LittlePreviews previews, LittleStructure structure) {
            LittleRemoteActivatorALET guiLinker = structure instanceof LittleRemoteActivatorALET ? (LittleRemoteActivatorALET)structure : null;
            this.parent.addControl((GuiControl)new GuiLabel("Pos X:", 0, 0));
            this.parent.addControl((GuiControl)new GuiLabel("Pos Y:", 0, 18));
            this.parent.addControl((GuiControl)new GuiLabel("Pos Z:", 0, 36));
            GuiTextfield x = new GuiTextfield("x", "0", 35, 0, 25, 10);
            GuiTextfield y = new GuiTextfield("y", "0", 35, 18, 25, 10);
            GuiTextfield z = new GuiTextfield("z", "0", 35, 36, 25, 10);
            if (guiLinker != null) {
                x.text = guiLinker.linkedBlock.func_177958_n() + "";
                y.text = guiLinker.linkedBlock.func_177956_o() + "";
                z.text = guiLinker.linkedBlock.func_177952_p() + "";
            }
            this.parent.addControl((GuiControl)x);
            this.parent.addControl((GuiControl)y);
            this.parent.addControl((GuiControl)z);
            GuiConnectedCheckBoxes boxes = new GuiConnectedCheckBoxes("abs", 0, 55);
            boxes.addCheckBox("absolute", "Use Absolute Coordinates");
            boxes.addCheckBox("relative", "Use Relative Coordinates");
            if (guiLinker != null) {
                boxes.setSelected(guiLinker.useAbsolutePos ? "absolute" : "relative");
            }
            this.parent.addControl((GuiControl)boxes);
        }

        protected LittleStructure parseStructure(LittlePreviews previews) {
            LittleRemoteActivatorALET structure = (LittleRemoteActivatorALET)this.createStructure(LittleRemoteActivatorALET.class, null);
            GuiTextfield x = (GuiTextfield)this.parent.get("x");
            GuiTextfield y = (GuiTextfield)this.parent.get("y");
            GuiTextfield z = (GuiTextfield)this.parent.get("z");
            structure.linkedBlock = new BlockPos(Integer.parseInt(x.text), Integer.parseInt(y.text), Integer.parseInt(z.text));
            structure.useAbsolutePos = ((GuiCheckBox)this.parent.get((String)"absolute")).value;
            return structure;
        }

        protected LittleStructureType getStructureType() {
            return LittleStructureRegistry.getStructureType(LittleRemoteActivatorALET.class);
        }
    }
}

