/*
 * Decompiled with CFR 0.152.
 */
package com.alet.common.structure.type;

import com.alet.client.gui.SubGuiSoundSettings;
import com.alet.client.gui.controls.GuiLongTextField;
import com.alet.client.gui.controls.Layer;
import com.alet.client.gui.message.SubGuiNoPathMessage;
import com.alet.client.gui.message.SubGuiTooManyChannels;
import com.alet.common.packet.PacketSendSound;
import com.alet.common.sounds.Notes;
import com.alet.common.structure.sound.Sound;
import com.alet.common.utils.CopyUtils;
import com.creativemd.creativecore.common.gui.GuiControl;
import com.creativemd.creativecore.common.gui.container.GuiParent;
import com.creativemd.creativecore.common.gui.controls.gui.GuiButton;
import com.creativemd.creativecore.common.gui.controls.gui.GuiCheckBox;
import com.creativemd.creativecore.common.gui.controls.gui.GuiComboBox;
import com.creativemd.creativecore.common.gui.controls.gui.GuiScrollBox;
import com.creativemd.creativecore.common.gui.controls.gui.GuiTextfield;
import com.creativemd.creativecore.common.gui.controls.gui.timeline.GuiTimeline;
import com.creativemd.creativecore.common.gui.controls.gui.timeline.IAnimationHandler;
import com.creativemd.creativecore.common.gui.controls.gui.timeline.KeyControl;
import com.creativemd.creativecore.common.gui.controls.gui.timeline.TimelineChannel;
import com.creativemd.creativecore.common.gui.event.ControlEvent;
import com.creativemd.creativecore.common.gui.event.gui.GuiControlChangedEvent;
import com.creativemd.creativecore.common.packet.CreativeCorePacket;
import com.creativemd.creativecore.common.packet.PacketHandler;
import com.creativemd.creativecore.common.utils.math.BooleanUtils;
import com.creativemd.creativecore.common.utils.type.PairList;
import com.creativemd.littletiles.client.gui.dialogs.SubGuiSignalEvents;
import com.creativemd.littletiles.common.action.LittleActionException;
import com.creativemd.littletiles.common.action.block.LittleActionActivated;
import com.creativemd.littletiles.common.structure.LittleStructure;
import com.creativemd.littletiles.common.structure.animation.AnimationGuiHandler;
import com.creativemd.littletiles.common.structure.animation.AnimationTimeline;
import com.creativemd.littletiles.common.structure.animation.ValueTimeline;
import com.creativemd.littletiles.common.structure.animation.event.PlaySoundEvent;
import com.creativemd.littletiles.common.structure.registry.LittleStructureGuiParser;
import com.creativemd.littletiles.common.structure.registry.LittleStructureRegistry;
import com.creativemd.littletiles.common.structure.registry.LittleStructureType;
import com.creativemd.littletiles.common.structure.signal.output.InternalSignalOutput;
import com.creativemd.littletiles.common.tile.LittleTile;
import com.creativemd.littletiles.common.tile.parent.IStructureTileList;
import com.creativemd.littletiles.common.tile.preview.LittlePreviews;
import com.n247s.api.eventapi.eventsystem.CustomEventSubscribe;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nullable;
import javax.sound.midi.Instrument;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiEvent;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Sequence;
import javax.sound.midi.Sequencer;
import javax.sound.midi.ShortMessage;
import javax.sound.midi.Soundbank;
import javax.sound.midi.Synthesizer;
import javax.sound.midi.Track;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class LittleMusicComposerALET
extends LittleStructure {
    public static final int LENGTH = 18;
    public ValueTimeline[] channels = new ValueTimeline[18];
    public String[] channelSounds = new String[18];
    public int duration = 10;
    public int tick = 0;
    public BlockPos pos;
    public boolean play = false;
    public int coursor;
    public boolean playLocal = false;
    public int volume = 1;
    public int tempo = 0;
    public boolean changeTempo = false;

    public LittleMusicComposerALET(LittleStructureType type, IStructureTileList mainBlock) {
        super(type, mainBlock);
    }

    protected void writeToNBTExtra(NBTTagCompound nbt) {
        NBTTagCompound audio = new NBTTagCompound();
        for (int i = 0; i < 18; ++i) {
            ValueTimeline channel = this.channels[i];
            if (channel == null) continue;
            audio.func_74783_a("ch" + i, channel.write());
        }
        NBTTagCompound audioSetting = new NBTTagCompound();
        for (int j = 0; j < 18; ++j) {
            String sound = this.channelSounds[j];
            if (sound == null) continue;
            audioSetting.func_74778_a("chs" + j, sound);
        }
        nbt.func_74782_a("audio", (NBTBase)audio);
        nbt.func_74782_a("audioSetting", (NBTBase)audioSetting);
        nbt.func_74768_a("duration", this.duration);
        nbt.func_74768_a("volume", this.volume);
        nbt.func_74757_a("local", this.playLocal);
        nbt.func_74757_a("change_tempo", this.changeTempo);
        nbt.func_74768_a("tempo", this.tempo);
        nbt.func_74757_a("playing", this.play);
    }

    public void performInternalOutputChange(InternalSignalOutput output) {
        if (((LittleStructureType.InternalComponentOutput)output.component).is("play") && output.getState()[0] != this.play) {
            this.play = !this.play;
        }
    }

    protected void loadFromNBTExtra(NBTTagCompound nbt) {
        if (nbt.func_74764_b("audio")) {
            NBTTagCompound audio = nbt.func_74775_l("audio");
            for (int i = 0; i < 18; ++i) {
                if (!audio.func_74764_b("ch" + i)) continue;
                this.channels[i] = ValueTimeline.read((int[])audio.func_74759_k("ch" + i));
            }
        }
        if (nbt.func_74764_b("audioSetting")) {
            NBTTagCompound audioSetting = nbt.func_74775_l("audioSetting");
            for (int j = 0; j < 18; ++j) {
                if (!audioSetting.func_74764_b("chs" + j)) continue;
                this.channelSounds[j] = audioSetting.func_74779_i("chs" + j);
            }
        }
        if (nbt.func_74764_b("playing")) {
            this.play = nbt.func_74767_n("playing");
        }
        if (nbt.func_74764_b("duration")) {
            this.duration = nbt.func_74762_e("duration");
        }
        if (nbt.func_74764_b("volume")) {
            this.volume = nbt.func_74762_e("volume");
        }
        if (nbt.func_74764_b("local")) {
            this.playLocal = nbt.func_74767_n("local");
        }
        if (nbt.func_74764_b("change_tempo")) {
            this.changeTempo = nbt.func_74767_n("change_tempo");
        }
        if (nbt.func_74764_b("tempo")) {
            this.tempo = nbt.func_74762_e("tempo");
        }
    }

    public boolean onBlockActivated(World worldIn, LittleTile tile, BlockPos pos, EntityPlayer playerIn, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ, LittleActionActivated action) throws LittleActionException {
        if (!worldIn.field_72995_K) {
            this.getOutput(0).toggle();
        }
        return true;
    }

    public void tick() {
        if (this.isClient()) {
            return;
        }
        if (this.play) {
            this.pos = this.getPos();
            ++this.tick;
            this.playSound(this.tick);
            this.getInput(0).updateState(BooleanUtils.toBits((int)0, (int)1));
            if (this.tick > this.duration) {
                this.tick = 0;
                this.play = false;
                this.getInput(0).updateState(BooleanUtils.toBits((int)1, (int)1));
                this.getOutput(0).toggle();
            }
        } else {
            this.tick = 0;
        }
    }

    public void playSound(int tick) {
        int i;
        ArrayList<Integer> pitch = new ArrayList<Integer>();
        ArrayList<ValueTimeline> timeLine = new ArrayList<ValueTimeline>();
        ArrayList<String> sound = new ArrayList<String>();
        for (i = 0; i < this.channels.length - 1; ++i) {
            ValueTimeline channel = this.channels[i];
            String channelSound = this.channelSounds[i];
            if (channel == null || !channel.getPointsCopy().containsKey((Object)tick)) continue;
            pitch.add(((Double)channel.getPointsCopy().getValue((Object)tick)).intValue());
            timeLine.add(channel);
            sound.add(channelSound);
        }
        if (timeLine != null && !timeLine.isEmpty()) {
            for (i = 0; i < timeLine.size(); ++i) {
                if (!((ValueTimeline)timeLine.get(i)).getPointsCopy().containsKey((Object)tick)) continue;
                Notes note = Notes.getNoteFromPitch((Integer)pitch.get(i));
                if (sound.get(i) == "no sound") {
                    return;
                }
                if (note == null) continue;
                PacketHandler.sendPacketToAllPlayers((CreativeCorePacket)new PacketSendSound((Integer)pitch.get(i), this.volume, this.playLocal, this.pos, sound.get(i) != null ? (String)sound.get(i) : "harp"));
            }
        }
    }

    public static class NoteData {
        public int tick;
        public int key;

        public NoteData(int tick, int key) {
            this.tick = tick;
            this.key = key;
        }
    }

    public static class LittleMusicComposerParserALET
    extends LittleStructureGuiParser {
        public String selectedSound;
        public int volume = 1;
        public boolean local = true;
        public boolean pauseUpdate = false;
        public List<String> possibleSounds;
        public String[] channelSounds = new String[18];
        public int tempo = 120;
        public boolean changeTempo = false;
        @SideOnly(value=Side.CLIENT)
        private KeyControl selected;

        public LittleMusicComposerParserALET(GuiParent parent, AnimationGuiHandler handler) {
            super(parent, handler);
        }

        @SideOnly(value=Side.CLIENT)
        public void create(LittlePreviews previews, @Nullable LittleStructure structure) {
            this.createControls(previews, structure);
            this.parent.controls.add(new SubGuiSignalEvents.GuiSignalEventsButton("signal", 0, 191, previews, structure, this.getStructureType()));
        }

        protected void createControls(LittlePreviews previews, LittleStructure structure) {
            LittleMusicComposerALET soundPlayer = structure instanceof LittleMusicComposerALET ? (LittleMusicComposerALET)structure : null;
            ArrayList<TimelineChannel.TimelineChannelDouble> channels = new ArrayList<TimelineChannel.TimelineChannelDouble>();
            for (int i = 0; i < 18; ++i) {
                channels.add(new TimelineChannel.TimelineChannelDouble("CH" + (i + 1)));
                if (soundPlayer != null) {
                    ValueTimeline channel = soundPlayer.channels[i];
                    if (channel != null) {
                        ((TimelineChannel)channels.get(i)).addKeys(channel.getPointsCopy());
                    }
                    if (soundPlayer.channelSounds[i] == null || soundPlayer.channelSounds[i].isEmpty()) continue;
                    this.channelSounds[i] = soundPlayer.channelSounds[i];
                    continue;
                }
                this.channelSounds[i] = "harp";
            }
            if (soundPlayer != null) {
                this.volume = soundPlayer.volume;
                this.local = soundPlayer.playLocal;
                this.tempo = soundPlayer.tempo;
                this.changeTempo = soundPlayer.changeTempo;
            }
            GuiScrollBox box = new GuiScrollBox("scroll_box", 0, 0, 200, 150);
            box.addControl((GuiControl)new GuiTimeline("timeline", 0, 0, 192, 187, soundPlayer != null ? soundPlayer.duration : 100, channels, (IAnimationHandler)this.handler).setSidebarWidth(25));
            this.parent.controls.add(box);
            this.parent.controls.add(new GuiComboBox("keyValue", 209, 0, 35, Notes.allNotes()){

                public void closeBox() {
                    this.updateTimeLine();
                    super.closeBox();
                }
            });
            GuiComboBox keyValue = (GuiComboBox)this.parent.get("keyValue");
            keyValue.setCustomTooltip(new String[]{"Pitch"}).setEnabled(false);
            this.parent.controls.add(new GuiButton("Paste", 108, 175, 28, 8){

                public void onClicked(int x, int y, int button) {
                    GuiLongTextField input = (GuiLongTextField)this.parent.get("file");
                    Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                    String path = CopyUtils.getCopiedFilePath(clipboard);
                    if (path == null) {
                        return;
                    }
                    try {
                        input.text = path;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
            this.parent.controls.add(new GuiCheckBox("changeTempo", "Change Import Tempo", 85, 158, this.changeTempo));
            this.parent.controls.add(new GuiTextfield("keyPosition", "", 209, 22, 35, 10).setNumbersOnly().setEnabled(false).setCustomTooltip(new String[]{"Tick"}));
            this.parent.controls.add(new GuiTextfield("tempo", "0", 209, 157, 35, 10).setNumbersOnly().setEnabled(this.changeTempo).setCustomTooltip(new String[]{"Import Tempo"}));
            this.parent.controls.add(new GuiTextfield("duration_s", structure instanceof LittleMusicComposerALET ? "" + ((LittleMusicComposerALET)structure).duration : "10", 209, 40, 35, 8).setNumbersOnly().setLangTooltip("gui.door.duration"));
            this.parent.controls.add(new GuiButtonSoundChannel("Sound Settings", this, 0, 175, 75, 8));
            this.parent.controls.add(new GuiButton("importMid", "Import Midi", 150, 175, 50, 8){

                public void onClicked(int x, int y, int button) {
                    this.importMidi();
                    this.updateTimeLine();
                }
            });
            this.parent.get("importMid").setCustomTooltip(new String[]{"Enter File Path of a Midi File Below.", "Example: C:\\MIDIs\\Sound.mid"});
            this.parent.controls.add(new GuiButton("clearSounds", "Wipe", 209, 175, 35, 8){

                public void onClicked(int x, int y, int button) {
                    this.clearKeys();
                    this.updateTimeLine();
                }
            });
            this.parent.get("clearSounds").setCustomTooltip(new String[]{"Removes all sounds from each channel"});
            this.parent.controls.add(new GuiLongTextField("file", "", 48, 191, 196, 8).setCustomTooltip(new String[]{"Enter File Path Here"}));
            this.updateTimeLine();
        }

        @CustomEventSubscribe
        @SideOnly(value=Side.CLIENT)
        public void onKeySelected(GuiTimeline.KeySelectedEvent event) {
            GuiComboBox textfield = (GuiComboBox)this.parent.get("keyValue");
            this.selected = (KeyControl)event.source;
            if (((KeyControl)event.source).value instanceof Double) {
                textfield.setEnabled(true);
                textfield.setVisible(true);
                Notes note = Notes.getNoteFromPitch((int)Double.parseDouble("" + this.selected.value));
                textfield.select(note.getPitchName());
            } else {
                textfield.setVisible(false);
                textfield.setEnabled(false);
            }
            GuiTextfield position = (GuiTextfield)this.parent.get("keyPosition");
            position.setEnabled(true);
            position.text = "" + this.selected.tick;
            this.updateTimeLine();
        }

        @CustomEventSubscribe
        @SideOnly(value=Side.CLIENT)
        public void onKeyDeselected(GuiTimeline.KeyDeselectedEvent event) {
            this.selected = null;
            GuiComboBox comboBox = (GuiComboBox)this.parent.get("keyValue");
            comboBox.setEnabled(false);
            comboBox.select(0);
            GuiTextfield textField = (GuiTextfield)this.parent.get("keyPosition");
            textField.setEnabled(false);
            textField.text = "";
            textField.setCursorPositionZero();
            this.updateTimeLine();
        }

        public void updateTimeLine() {
            if (!this.pauseUpdate) {
                GuiTimeline timeline = (GuiTimeline)this.parent.get("timeline");
                AnimationTimeline animation = new AnimationTimeline(timeline.getDuration(), new PairList());
                ArrayList<PlaySoundEvent> events = new ArrayList<PlaySoundEvent>();
                List<Sound> sounds = this.generateArrayOfSounds();
                for (Sound sound : sounds) {
                    PlaySoundEvent event = new PlaySoundEvent(sound.tick);
                    Notes note = Notes.getNoteFromPitch(sound.pitch);
                    event.opening = true;
                    event.pitch = note.getPitch();
                    event.sound = new SoundEvent(new ResourceLocation(note.getResourceLocation(sound.sound)));
                    event.volume = 1.0f;
                    events.add(event);
                }
                this.handler.setTimeline(animation, events);
            }
        }

        @CustomEventSubscribe
        @SideOnly(value=Side.CLIENT)
        public void onChange(GuiControlChangedEvent event) {
            if (event.source.is(new String[]{"keyValue"})) {
                if (this.selected == null) {
                    return;
                }
                if (!this.selected.modifiable) {
                    return;
                }
                try {
                    String pitchName = ((GuiComboBox)event.source).getCaption();
                    Notes note = Notes.getNote(pitchName);
                    this.selected.value = Double.parseDouble(note.getPos() + "");
                }
                catch (NumberFormatException pitchName) {}
            } else if (event.source.is(new String[]{"keyPosition"})) {
                if (!this.selected.modifiable) {
                    return;
                }
                try {
                    GuiTimeline timeline = (GuiTimeline)this.parent.get("timeline");
                    int tick = this.selected.tick;
                    int newTick = Integer.parseInt(((GuiTextfield)event.source).text);
                    if (this.selected.channel.isSpaceFor(this.selected, newTick)) {
                        this.selected.tick = newTick;
                        this.selected.channel.movedKey(this.selected);
                        if (tick != this.selected.tick) {
                            timeline.adjustKeysPositionX();
                        }
                        this.updateTimeLine();
                    }
                }
                catch (NumberFormatException timeline) {}
            } else if (event.source.is(new String[]{"duration_s"})) {
                try {
                    GuiTimeline timeline = (GuiTimeline)this.parent.get("timeline");
                    timeline.setDuration(Integer.parseInt(((GuiTextfield)event.source).text));
                }
                catch (NumberFormatException timeline) {}
            } else if (event.source.is(new String[]{"timeline"}) || event.source.is(new String[]{"keyValue"})) {
                this.updateTimeLine();
            } else if (event.source.is(new String[]{"changeTempo"})) {
                GuiCheckBox box = (GuiCheckBox)this.parent.get("changeTempo");
                GuiTextfield text = (GuiTextfield)this.parent.get("tempo");
                text.setEnabled(box.value);
                this.changeTempo = box.value;
            } else if (event.source.is(new String[]{"tempo"})) {
                GuiTextfield text = (GuiTextfield)this.parent.get("tempo");
                if (!text.text.isEmpty()) {
                    this.tempo = Integer.parseInt(text.text);
                }
            }
        }

        public void clearKeys() {
            GuiTimeline channelList = (GuiTimeline)this.parent.get("timeline");
            ArrayList<KeyControl> controlsToRemove = new ArrayList<KeyControl>();
            for (GuiControl control : channelList.controls) {
                if (!(control instanceof KeyControl)) continue;
                controlsToRemove.add((KeyControl)control);
            }
            for (KeyControl k : controlsToRemove) {
                channelList.removeControl((GuiControl)k);
                for (TimelineChannel ch : channelList.channels) {
                    ch.removeKey(k);
                }
            }
        }

        public void importMidi() {
            block19: {
                GuiLongTextField file = (GuiLongTextField)this.parent.get("file");
                File midiFile = new File(file.text);
                String extension = "";
                if (midiFile.exists()) {
                    extension = midiFile.getName().substring(midiFile.getName().lastIndexOf(".") + 1, midiFile.getName().length());
                    if (!file.text.equals("") && extension.equals("mid")) {
                        try {
                            int i;
                            Sequence sequence = MidiSystem.getSequence(midiFile);
                            Sequencer s = MidiSystem.getSequencer();
                            s.setSequence(sequence);
                            if (this.changeTempo) {
                                s.setTempoInBPM(this.tempo);
                            }
                            double mod = (double)(s.getTempoInBPM() * (float)sequence.getResolution()) / 60.0;
                            this.pauseUpdate = true;
                            Track[] tracks = s.getSequence().getTracks();
                            Instrument[] instrument_bank = null;
                            String[] instrument_names = new String[tracks.length];
                            Synthesizer synthesizer = MidiSystem.getSynthesizer();
                            Soundbank sb = synthesizer.getDefaultSoundbank();
                            ArrayList<List<NoteData>> notes = new ArrayList<List<NoteData>>();
                            if (sb != null) {
                                instrument_bank = sb.getInstruments();
                            }
                            HashSet<Integer> skipChannels = new HashSet<Integer>();
                            for (int j = 0; j < tracks.length; ++j) {
                                Track track = tracks[j];
                                ArrayList<NoteData> nd = new ArrayList<NoteData>();
                                for (i = 0; i < track.size(); ++i) {
                                    MidiEvent event = track.get(i);
                                    MidiMessage message = event.getMessage();
                                    if (!(message instanceof ShortMessage)) continue;
                                    ShortMessage shortMesg = (ShortMessage)message;
                                    skipChannels.add(shortMesg.getChannel());
                                    if (instrument_bank != null && shortMesg.getCommand() == 192) {
                                        Instrument instrument = instrument_bank[shortMesg.getData1()];
                                        instrument_names[j] = instrument.getName();
                                    }
                                    if (shortMesg.getCommand() != 144) continue;
                                    DecimalFormat df = new DecimalFormat("#####.##");
                                    double d = Double.parseDouble(df.format((double)event.getTick() / mod));
                                    int tick = (int)(d * 20.0);
                                    nd.add(new NoteData(tick, shortMesg.getData1()));
                                }
                                notes.add(nd);
                            }
                            GuiTimeline guiChannelList = (GuiTimeline)this.parent.get("timeline");
                            int duration = 0;
                            List<List<NoteData>> organizedList = this.organize(notes);
                            if (organizedList.size() <= 18) {
                                for (i = 0; i < organizedList.size(); ++i) {
                                    List<NoteData> channelList = organizedList.get(i);
                                    for (int j = 0; j < channelList.size(); ++j) {
                                        NoteData data = channelList.get(j);
                                        int key = data.key;
                                        int tick = data.tick;
                                        duration = Math.max(duration, tick);
                                        double pitch = 0.0;
                                        if (key > 64) {
                                            pitch = key % 64;
                                        } else if (key < 64) {
                                            pitch = -(64 % key);
                                        } else if (key == 64) {
                                            pitch = 0.0;
                                        }
                                        KeyControl control = null;
                                        if (((TimelineChannel)guiChannelList.channels.get(i)).isSpaceFor(null, tick)) {
                                            control = ((TimelineChannel)guiChannelList.channels.get(i)).addKey(tick, (Object)pitch);
                                        }
                                        if (control == null) continue;
                                        guiChannelList.adjustKeyPositionX(control);
                                        guiChannelList.adjustKeyPositionY(control);
                                        guiChannelList.addControl((GuiControl)control);
                                        guiChannelList.raiseEvent((ControlEvent)new GuiControlChangedEvent((GuiControl)guiChannelList));
                                    }
                                }
                                GuiTextfield guiDuration = (GuiTextfield)this.parent.get("duration_s");
                                guiDuration.text = duration + "";
                                guiChannelList.setDuration(duration);
                                this.pauseUpdate = false;
                                this.updateTimeLine();
                                break block19;
                            }
                            Layer.addLayer(this.parent.getGui(), new SubGuiTooManyChannels(midiFile.getName()));
                        }
                        catch (IOException | InvalidMidiDataException | MidiUnavailableException e) {
                            e.printStackTrace();
                        }
                    }
                } else {
                    Layer.addLayer(this.parent.getGui(), new SubGuiNoPathMessage(".mid"));
                }
            }
        }

        public List<List<NoteData>> organize(List<List<NoteData>> notes) {
            ArrayList<List<NoteData>> newNotes = new ArrayList<List<NoteData>>();
            boolean flag = true;
            for (List<NoteData> list : notes) {
                ArrayList<NoteData> newList = new ArrayList<NoteData>();
                ArrayList<NoteData> overflowList = new ArrayList<NoteData>();
                for (int i = 0; i < list.size(); ++i) {
                    if (i != 0 && list.get((int)i).tick == list.get((int)(i - 1)).tick) {
                        overflowList.add(list.get(i));
                        continue;
                    }
                    newList.add(list.get(i));
                }
                if (!overflowList.isEmpty()) {
                    flag = false;
                    newNotes.add(overflowList);
                }
                newNotes.add(newList);
            }
            if (flag) {
                return newNotes;
            }
            return this.organize(newNotes);
        }

        protected LittleStructure parseStructure(LittlePreviews previews) {
            LittleMusicComposerALET structure = (LittleMusicComposerALET)this.createStructure(LittleMusicComposerALET.class, null);
            GuiTimeline timeline = (GuiTimeline)this.parent.get("timeline");
            structure.duration = timeline.getDuration();
            for (int i = 0; i < 18; ++i) {
                structure.channels[i] = ValueTimeline.create((int)0, (PairList)((TimelineChannel)timeline.channels.get(i)).getPairs());
                structure.channelSounds[i] = this.channelSounds[i];
            }
            structure.volume = this.volume;
            structure.playLocal = this.local;
            return structure;
        }

        public List<Sound> generateArrayOfSounds() {
            int i;
            ArrayList<Sound> sounds = new ArrayList<Sound>();
            GuiTimeline timeline = (GuiTimeline)this.parent.get("timeline");
            ValueTimeline[] channels = new ValueTimeline[18];
            for (i = 0; i < 18; ++i) {
                channels[i] = ValueTimeline.create((int)0, (PairList)((TimelineChannel)timeline.channels.get(i)).getPairs());
            }
            for (i = 0; i < timeline.getDuration(); ++i) {
                for (int j = 0; j < 18; ++j) {
                    ValueTimeline channel = channels[j];
                    if (channel == null || !channel.getPointsCopy().containsKey((Object)i) || this.channelSounds[j].equals("nosound")) continue;
                    sounds.add(new Sound().setSound(this.channelSounds[j], (Double)channel.getPointsCopy().getValue((Object)i), i));
                }
            }
            return sounds;
        }

        protected LittleStructureType getStructureType() {
            return LittleStructureRegistry.getStructureType(LittleMusicComposerALET.class);
        }

        private class GuiButtonSoundChannel
        extends GuiButton {
            LittleMusicComposerParserALET littleSoundPlayerParserALET;

            public GuiButtonSoundChannel(String caption, LittleMusicComposerParserALET littleSoundPlayerParserALET, int x, int y, int width, int height) {
                super(caption, x, y, width, height);
                this.littleSoundPlayerParserALET = littleSoundPlayerParserALET;
            }

            public void onClicked(int x, int y, int button) {
                SubGuiSoundSettings channelSettings = new SubGuiSoundSettings(this.littleSoundPlayerParserALET);
                Layer.addLayer(this.getGui(), channelSettings);
            }
        }
    }
}

