/*
 * Decompiled with CFR 0.152.
 */
package com.alet.common.structure.type;

import com.alet.client.gui.LittleItemSelector;
import com.alet.client.gui.controls.GuiFakeSlot;
import com.creativemd.creativecore.common.gui.GuiControl;
import com.creativemd.creativecore.common.gui.container.GuiParent;
import com.creativemd.creativecore.common.gui.controls.gui.GuiButton;
import com.creativemd.creativecore.common.gui.controls.gui.GuiCheckBox;
import com.creativemd.creativecore.common.gui.controls.gui.GuiLabel;
import com.creativemd.creativecore.common.gui.controls.gui.GuiScrollBox;
import com.creativemd.creativecore.common.gui.controls.gui.custom.GuiStackSelectorAll;
import com.creativemd.littletiles.common.action.block.LittleActionActivated;
import com.creativemd.littletiles.common.structure.LittleStructure;
import com.creativemd.littletiles.common.structure.animation.AnimationGuiHandler;
import com.creativemd.littletiles.common.structure.exception.CorruptedConnectionException;
import com.creativemd.littletiles.common.structure.exception.NotYetConnectedException;
import com.creativemd.littletiles.common.structure.registry.LittleStructureGuiParser;
import com.creativemd.littletiles.common.structure.registry.LittleStructureRegistry;
import com.creativemd.littletiles.common.structure.registry.LittleStructureType;
import com.creativemd.littletiles.common.structure.signal.output.InternalSignalOutput;
import com.creativemd.littletiles.common.structure.type.door.LittleDoor;
import com.creativemd.littletiles.common.tile.LittleTile;
import com.creativemd.littletiles.common.tile.parent.IStructureTileList;
import com.creativemd.littletiles.common.tile.preview.LittlePreviews;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import org.apache.commons.lang3.ArrayUtils;

public class LittleLockALET
extends LittleStructure {
    public int[] toLock;
    public boolean lockIfOpen = true;
    public ItemStack key = ItemStack.field_190927_a;
    public boolean playSound = true;
    public boolean consumeKey = false;

    public LittleLockALET(LittleStructureType type, IStructureTileList mainBlock) {
        super(type, mainBlock);
    }

    public boolean onBlockActivated(World worldIn, LittleTile tile, BlockPos pos, EntityPlayer playerIn, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ, LittleActionActivated action) {
        if (!worldIn.field_72995_K) {
            if (!this.key.func_190926_b()) {
                if (heldItem.func_77973_b().equals(this.key.func_77973_b())) {
                    this.getOutput(0).toggle();
                    if (this.consumeKey) {
                        heldItem.func_190918_g(1);
                    }
                } else {
                    playerIn.func_146105_b((ITextComponent)new TextComponentString("Incorrect Key"), true);
                }
            } else {
                this.getOutput(0).toggle();
            }
        } else if (this.playSound) {
            SoundEvent event = new SoundEvent(new ResourceLocation("block.wooden_trapdoor.close"));
            worldIn.func_184148_a(playerIn, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), event, SoundCategory.BLOCKS, 1.0f, 1.6f);
        }
        return true;
    }

    public void lockDoor(LittleDoor door) {
        door.disableRightClick = !door.disableRightClick;
        door.mainBlock.getTe().updateBlock();
        door.mainBlock.getTe().updateNeighbour();
        door.updateStructure();
    }

    public void changeLockState() {
        try {
            for (int c : this.toLock) {
                LittleStructure child = this.getChild(c).getStructure();
                if (child instanceof LittleDoor) {
                    LittleDoor door = (LittleDoor)child;
                    if (!this.lockIfOpen) {
                        if (!door.opened) {
                            this.lockDoor(door);
                        }
                    } else {
                        this.lockDoor(door);
                    }
                }
                this.updateStructure();
            }
        }
        catch (CorruptedConnectionException | NotYetConnectedException e) {
            e.printStackTrace();
        }
    }

    protected void loadFromNBTExtra(NBTTagCompound nbt) {
        this.toLock = nbt.func_74759_k("toLock");
        this.key = new ItemStack(nbt.func_74775_l("key"));
        this.lockIfOpen = nbt.func_74767_n("lockIfOpen");
        this.playSound = nbt.func_74767_n("playSound");
        this.consumeKey = nbt.func_74767_n("consumeKey");
    }

    protected void writeToNBTExtra(NBTTagCompound nbt) {
        nbt.func_74783_a("toLock", this.toLock);
        NBTTagCompound nbtItemStack = new NBTTagCompound();
        this.key.func_77955_b(nbtItemStack);
        nbt.func_74782_a("key", (NBTBase)nbtItemStack);
        nbt.func_74757_a("lockIfOpen", this.lockIfOpen);
        nbt.func_74757_a("playSound", this.playSound);
        nbt.func_74757_a("consumeKey", this.consumeKey);
    }

    public void performInternalOutputChange(InternalSignalOutput output) {
        if (((LittleStructureType.InternalComponentOutput)output.component).is("lock")) {
            this.changeLockState();
        }
    }

    public static class LittleLockParserALET
    extends LittleStructureGuiParser {
        public List<Integer> possibleChildren;
        public List<Integer> selectedChildren;

        public LittleLockParserALET(GuiParent parent, AnimationGuiHandler handler) {
            super(parent, handler);
        }

        public String getDisplayName(LittlePreviews previews, int childId) {
            String name = previews.getStructureName();
            if (name == null) {
                name = previews.hasStructure() ? previews.getStructureId() : "none";
            }
            return name + " " + childId;
        }

        protected void createControls(LittlePreviews previews, LittleStructure structure) {
            EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
            LittleLockALET lock = structure instanceof LittleLockALET ? (LittleLockALET)structure : null;
            GuiScrollBox box = new GuiScrollBox("content", 0, 0, 100, 115);
            this.parent.removeControl((GuiControl)box);
            this.parent.controls.add(box);
            this.possibleChildren = new ArrayList<Integer>();
            int i = 0;
            int added = 0;
            for (LittlePreviews child : previews.getChildren()) {
                Class clazz = LittleStructureRegistry.getStructureClass((String)child.getStructureId());
                if (clazz != null && LittleDoor.class.isAssignableFrom(clazz)) {
                    box.addControl((GuiControl)new GuiCheckBox("" + i, this.getDisplayName(child, i), 0, added * 20, lock != null && ArrayUtils.contains((int[])lock.toLock, (int)i)));
                    this.possibleChildren.add(i);
                    ++added;
                }
                ++i;
            }
            this.parent.controls.add(new GuiLabel("Current Key:", 108, 45));
            this.parent.controls.add(new GuiButton("use", "Use Item As Key", 110, 23){

                public void onClicked(int x, int y, int button) {
                    GuiStackSelectorAll preview = (GuiStackSelectorAll)this.parent.get("preview");
                    GuiFakeSlot key = (GuiFakeSlot)this.parent.get("key");
                    key.updateItemStack(preview.getSelected());
                }
            });
            this.parent.controls.add(new GuiStackSelectorAll("preview", 110, 0, 110, (EntityPlayer)player, (GuiStackSelectorAll.StackCollector)new GuiStackSelectorAll.InventoryCollector((GuiStackSelectorAll.StackSelector)new LittleItemSelector()), true));
            this.parent.controls.add(new GuiFakeSlot("key", 175, 41, 18, 18));
            this.parent.controls.add(new GuiCheckBox("lockIfOpened", "Lock When Opened", 109, 62, lock != null ? lock.lockIfOpen : true));
            this.parent.controls.add(new GuiCheckBox("playSound", "Play Sound When Locked", 109, 76, lock != null ? lock.playSound : true));
            this.parent.controls.add(new GuiCheckBox("consumeKey", "Consume Key On Use", 109, 90, lock != null ? lock.consumeKey : false));
            if (!player.func_184812_l_()) {
                GuiCheckBox consumeKey = (GuiCheckBox)this.parent.get("consumeKey");
                consumeKey.enabled = false;
                consumeKey.setCustomTooltip(new String[]{"Must Be In Creaive Mode To Use."});
            }
            if (lock != null && !lock.key.func_190926_b()) {
                GuiStackSelectorAll preview = (GuiStackSelectorAll)this.parent.get("preview");
                GuiFakeSlot key = (GuiFakeSlot)this.parent.get("key");
                key.updateItemStack(lock.key);
            }
        }

        protected LittleStructure parseStructure(LittlePreviews previews) {
            LittleLockALET structure = (LittleLockALET)this.createStructure(LittleLockALET.class, null);
            GuiScrollBox box = (GuiScrollBox)this.parent.get("content");
            GuiCheckBox checkLockIfOpen = (GuiCheckBox)this.parent.get("lockIfOpened");
            GuiCheckBox checkPlaySound = (GuiCheckBox)this.parent.get("playSound");
            GuiCheckBox checkConsumeKey = (GuiCheckBox)this.parent.get("consumeKey");
            GuiFakeSlot selectedKey = (GuiFakeSlot)this.parent.get("key");
            ArrayList<Integer> toLock = new ArrayList<Integer>();
            for (Integer integer : this.possibleChildren) {
                GuiCheckBox checkBox = (GuiCheckBox)box.get("" + integer);
                if (checkBox == null || !checkBox.value) continue;
                toLock.add(integer);
            }
            structure.toLock = new int[toLock.size()];
            structure.key = selectedKey.basic.func_70301_a(0);
            structure.lockIfOpen = checkLockIfOpen.value;
            structure.playSound = checkPlaySound.value;
            structure.consumeKey = checkConsumeKey.value;
            for (int i = 0; i < structure.toLock.length; ++i) {
                structure.toLock[i] = (Integer)toLock.get(i);
            }
            return structure;
        }

        protected LittleStructureType getStructureType() {
            return LittleStructureRegistry.getStructureType(LittleLockALET.class);
        }
    }
}

