/*
 * Decompiled with CFR 0.152.
 */
package com.alet.common.structure.type;

import com.alet.common.packet.PacketGetServerCams;
import com.creativemd.cmdcam.common.packet.StartPathPacket;
import com.creativemd.cmdcam.common.utils.CamPath;
import com.creativemd.cmdcam.server.CMDCamServer;
import com.creativemd.cmdcam.server.CamCommandServer;
import com.creativemd.creativecore.common.gui.GuiControl;
import com.creativemd.creativecore.common.gui.container.GuiParent;
import com.creativemd.creativecore.common.gui.controls.gui.GuiCheckBox;
import com.creativemd.creativecore.common.gui.controls.gui.GuiComboBox;
import com.creativemd.creativecore.common.gui.controls.gui.GuiLabel;
import com.creativemd.creativecore.common.gui.controls.gui.GuiTextBox;
import com.creativemd.creativecore.common.gui.controls.gui.GuiTextfield;
import com.creativemd.creativecore.common.packet.CreativeCorePacket;
import com.creativemd.creativecore.common.packet.PacketHandler;
import com.creativemd.littletiles.common.action.LittleActionException;
import com.creativemd.littletiles.common.action.block.LittleActionActivated;
import com.creativemd.littletiles.common.structure.LittleStructure;
import com.creativemd.littletiles.common.structure.animation.AnimationGuiHandler;
import com.creativemd.littletiles.common.structure.registry.LittleStructureGuiParser;
import com.creativemd.littletiles.common.structure.registry.LittleStructureRegistry;
import com.creativemd.littletiles.common.structure.registry.LittleStructureType;
import com.creativemd.littletiles.common.structure.signal.output.InternalSignalOutput;
import com.creativemd.littletiles.common.tile.LittleTile;
import com.creativemd.littletiles.common.tile.parent.IStructureTileList;
import com.creativemd.littletiles.common.tile.preview.LittlePreviews;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;

public class LittleCamPlayerALET
extends LittleStructure {
    public String camToPlay = "";
    public boolean playerIsCamera = true;
    public int duration = 0;
    public int loop = 0;

    public LittleCamPlayerALET(LittleStructureType type, IStructureTileList mainBlock) {
        super(type, mainBlock);
    }

    public void performInternalOutputChange(InternalSignalOutput output) {
        if (((LittleStructureType.InternalComponentOutput)output.component).is("play")) {
            this.playCam(output.getStructureWorld());
        }
    }

    public void playCam(World world) {
        if (world.field_72995_K) {
            return;
        }
        CamPath path = CMDCamServer.getPath((World)world, (String)this.camToPlay);
        if (path != null && CamCommandServer.StringToDuration((String)(this.duration + "")) != 0L) {
            if (!path.isRunning()) {
                long duration;
                path.mode = this.playerIsCamera ? "default" : "outside";
                path.duration = duration = CamCommandServer.StringToDuration((String)(this.duration + ""));
                path.loop = this.loop;
            } else {
                for (EntityPlayer player : world.field_73010_i) {
                    player.func_145747_a((ITextComponent)new TextComponentString("Path 'new' could not be found!"));
                }
            }
            PacketHandler.sendPacketToAllPlayers((CreativeCorePacket)new StartPathPacket(path));
        }
    }

    public boolean onBlockActivated(World worldIn, LittleTile tile, BlockPos pos, EntityPlayer playerIn, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ, LittleActionActivated action) throws LittleActionException {
        if (playerIn.func_184812_l_()) {
            this.playCam(worldIn);
        }
        return true;
    }

    protected void loadFromNBTExtra(NBTTagCompound nbt) {
        this.camToPlay = nbt.func_74779_i("cam");
        this.playerIsCamera = nbt.func_74767_n("playerIsCam");
        this.duration = nbt.func_74762_e("duration");
        this.loop = nbt.func_74762_e("loop");
    }

    protected void writeToNBTExtra(NBTTagCompound nbt) {
        nbt.func_74778_a("cam", this.camToPlay);
        nbt.func_74757_a("playerIsCam", this.playerIsCamera);
        nbt.func_74768_a("duration", this.duration);
        nbt.func_74768_a("loop", this.loop);
    }

    public static class LittleCamPlayerParserALET
    extends LittleStructureGuiParser {
        public LittleCamPlayerParserALET(GuiParent parent, AnimationGuiHandler handler) {
            super(parent, handler);
        }

        protected void createControls(LittlePreviews previews, LittleStructure structure) {
            LittleCamPlayerALET camPlayer;
            EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
            LittleCamPlayerALET littleCamPlayerALET = camPlayer = structure instanceof LittleCamPlayerALET ? (LittleCamPlayerALET)structure : null;
            if (camPlayer != null) {
                PacketHandler.sendPacketToServer((CreativeCorePacket)new PacketGetServerCams(camPlayer.camToPlay));
            } else {
                PacketHandler.sendPacketToServer((CreativeCorePacket)new PacketGetServerCams(""));
            }
            ArrayList list = new ArrayList();
            GuiComboBox box = new GuiComboBox("cameras", 0, 0, 100, list);
            box.enabled = false;
            this.parent.controls.add(box);
            this.parent.controls.add(new GuiCheckBox("plyrCam", "Player Is Camera", 0, 22, camPlayer == null ? true : camPlayer.playerIsCamera));
            this.parent.controls.add(new GuiLabel("Duration: ", 0, 40));
            this.parent.controls.add(new GuiLabel("Loop: ", 0, 60));
            this.parent.controls.add(new GuiTextfield("duration", camPlayer == null ? "0" : camPlayer.duration + "", 50, 40, 20, 10));
            this.parent.controls.add(new GuiTextfield("loop", camPlayer == null ? "0" : camPlayer.loop + "", 50, 60, 20, 10));
            this.parent.controls.add(new GuiTextBox("text", "Use the /cam-server add command to add a new path to the drop down menu. Duration cannot be zero. It will not play.", 110, 0, 82));
            if (!player.func_184812_l_()) {
                for (GuiControl control : this.parent.controls) {
                    control.enabled = false;
                }
                this.parent.controls.add(new GuiTextBox("message", "These settings are only avalible in creative mode", 140, 45, 50));
                this.parent.get((String)"text").visible = false;
            }
        }

        protected LittleStructure parseStructure(LittlePreviews previews) {
            LittleCamPlayerALET structure = (LittleCamPlayerALET)this.createStructure(LittleCamPlayerALET.class, null);
            GuiComboBox cameras = (GuiComboBox)this.parent.get("cameras");
            GuiCheckBox plyrCam = (GuiCheckBox)this.parent.get("plyrCam");
            GuiTextfield duration = (GuiTextfield)this.parent.get("duration");
            GuiTextfield loop = (GuiTextfield)this.parent.get("loop");
            structure.camToPlay = cameras.getCaption();
            structure.playerIsCamera = plyrCam.value;
            structure.duration = Integer.parseInt(duration.text);
            structure.loop = Integer.parseInt(loop.text);
            return structure;
        }

        protected LittleStructureType getStructureType() {
            return LittleStructureRegistry.getStructureType(LittleCamPlayerALET.class);
        }
    }
}

