/*
 * Decompiled with CFR 0.152.
 */
package com.alet.common.structure.type;

import com.alet.common.entity.EntitySit;
import com.creativemd.creativecore.common.gui.container.GuiParent;
import com.creativemd.creativecore.common.gui.controls.gui.GuiCheckBox;
import com.creativemd.creativecore.common.gui.controls.gui.GuiIconButton;
import com.creativemd.creativecore.common.gui.controls.gui.GuiStateButton;
import com.creativemd.creativecore.common.gui.event.gui.GuiControlChangedEvent;
import com.creativemd.creativecore.common.gui.event.gui.GuiControlClickEvent;
import com.creativemd.creativecore.common.utils.math.BooleanUtils;
import com.creativemd.creativecore.common.world.CreativeWorld;
import com.creativemd.creativecore.common.world.IOrientatedWorld;
import com.creativemd.creativecore.common.world.SubWorld;
import com.creativemd.littletiles.client.gui.controls.GuiTileViewer;
import com.creativemd.littletiles.common.action.block.LittleActionActivated;
import com.creativemd.littletiles.common.structure.LittleStructure;
import com.creativemd.littletiles.common.structure.animation.AnimationGuiHandler;
import com.creativemd.littletiles.common.structure.connection.StructureChildConnection;
import com.creativemd.littletiles.common.structure.exception.CorruptedConnectionException;
import com.creativemd.littletiles.common.structure.exception.NotYetConnectedException;
import com.creativemd.littletiles.common.structure.registry.LittleStructureGuiParser;
import com.creativemd.littletiles.common.structure.registry.LittleStructureRegistry;
import com.creativemd.littletiles.common.structure.registry.LittleStructureType;
import com.creativemd.littletiles.common.structure.relative.StructureAbsolute;
import com.creativemd.littletiles.common.structure.relative.StructureRelative;
import com.creativemd.littletiles.common.structure.type.door.LittleAdvancedDoor;
import com.creativemd.littletiles.common.tile.LittleTile;
import com.creativemd.littletiles.common.tile.math.box.LittleBox;
import com.creativemd.littletiles.common.tile.math.vec.LittleAbsoluteVec;
import com.creativemd.littletiles.common.tile.parent.IStructureTileList;
import com.creativemd.littletiles.common.tile.preview.LittlePreviews;
import com.creativemd.littletiles.common.util.grid.LittleGridContext;
import com.creativemd.littletiles.common.world.LittleNeighborUpdateCollector;
import com.n247s.api.eventapi.eventsystem.CustomEventSubscribe;
import java.util.UUID;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class LittleAdvancedSeat
extends LittleAdvancedDoor {
    private UUID sitUUID;
    private EntityPlayer player;

    public LittleAdvancedSeat(LittleStructureType type, IStructureTileList mainBlock) {
        super(type, mainBlock);
    }

    protected void loadFromNBTExtra(NBTTagCompound nbt) {
        this.sitUUID = nbt.func_74764_b("connection") ? UUID.fromString(nbt.func_74779_i("connection")) : null;
    }

    protected void writeToNBTExtra(NBTTagCompound nbt) {
        if (this.sitUUID != null) {
            nbt.func_74778_a("connection", this.sitUUID.toString());
        } else {
            nbt.func_82580_o("connection");
        }
    }

    public boolean onBlockActivated(World world, LittleTile tile, BlockPos pos, EntityPlayer player, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ, LittleActionActivated action) {
        if (!world.field_72995_K) {
            if (this.player != null) {
                return true;
            }
            try {
                LittleAbsoluteVec vec = this.getHighestCenterPoint();
                if (vec != null) {
                    if (world instanceof IOrientatedWorld) {
                        world = ((IOrientatedWorld)world).getRealWorld();
                    }
                    EntitySit sit = new EntitySit(this, world, vec.getPosX(), vec.getPosY() - 0.25, vec.getPosZ());
                    this.sitUUID = sit.getPersistentID();
                    player.func_184220_m((Entity)sit);
                    world.func_72838_d((Entity)sit);
                    this.setPlayer(player);
                }
            }
            catch (CorruptedConnectionException | NotYetConnectedException e) {
                e.printStackTrace();
            }
        }
        return true;
    }

    public void setPlayer(EntityPlayer player) {
        this.player = player;
        if (!this.getWorld().field_72995_K) {
            this.getInput(0).updateState(BooleanUtils.asArray((player != null ? 1 : 0) != 0));
        }
        if (this.player == null) {
            this.sitUUID = null;
        }
    }

    public void afterPlaced() {
        super.afterPlaced();
        if (this.sitUUID != null) {
            World world = this.getWorld();
            if (world instanceof IOrientatedWorld) {
                if (world instanceof CreativeWorld && ((CreativeWorld)world).parent == null) {
                    return;
                }
                world = ((IOrientatedWorld)world).getRealWorld();
            }
            for (Entity entity : world.field_72996_f) {
                if (!entity.func_110124_au().equals(this.sitUUID) || !(entity instanceof EntitySit)) continue;
                EntitySit sit = (EntitySit)entity;
                StructureChildConnection temp = this.generateConnection(sit);
                sit.func_184212_Q().func_187227_b(EntitySit.CONNECTION, (Object)temp.writeToNBT(new NBTTagCompound()));
                break;
            }
        }
    }

    public void removeStructure(LittleNeighborUpdateCollector neighbor) throws CorruptedConnectionException, NotYetConnectedException {
        if (!this.getWorld().field_72995_K) {
            Entity entity;
            World world = this.getWorld();
            WorldServer serverWorld = null;
            if (this.getWorld() instanceof SubWorld) {
                SubWorld subWorld = (SubWorld)world;
                serverWorld = (WorldServer)subWorld.getRealWorld();
            } else if (this.getWorld() instanceof WorldServer) {
                serverWorld = (WorldServer)this.getWorld();
            }
            if (serverWorld != null && (entity = serverWorld.func_175733_a(this.sitUUID)) != null && entity instanceof EntitySit) {
                EntitySit connection = (EntitySit)entity;
                connection.func_70106_y();
            }
        }
        super.removeStructure(neighbor);
    }

    public void onStructureDestroyed() {
        super.onStructureDestroyed();
    }

    public static class LittleAdvancedSeatParserALET
    extends LittleStructureGuiParser {
        public LittleAdvancedSeatParserALET(GuiParent parent, AnimationGuiHandler handler) {
            super(parent, handler);
        }

        protected void createControls(LittlePreviews previews, LittleStructure structure) {
            LittleAdvancedDoor door = structure instanceof LittleAdvancedDoor ? (LittleAdvancedDoor)structure : null;
            final GuiTileViewer viewer = new GuiTileViewer("tileviewer", 0, 0, 100, 100, previews.getContext());
            this.setViewer(viewer, door, previews.getContext());
            this.parent.controls.add(viewer);
            this.parent.controls.add(new GuiIconButton("reset view", 20, 107, 8){

                public void onClicked(int x, int y, int button) {
                    viewer.offsetX.set(0.0);
                    viewer.offsetY.set(0.0);
                    viewer.scale.set(40.0);
                }
            }.setCustomTooltip(new String[]{"reset view"}));
            this.parent.controls.add(new GuiIconButton("change view", 40, 107, 7){

                public void onClicked(int x, int y, int button) {
                    switch (viewer.getAxis()) {
                        case X: {
                            viewer.setViewAxis(EnumFacing.Axis.Y);
                            break;
                        }
                        case Y: {
                            viewer.setViewAxis(EnumFacing.Axis.Z);
                            break;
                        }
                        case Z: {
                            viewer.setViewAxis(EnumFacing.Axis.X);
                            break;
                        }
                    }
                }
            }.setCustomTooltip(new String[]{"change view"}));
            this.parent.controls.add(new GuiIconButton("flip view", 60, 107, 4){

                public void onClicked(int x, int y, int button) {
                    viewer.setViewDirection(viewer.getViewDirection().func_176734_d());
                }
            }.setCustomTooltip(new String[]{"flip view"}));
            this.parent.controls.add(new GuiIconButton("up", 124, 33, 1){

                public void onClicked(int x, int y, int button) {
                    viewer.moveY(GuiScreen.func_146271_m() ? viewer.context.size : 1);
                }
            });
            this.parent.controls.add(new GuiIconButton("right", 141, 50, 0){

                public void onClicked(int x, int y, int button) {
                    viewer.moveX(GuiScreen.func_146271_m() ? viewer.context.size : 1);
                }
            });
            this.parent.controls.add(new GuiIconButton("left", 107, 50, 2){

                public void onClicked(int x, int y, int button) {
                    viewer.moveX(-(GuiScreen.func_146271_m() ? viewer.context.size : 1));
                }
            });
            this.parent.controls.add(new GuiIconButton("down", 124, 50, 3){

                public void onClicked(int x, int y, int button) {
                    viewer.moveY(-(GuiScreen.func_146271_m() ? viewer.context.size : 1));
                }
            });
            this.parent.controls.add(new GuiCheckBox("even", 107, 0, viewer.isEven()));
            GuiStateButton contextBox = new GuiStateButton("grid", LittleGridContext.getNames().indexOf(viewer.getAxisContext() + ""), 107, 80, 20, 12, LittleGridContext.getNames().toArray(new String[0]));
            this.parent.controls.add(contextBox);
        }

        private void setViewer(GuiTileViewer viewer, LittleAdvancedDoor door, LittleGridContext axisContext) {
            viewer.visibleAxis = true;
            boolean even = false;
            if (door != null) {
                even = door.axisCenter.isEven();
                viewer.setEven(even);
                door.axisCenter.convertToSmallest();
                axisContext = door.axisCenter.getContext();
                viewer.setAxis(door.axisCenter.getBox(), axisContext);
            } else {
                viewer.setEven(false);
                viewer.setAxis(new LittleBox(0, 0, 0, 1, 1, 1), viewer.context);
            }
            this.handler.setCenter(new StructureAbsolute(new BlockPos(0, 75, 0), viewer.getBox().copy(), viewer.getAxisContext()));
        }

        @CustomEventSubscribe
        @SideOnly(value=Side.CLIENT)
        public void onButtonClicked(GuiControlClickEvent event) {
            GuiTileViewer viewer = (GuiTileViewer)event.source.parent.get("tileviewer");
            if (event.source.is(new String[]{"even"})) {
                viewer.setEven(((GuiCheckBox)event.source).value);
            }
        }

        @CustomEventSubscribe
        @SideOnly(value=Side.CLIENT)
        public void onStateChange(GuiControlChangedEvent event) {
            if (event.source.is(new String[]{"grid"})) {
                LittleGridContext context;
                GuiStateButton contextBox = (GuiStateButton)event.source;
                try {
                    context = LittleGridContext.get((int)Integer.parseInt(contextBox.getCaption()));
                }
                catch (NumberFormatException e) {
                    context = LittleGridContext.get();
                }
                GuiTileViewer viewer = (GuiTileViewer)event.source.parent.get("tileviewer");
                LittleBox box = viewer.getBox();
                box.convertTo(viewer.getAxisContext(), context);
                box.maxX = viewer.isEven() ? box.minX + 2 : box.minX + 1;
                box.maxY = viewer.isEven() ? box.minY + 2 : box.minY + 1;
                box.maxZ = viewer.isEven() ? box.minZ + 2 : box.minZ + 1;
                viewer.setAxis(box, context);
            }
        }

        protected LittleStructure parseStructure(LittlePreviews previews) {
            LittleAdvancedSeat structure = (LittleAdvancedSeat)this.createStructure(LittleAdvancedSeat.class, null);
            GuiTileViewer viewer = (GuiTileViewer)this.parent.get("tileviewer");
            structure.axisCenter = new StructureRelative(viewer.getBox(), viewer.getAxisContext());
            return structure;
        }

        protected LittleStructureType getStructureType() {
            return LittleStructureRegistry.getStructureType(LittleAdvancedSeat.class);
        }
    }
}

