/*
 * Decompiled with CFR 0.152.
 */
package com.alet.common.structure.sound;

import com.alet.common.structure.sound.handler.ISoundHandler;
import com.creativemd.littletiles.common.entity.EntityAnimation;
import com.creativemd.littletiles.common.structure.LittleStructure;
import com.creativemd.littletiles.common.structure.animation.AnimationState;
import com.creativemd.littletiles.common.structure.animation.AnimationTimeline;
import com.creativemd.littletiles.common.structure.animation.event.AnimationEvent;
import com.creativemd.littletiles.common.structure.relative.StructureAbsolute;
import com.creativemd.littletiles.common.tile.preview.LittlePreviews;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import javax.vecmath.Vector3d;

public class SoundGuiHandler
implements ISoundHandler {
    public double offX;
    public double offY;
    public double offZ;
    public double rotX;
    public double rotY;
    public double rotZ;
    public int offset;
    private int setDuration = 0;
    private int lastTick = -1;
    private StructureAbsolute center = null;
    private boolean loop = true;
    private boolean playing = false;
    private int tick = 0;
    private AnimationTimeline timeline;
    private AnimationState state = new AnimationState();
    public List<SoundGuiHolder> subHolders = new ArrayList<SoundGuiHolder>();
    private boolean eventsChanged = false;

    public SoundGuiHandler(int offset, SoundGuiHandler copy) {
        this.offset = offset;
        this.lastTick = copy.lastTick;
        this.loop = copy.loop;
        this.playing = copy.playing;
        this.tick = copy.tick;
    }

    public SoundGuiHandler() {
    }

    public void takeInitialState(EntityAnimation animation) {
        this.offX = animation.initalOffX;
        this.offY = animation.initalOffY;
        this.offZ = animation.initalOffZ;
        this.rotX = animation.initalRotX;
        this.rotY = animation.initalRotY;
        this.rotZ = animation.initalRotZ;
    }

    public boolean hasTimeline() {
        return this.timeline != null;
    }

    public void setCenter(StructureAbsolute center) {
        this.center = center;
    }

    @Override
    public void loop(boolean loop) {
        this.loop = loop;
        for (SoundGuiHolder holder : this.subHolders) {
            holder.handler.loop(loop);
        }
    }

    @Override
    public void play() {
        this.playing = true;
        for (SoundGuiHolder holder : this.subHolders) {
            holder.handler.play();
        }
    }

    @Override
    public void pause() {
        this.playing = false;
        for (SoundGuiHolder holder : this.subHolders) {
            holder.handler.pause();
        }
    }

    @Override
    public void stop() {
        this.playing = false;
        this.set(0);
        for (SoundGuiHolder holder : this.subHolders) {
            holder.handler.stop();
        }
    }

    @Override
    public void set(int tick) {
        this.tick = tick;
        for (SoundGuiHolder holder : this.subHolders) {
            holder.handler.set(tick);
        }
    }

    @Override
    public int get() {
        return this.tick;
    }

    public void tick(LittlePreviews previews, LittleStructure structure, EntityAnimation animation) {
        if (this.timeline == null) {
            return;
        }
        if (this.playing) {
            if (this.tick > this.timeline.duration) {
                if (this.loop) {
                    this.tick = 0;
                }
            } else {
                ++this.tick;
            }
        }
        if (this.center != null) {
            animation.setCenter(this.center);
            this.center = null;
        }
        boolean hasChanged = false;
        if (this.eventsChanged) {
            for (SoundGuiHolder holder : this.subHolders) {
                holder.handler.stop();
                if (holder.animation == null) continue;
                holder.handler.updateTick(holder.animation);
                holder.handler.updateTick(holder.animation);
            }
            this.subHolders.clear();
            hasChanged = true;
            this.eventsChanged = false;
        }
        for (SoundGuiHolder holder : this.subHolders) {
            holder.handler.tick(holder.previews, holder.structure, holder.animation);
        }
        if (hasChanged) {
            this.updateTimeline();
        }
        if (animation != null) {
            this.updateTick(animation);
        }
    }

    public void updateTick(EntityAnimation animation) {
        animation.origin.tick();
        if (this.tick == this.lastTick) {
            return;
        }
        this.lastTick = this.tick;
        if (this.timeline != null) {
            this.timeline.tick(Math.min(this.tick, this.timeline.duration), this.state);
        } else {
            this.state.clear();
        }
        Vector3d offset = this.state.getOffset();
        Vector3d rotation = this.state.getRotation();
        animation.moveAndRotateAnimation(offset.x - animation.origin.offX() + this.offX, offset.y - animation.origin.offY() + this.offY, offset.z - animation.origin.offZ() + this.offZ, rotation.x - animation.origin.rotX() + this.rotX, rotation.y - animation.origin.rotY() + -this.rotY, rotation.z - animation.origin.rotZ() + this.rotZ);
    }

    public int getMaxDuration() {
        int duration = this.setDuration;
        for (SoundGuiHolder holder : this.subHolders) {
            duration = Math.max(holder.handler.getMaxDuration(), duration);
        }
        return duration;
    }

    public void updateTimeline() {
        this.syncTimelineDuration(this.getMaxDuration());
    }

    public void syncTimelineDuration(int duration) {
        this.timeline.duration = duration;
        for (SoundGuiHolder holder : this.subHolders) {
            holder.handler.syncTimelineDuration(duration);
        }
    }

    public void setTimeline(AnimationTimeline timeline, List<AnimationEvent> events) {
        this.timeline = timeline;
        if (this.timeline != null) {
            this.timeline.offset(this.offset);
            this.setDuration = this.timeline.duration;
            this.updateTimeline();
        } else {
            this.setDuration = 0;
        }
        this.state.clear();
        this.eventsChanged = true;
    }

    public static class SoundGuiHolder {
        public final LittlePreviews previews;
        public final SoundGuiHandler handler;
        public final LittleStructure structure;
        @Nullable
        public final EntityAnimation animation;

        public SoundGuiHolder(LittlePreviews previews, SoundGuiHandler handler, LittleStructure structure, @Nullable EntityAnimation animation) {
            this.previews = previews;
            this.handler = handler;
            this.structure = structure;
            this.animation = animation;
            if (animation != null) {
                handler.takeInitialState(animation);
            }
        }
    }
}

