/*
 * Decompiled with CFR 0.152.
 */
package com.alet.common.structure.connection;

import com.alet.common.entity.RopeData;
import com.alet.common.structure.type.LittleRopeConnectionALET;
import com.creativemd.creativecore.common.utils.math.Rotation;
import com.creativemd.creativecore.common.utils.math.RotationUtils;
import com.creativemd.creativecore.common.utils.math.collision.MatrixUtils;
import com.creativemd.creativecore.common.utils.math.vec.IVecOrigin;
import com.creativemd.creativecore.common.utils.mc.TickUtils;
import com.creativemd.creativecore.common.utils.mc.WorldUtils;
import com.creativemd.creativecore.common.world.IOrientatedWorld;
import com.creativemd.littletiles.common.entity.EntityAnimation;
import com.creativemd.littletiles.common.structure.LittleStructure;
import com.creativemd.littletiles.common.structure.connection.IWorldPositionProvider;
import com.creativemd.littletiles.common.structure.exception.CorruptedConnectionException;
import com.creativemd.littletiles.common.structure.exception.CorruptedLinkException;
import com.creativemd.littletiles.common.structure.exception.MissingAnimationException;
import com.creativemd.littletiles.common.structure.exception.MissingBlockException;
import com.creativemd.littletiles.common.structure.exception.MissingStructureException;
import com.creativemd.littletiles.common.structure.exception.MissingWorldException;
import com.creativemd.littletiles.common.structure.exception.NotYetConnectedException;
import com.creativemd.littletiles.common.tile.math.location.StructureLocation;
import com.creativemd.littletiles.common.tile.parent.IStructureTileList;
import com.creativemd.littletiles.common.tileentity.TileEntityLittleTiles;
import com.creativemd.littletiles.common.world.WorldAnimationHandler;
import com.google.common.base.Objects;
import java.security.InvalidParameterException;
import java.util.UUID;
import javax.annotation.Nullable;
import javax.vecmath.Matrix3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;

public class RopeConnection {
    private UUID worldUUID;
    private final IWorldPositionProvider parent;
    private BlockPos relativePos;
    private BlockPos unrotatedPos;
    private TileEntityLittleTiles cachedTe;
    private Vector3d targetCenter;
    public Vector3d backupTargetCenter;
    private Vector3d lastTargetCenter;
    private LittleRopeConnectionALET targetStructure;
    public final boolean IS_HEAD;
    public int targetStructureIndex;
    public RopeData ropeData;

    public RopeConnection(IWorldPositionProvider parent, StructureLocation location, int targetStructureIndex, boolean isHead, @Nullable RopeData ropeData) {
        this.parent = parent;
        this.IS_HEAD = isHead;
        this.unrotatedPos = this.relativePos = location.pos.func_177973_b((Vec3i)this.parent.getPos());
        if (location.worldUUID != null) {
            this.worldUUID = location.worldUUID;
        }
        this.targetStructureIndex = targetStructureIndex;
        this.ropeData = ropeData;
    }

    public RopeConnection(IWorldPositionProvider parent, NBTTagCompound nbt) {
        this.IS_HEAD = nbt.func_74767_n("isHead");
        this.parent = parent;
        int[] array = nbt.func_74759_k("coord");
        if (array.length != 3) {
            throw new InvalidParameterException("No valid coord given " + nbt);
        }
        this.relativePos = new BlockPos(array[0], array[1], array[2]);
        array = nbt.func_74759_k("unrotCoord");
        this.unrotatedPos = array.length == 3 ? new BlockPos(array[0], array[1], array[2]) : this.relativePos;
        if (nbt.func_74764_b("world")) {
            this.worldUUID = UUID.fromString(nbt.func_74779_i("world"));
        }
        if (nbt.func_74764_b("xCenter") && nbt.func_74764_b("yCenter") && nbt.func_74764_b("zCenter")) {
            this.backupTargetCenter = new Vector3d(nbt.func_74769_h("xCenter"), nbt.func_74769_h("yCenter"), nbt.func_74769_h("zCenter"));
        }
        if (nbt.func_74764_b("target_rope_id")) {
            this.targetStructureIndex = nbt.func_74762_e("target_rope_id");
        }
        if (this.IS_HEAD && nbt.func_74764_b("data")) {
            NBTTagCompound dataNBT = (NBTTagCompound)nbt.func_74781_a("data");
            this.ropeData = new RopeData(dataNBT);
        }
    }

    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        if (this.worldUUID != null) {
            nbt.func_74778_a("world", this.worldUUID.toString());
        }
        nbt.func_74783_a("coord", new int[]{this.relativePos.func_177958_n(), this.relativePos.func_177956_o(), this.relativePos.func_177952_p()});
        nbt.func_74783_a("unrotCoord", new int[]{this.unrotatedPos.func_177958_n(), this.unrotatedPos.func_177956_o(), this.unrotatedPos.func_177952_p()});
        if (this.targetCenter != null) {
            nbt.func_74780_a("xCenter", this.targetCenter.x);
            nbt.func_74780_a("yCenter", this.targetCenter.y);
            nbt.func_74780_a("zCenter", this.targetCenter.z);
        }
        nbt.func_74757_a("isHead", this.IS_HEAD);
        nbt.func_74768_a("target_rope_id", this.targetStructureIndex);
        if (this.IS_HEAD && this.ropeData != null) {
            nbt.func_74782_a("data", (NBTBase)this.ropeData.writeData());
        }
        return nbt;
    }

    public static void transformPointToWorld(Vector3d vec, IVecOrigin origin, float partialTicks) {
        double rotX = origin.rotXLast() + (origin.rotX() - origin.rotXLast()) * (double)partialTicks;
        double rotY = origin.rotYLast() + (origin.rotY() - origin.rotYLast()) * (double)partialTicks;
        double rotZ = origin.rotZLast() + (origin.rotZ() - origin.rotZLast()) * (double)partialTicks;
        double offX = origin.offXLast() + (origin.offX() - origin.offXLast()) * (double)partialTicks;
        double offY = origin.offYLast() + (origin.offY() - origin.offYLast()) * (double)partialTicks;
        double offZ = origin.offZLast() + (origin.offZ() - origin.offZLast()) * (double)partialTicks;
        Matrix3d rotation = MatrixUtils.createRotationMatrix((double)rotX, (double)rotY, (double)rotZ);
        vec.sub((Tuple3d)origin.center());
        rotation.transform((Tuple3d)vec);
        vec.add((Tuple3d)origin.center());
        vec.x += offX;
        vec.y += offY;
        vec.z += offZ;
    }

    public static void transformPointToFakeWorld(Vector3d vec, IVecOrigin origin, float partialTicks) {
        double rotX = origin.rotXLast() + (origin.rotX() - origin.rotXLast()) * (double)partialTicks;
        double rotY = origin.rotYLast() + (origin.rotY() - origin.rotYLast()) * (double)partialTicks;
        double rotZ = origin.rotZLast() + (origin.rotZ() - origin.rotZLast()) * (double)partialTicks;
        double offX = origin.offXLast() + (origin.offX() - origin.offXLast()) * (double)partialTicks;
        double offY = origin.offYLast() + (origin.offY() - origin.offYLast()) * (double)partialTicks;
        double offZ = origin.offZLast() + (origin.offZ() - origin.offZLast()) * (double)partialTicks;
        vec.x -= offX;
        vec.y -= offY;
        vec.z -= offZ;
        Matrix3d rotation = MatrixUtils.createRotationMatrix((double)rotX, (double)rotY, (double)rotZ);
        rotation.invert();
        vec.sub((Tuple3d)origin.center());
        rotation.transform((Tuple3d)vec);
        vec.add((Tuple3d)origin.center());
    }

    public void adaptStructureChange(LittleStructure struct) {
        UUID newWorldUUID = null;
        BlockPos newRelPos = struct.getPos().func_177973_b((Vec3i)this.parent.getPos());
        newWorldUUID = struct.getWorld() instanceof IOrientatedWorld ? ((IOrientatedWorld)struct.getWorld()).getParentEntity().func_110124_au() : null;
        if (this.shouldStructureChange(newWorldUUID, newRelPos)) {
            this.relativePos = newRelPos;
            this.worldUUID = newWorldUUID;
        }
    }

    public boolean shouldStructureChange(UUID newWorldUUID, BlockPos newRelPos) {
        BlockPos lastRelPos = this.relativePos;
        UUID lastWorldUUID = this.worldUUID;
        this.targetStructure = null;
        this.lastTargetCenter = null;
        return !lastRelPos.equals((Object)newRelPos) || !Objects.equal((Object)lastWorldUUID, (Object)newWorldUUID);
    }

    public LittleRopeConnectionALET getTarget() {
        if (this.targetStructure == null) {
            try {
                LittleStructure tar = this.getStructure();
                if (tar instanceof LittleRopeConnectionALET) {
                    this.targetStructure = (LittleRopeConnectionALET)tar;
                }
            }
            catch (CorruptedConnectionException | NotYetConnectedException throwable) {
                // empty catch block
            }
        }
        return this.targetStructure;
    }

    public boolean hasMoved(Vector3d vec) {
        if (this.lastTargetCenter != null && this.lastTargetCenter.epsilonEquals((Tuple3d)vec, 0.1)) {
            return false;
        }
        this.lastTargetCenter = vec;
        return true;
    }

    public Vector3d getTargetCenter() {
        IOrientatedWorld w;
        if (this.targetStructure != null) {
            this.targetCenter = this.targetStructure.axisCenter.getCenter();
            BlockPos pos = this.getStructurePosition();
            this.targetCenter.x += (double)pos.func_177958_n();
            this.targetCenter.y += (double)pos.func_177956_o();
            this.targetCenter.z += (double)pos.func_177952_p();
        } else {
            if (this.backupTargetCenter != null) {
                return this.backupTargetCenter;
            }
            return null;
        }
        Vector3d vec = new Vector3d(this.targetCenter);
        try {
            if (this.getWorld() instanceof IOrientatedWorld) {
                w = (IOrientatedWorld)this.getWorld();
                RopeConnection.transformPointToWorld(vec, w.getOrigin(), TickUtils.getPartialTickTime());
            }
        }
        catch (CorruptedConnectionException | NotYetConnectedException e) {
            return null;
        }
        if (this.parent.getWorld() instanceof IOrientatedWorld) {
            w = (IOrientatedWorld)this.parent.getWorld();
            RopeConnection.transformPointToFakeWorld(vec, w.getOrigin(), TickUtils.getPartialTickTime());
        }
        return vec;
    }

    public BlockPos getStructurePosition() {
        return this.relativePos.func_177971_a((Vec3i)this.parent.getPos());
    }

    public LittleStructure getStructure() throws CorruptedConnectionException, NotYetConnectedException {
        return this.getStructure(this.getWorld());
    }

    public LittleStructure getStructure(World world) throws CorruptedConnectionException, NotYetConnectedException {
        TileEntityLittleTiles te = this.getTileEntity(world);
        if (!te.hasLoaded()) {
            throw new NotYetConnectedException();
        }
        for (IStructureTileList struct : te.structures()) {
            LittleRopeConnectionALET rope;
            LittleStructure structure = struct.getStructure();
            if (structure == null || !(structure instanceof LittleRopeConnectionALET) || (rope = (LittleRopeConnectionALET)structure).getIndex() != this.targetStructureIndex) continue;
            return rope;
        }
        throw new MissingStructureException(te.func_174877_v());
    }

    public LittleRopeConnectionALET scanAfterPlace() throws CorruptedConnectionException, NotYetConnectedException {
        this.backupTargetCenter = null;
        if (((LittleRopeConnectionALET)this.parent).prevBlockPosition == null) {
            throw new MissingBlockException(null);
        }
        BlockPos absoluteCoord = this.getStructurePosition();
        World world = this.getWorld();
        if (world == null) {
            throw new MissingStructureException(absoluteCoord);
        }
        BlockPos original = this.unrotatedPos.func_177971_a((Vec3i)((LittleRopeConnectionALET)this.parent).prevBlockPosition);
        BlockPos.MutableBlockPos mPos = new BlockPos.MutableBlockPos();
        for (int x = absoluteCoord.func_177958_n() - 1; x <= absoluteCoord.func_177958_n() + 1; ++x) {
            for (int y = absoluteCoord.func_177956_o() - 1; y <= absoluteCoord.func_177956_o() + 1; ++y) {
                for (int z = absoluteCoord.func_177952_p() - 1; z <= absoluteCoord.func_177952_p() + 1; ++z) {
                    mPos.func_181079_c(x, y, z);
                    LittleRopeConnectionALET st = this.scanAfterPlaceBlock(world, (BlockPos)mPos, original);
                    if (st == null) continue;
                    return st;
                }
            }
        }
        throw new MissingStructureException(absoluteCoord);
    }

    public LittleRopeConnectionALET scanAfterPlaceBlock(World world, BlockPos pos, BlockPos original) throws CorruptedConnectionException, NotYetConnectedException {
        Chunk chunk = world.func_175726_f(pos);
        if (!WorldUtils.checkIfChunkExists((Chunk)chunk)) {
            throw new NotYetConnectedException();
        }
        TileEntity t = world.func_175625_s(pos);
        if (t instanceof TileEntityLittleTiles) {
            TileEntityLittleTiles te = (TileEntityLittleTiles)t;
            for (IStructureTileList tile : te.structures()) {
                LittleStructure s = tile.getStructure();
                if (!(s instanceof LittleRopeConnectionALET)) continue;
                LittleRopeConnectionALET rope = (LittleRopeConnectionALET)s;
                if (rope.prevStructureIndex != this.targetStructureIndex || !rope.prevBlockPosition.equals((Object)original)) continue;
                this.targetStructureIndex = rope.getIndex();
                this.relativePos = rope.getPos().func_177973_b((Vec3i)this.parent.getPos());
                return rope;
            }
        }
        return null;
    }

    protected TileEntityLittleTiles getTileEntity() throws CorruptedConnectionException, NotYetConnectedException {
        return this.getTileEntity(this.getWorld());
    }

    protected TileEntityLittleTiles getTileEntity(World world) throws CorruptedConnectionException, NotYetConnectedException {
        if (this.cachedTe != null && !this.cachedTe.func_145837_r() && !this.cachedTe.unloaded()) {
            return this.cachedTe;
        }
        if (this.relativePos == null) {
            throw new CorruptedLinkException();
        }
        if (world == null) {
            throw new MissingWorldException();
        }
        BlockPos absoluteCoord = this.getStructurePosition();
        Chunk chunk = world.func_175726_f(absoluteCoord);
        if (WorldUtils.checkIfChunkExists((Chunk)chunk)) {
            TileEntity te = world.func_175625_s(absoluteCoord);
            if (te instanceof TileEntityLittleTiles) {
                this.cachedTe = (TileEntityLittleTiles)te;
                return this.cachedTe;
            }
            throw new MissingBlockException(absoluteCoord);
        }
        throw new NotYetConnectedException();
    }

    protected World getWorld() throws CorruptedConnectionException, NotYetConnectedException {
        IOrientatedWorld world;
        if (this.worldUUID == null) {
            World world2 = this.parent.getWorld();
            if (world2 instanceof IOrientatedWorld) {
                IOrientatedWorld w = (IOrientatedWorld)world2;
                return w.getRealWorld();
            }
            return world2;
        }
        if (this.parent.getWorld() instanceof IOrientatedWorld && (world = (IOrientatedWorld)this.parent.getWorld()).getParentEntity().func_110124_au().equals(this.worldUUID)) {
            return (World)world;
        }
        EntityAnimation animation = WorldAnimationHandler.getHandler((World)this.parent.getWorld()).findAnimation(this.worldUUID);
        if (animation != null) {
            return animation.fakeWorld;
        }
        throw new MissingAnimationException(this.worldUUID);
    }

    public boolean isLinkToAnotherWorld() {
        return this.worldUUID != null;
    }

    public void rotateConnection(Rotation rot) {
        this.relativePos = rot.getMatrix().transform(this.relativePos);
    }

    public void mirrorConnection(EnumFacing.Axis axis) {
        this.relativePos = RotationUtils.flip((BlockPos)this.relativePos, (EnumFacing.Axis)axis);
    }
}

