/*
 * Decompiled with CFR 0.152.
 */
package com.alet.common.sounds;

import java.util.ArrayList;
import java.util.List;

public enum Notes {
    G1((float)Math.pow(2.0, -0.4166666567325592), (float)Math.pow(2.0, -2.75), -33, "G1", "alet:block.note.-low5"),
    GA1((float)Math.pow(2.0, -0.3333333432674408), (float)Math.pow(2.0, -2.6666667461395264), -32, "G#1", "alet:block.note.-low5"),
    A1((float)Math.pow(2.0, -0.25), (float)Math.pow(2.0, -2.5833332538604736), -31, "A1", "alet:block.note.-low5"),
    AB1((float)Math.pow(2.0, -0.1666666716337204), (float)Math.pow(2.0, -2.5), -30, "A#1", "alet:block.note.-low5"),
    B1((float)Math.pow(2.0, -0.0833333358168602), (float)Math.pow(2.0, -2.4166667461395264), -29, "B1", "alet:block.note.-low5"),
    C2((float)Math.pow(2.0, 0.0), (float)Math.pow(2.0, -2.3333332538604736), -28, "C2", "alet:block.note.-low5"),
    CD2((float)Math.pow(2.0, -0.4166666567325592), (float)Math.pow(2.0, -2.25), -27, "C#2", "alet:block.note.-low4"),
    D2((float)Math.pow(2.0, -0.3333333432674408), (float)Math.pow(2.0, -2.1666667461395264), -26, "D2", "alet:block.note.-low4"),
    DE2((float)Math.pow(2.0, -0.25), (float)Math.pow(2.0, -2.0833332538604736), -25, "D#2", "alet:block.note.-low4"),
    E2((float)Math.pow(2.0, -0.1666666716337204), (float)Math.pow(2.0, -2.0), -24, "E2", "alet:block.note.-low4"),
    F2((float)Math.pow(2.0, -0.0833333358168602), (float)Math.pow(2.0, -1.9166666269302368), -23, "F2", "alet:block.note.-low4"),
    FG2((float)Math.pow(2.0, 0.0), (float)Math.pow(2.0, -1.8333333730697632), -22, "F#2", "alet:block.note.-low4"),
    G2((float)Math.pow(2.0, -0.4166666567325592), (float)Math.pow(2.0, -1.75), -21, "G2", "alet:block.note.-low3"),
    GA2((float)Math.pow(2.0, -0.3333333432674408), (float)Math.pow(2.0, -1.6666666269302368), -20, "G#2", "alet:block.note.-low3"),
    A2((float)Math.pow(2.0, -0.25), (float)Math.pow(2.0, -1.5833333730697632), -19, "A2", "alet:block.note.-low3"),
    AB2((float)Math.pow(2.0, -0.1666666716337204), (float)Math.pow(2.0, -1.5), -18, "A#2", "alet:block.note.-low3"),
    B2((float)Math.pow(2.0, -0.0833333358168602), (float)Math.pow(2.0, -1.4166666269302368), -17, "B2", "alet:block.note.-low3"),
    C3((float)Math.pow(2.0, 0.0), (float)Math.pow(2.0, -1.3333333730697632), -16, "C3", "alet:block.note.-low3"),
    CD3((float)Math.pow(2.0, -0.4166666567325592), (float)Math.pow(2.0, -1.25), -15, "C#3", "alet:block.note.-low2"),
    D3((float)Math.pow(2.0, -0.3333333432674408), (float)Math.pow(2.0, -1.1666666269302368), -14, "D3", "alet:block.note.-low2"),
    DE3((float)Math.pow(2.0, -0.25), (float)Math.pow(2.0, -1.0833333730697632), -13, "D#3", "alet:block.note.-low2"),
    E3((float)Math.pow(2.0, -0.1666666716337204), (float)Math.pow(2.0, -1.0), -12, "E3", "alet:block.note.-low2"),
    F3((float)Math.pow(2.0, -0.0833333358168602), (float)Math.pow(2.0, -0.9166666865348816), -11, "F3", "alet:block.note.-low2"),
    FG3((float)Math.pow(2.0, 0.0), (float)Math.pow(2.0, -0.8333333134651184), -10, "F#3", "alet:block.note.-low2"),
    G3((float)Math.pow(2.0, -0.4166666567325592), (float)Math.pow(2.0, -0.75), -9, "G3", "alet:block.note.-low"),
    GA3((float)Math.pow(2.0, -0.3333333432674408), (float)Math.pow(2.0, -0.6666666865348816), -8, "G#3", "alet:block.note.-low"),
    A3((float)Math.pow(2.0, -0.25), (float)Math.pow(2.0, -0.5833333134651184), -7, "A3", "alet:block.note.-low"),
    AB3((float)Math.pow(2.0, -0.1666666716337204), (float)Math.pow(2.0, -0.5), -6, "A#3", "alet:block.note.-low"),
    B3((float)Math.pow(2.0, -0.0833333358168602), (float)Math.pow(2.0, -0.4166666567325592), -5, "B3", "alet:block.note.-low"),
    C4((float)Math.pow(2.0, 0.0), (float)Math.pow(2.0, -0.3333333432674408), -4, "C4", "alet:block.note.-low"),
    CD4((float)Math.pow(2.0, -0.4166666567325592), (float)Math.pow(2.0, -0.25), -3, "C#4", "alet:block.note.-"),
    D4((float)Math.pow(2.0, -0.3333333432674408), (float)Math.pow(2.0, -0.1666666716337204), -2, "D4", "alet:block.note.-"),
    DE4((float)Math.pow(2.0, -0.25), (float)Math.pow(2.0, -0.0833333358168602), -1, "D#4", "alet:block.note.-"),
    E4((float)Math.pow(2.0, -0.1666666716337204), (float)Math.pow(2.0, 0.0), 0, "E4", "alet:block.note.-"),
    F4((float)Math.pow(2.0, -0.0833333358168602), (float)Math.pow(2.0, 0.0833333358168602), 1, "F4", "alet:block.note.-"),
    FG4((float)Math.pow(2.0, 0.0), (float)Math.pow(2.0, 0.1666666716337204), 2, "F#4", "alet:block.note.-"),
    G4((float)Math.pow(2.0, 0.0833333358168602), (float)Math.pow(2.0, 0.25), 3, "G4", "alet:block.note.-"),
    GA4((float)Math.pow(2.0, 0.1666666716337204), (float)Math.pow(2.0, 0.3333333432674408), 4, "G#4", "alet:block.note.-"),
    A4((float)Math.pow(2.0, 0.25), (float)Math.pow(2.0, 0.4166666567325592), 5, "A4", "alet:block.note.-"),
    AB4((float)Math.pow(2.0, 0.3333333432674408), (float)Math.pow(2.0, 0.5), 6, "A#4", "alet:block.note.-"),
    B4((float)Math.pow(2.0, 0.4166666567325592), (float)Math.pow(2.0, 0.5833333134651184), 7, "B4", "alet:block.note.-"),
    C5((float)Math.pow(2.0, 0.0), (float)Math.pow(2.0, 0.6666666865348816), 8, "C5", "alet:block.note.-high"),
    CD5((float)Math.pow(2.0, 0.0833333358168602), (float)Math.pow(2.0, 0.75), 9, "C#5", "alet:block.note.-high"),
    D5((float)Math.pow(2.0, 0.1666666716337204), (float)Math.pow(2.0, 0.8333333134651184), 10, "D5", "alet:block.note.-high"),
    DE5((float)Math.pow(2.0, 0.25), (float)Math.pow(2.0, 0.9166666865348816), 11, "D#5", "alet:block.note.-high"),
    E5((float)Math.pow(2.0, 0.3333333432674408), (float)Math.pow(2.0, 1.0), 12, "E5", "alet:block.note.-high"),
    F5((float)Math.pow(2.0, 0.4166666567325592), (float)Math.pow(2.0, 1.0833333730697632), 13, "F5", "alet:block.note.-high"),
    FG5((float)Math.pow(2.0, 0.0), (float)Math.pow(2.0, 1.1666666269302368), 14, "F#5", "alet:block.note.-high2"),
    G5((float)Math.pow(2.0, 0.0833333358168602), (float)Math.pow(2.0, 1.25), 15, "G5", "alet:block.note.-high2"),
    GA5((float)Math.pow(2.0, 0.1666666716337204), (float)Math.pow(2.0, 1.3333333730697632), 16, "G#5", "alet:block.note.-high2"),
    A5((float)Math.pow(2.0, 0.25), (float)Math.pow(2.0, 1.4166666269302368), 17, "A5", "alet:block.note.-high2"),
    AB5((float)Math.pow(2.0, 0.3333333432674408), (float)Math.pow(2.0, 1.5), 18, "A#5", "alet:block.note.-high2"),
    B5((float)Math.pow(2.0, 0.4166666567325592), (float)Math.pow(2.0, 1.5833333730697632), 19, "B5", "alet:block.note.-high2"),
    C6((float)Math.pow(2.0, 0.0), (float)Math.pow(2.0, 1.6666666269302368), 20, "C6", "alet:block.note.-high3"),
    CD6((float)Math.pow(2.0, 0.0833333358168602), (float)Math.pow(2.0, 1.75), 21, "C#6", "alet:block.note.-high3"),
    D6((float)Math.pow(2.0, 0.1666666716337204), (float)Math.pow(2.0, 1.8333333730697632), 22, "D6", "alet:block.note.-high3"),
    DE6((float)Math.pow(2.0, 0.25), (float)Math.pow(2.0, 1.9166666269302368), 23, "D#6", "alet:block.note.-high3"),
    E6((float)Math.pow(2.0, 0.3333333432674408), (float)Math.pow(2.0, 2.0), 24, "E6", "alet:block.note.-high3"),
    F6((float)Math.pow(2.0, 0.4166666567325592), (float)Math.pow(2.0, 2.0833332538604736), 25, "F6", "alet:block.note.-high3"),
    FG6((float)Math.pow(2.0, 0.0), (float)Math.pow(2.0, 2.1666667461395264), 26, "F#6", "alet:block.note.-high4"),
    G6((float)Math.pow(2.0, 0.0833333358168602), (float)Math.pow(2.0, 2.25), 27, "G6", "alet:block.note.-high4"),
    GA6((float)Math.pow(2.0, 0.1666666716337204), (float)Math.pow(2.0, 2.3333332538604736), 28, "G#6", "alet:block.note.-high4"),
    A6((float)Math.pow(2.0, 0.25), (float)Math.pow(2.0, 2.4166667461395264), 29, "A6", "alet:block.note.-high4"),
    AB6((float)Math.pow(2.0, 0.3333333432674408), (float)Math.pow(2.0, 2.5), 30, "A#6", "alet:block.note.-high4"),
    B6((float)Math.pow(2.0, 0.4166666567325592), (float)Math.pow(2.0, 2.5833332538604736), 31, "B6", "alet:block.note.-high4"),
    C7((float)Math.pow(2.0, 0.0), (float)Math.pow(2.0, 2.6666667461395264), 32, "C7", "alet:block.note.-high5"),
    CD7((float)Math.pow(2.0, 0.0833333358168602), (float)Math.pow(2.0, 2.75), 33, "C#7", "alet:block.note.-high5"),
    D7((float)Math.pow(2.0, 0.1666666716337204), (float)Math.pow(2.0, 2.8333332538604736), 34, "D7", "alet:block.note.-high5"),
    DE7((float)Math.pow(2.0, 0.25), (float)Math.pow(2.0, 2.9166667461395264), 35, "D#7", "alet:block.note.-high5"),
    E7((float)Math.pow(2.0, 0.3333333432674408), (float)Math.pow(2.0, 3.0), 36, "E7", "alet:block.note.-high5"),
    F7((float)Math.pow(2.0, 0.4166666567325592), (float)Math.pow(2.0, 3.0833332538604736), 37, "F7", "alet:block.note.-high5");

    private float pitchOut;
    private float pitchIn;
    private String pitchName;
    private String resourceLocation;
    private int pos;

    private Notes(float pitchOut, float pitchIn, int pos, String pitchName, String resourceLocation) {
        this.pitchOut = pitchOut;
        this.pitchName = pitchName;
        this.pitchIn = pitchIn;
        this.resourceLocation = resourceLocation;
        this.pos = pos;
    }

    public static Notes getNoteFromPitch(int pitch) {
        float pitchC = (float)Math.pow(2.0, (float)pitch / 12.0f);
        for (Notes n : Notes.values()) {
            if (pitchC != n.pitchIn) continue;
            return n;
        }
        return null;
    }

    public static Notes getNoteFromPos(int pos) {
        for (Notes n : Notes.values()) {
            if (pos != n.pos) continue;
            return n;
        }
        return null;
    }

    public static Notes getNote(String pitchName) {
        for (Notes n : Notes.values()) {
            if (!pitchName.equals(n.getPitchName())) continue;
            return n;
        }
        return null;
    }

    public static List<String> allNotes() {
        ArrayList<String> allNotes = new ArrayList<String>();
        for (Notes n : Notes.values()) {
            allNotes.add(n.getPitchName());
        }
        return allNotes;
    }

    public String toString() {
        return this.pitchName;
    }

    public String getResourceLocation(String insturmentLocation) {
        return this.resourceLocation.replaceAll("-", insturmentLocation);
    }

    public int getPos() {
        return this.pos;
    }

    public String getPitchName() {
        return this.pitchName;
    }

    public float getPitchIn() {
        return this.pitchIn;
    }

    public float getPitch() {
        return this.pitchOut;
    }
}

