/*
 * Decompiled with CFR 0.152.
 */
package com.alet.common.packet;

import com.creativemd.creativecore.common.packet.CreativeCorePacket;
import com.creativemd.littletiles.common.action.LittleAction;
import com.creativemd.littletiles.common.action.LittleActionException;
import com.creativemd.littletiles.common.structure.LittleStructure;
import com.creativemd.littletiles.common.tile.math.location.StructureLocation;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;

public class PacketUpdateStructureFromClient
extends CreativeCorePacket {
    public StructureLocation location;
    public NBTTagCompound structureNBT;

    public PacketUpdateStructureFromClient() {
    }

    public PacketUpdateStructureFromClient(StructureLocation location, NBTTagCompound structureNBT) {
        this.location = location;
        this.structureNBT = structureNBT;
    }

    public void writeBytes(ByteBuf buf) {
        LittleAction.writeStructureLocation((StructureLocation)this.location, (ByteBuf)buf);
        PacketUpdateStructureFromClient.writeNBT((ByteBuf)buf, (NBTTagCompound)this.structureNBT);
    }

    public void readBytes(ByteBuf buf) {
        this.location = LittleAction.readStructureLocation((ByteBuf)buf);
        this.structureNBT = PacketUpdateStructureFromClient.readNBT((ByteBuf)buf);
    }

    public void executeClient(EntityPlayer player) {
    }

    public void executeServer(EntityPlayer player) {
        try {
            LittleStructure structure = this.location.find(player.field_70170_p);
            structure.loadFromNBT(this.structureNBT);
            structure.updateStructure();
            structure.updateSignaling();
        }
        catch (LittleActionException littleActionException) {
            // empty catch block
        }
    }
}

