/*
 * Decompiled with CFR 0.152.
 */
package com.alet.common.packet;

import com.creativemd.creativecore.common.packet.CreativeCorePacket;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class PacketPlaySound
extends CreativeCorePacket {
    private float pitch;
    private float volume;
    private boolean local;
    private BlockPos pos;
    private String resourcePath;

    public PacketPlaySound() {
    }

    public PacketPlaySound(float pitch, float volume, boolean local, BlockPos pos, String resourcePath) {
        this.pitch = pitch;
        this.volume = volume;
        this.local = local;
        this.pos = pos;
        this.resourcePath = resourcePath;
    }

    public void writeBytes(ByteBuf buf) {
        buf.writeFloat(this.pitch);
        buf.writeFloat(this.volume);
        buf.writeBoolean(this.local);
        PacketPlaySound.writeNBT((ByteBuf)buf, (NBTTagCompound)NBTUtil.func_186859_a((BlockPos)this.pos));
        PacketPlaySound.writeString((ByteBuf)buf, (String)this.resourcePath);
    }

    public void readBytes(ByteBuf buf) {
        this.pitch = buf.readFloat();
        this.volume = buf.readFloat();
        this.local = buf.readBoolean();
        this.pos = NBTUtil.func_186861_c((NBTTagCompound)PacketPlaySound.readNBT((ByteBuf)buf));
        this.resourcePath = PacketPlaySound.readString((ByteBuf)buf);
    }

    public void executeClient(EntityPlayer player) {
        World world = player.field_70170_p;
        SoundEvent event = new SoundEvent(new ResourceLocation(this.resourcePath));
        world.func_184133_a(player, this.pos, event, SoundCategory.NEUTRAL, this.volume, this.pitch);
    }

    public void executeServer(EntityPlayer player) {
    }
}

