/*
 * Decompiled with CFR 0.152.
 */
package com.alet.common.command.sender;

import com.creativemd.creativecore.common.world.IOrientatedWorld;
import com.creativemd.creativecore.common.world.SubWorldServer;
import com.creativemd.littletiles.common.structure.LittleStructure;
import com.creativemd.littletiles.common.structure.exception.CorruptedConnectionException;
import com.creativemd.littletiles.common.structure.exception.NotYetConnectedException;
import net.minecraft.command.CommandResultStats;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;

public class StructureCommandSender
implements ICommandSender {
    Vec3d center;
    private final Entity entity;
    private final LittleStructure structure;

    public StructureCommandSender(Entity entity, LittleStructure structure) {
        this.entity = entity;
        this.structure = structure;
        try {
            this.center = structure.getSurroundingBox().getHighestCenterVec();
        }
        catch (CorruptedConnectionException | NotYetConnectedException e) {
            e.printStackTrace();
        }
    }

    public String func_70005_c_() {
        return "Server";
    }

    public ITextComponent func_145748_c_() {
        String name = "";
        name = this.structure.name != null && !this.structure.name.isEmpty() ? this.structure.name : this.structure.type.id;
        return new TextComponentString(name);
    }

    public void func_145747_a(ITextComponent component) {
    }

    public boolean func_70003_b(int permLevel, String commandName) {
        return true;
    }

    public Entity func_174793_f() {
        return this.entity;
    }

    public BlockPos func_180425_c() {
        if (this.structure.getWorld() instanceof IOrientatedWorld) {
            BlockPos pos = this.structure.getPos();
            Vec3d vec = new Vec3d((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
            vec = ((IOrientatedWorld)this.structure.getWorld()).getOrigin().transformPointToWorld(vec);
            return new BlockPos(vec);
        }
        return this.structure.getPos();
    }

    public Vec3d func_174791_d() {
        if (this.structure.getWorld() instanceof IOrientatedWorld) {
            return ((IOrientatedWorld)this.structure.getWorld()).getOrigin().transformPointToWorld(this.center);
        }
        return this.center;
    }

    public boolean func_174792_t_() {
        return false;
    }

    public void func_174794_a(CommandResultStats.Type type, int amount) {
        this.func_184102_h().func_174794_a(type, amount);
    }

    public MinecraftServer func_184102_h() {
        return this.structure.getWorld().func_73046_m();
    }

    public World func_130014_f_() {
        World world = this.structure.getWorld();
        if (world instanceof SubWorldServer) {
            world = ((SubWorldServer)world).getRealWorld();
        }
        return world;
    }
}

