/*
 * Decompiled with CFR 0.152.
 */
package com.alet.client.tapemeasure.shape.measurement;

import com.alet.client.tapemeasure.shape.measurement.MeasurementShape;
import com.alet.client.tapemeasure.shape.measurement.MeasurementShapeBox;
import com.alet.client.tapemeasure.shape.measurement.MeasurementShapeCompass;
import com.alet.client.tapemeasure.shape.measurement.MeasurementShapeLine;
import java.util.Collection;
import java.util.LinkedHashMap;

public class MeasurementShapeRegistar {
    private static LinkedHashMap<String, MeasurementShape> registeredShapes = new LinkedHashMap();

    public static void registerMeasurementShape(String name, Class<? extends MeasurementShape> shapeClass) throws Exception {
        if (registeredShapes.containsKey(name)) {
            throw new Exception(name + " already exists");
        }
        MeasurementShape shape = shapeClass.getDeclaredConstructor(String.class).newInstance(name);
        registeredShapes.put(name, shape);
    }

    public static MeasurementShape getMeasurementShape(String measurementShapeName) {
        return registeredShapes.get(measurementShapeName);
    }

    public static Collection<String> getAllMeasurmentShapeNames() {
        return registeredShapes.keySet();
    }

    static {
        try {
            MeasurementShapeRegistar.registerMeasurementShape("Box", MeasurementShapeBox.class);
            MeasurementShapeRegistar.registerMeasurementShape("Line", MeasurementShapeLine.class);
            MeasurementShapeRegistar.registerMeasurementShape("Compass", MeasurementShapeCompass.class);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

