/*
 * Decompiled with CFR 0.152.
 */
package com.alet.client.tapemeasure.shape.measurement;

import com.alet.ALETConfig;
import com.alet.client.tapemeasure.shape.measurement.MeasurementShape;
import com.alet.client.tapemeasure.shape.measurement.MeasurementShapeBox;
import com.alet.common.utils.text.draw.DrawString3d;
import com.alet.items.ItemTapeMeasure;
import com.creativemd.creativecore.common.gui.GuiControl;
import com.creativemd.littletiles.common.util.grid.LittleGridContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.vecmath.Point3f;
import net.minecraft.nbt.NBTTagCompound;

public class MeasurementShapeLine
extends MeasurementShape {
    public MeasurementShapeLine(String name) {
        super(2, name);
    }

    @Override
    protected List<String> getMeasurementUnits(HashMap<Integer, Point3f> points, LittleGridContext context) {
        ArrayList<String> units = new ArrayList<String>();
        Point3f pos = points.get(0);
        Point3f pos2 = points.get(1);
        double xDist = MeasurementShapeLine.getDistence(pos.x, pos2.x, context.size);
        double yDist = MeasurementShapeLine.getDistence(pos.y, pos2.y, context.size);
        double zDist = MeasurementShapeLine.getDistence(pos.z, pos2.z, context.size);
        double dist = 0.0;
        if (xDist >= yDist && xDist >= zDist) {
            dist = xDist;
        } else if (yDist >= xDist && yDist >= zDist) {
            dist = yDist;
        } else if (zDist >= xDist && zDist >= yDist) {
            dist = zDist;
        }
        int denominator = context.size;
        String[] distArr = String.valueOf(dist).split("\\.");
        double numerator = (double)context.size * Double.parseDouble("0." + distArr[1]);
        if (ItemTapeMeasure.measurementType == 0) {
            if ((int)numerator == 0) {
                units.add(distArr[0] + " BLOCK");
            } else if (Integer.parseInt(distArr[0]) == 0) {
                units.add((int)numerator + "/" + denominator + " TILE");
            } else {
                units.add(distArr[0] + " BLOCK " + (int)numerator + "/" + denominator + " TILE");
            }
        } else {
            String measurementName = ALETConfig.tapeMeasure.measurementName.get(ItemTapeMeasure.measurementType - 1);
            double modifier = 1.0 / (double)context.size;
            units.add(MeasurementShapeLine.cleanDouble(MeasurementShapeLine.changeMesurmentType(Math.floor(((double)pos.distance(pos2) + modifier) * (double)context.size) / (double)context.size)) + " " + measurementName);
        }
        return units;
    }

    @Override
    public List<GuiControl> getCustomSettings(NBTTagCompound nbt, LittleGridContext context) {
        return null;
    }

    @Override
    protected void drawShape(HashMap<Integer, Point3f> points, LittleGridContext context, float red, float green, float blue, float alpha) {
        Point3f p1 = points.get(0);
        Point3f p2 = points.get(1);
        MeasurementShapeBox.drawCube(p1, context.size, 1.0f, 0.0f, 0.0f, 1.0f);
        MeasurementShapeBox.drawCube(p2, context.size, 0.0f, 1.0f, 0.0f, 1.0f);
        HashMap<Integer, Point3f> linePoints = MeasurementShapeLine.drawLine(p1, p2, context.size, red, green, blue, alpha);
        this.drawText(linePoints, this.getMeasurementUnits(linePoints, context), context.size, this.pointsNeeded);
    }

    @Override
    protected void drawText(HashMap<Integer, Point3f> points, List<String> measurementUnits, int contextSize, int colorInt) {
        float[] angles = MeasurementShapeLine.getLineAngle(points.get(0), points.get(1));
        DrawString3d.drawStringOnLine(measurementUnits.get(0), contextSize, DrawString3d.DrawPosition.Middle, points.get(0), points.get(1), -1, true, 0);
    }
}

