/*
 * Decompiled with CFR 0.152.
 */
package com.alet.client.tapemeasure.shape.measurement;

import com.alet.client.tapemeasure.shape.measurement.MeasurementShape;
import com.alet.client.tapemeasure.shape.measurement.MeasurementShapeBox;
import com.alet.client.tapemeasure.shape.measurement.MeasurementShapeLine;
import com.alet.client.tapemeasure.shape.measurement.MeasurementShapeRegistar;
import com.alet.common.utils.text.draw.DrawString3d;
import com.creativemd.creativecore.common.gui.GuiControl;
import com.creativemd.littletiles.common.util.grid.LittleGridContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.vecmath.Point3f;
import net.minecraft.nbt.NBTTagCompound;

public class MeasurementShapeCompass
extends MeasurementShape {
    public MeasurementShapeCompass(String name) {
        super(3, name);
    }

    @Override
    protected void drawShape(HashMap<Integer, Point3f> points, LittleGridContext context, float red, float green, float blue, float alpha) {
        Point3f p1 = points.get(0);
        Point3f p2 = points.get(1);
        Point3f p3 = points.get(2);
        MeasurementShapeLine.drawLine(p1, p2, context.size, red, green, blue, alpha);
        MeasurementShapeLine.drawLine(p2, p3, context.size, red, green, blue, alpha);
        MeasurementShapeBox.drawCube(p1, context.size, 1.0f, 0.0f, 0.0f, alpha);
        MeasurementShapeBox.drawCube(p2, context.size, 0.0f, 1.0f, 0.0f, alpha);
        MeasurementShapeBox.drawCube(p3, context.size, 0.0f, 0.0f, 1.0f, alpha);
        this.drawText(points, this.getMeasurementUnits(points, context), context.size, 1);
    }

    @Override
    protected List<String> getMeasurementUnits(HashMap<Integer, Point3f> points, LittleGridContext context) {
        ArrayList<String> units = new ArrayList<String>();
        Point3f C = points.get(0);
        Point3f A = points.get(1);
        Point3f B = points.get(2);
        double a = C.distance(B);
        double b = A.distance(C);
        double c = A.distance(B);
        double a2 = Math.pow(a, 2.0);
        double b2 = Math.pow(b, 2.0);
        double c2 = Math.pow(c, 2.0);
        double val = (b2 + c2 - a2) / (2.0 * b * c);
        HashMap<Integer, Point3f> CA = new HashMap<Integer, Point3f>();
        CA.put(0, C);
        CA.put(1, A);
        HashMap<Integer, Point3f> AB = new HashMap<Integer, Point3f>();
        AB.put(0, A);
        AB.put(1, B);
        units.add("Degrees: " + MeasurementShapeCompass.cleanDouble(Math.toDegrees(Math.acos(val))));
        units.addAll(MeasurementShapeRegistar.getMeasurementShape("Line").getMeasurementUnits(CA, context));
        units.addAll(MeasurementShapeRegistar.getMeasurementShape("Line").getMeasurementUnits(AB, context));
        return units;
    }

    @Override
    public List<GuiControl> getCustomSettings(NBTTagCompound nbt, LittleGridContext context) {
        return null;
    }

    @Override
    protected void drawText(HashMap<Integer, Point3f> points, List<String> measurementUnits, int contextSize, int colorInt) {
        DrawString3d.drawStringOnLine(measurementUnits.get(0), contextSize, DrawString3d.DrawPosition.Middle, points.get(1), points.get(1), -1, true, 0);
        DrawString3d.drawStringOnLine(measurementUnits.get(1), contextSize, DrawString3d.DrawPosition.Middle, points.get(0), points.get(1), -1, true, 0);
        DrawString3d.drawStringOnLine(measurementUnits.get(2), contextSize, DrawString3d.DrawPosition.Middle, points.get(1), points.get(2), -1, true, 0);
    }
}

