/*
 * Decompiled with CFR 0.152.
 */
package com.alet.client.tapemeasure.shape.measurement;

import com.alet.ALETConfig;
import com.alet.client.tapemeasure.shape.measurement.MeasurementShape;
import com.alet.common.utils.text.draw.DrawString3d;
import com.alet.items.ItemTapeMeasure;
import com.creativemd.creativecore.common.gui.GuiControl;
import com.creativemd.creativecore.common.utils.mc.TickUtils;
import com.creativemd.littletiles.common.util.grid.LittleGridContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.vecmath.Point3f;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;

public class MeasurementShapeBox
extends MeasurementShape {
    public MeasurementShapeBox(String name) {
        super(2, name);
    }

    @Override
    protected void drawShape(HashMap<Integer, Point3f> points, LittleGridContext context, float red, float green, float blue, float alpha) {
        HashMap<Integer, Point3f> boxPoints = MeasurementShapeBox.drawBox(points.get(0), points.get(1), context.size, red, green, blue, alpha);
        MeasurementShapeBox.drawCube(points.get(0), context.size, 1.0f, 0.0f, 0.0f, alpha);
        MeasurementShapeBox.drawCube(points.get(1), context.size, 0.0f, 1.0f, 0.0f, alpha);
        this.drawText(boxPoints, this.tryGetMeasurementUnits(points, context), context.size, -1);
    }

    @Override
    public List<GuiControl> getCustomSettings(NBTTagCompound nbt, LittleGridContext context) {
        return null;
    }

    @Override
    protected List<String> getMeasurementUnits(HashMap<Integer, Point3f> points, LittleGridContext context) {
        Point3f pos = points.get(0);
        Point3f pos2 = points.get(1);
        ArrayList<String> measurmentUnits = new ArrayList<String>();
        double xDistence = MeasurementShapeBox.getDistence(pos.x, pos2.x, context.size);
        double yDistence = MeasurementShapeBox.getDistence(pos.y, pos2.y, context.size);
        double zDistence = MeasurementShapeBox.getDistence(pos.z, pos2.z, context.size);
        double contDecimal = 1.0 / (double)context.size;
        int denominator = context.size;
        String[] xDis = String.valueOf(xDistence).split("\\.");
        double xNumerator = (double)context.size * Double.parseDouble("0." + xDis[1]);
        String[] yDis = String.valueOf(yDistence).split("\\.");
        double yNumerator = (double)context.size * Double.parseDouble("0." + yDis[1]);
        String[] zDis = String.valueOf(zDistence).split("\\.");
        double zNumerator = (double)context.size * Double.parseDouble("0." + zDis[1]);
        String xStr = "";
        String yStr = "";
        String zStr = "";
        if (ItemTapeMeasure.measurementType == 0) {
            xStr = (int)xNumerator == 0 ? xDis[0] + " BLOCK" : (Integer.parseInt(xDis[0]) == 0 ? (int)xNumerator + "/" + denominator + " TILE" : xDis[0] + " BLOCK " + (int)xNumerator + "/" + denominator + " TILE");
            yStr = (int)yNumerator == 0 ? yDis[0] + " BLOCK" : (Integer.parseInt(yDis[0]) == 0 ? (int)yNumerator + "/" + denominator + " TILE" : yDis[0] + " BLOCK " + (int)yNumerator + "/" + denominator + " TILE");
            zStr = (int)zNumerator == 0 ? zDis[0] + " BLOCK" : (Integer.parseInt(zDis[0]) == 0 ? (int)zNumerator + "/" + denominator + " TILE" : zDis[0] + " BLOCK " + (int)zNumerator + "/" + denominator + " TILE");
            measurmentUnits.add(xStr);
            measurmentUnits.add(yStr);
            measurmentUnits.add(zStr);
        } else {
            String measurementName = ALETConfig.tapeMeasure.measurementName.get(ItemTapeMeasure.measurementType - 1);
            measurmentUnits.add(MeasurementShapeBox.cleanDouble(MeasurementShapeBox.changeMesurmentType((double)Math.abs(pos.x - pos2.x) + contDecimal)) + " " + measurementName);
            measurmentUnits.add(MeasurementShapeBox.cleanDouble(MeasurementShapeBox.changeMesurmentType((double)Math.abs(pos.y - pos2.y) + contDecimal)) + " " + measurementName);
            measurmentUnits.add(MeasurementShapeBox.cleanDouble(MeasurementShapeBox.changeMesurmentType((double)Math.abs(pos.z - pos2.z) + contDecimal)) + " " + measurementName);
        }
        return measurmentUnits;
    }

    @Override
    protected void drawText(HashMap<Integer, Point3f> points, List<String> measurementUnits, int contextSize, int colorInt) {
        AxisAlignedBB[] boxes = new AxisAlignedBB[6];
        AxisAlignedBB xFrontFace = new AxisAlignedBB((double)points.get((Object)Integer.valueOf((int)1)).x, (double)points.get((Object)Integer.valueOf((int)1)).y, (double)points.get((Object)Integer.valueOf((int)1)).z, (double)points.get((Object)Integer.valueOf((int)4)).x, (double)points.get((Object)Integer.valueOf((int)4)).y, (double)points.get((Object)Integer.valueOf((int)4)).z);
        AxisAlignedBB xBackFace = new AxisAlignedBB((double)points.get((Object)Integer.valueOf((int)0)).x, (double)points.get((Object)Integer.valueOf((int)0)).y, (double)points.get((Object)Integer.valueOf((int)0)).z, (double)points.get((Object)Integer.valueOf((int)5)).x, (double)points.get((Object)Integer.valueOf((int)5)).y, (double)points.get((Object)Integer.valueOf((int)5)).z);
        AxisAlignedBB yTopFace = new AxisAlignedBB((double)points.get((Object)Integer.valueOf((int)0)).x, (double)points.get((Object)Integer.valueOf((int)0)).y, (double)points.get((Object)Integer.valueOf((int)0)).z, (double)points.get((Object)Integer.valueOf((int)3)).x, (double)points.get((Object)Integer.valueOf((int)3)).y, (double)points.get((Object)Integer.valueOf((int)3)).z);
        AxisAlignedBB yBottomFace = new AxisAlignedBB((double)points.get((Object)Integer.valueOf((int)4)).x, (double)points.get((Object)Integer.valueOf((int)4)).y, (double)points.get((Object)Integer.valueOf((int)4)).z, (double)points.get((Object)Integer.valueOf((int)7)).x, (double)points.get((Object)Integer.valueOf((int)7)).y, (double)points.get((Object)Integer.valueOf((int)7)).z);
        AxisAlignedBB zFrontFace = new AxisAlignedBB((double)points.get((Object)Integer.valueOf((int)4)).x, (double)points.get((Object)Integer.valueOf((int)4)).y, (double)points.get((Object)Integer.valueOf((int)4)).z, (double)points.get((Object)Integer.valueOf((int)2)).x, (double)points.get((Object)Integer.valueOf((int)2)).y, (double)points.get((Object)Integer.valueOf((int)2)).z);
        AxisAlignedBB zBackFace = new AxisAlignedBB((double)points.get((Object)Integer.valueOf((int)0)).x, (double)points.get((Object)Integer.valueOf((int)0)).y, (double)points.get((Object)Integer.valueOf((int)0)).z, (double)points.get((Object)Integer.valueOf((int)6)).x, (double)points.get((Object)Integer.valueOf((int)6)).y, (double)points.get((Object)Integer.valueOf((int)6)).z);
        boxes[0] = xFrontFace;
        boxes[1] = xBackFace;
        boxes[2] = yTopFace;
        boxes[3] = yBottomFace;
        boxes[4] = zFrontFace;
        boxes[5] = zBackFace;
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        float partialTickTime = TickUtils.getPartialTickTime();
        Vec3d pos = player.func_174824_e(partialTickTime);
        double d0 = player.field_71075_bZ.field_75098_d ? 5.0 : 4.5;
        Vec3d look = player.func_70676_i(partialTickTime);
        Vec3d vec32 = pos.func_72441_c(look.field_72450_a * d0, look.field_72448_b * d0, look.field_72449_c * d0);
        RayTraceResult ray = yTopFace.func_72327_a(pos, vec32);
        double distance = Double.MAX_VALUE;
        int index = -1;
        for (int i = 0; i < boxes.length; ++i) {
            double tempDistance;
            RayTraceResult result = boxes[i].func_72327_a(pos, vec32);
            if (result == null || !((tempDistance = pos.func_72436_e(result.field_72307_f)) < distance)) continue;
            index = i;
            distance = tempDistance;
        }
        if (index != -1) {
            if (index == 2 || index == 5) {
                DrawString3d.drawStringOnLine(measurementUnits.get(0), contextSize, DrawString3d.DrawPosition.Middle, points.get(0), points.get(1), -1, true, 0);
            }
            if (index == 2 || index == 4) {
                DrawString3d.drawStringOnLine(measurementUnits.get(0), contextSize, DrawString3d.DrawPosition.Middle, points.get(2), points.get(3), -1, true, 0);
            }
            if (index == 2 || index == 0) {
                DrawString3d.drawStringOnLine(measurementUnits.get(2), contextSize, DrawString3d.DrawPosition.Middle, points.get(1), points.get(3), -1, true, 0);
            }
            if (index == 2 || index == 1) {
                DrawString3d.drawStringOnLine(measurementUnits.get(2), contextSize, DrawString3d.DrawPosition.Middle, points.get(0), points.get(2), -1, true, 0);
            }
            if (index == 4 || index == 3) {
                DrawString3d.drawStringOnLine(measurementUnits.get(0), contextSize, DrawString3d.DrawPosition.Middle, points.get(4), points.get(5), -1, true, 0);
            }
            if (index == 5 || index == 3) {
                DrawString3d.drawStringOnLine(measurementUnits.get(0), contextSize, DrawString3d.DrawPosition.Middle, points.get(6), points.get(7), -1, true, 0);
            }
            if (index == 1 || index == 3) {
                DrawString3d.drawStringOnLine(measurementUnits.get(2), contextSize, DrawString3d.DrawPosition.Middle, points.get(5), points.get(7), -1, true, 0);
            }
            if (index == 0 || index == 3) {
                DrawString3d.drawStringOnLine(measurementUnits.get(2), contextSize, DrawString3d.DrawPosition.Middle, points.get(4), points.get(6), -1, true, 0);
            }
            if (index == 5 || index == 1) {
                DrawString3d.drawStringOnLine(measurementUnits.get(1), contextSize, DrawString3d.DrawPosition.Middle, points.get(0), points.get(7), -1, true, 0);
            }
            if (index == 0 || index == 5) {
                DrawString3d.drawStringOnLine(measurementUnits.get(1), contextSize, DrawString3d.DrawPosition.Middle, points.get(1), points.get(6), -1, true, 0);
            }
            if (index == 4 || index == 1) {
                DrawString3d.drawStringOnLine(measurementUnits.get(1), contextSize, DrawString3d.DrawPosition.Middle, points.get(2), points.get(5), -1, true, 0);
            }
            if (index == 0 || index == 4) {
                DrawString3d.drawStringOnLine(measurementUnits.get(1), contextSize, DrawString3d.DrawPosition.Middle, points.get(3), points.get(4), -1, true, 0);
            }
        }
    }
}

