/*
 * Decompiled with CFR 0.152.
 */
package com.alet.client.tapemeasure.shape.measurement;

import com.alet.ALETConfig;
import com.alet.client.tapemeasure.TapeRenderer;
import com.alet.items.ItemTapeMeasure;
import com.creativemd.creativecore.common.gui.GuiControl;
import com.creativemd.littletiles.common.util.grid.LittleGridContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Stack;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class MeasurementShape {
    protected int pointsNeeded;
    protected final String shapeName;

    public MeasurementShape(int pointsNeeded, String shapeName) {
        this.pointsNeeded = pointsNeeded;
        this.shapeName = shapeName;
    }

    public String getKey() {
        return this.shapeName;
    }

    public boolean hasPointsNeeded(HashMap<Integer, Point3f> points) {
        for (int i = 0; i < this.pointsNeeded; ++i) {
            if (points.containsKey(i)) continue;
            return false;
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public String getLocalizedName() {
        return GuiControl.translateOrDefault((String)("shape." + this.getKey()), (String)this.getKey());
    }

    public static double getDistence(double pos_1, double pos_2, int contextSize) {
        LittleGridContext context = LittleGridContext.get((int)contextSize);
        double contDecimal = 1.0 / (double)context.size;
        double distence = Math.abs(pos_1 - pos_2) + contDecimal;
        return distence;
    }

    public static Vector3f rotateVector(Vector3f vec, Vector3f axis, double theta) {
        double x = vec.getX();
        double y = vec.getY();
        double z = vec.getZ();
        double u = axis.getX();
        double v = axis.getY();
        double w = axis.getZ();
        float xPrime = (float)(u * (u * x + v * y + w * z) * (1.0 - Math.cos(theta)) + x * Math.cos(theta) + (-w * y + v * z) * Math.sin(theta));
        float yPrime = (float)(v * (u * x + v * y + w * z) * (1.0 - Math.cos(theta)) + y * Math.cos(theta) + (w * x - u * z) * Math.sin(theta));
        float zPrime = (float)(w * (u * x + v * y + w * z) * (1.0 - Math.cos(theta)) + z * Math.cos(theta) + (-v * x + u * y) * Math.sin(theta));
        return new Vector3f(xPrime, yPrime, zPrime);
    }

    public static Point3f getMidPoint(Point3f point2, Point3f point1) {
        return new Point3f((point2.x + point1.x) / 2.0f, (point2.y + point1.y) / 2.0f, (point2.z + point1.z) / 2.0f);
    }

    public static float[] getLineAngle(Point3f startPoint, Point3f endPoint) {
        float deltaX = startPoint.x - endPoint.x;
        float deltaY = startPoint.y - endPoint.y;
        float deltaZ = startPoint.z - endPoint.z;
        float yaw = (float)Math.atan2(deltaZ, deltaX);
        float pitch = (float)Math.atan2(Math.sqrt(deltaZ * deltaZ + deltaX * deltaX), deltaY);
        return new float[]{(float)Math.toDegrees(pitch), (float)Math.toDegrees(yaw)};
    }

    public static float[] getAngles(Point3f point1, Point3f point2, Point3f point3) {
        if (point1 != null && point2 != null && point3 != null) {
            Point3f C = point1;
            Point3f A = point2;
            Point3f B = point3;
            double a = C.distance(B);
            double b = A.distance(C);
            double c = A.distance(B);
            float a2 = (float)Math.pow(a, 2.0);
            float b2 = (float)Math.pow(b, 2.0);
            float c2 = (float)Math.pow(c, 2.0);
            return new float[]{(float)Math.toDegrees(Math.acos((double)(b2 + c2 - a2) / (2.0 * b * c))), (float)Math.toDegrees(Math.acos((double)(c2 + a2 - b2) / (2.0 * c * a))), (float)Math.toDegrees(Math.acos((double)(a2 + b2 - c2) / (2.0 * a * b)))};
        }
        return new float[0];
    }

    protected static double cleanDouble(double doub) {
        String clean = String.format("%.3f", doub);
        doub = Double.parseDouble(clean);
        return doub;
    }

    public static double changeMesurmentType(double toChange) {
        String s;
        List<String> arg;
        int x = ItemTapeMeasure.measurementType;
        if (x != 0 && (arg = Arrays.asList((s = ALETConfig.tapeMeasure.measurementEquation.get(x - 1)).split("M"))).size() == 2) {
            if (arg.get(0).equals("(")) {
                return MeasurementShape.evaluate("( " + toChange + arg.get(1));
            }
            return MeasurementShape.evaluate(toChange + arg.get(1));
        }
        return 0.0;
    }

    public static double evaluate(String expression) {
        char[] tokens = expression.toCharArray();
        Stack<Double> values = new Stack<Double>();
        Stack<Character> ops = new Stack<Character>();
        for (int i = 0; i < tokens.length; ++i) {
            if (tokens[i] == ' ') continue;
            if (tokens[i] >= '0' && tokens[i] <= '9' || tokens[i] == '.') {
                StringBuffer sbuf = new StringBuffer();
                while (i < tokens.length && tokens[i] >= '0' && tokens[i] <= '9' || i < tokens.length && tokens[i] == '.') {
                    sbuf.append(tokens[i++]);
                }
                values.push(Double.parseDouble(sbuf.toString()));
                --i;
                continue;
            }
            if (tokens[i] == '(') {
                ops.push(Character.valueOf(tokens[i]));
                continue;
            }
            if (tokens[i] == ')') {
                while (((Character)ops.peek()).charValue() != '(') {
                    values.push(MeasurementShape.applyOp(((Character)ops.pop()).charValue(), (Double)values.pop(), (Double)values.pop()));
                }
                ops.pop();
                continue;
            }
            if (tokens[i] != '+' && tokens[i] != '-' && tokens[i] != '*' && tokens[i] != '/') continue;
            while (!ops.empty() && MeasurementShape.hasPrecedence(tokens[i], ((Character)ops.peek()).charValue())) {
                values.push(MeasurementShape.applyOp(((Character)ops.pop()).charValue(), (Double)values.pop(), (Double)values.pop()));
            }
            ops.push(Character.valueOf(tokens[i]));
        }
        while (!ops.empty()) {
            values.push(MeasurementShape.applyOp(((Character)ops.pop()).charValue(), (Double)values.pop(), (Double)values.pop()));
        }
        return (Double)values.pop();
    }

    public static boolean hasPrecedence(char op1, char op2) {
        if (op2 == '(' || op2 == ')') {
            return false;
        }
        return op1 != '*' && op1 != '/' || op2 != '+' && op2 != '-';
    }

    public static double applyOp(char op, double b, double a) {
        switch (op) {
            case '+': {
                return a + b;
            }
            case '-': {
                return a - b;
            }
            case '*': {
                return a * b;
            }
            case '/': {
                if (b == 0.0) {
                    throw new UnsupportedOperationException("Cannot divide by zero");
                }
                return a / b;
            }
        }
        return 0.0;
    }

    private static void drawBoundingBox(BufferBuilder buffer, double minX, double minY, double minZ, double maxX, double maxY, double maxZ, float red, float green, float blue, float alpha) {
        buffer.func_181662_b(minX, minY, minZ).func_181666_a(red, green, blue, 0.0f).func_181675_d();
        buffer.func_181662_b(minX, minY, minZ).func_181666_a(red, green, blue, alpha).func_181675_d();
        buffer.func_181662_b(maxX, minY, minZ).func_181666_a(red, green, blue, alpha).func_181675_d();
        buffer.func_181662_b(maxX, minY, maxZ).func_181666_a(red, green, blue, alpha).func_181675_d();
        buffer.func_181662_b(minX, minY, maxZ).func_181666_a(red, green, blue, alpha).func_181675_d();
        buffer.func_181662_b(minX, minY, minZ).func_181666_a(red, green, blue, alpha).func_181675_d();
        buffer.func_181662_b(minX, maxY, minZ).func_181666_a(red, green, blue, alpha).func_181675_d();
        buffer.func_181662_b(maxX, maxY, minZ).func_181666_a(red, green, blue, alpha).func_181675_d();
        buffer.func_181662_b(maxX, maxY, maxZ).func_181666_a(red, green, blue, alpha).func_181675_d();
        buffer.func_181662_b(minX, maxY, maxZ).func_181666_a(red, green, blue, alpha).func_181675_d();
        buffer.func_181662_b(minX, maxY, minZ).func_181666_a(red, green, blue, alpha).func_181675_d();
        buffer.func_181662_b(minX, maxY, maxZ).func_181666_a(red, green, blue, 0.0f).func_181675_d();
        buffer.func_181662_b(minX, minY, maxZ).func_181666_a(red, green, blue, alpha).func_181675_d();
        buffer.func_181662_b(maxX, maxY, maxZ).func_181666_a(red, green, blue, 0.0f).func_181675_d();
        buffer.func_181662_b(maxX, minY, maxZ).func_181666_a(red, green, blue, alpha).func_181675_d();
        buffer.func_181662_b(maxX, maxY, minZ).func_181666_a(red, green, blue, 0.0f).func_181675_d();
        buffer.func_181662_b(maxX, minY, minZ).func_181666_a(red, green, blue, alpha).func_181675_d();
        buffer.func_181662_b(maxX, minY, minZ).func_181666_a(red, green, blue, 0.0f).func_181675_d();
    }

    public static HashMap<Integer, Point3f> drawLine(Point3f p1, Point3f p2, int contextSize, float red, float green, float blue, float alpha) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        double conDiv = 0.5 / (double)contextSize;
        double minX = (double)p1.x + conDiv;
        double minY = (double)p1.y + conDiv;
        double minZ = (double)p1.z + conDiv;
        double maxX = (double)p2.x + conDiv;
        double maxY = (double)p2.y + conDiv;
        double maxZ = (double)p2.z + conDiv;
        HashMap<Integer, Point3f> points = new HashMap<Integer, Point3f>();
        points.put(0, new Point3f((float)minX, (float)minY, (float)minZ));
        points.put(1, new Point3f((float)maxX, (float)maxY, (float)maxZ));
        bufferbuilder.func_181662_b(minX - 0.001, minY - 0.001, minZ - 0.001).func_181666_a(red, green, blue, 0.0f).func_181675_d();
        bufferbuilder.func_181662_b(maxX - 0.001, maxY - 0.001, maxZ - 0.001).func_181666_a(red, green, blue, 1.0f).func_181675_d();
        bufferbuilder.func_181662_b(minX - 0.001, minY - 0.001, minZ - 0.001).func_181666_a(red, green, blue, 0.0f).func_181675_d();
        return points;
    }

    public static HashMap<Integer, Point3f> drawCube(Point3f point, int contextSize, float red, float green, float blue, float alpha) {
        double conDiv = 1.0 / (double)contextSize;
        double minX = point.x;
        double minY = point.y;
        double minZ = point.z;
        double maxX = (double)point.x + conDiv;
        double maxY = (double)point.y + conDiv;
        double maxZ = (double)point.z + conDiv;
        HashMap<Integer, Point3f> points = new HashMap<Integer, Point3f>();
        points.put(0, new Point3f((float)minX, (float)minY, (float)minZ));
        points.put(1, new Point3f((float)maxX, (float)maxY, (float)maxZ));
        MeasurementShape.drawBoundingBox(TapeRenderer.bufferbuilder, minX - 0.001, minY - 0.001, minZ - 0.001, maxX + 0.001, maxY + 0.001, maxZ + 0.001, red, green, blue, alpha);
        return points;
    }

    public static HashMap<Integer, Point3f> drawBox(Point3f point1, Point3f point2, int contextSize, float red, float green, float blue, float alpha) {
        float conDiv = (float)(1.0 / (double)contextSize);
        float minX = point1.x;
        float minY = point1.y;
        float minZ = point1.z;
        float maxX = point2.x + conDiv;
        float maxY = point2.y + conDiv;
        float maxZ = point2.z + conDiv;
        if (minX >= maxX) {
            minX += conDiv;
            maxX -= conDiv;
        }
        if (minZ >= maxZ) {
            minZ += conDiv;
            maxZ -= conDiv;
        }
        if (minY >= maxY) {
            minY += conDiv;
            maxY -= conDiv;
        }
        HashMap<Integer, Point3f> points = new HashMap<Integer, Point3f>();
        points.put(0, new Point3f(minX, minY, minZ));
        points.put(1, new Point3f(maxX, minY, minZ));
        points.put(2, new Point3f(minX, minY, maxZ));
        points.put(3, new Point3f(maxX, minY, maxZ));
        points.put(4, new Point3f(maxX, maxY, maxZ));
        points.put(5, new Point3f(minX, maxY, maxZ));
        points.put(6, new Point3f(maxX, maxY, minZ));
        points.put(7, new Point3f(minX, maxY, minZ));
        MeasurementShape.drawBoundingBox(TapeRenderer.bufferbuilder, (double)minX - 0.001, (double)minY - 0.001, (double)minZ - 0.001, (double)maxX + 0.001, (double)maxY + 0.001, (double)maxZ + 0.001, red, green, blue, alpha);
        return points;
    }

    protected abstract void drawText(HashMap<Integer, Point3f> var1, List<String> var2, int var3, int var4);

    public void tryDrawShape(HashMap<Integer, Point3f> points, LittleGridContext context, float red, float green, float blue, float alpha) {
        if (points != null && !points.isEmpty() && this.hasPointsNeeded(points)) {
            this.drawShape(points, context, red, green, blue, alpha);
        }
    }

    protected abstract void drawShape(HashMap<Integer, Point3f> var1, LittleGridContext var2, float var3, float var4, float var5, float var6);

    public List<String> tryGetMeasurementUnits(HashMap<Integer, Point3f> points, LittleGridContext context) {
        if (points != null && points.size() >= this.pointsNeeded) {
            return this.getMeasurementUnits(points, context);
        }
        return new ArrayList<String>();
    }

    protected abstract List<String> getMeasurementUnits(HashMap<Integer, Point3f> var1, LittleGridContext var2);

    public abstract List<GuiControl> getCustomSettings(NBTTagCompound var1, LittleGridContext var2);
}

