/*
 * Decompiled with CFR 0.152.
 */
package com.alet.client.tapemeasure.shape.draw;

import com.creativemd.creativecore.common.gui.GuiControl;
import com.creativemd.creativecore.common.gui.container.GuiParent;
import com.creativemd.creativecore.common.gui.controls.gui.GuiLabel;
import com.creativemd.creativecore.common.gui.controls.gui.GuiSteppedSlider;
import com.creativemd.creativecore.common.utils.math.Rotation;
import com.creativemd.littletiles.common.tile.LittleTile;
import com.creativemd.littletiles.common.tile.math.box.LittleBox;
import com.creativemd.littletiles.common.tile.math.box.LittleBoxes;
import com.creativemd.littletiles.common.tile.parent.IParentTileList;
import com.creativemd.littletiles.common.util.grid.LittleGridContext;
import com.creativemd.littletiles.common.util.shape.ShapeSelection;
import com.creativemd.littletiles.common.util.shape.type.LittleShapeSelectable;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class LittleShapeMagicWand
extends LittleShapeSelectable {
    int tolerance;

    public LittleShapeMagicWand() {
        super(1);
    }

    protected void addBoxes(LittleBoxes boxes, ShapeSelection selection, boolean lowResolution) {
        for (ShapeSelection.ShapeSelectPos pos : selection) {
            if (pos.result.isComplete()) {
                if (pos.result.parent.isStructure()) continue;
                LittleTile tile = pos.result.tile;
                int color = tile.getPreviewTile().getColor();
                int r = color >> 16 & 0xFF;
                int g = color >> 8 & 0xFF;
                int b = color & 0xFF;
                int minR = Math.max(r - this.tolerance, 0);
                int minG = Math.max(g - this.tolerance, 0);
                int minB = Math.max(b - this.tolerance, 0);
                int maxR = Math.min(r + this.tolerance, 255);
                int maxG = Math.min(g + this.tolerance, 255);
                int maxB = Math.min(b + this.tolerance, 255);
                for (LittleTile toDestroy : pos.result.te.noneStructureTiles()) {
                    color = toDestroy.getPreviewTile().getColor();
                    int red = color >> 16 & 0xFF;
                    int green = color >> 8 & 0xFF;
                    int blue = color & 0xFF;
                    if (red < minR || red > maxR || green < minG || green > maxG || blue < minB || blue > maxB) continue;
                    LittleShapeMagicWand.addBox((LittleBoxes)boxes, (boolean)selection.inside, (LittleGridContext)selection.getContext(), (IParentTileList)pos.result.te.noneStructureTiles(), (LittleBox)toDestroy.getBox(), (EnumFacing)pos.pos.facing);
                }
                continue;
            }
            this.addBox(boxes, selection.inside, selection.getContext(), pos.ray.func_178782_a(), pos.pos.facing);
        }
    }

    public void addExtraInformation(NBTTagCompound nbt, List<String> list) {
        list.add("tolerance: " + nbt.func_74762_e("tolerance"));
    }

    @SideOnly(value=Side.CLIENT)
    public List<GuiControl> getCustomSettings(NBTTagCompound nbt, LittleGridContext context) {
        ArrayList<GuiControl> controls = new ArrayList<GuiControl>();
        controls.add((GuiControl)new GuiLabel("tolerance: ", 5, 5));
        controls.add((GuiControl)new GuiSteppedSlider("tolerance", 5, 20, 100, 14, nbt.func_74762_e("tolerance"), 1, 255));
        return controls;
    }

    @SideOnly(value=Side.CLIENT)
    public void saveCustomSettings(GuiParent gui, NBTTagCompound nbt, LittleGridContext context) {
        GuiSteppedSlider slider = (GuiSteppedSlider)gui.get("tolerance");
        nbt.func_74768_a("tolerance", (int)slider.value);
        this.tolerance = (int)slider.value;
    }

    public void rotate(NBTTagCompound nbt, Rotation rotation) {
    }

    public void flip(NBTTagCompound nbt, EnumFacing.Axis axis) {
    }
}

