/*
 * Decompiled with CFR 0.152.
 */
package com.alet.client.tapemeasure.shape.draw;

import com.creativemd.creativecore.common.gui.GuiControl;
import com.creativemd.creativecore.common.gui.container.GuiParent;
import com.creativemd.creativecore.common.gui.controls.gui.GuiCheckBox;
import com.creativemd.creativecore.common.gui.controls.gui.GuiStateButton;
import com.creativemd.creativecore.common.gui.controls.gui.GuiSteppedSlider;
import com.creativemd.creativecore.common.utils.math.Rotation;
import com.creativemd.littletiles.common.tile.math.box.LittleBox;
import com.creativemd.littletiles.common.tile.math.box.LittleBoxes;
import com.creativemd.littletiles.common.tile.math.vec.LittleVec;
import com.creativemd.littletiles.common.util.grid.LittleGridContext;
import com.creativemd.littletiles.common.util.shape.LittleShape;
import com.creativemd.littletiles.common.util.shape.ShapeSelection;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class DragShapeCenteredCylinder
extends LittleShape {
    public DragShapeCenteredCylinder() {
        super(2);
    }

    protected void addBoxes(LittleBoxes boxes, ShapeSelection selection, boolean lowResolution) {
        LittleVec vec1 = selection.getFirst().pos.getRelative(selection.getPos());
        LittleVec vec2 = selection.getLast().pos.getRelative(selection.getPos());
        LittleBox box1 = new LittleBox(vec1);
        LittleBox box2 = new LittleBox(vec2);
        int pX = box1.maxX - box2.maxX;
        int pY = box1.maxY - box2.maxY;
        int pZ = box1.maxZ - box2.maxZ;
        LittleBox box3 = new LittleBox(new LittleBox[]{box2});
        System.out.println(pX + " " + pY + " " + pZ);
        int i = 0;
        if (selection.getNBT().func_74767_n("center")) {
            ++i;
        }
        box3.add(pX * 2 + i, pY * 2 + i, pZ * 2 + i);
        LittleBox box = new LittleBox(new LittleBox[]{box2, box3});
        LittleBoxes innerBoxes = boxes.copy();
        boolean hollow = selection.getNBT().func_74767_n("hollow");
        int direction = selection.getNBT().func_74762_e("direction");
        LittleVec size = box.getSize();
        int sizeA = size.x;
        int sizeB = size.z;
        if (direction == 1) {
            sizeA = size.y;
            sizeB = size.z;
        } else if (direction == 2) {
            sizeA = size.x;
            sizeB = size.y;
        }
        double a = Math.pow(Math.max(1.0, (double)sizeA / 2.0), 2.0);
        double b = Math.pow(Math.max(1.0, (double)sizeB / 2.0), 2.0);
        double a2 = 1.0;
        double b2 = 1.0;
        double c2 = 1.0;
        int thickness = selection.getNBT().func_74762_e("thickness");
        if (hollow && sizeA > thickness * 2 && sizeB > thickness * 2) {
            int sizeAValue = sizeA - thickness - 1;
            int sizeBValue = sizeB - thickness - 1;
            a2 = Math.pow(Math.max(1.0, (double)sizeAValue / 2.0), 2.0);
            b2 = Math.pow(Math.max(1.0, (double)sizeBValue / 2.0), 2.0);
        } else {
            hollow = false;
        }
        boolean stretchedA = sizeA % 2 == 0;
        boolean stretchedB = sizeB % 2 == 0;
        double centerA = sizeA / 2;
        double centerB = sizeB / 2;
        LittleVec min = box.getMinVec();
        LittleVec max = box.getMaxVec();
        for (int incA = 0; incA < sizeA; ++incA) {
            for (int incB = 0; incB < sizeB; ++incB) {
                double valueB;
                double posA = (double)incA - centerA + (stretchedA ? 0.5 : 0.0);
                double posB = (double)incB - centerB + (stretchedB ? 0.5 : 0.0);
                double valueA = Math.pow(posA, 2.0) / a;
                if (!(valueA + (valueB = Math.pow(posB, 2.0) / b) <= 1.0)) continue;
                LittleBox toAdd = null;
                switch (direction) {
                    case 0: {
                        toAdd = new LittleBox(min.x + incA, min.y, min.z + incB, min.x + incA + 1, max.y, min.z + incB + 1);
                        break;
                    }
                    case 1: {
                        toAdd = new LittleBox(min.x, min.y + incA, min.z + incB, max.x, min.y + incA + 1, min.z + incB + 1);
                        break;
                    }
                    case 2: {
                        toAdd = new LittleBox(min.x + incA, min.y + incB, min.z, min.x + incA + 1, min.y + incB + 1, max.z);
                    }
                }
                if (hollow) {
                    double valueB2;
                    double valueA2 = Math.pow(posA, 2.0) / a2;
                    if (valueA2 + (valueB2 = Math.pow(posB, 2.0) / b2) <= 1.0) continue;
                    boxes.add(toAdd);
                    continue;
                }
                boxes.add(toAdd);
            }
        }
        boxes.combineBoxesBlocks();
    }

    public void addExtraInformation(NBTTagCompound nbt, List<String> list) {
        if (nbt.func_74767_n("hollow")) {
            list.add("type: hollow");
            list.add("thickness: " + nbt.func_74762_e("thickness") + " tiles");
        } else {
            list.add("type: solid");
        }
        if (nbt.func_74767_n("center")) {
            list.add("center: double");
        } else {
            list.add("center: single");
        }
        int facing = nbt.func_74762_e("direction");
        String text = "facing: ";
        switch (facing) {
            case 0: {
                text = text + "y";
                break;
            }
            case 1: {
                text = text + "x";
                break;
            }
            case 2: {
                text = text + "z";
            }
        }
        list.add(text);
    }

    @SideOnly(value=Side.CLIENT)
    public List<GuiControl> getCustomSettings(NBTTagCompound nbt, LittleGridContext context) {
        ArrayList<GuiControl> controls = new ArrayList<GuiControl>();
        controls.add((GuiControl)new GuiCheckBox("hollow", 5, 0, nbt.func_74767_n("hollow")));
        controls.add((GuiControl)new GuiCheckBox("center", "double center", 5, 13, nbt.func_74767_n("center")));
        controls.add((GuiControl)new GuiSteppedSlider("thickness", 5, 30, 100, 14, nbt.func_74762_e("thickness"), 1, context.size));
        controls.add((GuiControl)new GuiStateButton("direction", nbt.func_74762_e("direction"), 5, 52, new String[]{"facing: y", "facing: x", "facing: z"}));
        return controls;
    }

    @SideOnly(value=Side.CLIENT)
    public void saveCustomSettings(GuiParent gui, NBTTagCompound nbt, LittleGridContext context) {
        GuiCheckBox box = (GuiCheckBox)gui.get("hollow");
        nbt.func_74757_a("hollow", box.value);
        GuiSteppedSlider slider = (GuiSteppedSlider)gui.get("thickness");
        nbt.func_74768_a("thickness", (int)slider.value);
        GuiCheckBox center = (GuiCheckBox)gui.get("center");
        nbt.func_74757_a("center", center.value);
        GuiStateButton state = (GuiStateButton)gui.get("direction");
        nbt.func_74768_a("direction", state.getState());
    }

    public void rotate(NBTTagCompound nbt, Rotation rotation) {
        int direction = nbt.func_74762_e("direction");
        direction = rotation.axis != EnumFacing.Axis.Y ? 0 : (direction == 1 ? 2 : 1);
        nbt.func_74768_a("direction", direction);
    }

    public void flip(NBTTagCompound nbt, EnumFacing.Axis axis) {
    }
}

