/*
 * Decompiled with CFR 0.152.
 */
package com.alet.client.tapemeasure;

import com.alet.client.tapemeasure.shape.measurement.MeasurementShape;
import com.alet.client.tapemeasure.shape.measurement.MeasurementShapeBox;
import com.alet.client.tapemeasure.shape.measurement.MeasurementShapeRegistar;
import com.alet.common.utils.NBTUtils;
import com.alet.items.ItemTapeMeasure;
import com.creativemd.creativecore.common.utils.mc.ColorUtils;
import com.creativemd.littletiles.common.util.grid.LittleGridContext;
import com.creativemd.littletiles.common.util.ingredient.LittleInventory;
import java.util.HashMap;
import javax.vecmath.Point3f;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.util.Color;

public class TapeRenderer {
    public static int slotID = -1;
    public static Minecraft mc = Minecraft.func_71410_x();
    public static Tessellator tessellator = Tessellator.func_178181_a();
    public static BufferBuilder bufferbuilder = tessellator.func_178180_c();
    public static ItemStack tapemeasure = ItemStack.field_190927_a;
    public static HashMap<Integer, MeasurementShape> cachedMeasurements = new HashMap();
    public static Point3f lastKnownCursorPos;

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void render(RenderWorldLastEvent event) {
        NBTTagCompound stackNBT;
        EntityPlayerSP player = TapeRenderer.mc.field_71439_g;
        LittleInventory inventory = new LittleInventory((EntityPlayer)player);
        if (slotID == -1) {
            for (int i = 0; i < inventory.size(); ++i) {
                if (!(inventory.get(i).func_77973_b() instanceof ItemTapeMeasure)) continue;
                tapemeasure = inventory.get(i);
                slotID = i;
                break;
            }
        }
        if (!(inventory.get(slotID).func_77973_b() instanceof ItemTapeMeasure)) {
            slotID = -1;
            tapemeasure = ItemStack.field_190927_a;
        } else {
            tapemeasure = inventory.get(slotID);
        }
        if (!tapemeasure.func_190926_b() && tapemeasure.func_77942_o() && (stackNBT = tapemeasure.func_77978_p()).func_74764_b("measurements")) {
            NBTTagCompound measurements = (NBTTagCompound)stackNBT.func_74781_a("measurements");
            for (String key : measurements.func_150296_c()) {
                NBTTagCompound measurement = (NBTTagCompound)measurements.func_74781_a(key);
                int index = Integer.parseInt(key);
                String shapeName = measurement.func_74779_i("shape");
                Color color = ColorUtils.IntToRGBA((int)measurement.func_74762_e("color"));
                LittleGridContext context = ItemTapeMeasure.getContextAt(stackNBT, index);
                Point3f point1 = lastKnownCursorPos;
                Point3f point2 = lastKnownCursorPos;
                Point3f point3 = lastKnownCursorPos;
                Point3f point4 = lastKnownCursorPos;
                if (measurement.func_74764_b("positions")) {
                    NBTTagCompound positions = measurement.func_74775_l("positions");
                    if (positions.func_74764_b("0")) {
                        double[] p0 = NBTUtils.readDoubleArray(positions.func_74775_l("0"), "pos", 6);
                        point1 = new Point3f((float)p0[0], (float)p0[1], (float)p0[2]);
                    }
                    if (positions.func_74764_b("1")) {
                        double[] p1 = NBTUtils.readDoubleArray(positions.func_74775_l("1"), "pos", 6);
                        point2 = new Point3f((float)p1[0], (float)p1[1], (float)p1[2]);
                    }
                    if (positions.func_74764_b("2")) {
                        double[] p2 = NBTUtils.readDoubleArray(positions.func_74775_l("2"), "pos", 6);
                        point3 = new Point3f((float)p2[0], (float)p2[1], (float)p2[2]);
                    }
                    if (positions.func_74764_b("3")) {
                        double[] p3 = NBTUtils.readDoubleArray(positions.func_74775_l("3"), "pos", 6);
                        point4 = new Point3f((float)p3[0], (float)p3[1], (float)p3[2]);
                    }
                }
                HashMap<Integer, Point3f> listOfP = new HashMap<Integer, Point3f>();
                if (point1 != null) {
                    listOfP.put(0, point1);
                }
                if (point2 != null) {
                    listOfP.put(1, point2);
                }
                if (point3 != null) {
                    listOfP.put(2, point3);
                }
                if (point4 != null) {
                    listOfP.put(3, point4);
                }
                MeasurementShape shape = MeasurementShapeRegistar.getMeasurementShape(shapeName);
                cachedMeasurements.put(index, shape);
                float r = (float)color.getRed() / 255.0f;
                float g = (float)color.getGreen() / 255.0f;
                float b = (float)color.getBlue() / 255.0f;
                GlStateManager.func_179094_E();
                GlStateManager.func_179147_l();
                GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
                GlStateManager.func_187441_d((float)2.0f);
                GlStateManager.func_179141_d();
                double d0 = player.field_70142_S + (player.field_70165_t - player.field_70142_S) * (double)mc.func_184121_ak();
                double d1 = player.field_70137_T + (player.field_70163_u - player.field_70137_T) * (double)mc.func_184121_ak();
                double d2 = player.field_70136_U + (player.field_70161_v - player.field_70136_U) * (double)mc.func_184121_ak();
                GlStateManager.func_179137_b((double)(-d0), (double)(-d1), (double)(-d2));
                GlStateManager.func_179090_x();
                GlStateManager.func_179132_a((boolean)false);
                GlStateManager.func_179097_i();
                bufferbuilder.func_181668_a(2, DefaultVertexFormats.field_181706_f);
                shape.tryDrawShape(listOfP, context, r, g, b, 1.0f);
                tessellator.func_78381_a();
                GlStateManager.func_179098_w();
                GlStateManager.func_179126_j();
                GlStateManager.func_179132_a((boolean)true);
                GlStateManager.func_179084_k();
                GlStateManager.func_179121_F();
            }
        }
    }

    public static void renderCursor(Point3f posCursor, LittleGridContext context) {
        Color color = ColorUtils.IntToRGBA((int)-1);
        float r = (float)color.getRed() / 255.0f;
        float g = (float)color.getGreen() / 255.0f;
        float b = (float)color.getBlue() / 255.0f;
        GlStateManager.func_179094_E();
        GlStateManager.func_179147_l();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_187441_d((float)2.0f);
        GlStateManager.func_179090_x();
        GlStateManager.func_179132_a((boolean)false);
        GlStateManager.func_179097_i();
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        double d0 = player.field_70142_S + (player.field_70165_t - player.field_70142_S) * (double)mc.func_184121_ak();
        double d1 = player.field_70137_T + (player.field_70163_u - player.field_70137_T) * (double)mc.func_184121_ak();
        double d2 = player.field_70136_U + (player.field_70161_v - player.field_70136_U) * (double)mc.func_184121_ak();
        GlStateManager.func_179137_b((double)(-d0), (double)(-d1), (double)(-d2));
        bufferbuilder.func_181668_a(2, DefaultVertexFormats.field_181706_f);
        MeasurementShapeBox.drawCube(posCursor, context.size, r, g, b, 1.0f);
        lastKnownCursorPos = posCursor;
        tessellator.func_78381_a();
        GlStateManager.func_179126_j();
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179098_w();
        GlStateManager.func_179084_k();
        GlStateManager.func_179121_F();
    }
}

