/*
 * Decompiled with CFR 0.152.
 */
package com.alet.client.gui.overlay;

import com.alet.client.gui.overlay.controls.GuiOverlayTextList;
import com.alet.client.tapemeasure.TapeRenderer;
import com.alet.client.tapemeasure.shape.measurement.MeasurementShape;
import com.creativemd.creativecore.common.gui.GuiControl;
import com.creativemd.creativecore.common.gui.GuiRenderHelper;
import com.creativemd.creativecore.common.gui.client.style.ColoredDisplayStyle;
import com.creativemd.creativecore.common.gui.client.style.DisplayStyle;
import com.creativemd.creativecore.common.gui.client.style.Style;
import com.creativemd.creativecore.common.utils.mc.ColorUtils;
import com.creativemd.littletiles.common.tile.math.vec.LittleVec;
import com.creativemd.littletiles.common.tile.math.vec.LittleVecContext;
import com.creativemd.littletiles.common.util.grid.LittleGridContext;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.TextFormatting;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.Color;

public class GuiDisplayMeasurements
extends GuiControl {
    public static Style transparentStyle = new Style("Transparent", (DisplayStyle)new ColoredDisplayStyle(0, 0, 0, 40), (DisplayStyle)new ColoredDisplayStyle(90, 90, 90, 60), (DisplayStyle)new ColoredDisplayStyle(90, 90, 90, 50), (DisplayStyle)new ColoredDisplayStyle(198, 198, 198), (DisplayStyle)new ColoredDisplayStyle(0, 0, 0, 100));
    protected static ScaledResolution scaledResolution;
    public static int slotID;
    public static Tessellator tessellator;
    public static BufferBuilder bufferbuilder;
    public static Minecraft mc;

    public GuiDisplayMeasurements(String name) {
        super(name, 0, 0, 100, 100);
    }

    protected void renderContent(GuiRenderHelper helper, Style style, int width, int height) {
        EntityPlayerSP player = GuiDisplayMeasurements.mc.field_71439_g;
        scaledResolution = new ScaledResolution(mc);
        this.posX = 0;
        this.posY = 0;
        ItemStack stack = TapeRenderer.tapemeasure;
        if (!stack.func_190926_b() && stack.func_77942_o() && !Minecraft.func_71410_x().field_71474_y.field_74330_P) {
            GuiOverlayTextList textList = new GuiOverlayTextList("measurement", 0, 90, 140, this.getParent());
            textList.setStyle(transparentStyle);
            NBTTagCompound stackNBT = stack.func_77978_p();
            if (stackNBT.func_74764_b("measurements")) {
                NBTTagCompound measurements = (NBTTagCompound)stackNBT.func_74781_a("measurements");
                for (String key : measurements.func_150296_c()) {
                    NBTTagCompound measurement = (NBTTagCompound)measurements.func_74781_a(key);
                    int index = Integer.parseInt(key);
                    Color color = ColorUtils.IntToRGBA((int)measurement.func_74762_e("color"));
                    MeasurementShape shape = null;
                    if (TapeRenderer.cachedMeasurements.containsKey(index)) {
                        shape = TapeRenderer.cachedMeasurements.get(index);
                    }
                    String title = "Measurment " + (index + 1);
                    if (index == stackNBT.func_74762_e("index")) {
                        title = TextFormatting.UNDERLINE + title;
                    }
                    textList.addText(title, -1);
                }
            }
            GlStateManager.func_179094_E();
            GlStateManager.func_179129_p();
            GlStateManager.func_179152_a((float)0.9f, (float)0.9f, (float)0.0f);
            GL11.glEnable((int)3042);
            GL11.glFlush();
            GlStateManager.func_179089_o();
            textList.renderControl(helper, 0.0f, this.getRect());
            GlStateManager.func_179121_F();
        }
    }

    public static AxisAlignedBB getBox(Vec3d playerPos, Vec3d playerLookVector, List<AxisAlignedBB> boxes, double maxDistance) {
        AxisAlignedBB result = null;
        AxisAlignedBB box = null;
        Vec3d startPos = null;
        Vec3d endPos = null;
        double distance = 0.0;
        double z3 = 0.0;
        int m = boxes.size();
        for (int i = 0; i < m; ++i) {
            box = boxes.get(i);
            endPos = playerPos.func_72441_c(playerLookVector.field_72450_a * maxDistance, playerLookVector.field_72448_b * maxDistance, playerLookVector.field_72449_c * maxDistance);
            endPos = new Vec3d(endPos.field_72450_a, endPos.field_72448_b, endPos.field_72449_c);
            startPos = new Vec3d(playerPos.field_72450_a, playerPos.field_72448_b, playerPos.field_72449_c);
            distance = startPos.func_72438_d(endPos);
        }
        for (double j = 0.0; j < distance; j += 0.25) {
            double x3 = startPos.field_72450_a + j / distance * (endPos.field_72450_a - startPos.field_72450_a);
            double y3 = startPos.field_72448_b + j / distance * (endPos.field_72448_b - startPos.field_72448_b);
            z3 = startPos.field_72449_c + j / distance * (endPos.field_72449_c - startPos.field_72449_c);
            Vec3d pointPos = GuiDisplayMeasurements.getAccurateVec(x3, y3, z3);
            if (!GuiDisplayMeasurements.contains(box, pointPos)) continue;
            result = box;
            break;
        }
        return result;
    }

    public static Vec3d getAccurateVec(double x, double y, double z) {
        LittleGridContext context = LittleGridContext.get((int)4);
        x = context.toGridAccurate(x);
        y = context.toGridAccurate(y);
        z = context.toGridAccurate(z);
        BlockPos pos = new BlockPos((int)Math.floor(context.toVanillaGrid(x)), (int)Math.floor(context.toVanillaGrid(y)), (int)Math.floor(context.toVanillaGrid(z)));
        LittleVecContext contextVec = new LittleVecContext(new LittleVec((int)(x - (double)context.toGridAccurate((double)pos.func_177958_n())), (int)(y - (double)context.toGridAccurate((double)pos.func_177956_o())), (int)(z - (double)context.toGridAccurate((double)pos.func_177952_p()))), context);
        return new Vec3d((double)pos.func_177958_n() + contextVec.getPosX(), (double)pos.func_177956_o() + contextVec.getPosY(), (double)pos.func_177952_p() + contextVec.getPosZ());
    }

    public static boolean contains(AxisAlignedBB box, Vec3d vec) {
        if (vec.field_72450_a >= box.field_72340_a && vec.field_72450_a <= box.field_72336_d) {
            if (vec.field_72448_b >= box.field_72338_b && vec.field_72448_b <= box.field_72337_e) {
                return vec.field_72449_c >= box.field_72339_c && vec.field_72449_c <= box.field_72334_f;
            }
            return false;
        }
        return false;
    }

    static {
        slotID = -1;
        tessellator = Tessellator.func_178181_a();
        bufferbuilder = tessellator.func_178180_c();
        mc = Minecraft.func_71410_x();
    }
}

