/*
 * Decompiled with CFR 0.152.
 */
package com.alet.client.gui.controls.tutorial;

import com.alet.client.gui.controls.GuiColorablePanel;
import com.alet.client.gui.controls.tutorial.GuiControlHighlighter;
import com.alet.client.gui.controls.tutorial.TutorialData;
import com.creativemd.creativecore.common.gui.GuiControl;
import com.creativemd.creativecore.common.gui.GuiRenderHelper;
import com.creativemd.creativecore.common.gui.client.style.ColoredDisplayStyle;
import com.creativemd.creativecore.common.gui.client.style.DisplayStyle;
import com.creativemd.creativecore.common.gui.client.style.Style;
import com.creativemd.creativecore.common.gui.container.GuiParent;
import com.creativemd.creativecore.common.gui.container.SubGui;
import com.creativemd.creativecore.common.gui.controls.gui.GuiButton;
import com.creativemd.creativecore.common.gui.controls.gui.GuiLabel;
import com.creativemd.creativecore.common.gui.controls.gui.GuiTextBox;
import com.creativemd.creativecore.common.gui.controls.gui.GuiTextfield;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.text.TextFormatting;
import org.lwjgl.util.Color;

public class GuiTutorialBox
extends GuiParent {
    public static Style helpStyle = new Style("panel", (DisplayStyle)new ColoredDisplayStyle(0, 0, 0), (DisplayStyle)new ColoredDisplayStyle(0, 65, 148), (DisplayStyle)new ColoredDisplayStyle(0, 45, 128), (DisplayStyle)new ColoredDisplayStyle(198, 198, 198), (DisplayStyle)new ColoredDisplayStyle(0, 0, 0, 100));
    public static Style backgroundStyle = new Style("panel", (DisplayStyle)new ColoredDisplayStyle(0, 0, 0), (DisplayStyle)new ColoredDisplayStyle(89, 89, 89), (DisplayStyle)new ColoredDisplayStyle(100, 100, 100), (DisplayStyle)new ColoredDisplayStyle(198, 198, 198), (DisplayStyle)new ColoredDisplayStyle(0, 0, 0, 100));
    public static Style panelStyle = new Style("panel", (DisplayStyle)new ColoredDisplayStyle(0, 0, 0), (DisplayStyle)new ColoredDisplayStyle(198, 198, 198), (DisplayStyle)new ColoredDisplayStyle(100, 100, 100), (DisplayStyle)new ColoredDisplayStyle(198, 198, 198), (DisplayStyle)new ColoredDisplayStyle(0, 0, 0, 100));
    public int boxPosX;
    public int boxPosY;
    public int guiWidth;
    public int guiHeight;
    public int index = 0;
    public boolean closed = true;
    public List<TutorialData> tutorialMap = new ArrayList<TutorialData>();
    public GuiTutorialBox instance;

    public GuiTutorialBox(String name, int x, int y, int height, int guiWidth, int guiHeight) {
        super(name, -110, -3, 100, height);
        this.boxPosX = x;
        this.boxPosY = y;
        this.guiWidth = guiWidth;
        this.guiHeight = guiHeight;
        this.setStyle(backgroundStyle);
        this.instance = this;
        TutorialData.setGuiDimensions(guiWidth, guiHeight);
        this.closedControls();
    }

    protected void renderContent(GuiRenderHelper helper, Style style, int width, int height) {
    }

    public void updateControls() {
        if (this.closed) {
            this.removeControl(this.get("close"));
            this.removeControl(this.get("back"));
            this.removeControl(this.get("next"));
            this.removeControl(this.get("highlight"));
            this.removeControl(this.get("textBox"));
            this.removeControl(this.get("maxPages"));
            this.removeControl(this.get("page"));
            this.removeControl(this.get("pageBackground"));
            this.posX = -110;
            this.posY = -3;
            this.index = 0;
            this.closedControls();
        } else {
            this.removeControl(this.get("open"));
            this.openedControls();
        }
    }

    public void closedControls() {
        this.addControl((GuiControl)new GuiButton("open", TextFormatting.BOLD + "?", this.width - 21, -this.boxPosY - 3, 12, 10){

            public void onClicked(int x, int y, int button) {
                GuiTutorialBox.this.instance.closed = false;
                GuiTutorialBox.this.instance.updateControls();
            }

            public boolean canOverlap() {
                return true;
            }
        });
        GuiButton openButton = (GuiButton)this.get("open");
        openButton.setStyle(helpStyle);
        openButton.color = -1;
    }

    public void openedControls() {
        this.addControl((GuiControl)new GuiButton("close", TextFormatting.DARK_GRAY + "" + TextFormatting.BOLD + "X", this.width - 24, 0, 12, 10){

            public void onClicked(int x, int y, int button) {
                GuiTutorialBox.this.instance.closed = true;
                GuiTutorialBox.this.instance.updateControls();
            }
        });
        this.addControl((GuiControl)new GuiTextBox("textBox", "Hello, How are you today?", 0, 15, 94){

            public boolean hasBackground() {
                return false;
            }

            public boolean hasBorder() {
                return false;
            }
        });
        this.addControl((GuiControl)new GuiButton("next", TextFormatting.DARK_GRAY + "" + TextFormatting.BOLD + ">", this.width - 23, this.height - 22, 11, 10){

            public void onClicked(int x, int y, int button) {
                System.out.println(GuiTutorialBox.this.index);
                if (GuiTutorialBox.this.index < GuiTutorialBox.this.tutorialMap.size() - 1) {
                    ++GuiTutorialBox.this.index;
                    GuiTutorialBox.this.updateHighlightedControl();
                } else {
                    GuiTextBox textBox = (GuiTextBox)GuiTutorialBox.this.instance.get("textBox");
                    textBox.text = "This completes the instructions. Please click close or back to view something you want to look over again. You can click on the question mark again after closing.";
                    GuiTutorialBox.this.instance.removeControl(GuiTutorialBox.this.instance.get("highlight"));
                }
            }
        });
        this.addControl((GuiControl)new GuiButton("back", TextFormatting.DARK_GRAY + "" + TextFormatting.BOLD + "<", 0, this.height - 22, 11, 10){

            public void onClicked(int x, int y, int button) {
                System.out.println(GuiTutorialBox.this.index);
                if (!GuiTutorialBox.this.instance.has("highlight")) {
                    GuiControlHighlighter highlighter = new GuiControlHighlighter("highlight", null, GuiTutorialBox.this.instance.boxPosX, GuiTutorialBox.this.instance.boxPosY);
                    GuiTutorialBox.this.addControl(highlighter);
                    GuiTutorialBox.this.updateHighlightedControl();
                    return;
                }
                if (GuiTutorialBox.this.index > 0) {
                    --GuiTutorialBox.this.index;
                    GuiTutorialBox.this.updateHighlightedControl();
                }
            }
        });
        this.addControl((GuiControl)new GuiLabel("maxPages", TextFormatting.DARK_GRAY + "" + TextFormatting.BOLD + "/" + this.tutorialMap.size(), 50, this.height - 21));
        this.addControl((GuiControl)new GuiTextfield("page", "1", 25, this.height - 23, 20, 10){

            public boolean hasBackground() {
                return false;
            }

            public boolean hasBorder() {
                return false;
            }
        });
        this.addControl((GuiControl)new GuiColorablePanel("pageBackground", 23, this.width + 58, 48, 10, new Color(0, 0, 0), new Color(198, 198, 198)));
        GuiControlHighlighter highlighter = new GuiControlHighlighter("highlight", null, this.boxPosX, this.boxPosY);
        this.addControl(highlighter);
        this.updateHighlightedControl();
        this.get("next").setStyle(panelStyle);
        this.get("close").setStyle(panelStyle);
        this.get("back").setStyle(panelStyle);
    }

    public void updateHighlightedControl() {
        GuiControlHighlighter highlight = (GuiControlHighlighter)this.get("highlight");
        ((GuiTextfield)this.get((String)"page")).text = TextFormatting.DARK_GRAY + "" + TextFormatting.BOLD + (this.index + 1) + "";
        TutorialData data = this.tutorialMap.get(this.index);
        GuiTextBox textBox = (GuiTextBox)this.getGui().get("textBox");
        textBox.text = data.tutorial;
        data.setPos(this.posX, this.posY);
        this.posX = data.tutBoxPosX;
        highlight.setControl(this.getGui().get(data.control.name));
        highlight.posX = -10 - this.posX + highlight.control.posX;
        highlight.posY = -10 - this.posY + highlight.control.posY + data.y;
        if (data.control.getParent() instanceof GuiParent && !(data.control.getParent() instanceof SubGui)) {
            highlight.posX += data.control.getParent().posX + 2;
            highlight.posY += data.control.getParent().posY + 2;
        }
    }

    public boolean hasBackground() {
        return !this.closed;
    }

    public boolean hasBorder() {
        return !this.closed;
    }

    public boolean canOverlap() {
        return true;
    }

    public boolean hasMouseOverEffect() {
        return false;
    }
}

