/*
 * Decompiled with CFR 0.152.
 */
package com.alet.client.gui.controls.programmable.nodes;

import com.alet.client.gui.controls.programmable.functions.GuiFunction;
import com.alet.client.gui.event.GuiControlReleaseEvent;
import com.alet.common.structure.type.programable.advanced.nodes.Node;
import com.alet.common.structure.type.programable.advanced.nodes.NodeRegistar;
import com.creativemd.creativecore.common.gui.GuiControl;
import com.creativemd.creativecore.common.gui.GuiRenderHelper;
import com.creativemd.creativecore.common.gui.client.style.Style;
import com.creativemd.creativecore.common.gui.container.GuiParent;
import com.creativemd.creativecore.common.gui.event.ControlEvent;
import com.creativemd.creativecore.common.gui.event.gui.GuiControlClickEvent;
import java.util.ArrayList;
import java.util.List;

public class GuiNodeValue<V>
extends GuiParent {
    public final String TITLE;
    public final int COLOR;
    public boolean selected = false;
    public GuiNodeValue senderConnection;
    public List<GuiNodeValue> receiverConnections = new ArrayList<GuiNodeValue>();
    public final boolean IS_MODIFIABLE;
    private boolean isSender;
    V v;

    public GuiNodeValue(String name, Node.NodeType type, String title, int color, boolean isModifiable) throws Exception {
        super(name, 0, 0, !title.equals("") ? font.func_78256_a(title) + 7 : 1, 1);
        this.TITLE = title;
        this.IS_MODIFIABLE = isModifiable;
        this.COLOR = color;
    }

    public void setValue(V v) {
    }

    public boolean isSender() {
        return this.isSender;
    }

    public boolean isReciever() {
        return !this.isSender;
    }

    public GuiNodeValue setSender(boolean isSender) {
        this.isSender = isSender;
        return this;
    }

    public GuiFunction getBlueprint() {
        return (GuiFunction)this.parent;
    }

    public void createControls(List<GuiControl> controls) {
        this.parent.getControls().add(controls);
        this.parent.refreshControls();
    }

    public void mouseReleased(int x, int y, int button) {
        this.raiseEvent((ControlEvent)new GuiControlReleaseEvent((GuiControl)this, x, y, button));
    }

    public boolean canConnect(GuiNodeValue secondNode) {
        if (secondNode == null) {
            return false;
        }
        System.out.println(this.isSender() + " " + secondNode.isReciever());
        if (this.getParent().equals(secondNode.parent)) {
            return false;
        }
        if (this.isSender() && secondNode.isSender()) {
            return false;
        }
        if (this.isReciever() && secondNode.isReciever()) {
            return false;
        }
        if (this.alreadyConnectedTo(secondNode)) {
            return false;
        }
        if (!this.isDataTypeEqual(secondNode)) {
            return false;
        }
        if (this.isConnected() && NodeRegistar.matchType("function", this)) {
            return false;
        }
        if (secondNode.isConnected() && NodeRegistar.matchType("function", secondNode)) {
            return false;
        }
        if (this.isReciever() && this.isConnected()) {
            return false;
        }
        return !secondNode.isReciever() || !secondNode.isConnected();
    }

    public void connect(GuiNodeValue secondNode) {
        if (secondNode.isReciever()) {
            secondNode.senderConnection = this;
            this.receiverConnections.add(secondNode);
        }
    }

    public boolean isConnected() {
        return !this.receiverConnections.isEmpty() || this.senderConnection != null;
    }

    public boolean alreadyConnectedTo(GuiNodeValue secondNode) {
        if (this.senderConnection == secondNode) {
            return true;
        }
        for (GuiNodeValue node : this.receiverConnections) {
            if (!((Object)((Object)node)).equals((Object)secondNode)) continue;
            return true;
        }
        return false;
    }

    protected void renderBackground(GuiRenderHelper helper, Style style) {
        super.renderBackground(helper, style);
        int xOffSet = 0;
        if (this.isSender) {
            font.func_175063_a(this.TITLE, (float)(this.width - font.func_78256_a(this.TITLE) - 11), -1.0f, -1);
            xOffSet = this.width - 7;
        } else if (this.isReciever()) {
            font.func_175063_a(this.TITLE, 8.0f, -1.0f, -1);
            xOffSet = 0;
        }
        helper.drawRect((double)(-1 + xOffSet), -1.0, (double)(6 + xOffSet), 6.0, this.COLOR);
        if (!this.isConnected()) {
            helper.drawRect((double)(0 + xOffSet), 0.0, (double)(5 + xOffSet), 5.0, -10855846);
        }
        if (this.selected) {
            helper.drawRect((double)(0 + xOffSet), 0.0, (double)(5 + xOffSet), 5.0, -16777216);
        }
    }

    public boolean mousePressed(int x, int y, int button) {
        boolean results = super.mousePressed(x, y, button);
        GuiFunction blueprint = (GuiFunction)this.topControl(this.getParent().getParent().getControls(), GuiFunction.class);
        GuiNodeValue node = (GuiNodeValue)this.topControl(blueprint.getControls(), ((Object)((Object)this)).getClass());
        if (node == this) {
            this.raiseEvent((ControlEvent)new GuiControlClickEvent((GuiControl)this, x, y, button));
        }
        return results;
    }

    public GuiControl topControl(List<GuiControl> controls, Class<? extends GuiControl> search) {
        for (GuiControl control : controls) {
            if (!search.isAssignableFrom(control.getClass()) || !control.isMouseOver()) continue;
            return control;
        }
        return null;
    }

    public boolean hasBorder() {
        return false;
    }

    public boolean hasBackground() {
        return false;
    }

    public boolean isDataTypeEqual(GuiNodeValue secondNode) {
        return this.name.equals(secondNode.name);
    }

    public GuiNodeValue clone(String name, String title, boolean isModifiable) {
        try {
            return new GuiNodeValue<V>(name, null, title, this.COLOR, isModifiable);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

