/*
 * Decompiled with CFR 0.152.
 */
package com.alet.client.gui.controls.programmable.functions;

import com.alet.client.gui.controls.GuiDragablePanel;
import com.alet.client.gui.controls.programmable.nodes.GuiNodeValue;
import com.alet.client.gui.event.GuiControlReleaseEvent;
import com.alet.common.structure.type.programable.advanced.FunctionRegistar;
import com.alet.common.structure.type.programable.advanced.nodes.NodeRegistar;
import com.alet.common.utils.MouseUtils;
import com.creativemd.creativecore.common.gui.GuiControl;
import com.creativemd.creativecore.common.gui.GuiRenderHelper;
import com.creativemd.creativecore.common.gui.client.style.Style;
import com.creativemd.creativecore.common.gui.container.GuiParent;
import com.creativemd.creativecore.common.gui.event.ControlEvent;
import com.creativemd.creativecore.common.gui.event.gui.GuiControlClickEvent;
import com.creativemd.creativecore.common.utils.type.Pair;
import com.creativemd.creativecore.common.utils.type.PairList;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.WorldServer;

public class GuiFunction
extends GuiParent {
    private int mousePosX = 0;
    private int mousePosY = 0;
    public int color;
    public boolean selected = false;
    public GuiNodeValue selectedNode;
    public final String FUNCTION_TITLE;
    public int id;
    public GuiNodeValue methodSender;
    public GuiNodeValue methodReceiver;
    public List<GuiNodeValue> senderNodes = new ArrayList<GuiNodeValue>();
    public List<GuiNodeValue> receiverNodes = new ArrayList<GuiNodeValue>();
    public final boolean IS_METHOD_SENDER;
    public final boolean IS_METHOD_RECIEVER;

    public GuiFunction(String title, String name, int id, int color, boolean isSender, boolean isReceiver, List<GuiNodeValue> nodes) {
        super(name, 0, 0, 0, 0);
        this.id = id;
        this.color = color;
        this.IS_METHOD_SENDER = isSender;
        this.IS_METHOD_RECIEVER = isReceiver;
        this.setMethodNodes();
        this.organizeNodes(nodes);
        this.FUNCTION_TITLE = title;
        this.createControls();
        this.createMethodControls();
    }

    public GuiFunction(String name, String title, int color, boolean isSender, boolean isReceiver, List<GuiNodeValue> nodes) {
        this(title, name, 0, color, isSender, isReceiver, nodes);
    }

    public GuiFunction getNextBlueprint() {
        if (this.methodSender.receiverConnections != null && !this.methodSender.receiverConnections.isEmpty()) {
            return this.methodSender.receiverConnections.get(0).getBlueprint();
        }
        return null;
    }

    public NBTTagCompound createNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74768_a("id", this.id);
        nbt.func_74768_a("posY", this.posY);
        nbt.func_74768_a("posX", this.posX);
        nbt.func_74778_a("name", this.name);
        return this.serializeNBT(this.createNodeNBT(nbt));
    }

    public GuiFunction clone(int id) {
        return new GuiFunction(this.FUNCTION_TITLE, this.name, id, this.color, this.IS_METHOD_SENDER, this.IS_METHOD_RECIEVER, this.getNodes());
    }

    public NBTTagCompound serializeNBT(NBTTagCompound nbt) {
        return nbt;
    }

    public GuiFunction deserializeNBT(NBTTagCompound nbt) {
        return this;
    }

    public NBTTagCompound createNodeNBT(NBTTagCompound nbt) {
        NBTTagList l = new NBTTagList();
        ArrayList<GuiNodeValue> combined = new ArrayList<GuiNodeValue>();
        combined.addAll(this.receiverNodes);
        if (this.methodReceiver != null) {
            combined.add(this.methodReceiver);
        }
        for (GuiNodeValue node : combined) {
            NBTTagCompound n = new NBTTagCompound();
            n.func_74778_a("node", node.name);
            NBTTagList list = new NBTTagList();
            List<GuiNodeValue> s = node.receiverConnections;
            for (GuiNodeValue receiver : s) {
                NBTTagCompound nb = new NBTTagCompound();
                nb.func_74778_a("node", receiver.name);
                nb.func_74778_a("name", receiver.getParent().name);
                nb.func_74768_a("id", ((GuiFunction)receiver.getParent()).id);
                list.func_74742_a((NBTBase)nb);
            }
            if (node.senderConnection != null) {
                NBTTagCompound nb = new NBTTagCompound();
                nb.func_74778_a("node", node.senderConnection.name);
                nb.func_74778_a("name", node.senderConnection.getParent().name);
                nb.func_74768_a("id", ((GuiFunction)node.senderConnection.getParent()).id);
                list.func_74742_a((NBTBase)nb);
            }
            n.func_74782_a("connections", (NBTBase)list);
            l.func_74742_a((NBTBase)n);
        }
        nbt.func_74782_a("nodes", (NBTBase)l);
        return nbt;
    }

    public static GuiFunction createFunctionFrom(String name, int id) {
        GuiFunction obj = FunctionRegistar.createFunctionGui(name, true, id);
        return obj;
    }

    public static NBTTagList getNodeNBTList(NBTTagCompound nbt) {
        return nbt.func_150295_c("nodes", 10);
    }

    public static PairList<GuiFunction, GuiNodeValue> getFunctionFromNodeNBT(List<GuiFunction> blueprints, NBTTagCompound node) {
        NBTTagList list = node.func_150295_c("connections", 10);
        PairList bpList = new PairList();
        for (NBTBase d : list) {
            if (!(d instanceof NBTTagCompound)) continue;
            NBTTagCompound nbt = (NBTTagCompound)d;
            GuiFunction bp = blueprints.stream().filter(x -> x.name.equals(nbt.func_74779_i("name")) && x.id == nbt.func_74762_e("id")).findFirst().get();
            bpList.add(new Pair((Object)bp, (Object)((GuiNodeValue)bp.get(nbt.func_74779_i("node")))));
        }
        return bpList;
    }

    public static GuiFunction getFunctionObjectFromNBT(List<GuiFunction> blueprints, NBTTagCompound nbt) {
        String name = nbt.func_74779_i("name");
        int id = nbt.func_74762_e("id");
        return blueprints.stream().filter(x -> x.name.equals(name) && x.id == id).findFirst().get();
    }

    public List<GuiNodeValue> getNodes() {
        ArrayList<GuiNodeValue> nodes = new ArrayList<GuiNodeValue>();
        nodes.addAll(this.receiverNodes);
        nodes.addAll(this.senderNodes);
        return nodes;
    }

    public GuiNodeValue getNode(String name) {
        Optional<GuiNodeValue> node = this.getNodes().stream().filter(x -> x.name.equals(name)).findFirst();
        if (node.isPresent()) {
            return node.get();
        }
        return null;
    }

    public void organizeNodes(List<GuiNodeValue> nodes) {
        if (!nodes.isEmpty() && nodes != null) {
            for (GuiNodeValue node : nodes) {
                if (node.isSender()) {
                    this.senderNodes.add(node);
                    continue;
                }
                if (!node.isReciever()) continue;
                this.receiverNodes.add(node);
            }
        }
    }

    public void setMethodNodes() {
        try {
            if (this.IS_METHOD_RECIEVER) {
                this.methodReceiver = NodeRegistar.createNode("function", "method_receiver", "", false).setSender(false);
            }
            if (this.IS_METHOD_SENDER) {
                this.methodSender = NodeRegistar.createNode("function", "method_sender", "", false).setSender(true);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Entity getEntity(WorldServer world, UUID uuid) {
        return world.func_175733_a(uuid);
    }

    private void createMethodControls() {
        if (this.IS_METHOD_RECIEVER && this.IS_METHOD_SENDER) {
            this.addControl((GuiControl)this.methodSender);
            this.methodSender.posX = this.width - this.methodReceiver.width - 6;
            this.addControl((GuiControl)this.methodReceiver);
        } else if (this.IS_METHOD_RECIEVER) {
            this.addControl((GuiControl)this.methodReceiver);
        } else if (this.IS_METHOD_SENDER) {
            this.methodSender.posX = this.width - 13;
            this.addControl((GuiControl)this.methodSender);
        }
    }

    private void createControls() {
        GuiNodeValue n;
        GuiNodeValue node2;
        int i;
        int maxSpacing = 0;
        int maxWidth = font.func_78256_a(this.FUNCTION_TITLE) + 14;
        int maxHeight = 14;
        int y = 15;
        boolean hasModifiable = false;
        for (i = 0; i < this.receiverNodes.size(); ++i) {
            node2 = this.receiverNodes.get(i);
            maxSpacing = Math.max(maxSpacing, font.func_78256_a(node2.TITLE)) + 20;
            if (node2.IS_MODIFIABLE) {
                hasModifiable = true;
            }
            if (i > 0) {
                n = this.receiverNodes.get(i - 1);
                node2.posY = n.posY + 15;
                if (n.IS_MODIFIABLE) {
                    node2.posY = i * y + 30;
                }
            } else if (node2.IS_MODIFIABLE && this.receiverNodes.size() == 1 && this.senderNodes.size() == 1) {
                maxHeight = 30;
            } else {
                node2.posY = 15;
            }
            maxHeight = Math.max(maxHeight, node2.posY + 15);
            this.addControl((GuiControl)node2);
        }
        for (i = 0; i < this.senderNodes.size(); ++i) {
            node2 = this.senderNodes.get(i);
            maxWidth = Math.max(maxWidth, maxSpacing + font.func_78256_a(node2.TITLE) + 5);
            if (node2.IS_MODIFIABLE) {
                hasModifiable = true;
            }
            if (i > 0) {
                n = this.senderNodes.get(i - 1);
                node2.posY = n.posY + 15;
                if (n.IS_MODIFIABLE) {
                    node2.posY = i * y + 30;
                }
            } else if (!(!node2.IS_MODIFIABLE || this.receiverNodes.size() != 1 && this.receiverNodes.size() != 0 || this.senderNodes.size() != 1 && this.senderNodes.size() != 0)) {
                node2.posY = 15;
                maxHeight = 30;
            } else {
                node2.posY = 15;
            }
            maxHeight = Math.max(maxHeight, node2.posY);
            this.addControl((GuiControl)node2);
        }
        this.width = maxWidth + 14;
        this.height = maxHeight;
        for (GuiNodeValue node2 : this.senderNodes) {
            node2.posX = this.width - node2.width - 6;
        }
    }

    public boolean mousePressed(int x, int y, int button) {
        boolean result = super.mousePressed(x, y, button);
        if (this.controlOver(x, y, button, this.controls) == null) {
            MouseUtils.setCursor("move");
            this.mousePosX = (int)this.getMousePos().field_72450_a;
            this.mousePosY = (int)this.getMousePos().field_72448_b;
            if (this.isMouseOver()) {
                this.selected = true;
                this.raiseEvent((ControlEvent)new GuiControlClickEvent((GuiControl)this, x, y, button));
            }
        }
        return result;
    }

    public void mouseReleased(int x, int y, int button) {
        super.mouseReleased(x, y, button);
        MouseUtils.resetCursor();
        this.raiseEvent((ControlEvent)new GuiControlReleaseEvent((GuiControl)this, x, y, button));
        this.selected = false;
    }

    public void mouseDragged(int x, int y, int button, long time) {
        if (this.selected) {
            this.posX = x - this.mousePosX;
            this.posY = y - this.mousePosY;
            int left = this.posX + 1;
            int top = this.posY + 1;
            int right = this.posX + this.width + 5;
            int bottom = this.posY + this.height + 5;
            int guiWidth = this.getParent().width;
            int guiHeight = this.getParent().height;
            if (this.getParent() instanceof GuiDragablePanel) {
                GuiDragablePanel gui = (GuiDragablePanel)this.getParent();
                guiWidth = gui.maxWidth;
                guiHeight = gui.maxHeight;
            }
            if (left < 0) {
                this.posX = -2;
            }
            if (right > guiWidth) {
                this.posX = guiWidth - this.width - 4;
            }
            if (top < 0) {
                this.posY = -2;
            }
            if (bottom > guiHeight) {
                this.posY = guiHeight - this.height - 4;
            }
        }
    }

    public void nodeClicked(GuiNodeValue node, boolean selected) {
        node.selected = selected;
        this.selectedNode = node.selected ? node : null;
        for (GuiControl control : this.controls) {
            if (!(control instanceof GuiNodeValue) || control.equals((Object)node)) continue;
            GuiNodeValue n = (GuiNodeValue)control;
            n.selected = false;
        }
    }

    public GuiControl controlOver(int x, int y, int button, ArrayList<GuiControl> controls) {
        for (GuiControl control : controls) {
            GuiControl found;
            if (control.isMouseOver()) {
                return control;
            }
            if (!(control instanceof GuiParent) || (found = this.controlOver(x, y, button, ((GuiParent)control).controls)) == null) continue;
            return found;
        }
        return null;
    }

    protected void renderBackground(GuiRenderHelper helper, Style style) {
        super.renderBackground(helper, style);
        helper.drawRect(0.0, 12.0, (double)(this.width - 1), 13.0, -16777216);
        font.func_175065_a(this.FUNCTION_TITLE, (float)(this.width / 2 - font.func_78256_a(this.FUNCTION_TITLE) / 2), 3.0f, this.color, true);
    }
}

