/*
 * Decompiled with CFR 0.152.
 */
package com.alet.client.gui.controls.menu;

import com.alet.client.gui.controls.menu.GuiTree;
import com.alet.client.gui.event.GuiControlDragEvent;
import com.alet.client.gui.event.GuiControlReleaseEvent;
import com.creativemd.creativecore.common.gui.GuiControl;
import com.creativemd.creativecore.common.gui.GuiRenderHelper;
import com.creativemd.creativecore.common.gui.client.style.ColoredDisplayStyle;
import com.creativemd.creativecore.common.gui.client.style.DisplayStyle;
import com.creativemd.creativecore.common.gui.client.style.Style;
import com.creativemd.creativecore.common.gui.controls.gui.GuiTextfield;
import com.creativemd.creativecore.common.gui.event.ControlEvent;
import com.creativemd.creativecore.common.gui.event.gui.GuiControlChangedEvent;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.SoundEvent;

public class GuiTreePart
extends GuiControl {
    public List<GuiTreePart> listOfParts = new ArrayList<GuiTreePart>();
    public List<String> listOfSearchKeywords = new ArrayList<String>();
    GuiTreePart branchHeldIn;
    protected boolean isOpened = false;
    boolean isRoot = false;
    int heldInID;
    public final String CAPTION;
    public String caption;
    public GuiTree tree;
    boolean flag = false;
    public int originPosY;
    public int originPosX;
    public int textColor = -1;
    public boolean mousePressed = false;
    public boolean wasOver = false;
    public boolean counting = false;
    public int tick = 0;
    public int tempPosY;
    public int tempPosX;
    public boolean selected = false;
    public static final Style SELECTED_DISPLAY = new Style("SELECTED", (DisplayStyle)new ColoredDisplayStyle(50, 50, 50), (DisplayStyle)new ColoredDisplayStyle(145, 201, 247), (DisplayStyle)new ColoredDisplayStyle(145, 201, 247), (DisplayStyle)new ColoredDisplayStyle(198, 198, 198), (DisplayStyle)new ColoredDisplayStyle(0, 0, 0, 100));
    public static final Style DISPLAY = new Style("DISPLAY", (DisplayStyle)new ColoredDisplayStyle(240, 240, 240), (DisplayStyle)new ColoredDisplayStyle(240, 240, 240), (DisplayStyle)new ColoredDisplayStyle(145, 201, 247), (DisplayStyle)new ColoredDisplayStyle(198, 198, 198), (DisplayStyle)new ColoredDisplayStyle(0, 0, 0, 100));
    public EnumPartType type;

    public GuiTreePart(GuiTreePart part) {
        this(part, part.type);
        this.posX = part.posX;
        this.posY = part.posY;
        this.originPosX = part.originPosX;
        this.originPosY = part.originPosY;
        this.tempPosX = part.tempPosX;
        this.tempPosY = part.tempPosY;
        this.tree = part.tree;
    }

    public GuiTreePart(GuiTreePart part, EnumPartType type) {
        this("", part.caption, type);
        this.heldInID = part.heldInID;
        this.name = part.name;
        this.posX = part.posX;
        this.posY = part.posY;
        this.originPosX = part.originPosX;
        this.originPosY = part.originPosY;
        this.tempPosX = part.tempPosX;
        this.tempPosY = part.tempPosY;
        this.tree = part.tree;
    }

    public GuiTreePart(String name, String caption, EnumPartType type) {
        super(name, 0, 0, GuiRenderHelper.instance.getStringWidth(caption), 8);
        this.caption = caption;
        this.CAPTION = caption;
        this.type = type;
    }

    public GuiTreePart(String name, int textColor, String caption, EnumPartType type) {
        super(name, 0, 0, GuiRenderHelper.instance.getStringWidth(caption), 8);
        this.caption = caption;
        this.CAPTION = caption;
        this.type = type;
        this.textColor = textColor;
    }

    public GuiTreePart(String caption, int textColor, EnumPartType type) {
        this("", textColor, caption, type);
    }

    public GuiTreePart(String caption, EnumPartType type) {
        this("", caption, type);
    }

    public GuiTreePart addMenu(GuiTreePart button) {
        this.listOfParts.add(button);
        button.branchHeldIn = this;
        return this;
    }

    public GuiTreePart getBranchThisIsIn() {
        GuiTreePart part = this.tree.listOfParts.get(this.getBranchIDThisIsIn());
        if (((Object)((Object)part)).equals((Object)this)) {
            return null;
        }
        return part;
    }

    protected void renderContent(GuiRenderHelper helper, Style style, int width, int height) {
        if (this.isOpened) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)0.0f, (float)3.0f, (float)0.0f);
            helper.drawRect(2.0, 0.0, 3.0, (double)(this.getTotalOpenedBranchSize() * 14 + 2), -1);
            GlStateManager.func_179121_F();
        }
        int off = this.posY - this.originPosY;
        int count = (int)Math.floor((double)off / 14.0);
        int y = off - count * 14;
        if (!this.type.canHold()) {
            helper.drawRect(-12.0, (double)(y + 4), -4.0, (double)(y + 5), -1);
        } else {
            helper.drawRect(-12.0, (double)(y + 4), -4.0, (double)(y + 5), -1);
            helper.drawRect(-1.0, (double)y, 7.0, (double)(y + 8), -1);
            if (!this.type.equals((Object)EnumPartType.Title)) {
                if (!this.isOpened) {
                    GlStateManager.func_179094_E();
                    GlStateManager.func_179137_b((double)0.4, (double)0.0, (double)0.0);
                    helper.drawRect(2.0, (double)(y + 1), 3.0, (double)(y + 7), -16777216);
                    GlStateManager.func_179121_F();
                    GlStateManager.func_179094_E();
                    GlStateManager.func_179137_b((double)0.0, (double)0.4, (double)0.0);
                    helper.drawRect(0.0, (double)(y + 3), 6.0, (double)(y + 4), -16777216);
                    GlStateManager.func_179121_F();
                } else {
                    GlStateManager.func_179094_E();
                    GlStateManager.func_179137_b((double)0.0, (double)0.4, (double)0.0);
                    helper.drawRect(0.0, (double)(y + 3), 6.0, (double)(y + 4), -16777216);
                    GlStateManager.func_179121_F();
                }
            }
        }
        GlStateManager.func_179094_E();
        if (this.type.equals((Object)EnumPartType.Title)) {
            GlStateManager.func_179109_b((float)10.0f, (float)0.0f, (float)0.0f);
        }
        if (this.type.openable) {
            GlStateManager.func_179109_b((float)10.0f, (float)0.0f, (float)0.0f);
        }
        helper.drawStringWithShadow(this.caption, 0, 0, GuiRenderHelper.instance.getStringWidth(this.caption), height, this.textColor);
        GlStateManager.func_179121_F();
    }

    public void setSearchKeywords(String ... keyword) {
        for (int i = 0; i < keyword.length; ++i) {
            this.listOfSearchKeywords.add(keyword[i]);
        }
    }

    public GuiTreePart previousPart() {
        int id = this.getPartID() - 1;
        if (id <= 0) {
            return null;
        }
        return this.tree.listOfParts.get(id);
    }

    public GuiTreePart nextPart() {
        int id = this.getPartID() + 1;
        if (id >= this.tree.numberOfAllParts()) {
            return null;
        }
        return this.tree.listOfParts.get(id);
    }

    public GuiTreePart nextBranch() {
        GuiTreePart part = this;
        do {
            if (!part.isBranch()) continue;
            return part;
        } while ((part = part.nextPart()) != null);
        return null;
    }

    public GuiTreePart previousBranch() {
        GuiTreePart part = this;
        do {
            if (!part.isBranch() || ((Object)((Object)part)).equals((Object)this)) continue;
            return part;
        } while ((part = part.previousPart()) != null);
        return null;
    }

    public boolean isInView() {
        return this.tree.has(this.name);
    }

    public int getPartID() {
        return Integer.parseInt(this.name);
    }

    public boolean isBranch() {
        return this.listOfParts != null && !this.listOfParts.isEmpty();
    }

    public int getBranchIDThisIsIn() {
        return this.heldInID;
    }

    public boolean isRoot() {
        return this.isRoot;
    }

    public int getRootIDThisIsIn() {
        if (!this.isRoot) {
            for (int i = this.getPartID(); i >= 0; --i) {
                if (!this.tree.listOfParts.get((int)i).isRoot) continue;
                return this.tree.listOfParts.get(i).getPartID();
            }
        } else {
            return -1;
        }
        return -2;
    }

    public int getBranchSize() {
        if (this.isBranch()) {
            return this.listOfParts.size();
        }
        return 0;
    }

    public int getTotalBranchSize() {
        int total = 0;
        int start = this.getPartID() + 1;
        if (start < this.tree.listOfParts.size()) {
            for (int i = start; i < this.tree.numberOfAllParts(); ++i) {
                GuiTreePart part1 = this.tree.listOfParts.get(i);
                if (!this.isInSameBranch(part1)) continue;
                ++total;
            }
        }
        return total;
    }

    public int getTotalOpenedBranchSize() {
        int total = 0;
        for (GuiTreePart part : this.getListOfPartsUp()) {
            if (!part.isInView()) continue;
            ++total;
        }
        return total;
    }

    public List<GuiTreePart> getListOfPartsToMove() {
        ArrayList<GuiTreePart> list = new ArrayList<GuiTreePart>();
        int start = this.getBranchSize() + Integer.parseInt(this.name) - 1;
        int end = this.tree.listOfParts.size();
        for (int i = start; i < end; ++i) {
            GuiTreePart checkPart = this.tree.listOfParts.get(i);
            if (this.isInSameBranch(checkPart)) continue;
            list.add(checkPart);
        }
        return list;
    }

    public List<GuiTreePart> getListOfPartsUp() {
        ArrayList<GuiTreePart> list = new ArrayList<GuiTreePart>();
        int start = this.getPartID() + 1;
        int end = start + this.getTotalBranchSize();
        for (int i = start; i < end; ++i) {
            GuiTreePart checkPart = this.tree.listOfParts.get(i);
            list.add(checkPart);
        }
        return list;
    }

    public List<GuiTreePart> getListOfPartsDown() {
        ArrayList<GuiTreePart> list = new ArrayList<GuiTreePart>();
        int start = this.getPartID();
        int end = this.getRootIDThisIsIn();
        for (int i = start; i > end; --i) {
            GuiTreePart checkPart = this.tree.listOfParts.get(i);
            list.add(checkPart);
        }
        return list;
    }

    public List<GuiTreePart> getListOfBranchesUp() {
        ArrayList<GuiTreePart> list = new ArrayList<GuiTreePart>();
        int start = this.getPartID() + 1;
        int end = start + this.getTotalBranchSize();
        for (int i = start; i < end; ++i) {
            GuiTreePart checkPart = this.tree.listOfParts.get(i);
            if (!checkPart.isBranch()) continue;
            list.add(checkPart);
        }
        return list;
    }

    public List<GuiTreePart> getListOfBranchesDown() {
        ArrayList<GuiTreePart> list = new ArrayList<GuiTreePart>();
        GuiTreePart branch = this;
        while (branch.branchHeldIn != null) {
            branch = branch.branchHeldIn;
            list.add(branch);
        }
        return list;
    }

    public boolean isInSameBranch(GuiTreePart part) {
        int partBranchID2;
        int partBranchID;
        GuiTreePart previousPart = part;
        GuiTreePart comparePart = this;
        if (comparePart.isBranch()) {
            comparePart = comparePart.nextPart();
        }
        if ((partBranchID = comparePart.getBranchIDThisIsIn()) == (partBranchID2 = part.getBranchIDThisIsIn())) {
            return true;
        }
        if (((Object)((Object)part)).equals((Object)this)) {
            return true;
        }
        while (previousPart != null) {
            if (previousPart.isRoot()) {
                return false;
            }
            int previousPartBrandID = previousPart.getBranchIDThisIsIn();
            if (partBranchID == previousPartBrandID) {
                return true;
            }
            if (partBranchID > previousPartBrandID) {
                return false;
            }
            previousPart = previousPart.previousPart();
        }
        return false;
    }

    public boolean isBranchHiddenAndOpened() {
        return !this.isInView() && this.isOpened;
    }

    public boolean isBranchHiddenAndClosed() {
        return !this.isInView() && !this.isOpened;
    }

    public void onClicked(int x, int y, int mouseButton) {
        int xPos = x - this.posX;
        int yPos = y - this.posY;
        if (xPos >= 2 && xPos <= 10 && yPos >= 3 && yPos <= 10 && this.listOfParts != null && !this.listOfParts.isEmpty() && this.type.isOpenable()) {
            if (!this.isOpened) {
                this.isOpened = true;
                this.openMenus();
            } else {
                this.isOpened = false;
                this.closeMenus();
            }
            this.tree.updatePartsPosition();
        }
        this.tree.highlightPart(this);
        this.raiseEvent((ControlEvent)new GuiControlChangedEvent((GuiControl)this));
    }

    public void setOpened(boolean opened) {
        this.isOpened = opened;
    }

    public boolean isOpened() {
        return this.isOpened;
    }

    public void openMenus() {
        for (int i = 0; i < this.listOfParts.size(); ++i) {
            GuiTreePart button = this.listOfParts.get(i);
            button.width = !button.type.openable ? GuiRenderHelper.instance.getStringWidth(button.caption) + 5 : GuiRenderHelper.instance.getStringWidth(button.caption) + 15;
            if (button.isRoot) continue;
            this.tree.addControl(button);
            if (!button.isBranch() || !button.isOpened) continue;
            button.openMenus();
        }
    }

    public void closeMenus() {
        List controls = this.tree.getControls();
        for (GuiTreePart button : this.listOfParts) {
            if (button.isBranch()) {
                button.closeMenus();
            }
            controls.remove((Object)button);
        }
    }

    public void onDoubleClick() {
        if (this.type.equals((Object)EnumPartType.Searched)) {
            this.tree.wipePartControls();
            this.tree.createRootControls();
            this.tree.openTitles();
            this.tree.openTo(this);
            ((GuiTextfield)this.tree.get((String)"search")).text = "";
            ((GuiTextfield)this.tree.get((String)"search")).cursorPosition = 0;
        }
        if (this.listOfParts != null && !this.listOfParts.isEmpty() && this.type.isOpenable()) {
            if (!this.isOpened) {
                this.isOpened = true;
                this.openMenus();
            } else {
                this.isOpened = false;
                this.closeMenus();
            }
            this.tree.updatePartsPosition();
        }
        this.tree.highlightPart(this);
        this.raiseEvent((ControlEvent)new GuiControlChangedEvent((GuiControl)this));
    }

    public void mouseDragged(int x, int y, int button, long time) {
        super.mouseDragged(x, y, button, time);
        if (this.selected && this.wasOver && !this.type.canHold()) {
            this.raiseEvent((ControlEvent)new GuiControlDragEvent(this, x, y, button));
        }
    }

    public boolean isMouseOver(int posX, int posY) {
        boolean result = super.isMouseOver(posX, posY);
        if (result) {
            if (this.mousePressed && !this.counting) {
                this.mousePressed = false;
                this.counting = true;
            }
            if (this.counting) {
                ++this.tick;
            }
            if (this.tick > 80) {
                this.tick = 0;
                this.counting = false;
            }
            int xPos = posX - this.posX;
            int yPos = posY - this.posY;
            if (this.counting && this.mousePressed && (xPos < 2 || xPos > 10 || yPos < 2 || yPos > 10)) {
                this.onDoubleClick();
                this.tick = 0;
                this.counting = false;
                this.mousePressed = false;
            }
        } else {
            this.counting = false;
            this.mousePressed = false;
        }
        return result;
    }

    public void mouseReleased(int x, int y, int button) {
        if (this.wasOver) {
            this.wasOver = false;
            this.raiseEvent((ControlEvent)new GuiControlReleaseEvent(this, x, y, button));
        }
    }

    public boolean mousePressed(int x, int y, int button) {
        GuiTreePart.playSound((SoundEvent)SoundEvents.field_187909_gi);
        this.onClicked(x, y, button);
        this.mousePressed = true;
        this.wasOver = false;
        if (super.isMouseOver(x, y)) {
            this.wasOver = true;
        }
        return true;
    }

    public boolean hasBorder() {
        return false;
    }

    public static enum EnumPartType {
        Root(true, true),
        Branch(true, true),
        Title(false, true),
        Leaf(false, false),
        Searched(false, false);

        private boolean openable;
        private boolean canHold;

        private EnumPartType(boolean openable, boolean canHold) {
            this.openable = openable;
            this.canHold = canHold;
        }

        public boolean isOpenable() {
            return this.openable;
        }

        public boolean canHold() {
            return this.canHold;
        }
    }
}

