/*
 * Decompiled with CFR 0.152.
 */
package com.alet.client.gui.controls.menu;

import com.alet.client.gui.controls.menu.GuiTreePart;
import com.creativemd.creativecore.common.gui.GuiControl;
import com.creativemd.creativecore.common.gui.GuiRenderHelper;
import com.creativemd.creativecore.common.gui.container.GuiParent;
import com.creativemd.creativecore.common.gui.controls.gui.GuiTextfield;
import com.creativemd.creativecore.common.gui.event.ControlEvent;
import com.creativemd.creativecore.common.gui.event.gui.GuiControlClickEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public class GuiTree
extends GuiParent {
    public List<GuiTreePart> listOfRoots;
    public List<GuiTreePart> listOfParts = new ArrayList<GuiTreePart>();
    public List<GuiTreePart> listOfPartsSearched = new ArrayList<GuiTreePart>();
    protected int indexPos = 0;
    public boolean useSearchBar;
    int searchBarX;
    int searchBarY;
    int searchBarWidth;

    public GuiTree(String name, int x, int y, int width, List<GuiTreePart> listOfRoots) {
        super(name, x, y, width, 320);
        this.useSearchBar = false;
        this.searchBarX = 0;
        this.searchBarY = 0;
        this.searchBarWidth = 0;
        this.listOfRoots = listOfRoots;
    }

    public GuiTree(String name, int x, int y, int width, List<GuiTreePart> listOfRoots, boolean useSearchBar, int searchBarX, int searchBarY, int searchBarWidth) {
        super(name, x, y, width, 320);
        this.useSearchBar = useSearchBar;
        this.searchBarX = searchBarX;
        this.searchBarY = searchBarY;
        this.searchBarWidth = searchBarWidth;
        this.listOfRoots = listOfRoots;
        this.createRootControls();
        this.createSearchControls();
        this.allButtons();
        this.openTitles();
        this.height = this.listOfParts.size() * 14 + 25;
    }

    public void addToTree(GuiTreePart part) {
        this.listOfRoots.add(part);
        this.createRootControls();
        this.createSearchControls();
        this.allButtons();
        this.openTitles();
        this.height = this.listOfParts.size() * 14 + 25;
    }

    public void replaceTree(List<GuiTreePart> listOfRoots) {
        this.listOfRoots = listOfRoots;
        this.removeControls(new String[]{""});
        this.createRootControls();
        this.createSearchControls();
        this.allButtons();
        this.openTitles();
        this.height = this.listOfParts.size() * 14 + 25;
    }

    public void createRootControls() {
        for (int i = 0; i < this.listOfRoots.size(); ++i) {
            GuiTreePart root = this.listOfRoots.get(i);
            root.posY = 14 * i + 20;
            root.originPosY = new Integer(root.posY);
            root.width = GuiRenderHelper.instance.getStringWidth(root.caption) + 15;
            this.addControl(root);
        }
    }

    public void createSearchControls() {
        if (this.useSearchBar && !this.has("search")) {
            this.addControl((GuiControl)new GuiTextfield("search", "", this.searchBarX, this.searchBarY, this.searchBarWidth, 10){

                public boolean onKeyPressed(char character, int key) {
                    boolean result = super.onKeyPressed(character, key);
                    if (result) {
                        GuiTextfield searchBar = (GuiTextfield)GuiTree.this.get("search");
                        GuiTree.this.wipePartControls();
                        if (!searchBar.text.equals("")) {
                            GuiTree.this.setSearchedParts(searchBar.text);
                            GuiTree.this.createSearchResultControls();
                        } else {
                            GuiTree.this.createRootControls();
                            GuiTree.this.openTitles();
                        }
                    }
                    return result;
                }
            });
        }
    }

    public void openTitles() {
        for (GuiTreePart part : this.listOfParts) {
            if (!part.type.equals((Object)GuiTreePart.EnumPartType.Title)) continue;
            part.openMenus();
            part.setOpened(true);
            this.updatePartsPosition();
        }
    }

    public void setSearchedParts(String search) {
        this.listOfPartsSearched.clear();
        for (GuiTreePart part : this.listOfParts) {
            if (part.isBranch()) continue;
            if (Pattern.compile(Pattern.quote(search), 2).matcher(part.CAPTION).find()) {
                this.listOfPartsSearched.add(new GuiTreePart(part, GuiTreePart.EnumPartType.Searched));
            }
            for (String keyword : part.listOfSearchKeywords) {
                if (!Pattern.compile(Pattern.quote(search), 2).matcher(keyword).find()) continue;
                GuiTreePart searchedPart = new GuiTreePart(part, GuiTreePart.EnumPartType.Searched);
                searchedPart.caption = searchedPart.CAPTION + ": " + keyword;
                searchedPart.width = GuiRenderHelper.instance.getStringWidth(searchedPart.caption) + searchedPart.getContentOffset() * 2;
                this.listOfPartsSearched.add(searchedPart);
            }
        }
    }

    public void createSearchResultControls() {
        if (this.listOfPartsSearched != null && !this.listOfPartsSearched.isEmpty()) {
            for (int i = 0; i < this.listOfPartsSearched.size(); ++i) {
                GuiTreePart part = this.listOfPartsSearched.get(i);
                part.posY = 14 * i + 20;
                part.posX = 0;
                part.originPosY = new Integer(part.posY);
                this.addControl(part);
            }
        }
    }

    public void wipePartControls() {
        this.removeControls(new String[]{"search"});
    }

    public void closeAllMenus() {
        for (GuiTreePart part : this.listOfParts) {
            if (!part.type.canHold()) continue;
            part.closeMenus();
        }
    }

    public void openTo(GuiTreePart check) {
        do {
            GuiTreePart heldInPart = this.listOfParts.get(check.heldInID);
            GuiTreePart part = this.listOfParts.get(Integer.parseInt(check.name));
            if (heldInPart.type.isOpenable()) {
                heldInPart.openMenus();
                heldInPart.setOpened(true);
                heldInPart.caption = "- " + heldInPart.CAPTION;
                this.updatePartsPosition();
            }
            this.highlightPart(part);
        } while ((check = check.previousBranch()) != null);
    }

    public void allButtons() {
        for (int i = 0; i < this.listOfRoots.size(); ++i) {
            GuiTreePart root = this.listOfRoots.get(i);
            root.isRoot = true;
            root.name = this.indexPos++ + "";
            root.heldInID = Integer.parseInt(root.name);
            root.tree = this;
            this.listOfParts.add(root);
            if (root.listOfParts == null || root.listOfParts.isEmpty()) continue;
            this.allButtons(root, i);
        }
    }

    public void allButtons(GuiTreePart root, int j) {
        for (int i = 0; i < root.listOfParts.size(); ++i) {
            GuiTreePart part = root.listOfParts.get(i);
            if (!part.isRoot) {
                part.posY = 14 * (i + 1) + root.posY;
                part.posX = 14 + root.posX;
                if (!part.flag) {
                    part.originPosX = new Integer(part.posX);
                    part.originPosY = new Integer(part.posY);
                    part.flag = true;
                }
            }
            part.heldInID = Integer.parseInt(root.name);
            part.name = this.indexPos++ + "";
            part.tree = this;
            this.listOfParts.add(part);
            if (part.listOfParts == null || part.listOfParts.isEmpty()) continue;
            this.allButtons(part, j);
        }
    }

    public void highlightPart(GuiTreePart partToHighlight) {
        block5: {
            block4: {
                if (partToHighlight.type.equals((Object)GuiTreePart.EnumPartType.Searched)) break block4;
                for (GuiTreePart part : this.listOfParts) {
                    part.selected = ((Object)((Object)part)).equals((Object)partToHighlight);
                    if (part.selected) {
                        part.setStyle(GuiTreePart.SELECTED_DISPLAY);
                        continue;
                    }
                    part.setStyle(defaultStyle);
                }
                break block5;
            }
            if (this.listOfPartsSearched == null || this.listOfPartsSearched.isEmpty()) break block5;
            for (GuiTreePart part : this.listOfPartsSearched) {
                part.selected = ((Object)((Object)part)).equals((Object)partToHighlight);
                if (part.selected) {
                    part.setStyle(GuiTreePart.SELECTED_DISPLAY);
                    continue;
                }
                part.setStyle(defaultStyle);
            }
        }
    }

    public int numberOfAllParts() {
        return this.listOfParts.size();
    }

    public void updatePartsPosition() {
        boolean flag = true;
        int i = 0;
        HashMap<GuiTreePart, Integer> movePartBy = new HashMap<GuiTreePart, Integer>();
        for (GuiTreePart guiTreePart : this.listOfParts) {
            ++i;
            if (!guiTreePart.isBranch()) continue;
            for (GuiTreePart part : guiTreePart.getListOfPartsToMove()) {
                int add;
                if (movePartBy.containsKey((Object)part)) {
                    add = (Integer)movePartBy.get((Object)part);
                    movePartBy.put(part, add + guiTreePart.getBranchSize());
                } else {
                    movePartBy.put(part, guiTreePart.getBranchSize());
                }
                if (guiTreePart.isOpened() && !guiTreePart.isBranchHiddenAndOpened()) continue;
                add = (Integer)movePartBy.get((Object)part);
                movePartBy.put(part, add - guiTreePart.getBranchSize());
            }
        }
        for (Map.Entry entry : movePartBy.entrySet()) {
            ((GuiTreePart)((Object)entry.getKey())).posY = ((GuiTreePart)((Object)entry.getKey())).originPosY + 14 * (Integer)entry.getValue();
        }
    }

    public boolean mousePressed(int x, int y, int button) {
        this.raiseEvent((ControlEvent)new GuiControlClickEvent((GuiControl)this, x, y, button));
        return super.mousePressed(x, y, button);
    }

    public boolean hasBackground() {
        return false;
    }

    public boolean hasBorder() {
        return false;
    }
}

