/*
 * Decompiled with CFR 0.152.
 */
package com.alet.client.gui.controls.menu;

import com.alet.client.gui.controls.menu.GuiMenu;
import com.alet.client.gui.controls.menu.GuiMenuPart;
import com.alet.client.gui.controls.menu.GuiTreePart;
import com.creativemd.creativecore.common.gui.CoreControl;
import com.creativemd.creativecore.common.gui.GuiControl;
import com.creativemd.creativecore.common.gui.container.GuiParent;
import com.creativemd.creativecore.common.gui.event.ControlEvent;
import com.creativemd.creativecore.common.gui.event.gui.GuiControlClickEvent;
import java.util.ArrayList;
import java.util.List;

public class GuiPopupMenu
extends GuiParent {
    private boolean pressed = false;
    public GuiMenu menu;
    public GuiControl selected;
    public Class<? extends GuiControl> listenFor;

    public GuiPopupMenu(String name, GuiMenu menu, int x, int y, int width, int height) {
        super(name, x, y, width, height);
        this.menu = menu;
    }

    public void listenFor(Class<? extends GuiControl> controlClass) {
        this.listenFor = controlClass;
    }

    public boolean mousePressed(int x, int y, int button) {
        return super.mousePressed(x, y, button);
    }

    public GuiControl controlOver(int x, int y, int button, List<GuiControl> controls) {
        for (GuiControl control : controls) {
            GuiControl found;
            if (control.isMouseOver()) {
                return control;
            }
            if (!(control instanceof GuiParent) || (found = this.controlOver(x, y, button, ((GuiParent)control).controls)) == null) continue;
            return found;
        }
        return null;
    }

    public GuiControl menuOver(int x, int y, int button, ArrayList<GuiControl> controls) {
        for (GuiControl control : controls) {
            GuiControl found;
            if (control instanceof GuiMenuPart && control.isMouseOver(x - this.menu.posX, y - this.menu.posY - 3)) {
                return control;
            }
            if (!(control instanceof GuiParent) || (found = this.menuOver(x, y, button, ((GuiParent)control).controls)) == null) continue;
            return found;
        }
        return null;
    }

    public boolean mouseOver(int x, int y, int button, GuiControl found) {
        for (GuiTreePart part : this.menu.listOfParts) {
            if (found == null || !found.equals((Object)part)) continue;
            return true;
        }
        return false;
    }

    public void mouseDragged(int x, int y, int button, long time) {
        super.mouseDragged(x, y, button, time);
        this.menu.closeAllMenus();
        this.getParent().removeControl((GuiControl)this.menu);
        this.pressed = false;
    }

    public void mouseReleased(int x, int y, int button) {
        this.update(x, y, button);
    }

    public void update(int x, int y, int button) {
        GuiMenuPart found = (GuiMenuPart)this.menuOver(x, y, button, this.getParent().controls);
        if (button == 1) {
            if (!this.pressed) {
                this.menu.posX = x - 2;
                this.menu.posY = y - 23;
                this.menu.closeAllMenus();
                this.getParent().controls.add(this.menu);
            } else {
                this.menu.posX = x - 2;
                this.menu.posY = y - 23;
                this.menu.closeAllMenus();
            }
            this.pressed = true;
            this.selected = this.controlOver(x, y, button, this.parent.getControls());
            this.getParent().moveControlToTop((CoreControl)this.menu);
            this.raiseEvent((ControlEvent)new GuiControlClickEvent((GuiControl)this, x, y, button));
        } else if (button != 2 && (button == 0 && found == null || found.type.equals((Object)GuiTreePart.EnumPartType.Leaf))) {
            this.menu.closeAllMenus();
            this.getParent().removeControl((GuiControl)this.menu);
            this.pressed = false;
            this.selected = null;
        }
    }

    public boolean canOverlap() {
        return true;
    }

    public boolean hasBackground() {
        return false;
    }

    public boolean hasBorder() {
        return false;
    }
}

