/*
 * Decompiled with CFR 0.152.
 */
package com.alet.client.gui.controls.menu;

import com.alet.client.gui.controls.menu.GuiTreePart;
import com.creativemd.creativecore.common.gui.GuiControl;
import com.creativemd.creativecore.common.gui.GuiRenderHelper;
import com.creativemd.creativecore.common.gui.client.style.Style;
import com.creativemd.creativecore.common.gui.event.ControlEvent;
import com.creativemd.creativecore.common.gui.event.gui.GuiControlChangedEvent;
import com.creativemd.creativecore.common.utils.mc.ColorUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.GlStateManager;

public class GuiMenuPart
extends GuiTreePart {
    boolean seprateLine = false;

    public GuiMenuPart(GuiTreePart part) {
        super(part);
    }

    public GuiMenuPart(GuiTreePart part, GuiTreePart.EnumPartType type) {
        super(part, type);
    }

    public GuiMenuPart(String name, String caption, GuiTreePart.EnumPartType type) {
        super(name, caption, type);
    }

    public GuiMenuPart(String name, String caption, GuiTreePart.EnumPartType type, boolean seprateLine) {
        super(name, caption, type);
        this.seprateLine = seprateLine;
    }

    @Override
    protected void renderContent(GuiRenderHelper helper, Style style, int width, int height) {
        GlStateManager.func_179094_E();
        font.func_78276_b(this.caption, 0, 0, -16777216);
        if (this.seprateLine) {
            helper.drawRect(0.0, 10.0, (double)(this.width - 6), 11.0, -16777216);
        }
        if (this.type.canHold()) {
            font.func_78276_b(">", this.width - 10, 0, -16777216);
        }
        GlStateManager.func_179121_F();
    }

    protected void renderBackground(GuiRenderHelper helper, Style style) {
        super.renderBackground(helper, style);
        helper.drawRect((double)(this.width - 1), 0.0, (double)(this.width + 1), 14.0, ColorUtils.RGBAToInt((int)60, (int)60, (int)60, (int)255));
        helper.drawRect(0.0, (double)(this.height - 1), (double)(this.width + 1), (double)(this.height + 1), ColorUtils.RGBAToInt((int)60, (int)60, (int)60, (int)255));
    }

    @Override
    public boolean mousePressed(int x, int y, int button) {
        return super.mousePressed(x, y, button);
    }

    @Override
    public void onClicked(int x, int y, int mouseButton) {
        if (this.listOfParts != null && !this.listOfParts.isEmpty() && this.type.isOpenable()) {
            this.closeBackMenus();
            if (!this.isOpened) {
                this.openMenus();
            } else {
                this.closeMenus();
            }
        }
        this.tree.highlightPart(this);
        this.raiseEvent((ControlEvent)new GuiControlChangedEvent((GuiControl)this));
    }

    public void closeBackMenus() {
        ArrayList<GuiTreePart> toClose = new ArrayList<GuiTreePart>();
        for (GuiTreePart branch : this.tree.listOfParts) {
            if (!branch.type.canHold() || !branch.isOpened) continue;
            toClose.add(branch);
        }
        toClose.remove((Object)this);
        for (GuiTreePart part : this.getListOfBranchesDown()) {
            toClose.remove((Object)part);
        }
        for (GuiTreePart close : toClose) {
            close.closeMenus();
        }
    }

    @Override
    public void openMenus() {
        int i;
        this.isOpened = true;
        int maxWidth = 0;
        for (i = 0; i < this.listOfParts.size(); ++i) {
            GuiTreePart root = (GuiTreePart)((Object)this.listOfParts.get(i));
            int add = 0;
            if (root.type.canHold()) {
                add = 15;
            }
            maxWidth = Math.max(maxWidth, GuiRenderHelper.instance.getStringWidth(root.caption) + 6 + add);
        }
        for (i = 0; i < this.listOfParts.size(); ++i) {
            GuiTreePart button = (GuiTreePart)((Object)this.listOfParts.get(i));
            button.width = maxWidth;
            if (!button.isRoot) {
                this.tree.addControl(button);
            }
            button.moveControlToTop();
        }
    }

    @Override
    public void closeMenus() {
        List controls = this.tree.getControls();
        this.isOpened = false;
        for (GuiTreePart button : this.listOfParts) {
            if (button.isBranch()) {
                button.closeMenus();
            }
            controls.remove((Object)button);
        }
    }

    @Override
    public boolean isMouseOver(int posX, int posY) {
        return posX >= this.posX && posX < this.posX + this.width && posY >= this.posY && posY < this.posY + this.height;
    }

    @Override
    public boolean hasBorder() {
        return true;
    }

    public Style getStyle() {
        return GuiTreePart.DISPLAY;
    }
}

