/*
 * Decompiled with CFR 0.152.
 */
package com.alet.client.gui.controls;

import com.alet.client.gui.controls.KeyControlALET;
import com.creativemd.creativecore.common.utils.type.Pair;
import com.creativemd.creativecore.common.utils.type.PairList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class TimelineChannelALET<T> {
    public int index;
    public String name;
    public List<KeyControlALET<T>> controls = new ArrayList<KeyControlALET<T>>();

    public TimelineChannelALET(String name) {
        this.name = name;
    }

    public TimelineChannelALET addKeys(PairList<Integer, T> keys) {
        if (keys == null || keys.isEmpty()) {
            this.addKey(0, this.getDefault());
            return this;
        }
        for (Pair pair : keys) {
            this.addKey((Integer)pair.key, pair.value);
        }
        return this;
    }

    public TimelineChannelALET<T> addKeyFixed(int tick, T value) {
        KeyControlALET control = this.addKey(tick, value);
        control.modifiable = false;
        return this;
    }

    public KeyControlALET addKey(int tick, T value) {
        value = ((double[])value).clone();
        KeyControlALET<T> control = new KeyControlALET<T>(this, this.controls.size(), tick, value);
        for (int i = 0; i < this.controls.size(); ++i) {
            KeyControlALET<T> other = this.controls.get(i);
            if (other.tick == tick) {
                return null;
            }
            if (other.tick <= tick) continue;
            this.controls.add(i, control);
            return control;
        }
        this.controls.add(control);
        return control;
    }

    public void removeKey(KeyControlALET control) {
        this.controls.remove(control);
    }

    public void movedKey(KeyControlALET control) {
        Collections.sort(this.controls);
    }

    public boolean isSpaceFor(KeyControlALET control, int tick) {
        for (int i = 0; i < this.controls.size(); ++i) {
            int otherTick = this.controls.get((int)i).tick;
            if (otherTick == tick) {
                return false;
            }
            if (otherTick <= tick) continue;
            return true;
        }
        return true;
    }

    public T getValueAt(int tick) {
        if (this.controls.isEmpty()) {
            return this.getDefault();
        }
        int higher = this.controls.size();
        for (int i = 0; i < this.controls.size(); ++i) {
            int otherTick = this.controls.get((int)i).tick;
            if (otherTick == tick) {
                return this.controls.get((int)i).value;
            }
            if (otherTick <= tick) continue;
            higher = i;
            break;
        }
        if (higher == 0 || higher == this.controls.size()) {
            return this.controls.get((int)(higher == 0 ? 0 : this.controls.size() - 1)).value;
        }
        KeyControlALET<T> before = this.controls.get(higher - 1);
        KeyControlALET<T> after = this.controls.get(higher);
        double percentage = (double)(tick - before.tick) / (double)(after.tick - before.tick);
        return this.getValueAt(before, after, percentage);
    }

    protected abstract T getValueAt(KeyControlALET<T> var1, KeyControlALET<T> var2, double var3);

    protected abstract T getDefault();

    public PairList<Integer, T> getPairs() {
        if (this.controls.isEmpty()) {
            return null;
        }
        boolean fixed = true;
        PairList list = new PairList();
        for (KeyControlALET<T> control : this.controls) {
            if (control.modifiable) {
                fixed = false;
            }
            list.add((Object)control.tick, control.value);
        }
        if (fixed) {
            return null;
        }
        return list;
    }

    public static class TimelineChannelDoorData
    extends TimelineChannelALET<double[]> {
        public TimelineChannelDoorData(String name) {
            super(name);
        }

        @Override
        protected double[] getValueAt(KeyControlALET<double[]> before, KeyControlALET<double[]> after, double percentage) {
            double difOffX = (double)Math.round(((((double[])after.value)[0] - ((double[])before.value)[0]) * percentage + ((double[])before.value)[0]) * 100.0) / 100.0;
            double difOffY = (double)Math.round(((((double[])after.value)[1] - ((double[])before.value)[1]) * percentage + ((double[])before.value)[1]) * 100.0) / 100.0;
            double difOffZ = (double)Math.round(((((double[])after.value)[2] - ((double[])before.value)[2]) * percentage + ((double[])before.value)[2]) * 100.0) / 100.0;
            double difRotX = (double)Math.round(((((double[])after.value)[3] - ((double[])before.value)[3]) * percentage + ((double[])before.value)[3]) * 100.0) / 100.0;
            double difRotY = (double)Math.round(((((double[])after.value)[4] - ((double[])before.value)[4]) * percentage + ((double[])before.value)[4]) * 100.0) / 100.0;
            double difRotZ = (double)Math.round(((((double[])after.value)[5] - ((double[])before.value)[5]) * percentage + ((double[])before.value)[5]) * 100.0) / 100.0;
            double[] arr = new double[]{difOffX, difOffY, difOffZ, difRotX, difRotY, difRotZ};
            return (double[])arr.clone();
        }

        @Override
        protected double[] getDefault() {
            return new double[8];
        }
    }
}

