/*
 * Decompiled with CFR 0.152.
 */
package com.alet.client.gui.controls;

import com.creativemd.creativecore.common.gui.GuiControl;
import com.creativemd.creativecore.common.gui.GuiRenderHelper;
import com.creativemd.creativecore.common.gui.client.style.Style;
import com.creativemd.creativecore.common.gui.controls.gui.GuiFocusControl;
import com.creativemd.creativecore.common.gui.event.ControlEvent;
import com.creativemd.creativecore.common.gui.event.gui.GuiControlChangedEvent;
import java.util.ArrayList;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ChatAllowedCharacters;
import net.minecraft.util.math.MathHelper;
import org.apache.commons.lang3.ArrayUtils;

public class GuiWrappedTextField
extends GuiFocusControl {
    public String text = "";
    public int cursorPosition;
    private int scrollOffset = 0;
    public int maxLength = 2048;
    public int selEnd = 0;
    public char[] allowedChars;
    private int cursorCounter;
    private int enabledColor = 0xE0E0E0;
    private int disabledColor = 0x707070;

    public GuiWrappedTextField(String text, int x, int y, int width) {
        this(text, x, y, width, 16);
    }

    public GuiWrappedTextField(String text, int x, int y, int width, int height) {
        this(text, text, x, y, width, height);
    }

    public GuiWrappedTextField(String name, String text, int x, int y, int width, int height) {
        super(name, x, y, width, height);
        this.text = text;
    }

    public GuiWrappedTextField setFloatOnly() {
        this.allowedChars = new char[]{'-', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '.'};
        return this;
    }

    public GuiWrappedTextField setNumbersIncludingNegativeOnly() {
        this.allowedChars = new char[]{'-', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
        return this;
    }

    public GuiWrappedTextField setNumbersOnly() {
        this.allowedChars = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
        return this;
    }

    public int getScrollOffset() {
        return this.scrollOffset;
    }

    public boolean hasSelectedText() {
        return this.selEnd != -1 && this.selEnd != this.cursorPosition;
    }

    public String getSelectedText() {
        if (this.hasSelectedText() && this.text != null) {
            return this.text.substring(Math.min(this.cursorPosition, this.selEnd), Math.max(this.cursorPosition, this.selEnd));
        }
        return "";
    }

    public boolean mousePressed(int posX, int posY, int button) {
        boolean wasFocused = this.focused;
        super.mousePressed(posX, posY, button);
        if (this.focused && !wasFocused) {
            this.cursorCounter = 0;
        }
        int l = posX - (this.posX - this.width / 2);
        String s = GuiRenderHelper.instance.font.func_78269_a(this.text.substring(this.scrollOffset), this.getWidth());
        this.setCursorPosition(GuiRenderHelper.instance.font.func_78269_a(s, l).length() + this.scrollOffset);
        return true;
    }

    public void writeText(String text) {
        int l;
        int i;
        String s1 = "";
        String s2 = ChatAllowedCharacters.func_71565_a((String)text);
        String s3 = "";
        char[] chars = s2.toCharArray();
        if (this.allowedChars != null) {
            for (i = 0; i < chars.length; ++i) {
                if (!ArrayUtils.contains((char[])this.allowedChars, (char)chars[i])) continue;
                s3 = s3 + chars[i];
            }
            s2 = s3;
        }
        i = this.cursorPosition < this.selEnd ? this.cursorPosition : this.selEnd;
        int j = this.cursorPosition < this.selEnd ? this.selEnd : this.cursorPosition;
        int k = this.maxLength - this.text.length() - (i - this.selEnd);
        boolean flag = false;
        if (k < 0 && this.maxLength < this.text.length()) {
            k = 0;
        }
        if (this.text.length() > 0) {
            s1 = s1 + this.text.substring(0, i);
        }
        if (k < s2.length()) {
            s1 = s1 + s2.substring(0, k);
            l = k;
        } else {
            s1 = s1 + s2;
            l = s2.length();
        }
        if (this.text.length() > 0 && j < this.text.length()) {
            s1 = s1 + this.text.substring(j);
        }
        this.text = s1;
        this.moveCursorBy(i - this.selEnd + l);
        this.raiseEvent((ControlEvent)new GuiControlChangedEvent((GuiControl)this));
    }

    public void moveCursorBy(int offset) {
        this.setCursorPosition(this.selEnd + offset);
    }

    public int getNthWordFromCursor(int pos) {
        return this.getNthWordFromPos(pos, this.cursorPosition);
    }

    public int getNthWordFromPos(int pos, int cursorPos) {
        return this.func_146197_a(pos, this.cursorPosition, true);
    }

    public int func_146197_a(int p_146197_1_, int p_146197_2_, boolean p_146197_3_) {
        int k = p_146197_2_;
        boolean flag1 = p_146197_1_ < 0;
        int l = Math.abs(p_146197_1_);
        for (int i1 = 0; i1 < l; ++i1) {
            if (flag1) {
                while (p_146197_3_ && k > 0 && this.text.charAt(k - 1) == ' ') {
                    --k;
                }
                while (k > 0 && this.text.charAt(k - 1) != ' ') {
                    --k;
                }
                continue;
            }
            int j1 = this.text.length();
            if ((k = this.text.indexOf(32, k)) == -1) {
                k = j1;
                continue;
            }
            while (p_146197_3_ && k < j1 && this.text.charAt(k) == ' ') {
                ++k;
            }
        }
        return k;
    }

    public void deleteWords(int pos) {
        if (this.text.length() != 0) {
            if (this.selEnd != this.cursorPosition) {
                this.writeText("");
            } else {
                this.deleteFromCursor(this.getNthWordFromCursor(pos) - this.cursorPosition);
            }
        }
        this.raiseEvent((ControlEvent)new GuiControlChangedEvent((GuiControl)this));
    }

    public ArrayList<String> getTooltip() {
        ArrayList<String> strings = new ArrayList<String>();
        return strings;
    }

    public void deleteFromCursor(int pos) {
        if (this.text.length() != 0) {
            if (this.selEnd != this.cursorPosition) {
                this.writeText("");
            } else {
                boolean flag = pos < 0;
                int j = flag ? this.cursorPosition + pos : this.cursorPosition;
                int k = flag ? this.cursorPosition : this.cursorPosition + pos;
                String s = "";
                if (j >= 0) {
                    s = this.text.substring(0, j);
                }
                if (k < this.text.length()) {
                    s = s + this.text.substring(k);
                }
                this.text = s;
                if (flag) {
                    this.moveCursorBy(pos);
                }
            }
        }
        this.raiseEvent((ControlEvent)new GuiControlChangedEvent((GuiControl)this));
    }

    public int getWidth() {
        return this.width - 8;
    }

    public void setSelectionPos(int p_146199_1_) {
        int j = this.text.length();
        this.selEnd = p_146199_1_ = MathHelper.func_76125_a((int)p_146199_1_, (int)0, (int)j);
        if (GuiRenderHelper.instance.font != null) {
            if (this.scrollOffset > j) {
                this.scrollOffset = j;
            }
            int k = this.getWidth();
            String s = GuiRenderHelper.instance.font.func_78269_a(this.text.substring(this.scrollOffset), k);
            int l = s.length() + this.scrollOffset;
            if (p_146199_1_ == this.scrollOffset) {
                this.scrollOffset -= GuiRenderHelper.instance.font.func_78262_a(this.text, k, true).length();
            }
            if (p_146199_1_ > l) {
                this.scrollOffset += p_146199_1_ - l;
            } else if (p_146199_1_ <= this.scrollOffset) {
                this.scrollOffset -= this.scrollOffset - p_146199_1_;
            }
            this.scrollOffset = MathHelper.func_76125_a((int)this.scrollOffset, (int)0, (int)j);
        }
    }

    public void setCursorPosition(int pos) {
        this.cursorPosition = pos;
        this.cursorPosition = MathHelper.func_76125_a((int)this.cursorPosition, (int)0, (int)this.text.length());
        this.setSelectionPos(this.cursorPosition);
    }

    public void setCursorPositionZero() {
        this.setCursorPosition(0);
    }

    public void setCursorPositionEnd() {
        this.setCursorPosition(this.text.length());
    }

    public boolean onKeyPressed(char character, int key) {
        if (!this.focused) {
            return false;
        }
        if (GuiScreen.func_175278_g((int)key)) {
            this.setCursorPositionEnd();
            this.setSelectionPos(0);
            return true;
        }
        if (GuiScreen.func_175280_f((int)key)) {
            GuiScreen.func_146275_d((String)this.getSelectedText());
            return true;
        }
        if (GuiScreen.func_175279_e((int)key)) {
            if (this.enabled) {
                this.writeText(GuiScreen.func_146277_j());
            }
            return true;
        }
        if (GuiScreen.func_175277_d((int)key)) {
            GuiScreen.func_146275_d((String)this.getSelectedText());
            if (this.enabled) {
                this.writeText("");
            }
            return true;
        }
        switch (key) {
            case 14: {
                if (GuiScreen.func_146271_m()) {
                    if (this.enabled) {
                        this.deleteWords(-1);
                    }
                } else if (this.enabled) {
                    this.deleteFromCursor(-1);
                }
                return true;
            }
            case 199: {
                if (GuiScreen.func_146272_n()) {
                    this.setSelectionPos(0);
                } else {
                    this.setCursorPositionZero();
                }
                return true;
            }
            case 203: {
                if (GuiScreen.func_146272_n()) {
                    if (GuiScreen.func_146271_m()) {
                        this.setSelectionPos(this.getNthWordFromPos(-1, this.selEnd));
                    } else {
                        this.setSelectionPos(this.selEnd - 1);
                    }
                } else if (GuiScreen.func_146271_m()) {
                    this.setCursorPosition(this.getNthWordFromCursor(-1));
                } else {
                    this.moveCursorBy(-1);
                }
                return true;
            }
            case 205: {
                if (GuiScreen.func_146272_n()) {
                    if (GuiScreen.func_146271_m()) {
                        this.setSelectionPos(this.getNthWordFromPos(1, this.selEnd));
                    } else {
                        this.setSelectionPos(this.selEnd + 1);
                    }
                } else if (GuiScreen.func_146271_m()) {
                    this.setCursorPosition(this.getNthWordFromCursor(1));
                } else {
                    this.moveCursorBy(1);
                }
                return true;
            }
            case 207: {
                if (GuiScreen.func_146272_n()) {
                    this.setSelectionPos(this.text.length());
                } else {
                    this.setCursorPositionEnd();
                }
                return true;
            }
            case 211: {
                if (GuiScreen.func_146271_m()) {
                    if (this.enabled) {
                        this.deleteWords(1);
                    }
                } else if (this.enabled) {
                    this.deleteFromCursor(1);
                }
                return true;
            }
        }
        if (ChatAllowedCharacters.func_71566_a((char)character)) {
            if (this.enabled) {
                this.writeText(Character.toString(character));
            }
            return true;
        }
        return false;
    }

    public void updateCursorCounter() {
        ++this.cursorCounter;
    }

    public void onTextChange() {
    }

    private void drawCursorVertical(int startX, int startY, int endX, int endY) {
        if (startX < endX) {
            int i = startX;
            startX = endX;
            endX = i;
        }
        if (startY < endY) {
            int j = startY;
            startY = endY;
            endY = j;
        }
        if (endX > this.posX + this.width) {
            endX = this.posX + this.width;
        }
        if (startX > this.posX + this.width) {
            startX = this.posX + this.width;
        }
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder vertexbuffer = tessellator.func_178180_c();
        GlStateManager.func_179131_c((float)0.0f, (float)0.0f, (float)255.0f, (float)255.0f);
        GlStateManager.func_179090_x();
        GlStateManager.func_179115_u();
        GlStateManager.func_187422_a((GlStateManager.LogicOp)GlStateManager.LogicOp.OR_REVERSE);
        vertexbuffer.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        vertexbuffer.func_181662_b((double)startX, (double)endY, 0.0).func_181675_d();
        vertexbuffer.func_181662_b((double)endX, (double)endY, 0.0).func_181675_d();
        vertexbuffer.func_181662_b((double)endX, (double)startY, 0.0).func_181675_d();
        vertexbuffer.func_181662_b((double)startX, (double)startY, 0.0).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179134_v();
        GlStateManager.func_179098_w();
    }

    protected void renderContent(GuiRenderHelper helper, Style style, int width, int height) {
        this.scrollOffset = MathHelper.func_76125_a((int)this.scrollOffset, (int)0, (int)this.text.length());
        int i = this.enabled ? this.enabledColor : this.disabledColor;
        int j = this.cursorPosition - this.scrollOffset;
        int k = this.selEnd - this.scrollOffset;
        String s = GuiRenderHelper.instance.font.func_78269_a(this.text.substring(this.scrollOffset), this.getWidth());
        boolean flag = j >= 0 && j <= s.length();
        boolean flag1 = this.focused && this.cursorCounter / 6 % 2 == 0 && flag;
        int l = 4;
        int i1 = GuiRenderHelper.instance.getFontHeight() - this.getContentOffset();
        int j1 = l;
        if (k > s.length()) {
            k = s.length();
        }
        int y = 0;
        int cursorWidth = 0;
        int cursorHeight = 0;
        int stringLength = 0;
        boolean flag3 = false;
        if (s.length() > 0) {
            String s1 = flag ? s.substring(0, j) : s;
            for (String line : font.func_78271_c(this.text, width)) {
                int lineWidth = font.func_78256_a(line);
                j1 = lineWidth + 5;
                GuiRenderHelper.instance.font.func_175063_a(line, (float)l, (float)(y + i1), i);
                if ((stringLength += line.length()) < this.cursorPosition) {
                    cursorHeight += GuiWrappedTextField.font.field_78288_b + 1;
                } else if (!flag3) {
                    flag3 = true;
                    if (this.cursorPosition != -1) {
                        cursorWidth = 4 + (lineWidth - font.func_78256_a(line.substring(this.cursorPosition - (stringLength - line.length()))));
                    }
                }
                y += GuiWrappedTextField.font.field_78288_b + 1;
            }
            y -= GuiWrappedTextField.font.field_78288_b + 1;
        }
        boolean flag2 = this.cursorPosition < this.text.length() || this.text.length() >= this.maxLength;
        int k1 = j1;
        if (!flag) {
            k1 = j > 0 ? l + this.width : l;
        } else if (flag2) {
            k1 = j1 - 1;
            --j1;
        }
        if (flag1) {
            if (flag2) {
                Gui.func_73734_a((int)cursorWidth, (int)(i1 - 1 + cursorHeight), (int)(cursorWidth + 1), (int)(cursorHeight + i1 + 1 + GuiRenderHelper.instance.getFontHeight()), (int)-3092272);
            } else {
                GuiRenderHelper.instance.font.func_175063_a("_", (float)k1, (float)(i1 + y), i);
            }
        }
        if (k != j) {
            int l1 = l + GuiRenderHelper.instance.font.func_78256_a(s.substring(0, k));
            this.drawCursorVertical(k1, i1 - 1, l1 - 1, i1 + 1 + GuiRenderHelper.instance.getFontHeight());
        }
    }

    public float parseFloat() {
        try {
            return Float.parseFloat(this.text);
        }
        catch (NumberFormatException e) {
            return 0.0f;
        }
    }

    public int parseInteger() {
        try {
            return Integer.parseInt(this.text);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }
}

