/*
 * Decompiled with CFR 0.152.
 */
package com.alet.client.gui.controls;

import com.alet.client.gui.controls.KeyControlALET;
import com.alet.client.gui.controls.TimelineChannelALET;
import com.creativemd.creativecore.common.gui.GuiControl;
import com.creativemd.creativecore.common.gui.GuiRenderHelper;
import com.creativemd.creativecore.common.gui.client.style.ColoredDisplayStyle;
import com.creativemd.creativecore.common.gui.client.style.DisplayStyle;
import com.creativemd.creativecore.common.gui.client.style.Style;
import com.creativemd.creativecore.common.gui.container.GuiParent;
import com.creativemd.creativecore.common.gui.controls.gui.timeline.IAnimationHandler;
import com.creativemd.creativecore.common.gui.event.ControlEvent;
import com.creativemd.creativecore.common.gui.event.gui.GuiControlChangedEvent;
import com.creativemd.creativecore.common.gui.event.gui.GuiControlEvent;
import com.creativemd.creativecore.common.utils.math.SmoothValue;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import org.lwjgl.util.Color;

public class GuiTimelineALET
extends GuiParent {
    protected double ticksPerPixel;
    protected double basePixelWidth;
    protected static final double maxZoom = 10.0;
    protected SmoothValue zoom = new SmoothValue(100L);
    protected SmoothValue scrollX = new SmoothValue(100L);
    protected SmoothValue scrollY = new SmoothValue(100L);
    protected int duration;
    public DisplayStyle timelineBackground = new ColoredDisplayStyle(255, 255, 255);
    public IAnimationHandler handler;
    public List<TimelineChannelALET> channels;
    public int sidebarWidth = 50;
    private int channelHeight = 10;
    private int timelineHeight = 11;
    protected List<KeyControlALET> dragging = new ArrayList<KeyControlALET>();
    private List<KeyControlALET> selected = new ArrayList<KeyControlALET>();
    private boolean movedSelected = false;
    private int movedStart = 0;
    private boolean draggedTimeline = false;
    private double lastZoom = 0.0;
    protected double sizeX;
    protected double maxScrollX;
    protected double sizeY;
    protected double maxScrollY;

    public GuiTimelineALET(String name, int x, int y, int width, int height, int duration, List<TimelineChannelALET> channels, IAnimationHandler handler) {
        super(name, x, y, width, height);
        this.handler = handler;
        this.marginWidth = 0;
        this.channels = channels;
        this.refreshChannels();
        this.setDuration(duration);
    }

    public void refreshChannels() {
        int i = 0;
        this.removeControls(new String[]{""});
        for (TimelineChannelALET channel : this.channels) {
            channel.index = i;
            for (KeyControlALET control : channel.controls) {
                this.adjustKeyPositionX(control);
                this.adjustKeyPositionY(control);
                this.addControl(control);
            }
            ++i;
        }
    }

    public GuiTimelineALET setSidebarWidth(int width) {
        this.sidebarWidth = width;
        return this;
    }

    public void adjustKeyPositionY(KeyControlALET control) {
        System.out.println(control.channel.index);
        control.posY = this.timelineHeight + control.height / 2 + this.channelHeight * control.channel.index;
    }

    public void adjustKeyPositionX(KeyControlALET control) {
        control.posX = (int)((double)control.tick * this.getTickWidth()) - control.width / 2;
    }

    public void adjustKeysPositionX() {
        double tickWidth = this.getTickWidth();
        for (TimelineChannelALET channel : this.channels) {
            for (KeyControlALET control : channel.controls) {
                control.posX = (int)((double)control.tick * tickWidth) - control.width / 2;
            }
        }
    }

    public double getOffsetX() {
        return (double)this.sidebarWidth - this.scrollX.current();
    }

    public void mouseMove(int x, int y, int button) {
        if (this.dragging != null) {
            if (!this.movedSelected) {
                boolean bl = this.movedSelected = Math.abs(this.movedStart - x) > 5;
            }
            if (this.movedSelected) {
                int tick = Math.max(0, this.getTickAt(x));
                for (KeyControlALET dragged : this.dragging) {
                    if (!dragged.channel.isSpaceFor(dragged, tick)) continue;
                    dragged.tick = tick;
                    this.adjustKeyPositionX(dragged);
                }
            }
        } else if (this.draggedTimeline) {
            this.handler.set(MathHelper.func_76125_a((int)((int)(((double)(x - this.sidebarWidth) + this.getTickWidth() / 2.0 + this.scrollX.current()) / this.getTickWidth())), (int)0, (int)this.duration));
        }
        super.mouseMove(x, y, button);
    }

    public boolean mousePressed(int x, int y, int button) {
        this.selected.clear();
        boolean result = super.mousePressed(x, y, button);
        for (GuiControl control : this.controls) {
            if (!(control instanceof KeyControlALET) || this.selected == control || !((KeyControlALET)control).selected) continue;
            ((KeyControlALET)control).selected = false;
            if (!this.selected.isEmpty()) continue;
            this.raiseEvent((ControlEvent)new KeyALETDeselectedEvent((KeyControlALET)control));
        }
        if (!result && this.selected.isEmpty()) {
            int tick;
            int channel = this.getChannelAt((int)this.getMousePos().field_72448_b);
            if (channel != -1 && button == 1) {
                int tick2 = this.getTickAt(x);
                KeyControlALET control = this.channels.get(channel).addKey(tick2, this.channels.get(channel).getValueAt(tick2));
                if (control == null) {
                    return result;
                }
                this.adjustKeyPositionX(control);
                this.adjustKeyPositionY(control);
                this.addControl(control);
                this.raiseEvent((ControlEvent)new GuiControlChangedEvent((GuiControl)this));
            } else if (channel != -1 && (tick = this.getTickAt(x)) >= 0 && tick <= this.duration) {
                this.handler.set(tick);
                this.draggedTimeline = true;
            }
        }
        return result;
    }

    protected void clickControl(GuiControl control, int x, int y, int button) {
        if (control instanceof KeyControlALET) {
            if (button == 1) {
                if (!((KeyControlALET)control).modifiable) {
                    return;
                }
                ((KeyControlALET)control).removeKey();
                this.selected = new ArrayList<KeyControlALET>();
                this.raiseEvent((ControlEvent)new GuiControlChangedEvent((GuiControl)this));
                return;
            }
            if (GuiScreen.func_146271_m()) {
                this.selected.add((KeyControlALET)control);
                ((KeyControlALET)control).selected = true;
            } else {
                if (!this.selected.isEmpty()) {
                    for (KeyControlALET select : this.selected) {
                        select.selected = false;
                    }
                }
                this.dragging.clear();
                this.selected.clear();
                this.selected.add((KeyControlALET)control);
                ((KeyControlALET)control).selected = true;
            }
            for (KeyControlALET select : this.selected) {
                if (!select.modifiable) continue;
                this.dragging.add(select);
                this.movedSelected = false;
                this.movedStart = x;
            }
            this.raiseEvent((ControlEvent)new KeyALETSelectedEvent((KeyControlALET)control));
            GuiTimelineALET.playSound((SoundEvent)SoundEvents.field_187909_gi);
        }
        super.clickControl(control, x, y, button);
    }

    public void mouseReleased(int x, int y, int button) {
        super.mouseReleased(x, y, button);
        if (!this.dragging.isEmpty()) {
            for (KeyControlALET dragged : this.dragging) {
                dragged.channel.movedKey(dragged);
                dragged = null;
            }
            this.dragging.clear();
            this.raiseEvent((ControlEvent)new GuiControlChangedEvent((GuiControl)this));
        }
        this.draggedTimeline = false;
    }

    public GuiTimelineALET setDuration(int duration) {
        int useableWidth = this.width - this.sidebarWidth - 2 - this.getContentOffset() * 2;
        this.ticksPerPixel = (double)duration / (double)useableWidth;
        this.basePixelWidth = 1.0 / this.ticksPerPixel;
        this.zoom.setStart(0.0);
        this.duration = duration;
        this.scrollX.setStart(0.0);
        this.scrollY.setStart(0.0);
        this.adjustKeysPositionX();
        this.raiseEvent((ControlEvent)new GuiControlChangedEvent((GuiControl)this));
        return this;
    }

    public int getDuration() {
        return this.duration;
    }

    public boolean mouseScrolled(int x, int y, int scrolled) {
        if (GuiScreen.func_146272_n()) {
            this.scrollX.set(MathHelper.func_151237_a((double)(this.scrollX.aimed() - (double)(scrolled * 10)), (double)0.0, (double)this.maxScrollX));
        } else if (GuiScreen.func_146271_m()) {
            this.scrollY.set(MathHelper.func_151237_a((double)(this.scrollY.aimed() + (double)scrolled), (double)0.0, (double)this.maxScrollY));
        } else {
            int focusedTick = Math.max(0, this.getTickAtAimed(x));
            this.zoom.set(MathHelper.func_151237_a((double)(this.zoom.aimed() + (double)scrolled * this.basePixelWidth * 2.0 * Math.max(this.basePixelWidth * 2.0, this.zoom.aimed()) / 10.0), (double)0.0, (double)10.0));
            int currentTick = Math.max(0, this.getTickAtAimed(x));
            double aimedTickWidth = this.getTickWidthAimed();
            double sizeX = aimedTickWidth * (double)this.duration;
            double maxScrollX = Math.max(0.0, sizeX - (double)(this.width - this.getContentOffset() * 2));
            this.scrollX.set(MathHelper.func_151237_a((double)(this.scrollX.aimed() + (double)(focusedTick - currentTick) * aimedTickWidth), (double)0.0, (double)maxScrollX));
        }
        return true;
    }

    public int getChannelAt(int y) {
        int channel = (y - this.timelineHeight) / this.channelHeight;
        if (channel < 0 || channel >= this.channels.size()) {
            return -1;
        }
        return channel;
    }

    public int getTickAt(int x) {
        if ((x -= this.posX) <= this.sidebarWidth) {
            return -1;
        }
        return MathHelper.func_76125_a((int)((int)(((double)(x - this.sidebarWidth) + this.getTickWidth() / 2.0 + this.scrollX.current()) / this.getTickWidth())), (int)0, (int)this.duration);
    }

    public int getTickAtAimed(int x) {
        if ((x -= this.posX) <= this.sidebarWidth) {
            return -1;
        }
        return MathHelper.func_76125_a((int)((int)(((double)(x - this.sidebarWidth) + this.getTickWidth() / 2.0 + this.scrollX.aimed()) / this.getTickWidthAimed())), (int)0, (int)this.duration);
    }

    protected double getTickWidth() {
        return this.basePixelWidth + this.zoom.current();
    }

    protected double getTickWidthAimed() {
        return this.basePixelWidth + this.zoom.aimed();
    }

    public List<String> getTooltip() {
        int channelId;
        Vec3d mouse = this.getMousePos();
        double x = mouse.field_72450_a + this.getOffsetX();
        ArrayList<String> lines = new ArrayList<String>();
        if (x > (double)this.sidebarWidth && x < (double)(this.width - this.getContentOffset() * 2)) {
            int channelId2 = this.getChannelAt((int)mouse.field_72448_b);
            if (channelId2 >= 0) {
                TimelineChannelALET channel = this.channels.get(channelId2);
                int tick = this.getTickAt((int)x);
                lines.add("" + tick + ". " + channel.name);
            }
        } else if (x > 0.0 && x < (double)this.sidebarWidth && (channelId = this.getChannelAt((int)mouse.field_72448_b)) >= 0) {
            TimelineChannelALET channel = this.channels.get(channelId);
            lines.add(channel.name);
        }
        return lines;
    }

    protected void renderContent(GuiRenderHelper helper, Style style, int width, int height) {
        int i;
        this.zoom.tick();
        this.scrollX.tick();
        this.scrollY.tick();
        int usuableWidth = width - this.sidebarWidth;
        double tickWidth = this.getTickWidth();
        if (this.lastZoom != this.zoom.current()) {
            this.sizeX = tickWidth * (double)this.duration;
            this.maxScrollX = Math.max(0.0, this.sizeX - (double)usuableWidth);
            this.lastZoom = this.zoom.current();
            this.adjustKeysPositionX();
        }
        int ticks = (int)((double)usuableWidth / tickWidth);
        int area = 5;
        int halfArea = 5;
        int smallestStep = 0;
        while (Math.pow(area, smallestStep) * tickWidth < 3.0) {
            ++smallestStep;
        }
        smallestStep = (int)Math.pow(area, smallestStep);
        double stepWidth = tickWidth * (double)smallestStep;
        int stepOffset = (int)(this.scrollX.current() / stepWidth);
        int stamps = ticks / smallestStep;
        int begin = Math.max(0, stepOffset);
        int end = stepOffset + stamps + 1;
        int pointerWidth = Math.max((int)tickWidth, 1);
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)this.sidebarWidth, (float)0.0f, (float)0.0f);
        Color a = new Color(31, 78, 120, 150);
        Color b = new Color(47, 117, 181, 150);
        Color c = new Color(155, 194, 230, 150);
        Color d = new Color(189, 215, 238, 150);
        Color e = new Color(221, 235, 247, 150);
        Color color = a;
        int counter = 0;
        int stop = (int)(Math.ceil(this.scrollX.current() / stepWidth) + (double)ticks + 1.0);
        for (i = begin; i <= stop; ++i) {
            counter = i % 5;
            if (counter == 0) {
                color = a;
            } else if (counter == 1) {
                color = b;
            } else if (counter == 2) {
                color = c;
            } else if (counter == 3) {
                color = d;
            } else if (counter == 4) {
                color = e;
                counter = -1;
            }
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)(tickWidth * (double)i - (double)pointerWidth / 2.0 - this.scrollX.current()), (double)0.0, (double)0.0);
            new ColoredDisplayStyle(color).renderStyle(helper, pointerWidth, this.timelineHeight * this.height);
            GlStateManager.func_179121_F();
        }
        GlStateManager.func_179121_F();
        GlStateManager.func_179094_E();
        this.timelineBackground.renderStyle(helper, this.sidebarWidth, height);
        GlStateManager.func_179109_b((float)0.0f, (float)this.timelineHeight, (float)0.0f);
        for (i = 0; i < this.channels.size(); ++i) {
            int textW = font.func_78256_a(this.channels.get((int)i).name);
            if (textW > this.sidebarWidth) {
                font.func_78276_b(this.channels.get((int)i).name.substring(0, 5).replaceAll(" ", "") + "...", 1, 1, -16777216);
            } else {
                font.func_78276_b(this.channels.get((int)i).name, 1, 1, -16777216);
            }
            GlStateManager.func_179109_b((float)0.0f, (float)this.channelHeight, (float)0.0f);
        }
        GlStateManager.func_179121_F();
        GlStateManager.func_179109_b((float)this.sidebarWidth, (float)0.0f, (float)0.0f);
        GlStateManager.func_179094_E();
        this.timelineBackground.renderStyle(helper, width, this.timelineHeight);
        GlStateManager.func_179109_b((float)0.0f, (float)this.timelineHeight, (float)0.0f);
        this.getStyle().getBorder((GuiControl)this).renderStyle(helper, width, 1);
        GlStateManager.func_179094_E();
        pointerWidth = Math.max((int)tickWidth, 1);
        GlStateManager.func_179137_b((double)(tickWidth * (double)this.handler.get() - (double)pointerWidth / 2.0 - this.scrollX.current()), (double)(-this.timelineHeight), (double)0.0);
        new ColoredDisplayStyle(200, 200, 0, 150).renderStyle(helper, pointerWidth, this.timelineHeight);
        GlStateManager.func_179121_F();
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)(-this.scrollX.current() + (double)begin * stepWidth), (double)-2.0, (double)0.0);
        for (i = begin; i < end; ++i) {
            if (i % halfArea == 0) {
                this.getStyle().getBorder((GuiControl)this).renderStyle(helper, 1, 2);
                this.getStyle().getDisableEffect((GuiControl)this).renderStyle(0, 2, helper, 1, height - 2);
                String text = "" + i * smallestStep;
                font.func_78276_b(text, 0 - font.func_78256_a(text) / 2, -8, -16777216);
            } else {
                this.getStyle().getBorder((GuiControl)this).renderStyle(helper, 1, 1);
            }
            GlStateManager.func_179137_b((double)stepWidth, (double)0.0, (double)0.0);
        }
        GlStateManager.func_179121_F();
        GlStateManager.func_179121_F();
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)0.0f, (float)this.timelineHeight, (float)0.0f);
        for (i = 0; i < this.channels.size(); ++i) {
            GlStateManager.func_179109_b((float)0.0f, (float)this.channelHeight, (float)0.0f);
            this.getStyle().getBorder((GuiControl)this).renderStyle(helper, usuableWidth, 1);
        }
        GlStateManager.func_179121_F();
        if (this.maxScrollX > 0.0) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)(this.scrollX.current() / this.sizeX * (double)usuableWidth), (double)(height - 2), (double)0.0);
            this.getStyle().getBorder((GuiControl)this).renderStyle(helper, (int)Math.max(1.0, (1.0 - this.maxScrollX / this.sizeX) * (double)usuableWidth), 1);
            GlStateManager.func_179121_F();
        }
    }

    public boolean hasMouseOverEffect() {
        return false;
    }

    public static class KeyALETDeselectedEvent
    extends GuiControlEvent {
        public KeyALETDeselectedEvent(KeyControlALET source) {
            super((GuiControl)source);
        }

        public boolean isCancelable() {
            return false;
        }
    }

    public static class KeyALETSelectedEvent
    extends GuiControlEvent {
        public KeyALETSelectedEvent(KeyControlALET source) {
            super((GuiControl)source);
        }

        public boolean isCancelable() {
            return false;
        }
    }
}

