/*
 * Decompiled with CFR 0.152.
 */
package com.alet.client.gui.controls;

import com.creativemd.creativecore.common.gui.GuiControl;
import com.creativemd.creativecore.common.gui.controls.gui.custom.GuiStackSelectorAll;
import com.creativemd.creativecore.common.gui.event.ControlEvent;
import com.creativemd.creativecore.common.gui.event.gui.GuiControlChangedEvent;
import com.creativemd.creativecore.common.utils.mc.BlockUtils;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.ItemModelMesher;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;

public class GuiStack
extends GuiStackSelectorAll {
    public String texture;
    private EnumFacing facing;
    private ItemStack itemStack;
    public boolean useBlock;

    public GuiStack(String name, int x, int y, int width, EntityPlayer player, GuiStackSelectorAll.StackCollector collector, boolean searchBar, boolean block) {
        super(name, x, y, width, player, collector, searchBar);
        this.useBlock = block;
    }

    public void setEnumFacing(String face) {
        switch (face) {
            case "up": {
                this.facing = EnumFacing.UP;
                break;
            }
            case "down": {
                this.facing = EnumFacing.DOWN;
                break;
            }
            case "north": {
                this.facing = EnumFacing.NORTH;
                break;
            }
            case "east": {
                this.facing = EnumFacing.EAST;
                break;
            }
            case "south": {
                this.facing = EnumFacing.SOUTH;
                break;
            }
            case "west": {
                this.facing = EnumFacing.WEST;
                break;
            }
            default: {
                this.facing = EnumFacing.NORTH;
            }
        }
        this.getTexture(this.itemStack);
    }

    public EnumFacing getEnumFacing() {
        return this.facing;
    }

    public boolean setSelected(ItemStack stack) {
        if (this.stacks.contains((Object)stack)) {
            this.itemStack = stack;
            if (this.facing == null) {
                this.facing = EnumFacing.NORTH;
            }
            this.caption = stack.func_82833_r();
            this.selected = stack;
            this.raiseEvent((ControlEvent)new GuiControlChangedEvent((GuiControl)this));
            return true;
        }
        return false;
    }

    public String getTexture(ItemStack stack) {
        Block block = Block.func_149634_a((Item)stack.func_77973_b());
        Item item = stack.func_77973_b();
        int damage = item.getDamage(stack);
        int meta = item.func_77647_b(damage);
        IBlockState state = BlockUtils.getState((Block)block, (int)meta);
        Minecraft minecraft = Minecraft.func_71410_x();
        if (this.useBlock) {
            ResourceLocation reg = block.getRegistryName();
            BlockRendererDispatcher ren = minecraft.func_175602_ab();
            this.texture = ((BakedQuad)ren.func_184389_a(state).func_188616_a(state, this.facing, 0L).get(0)).func_187508_a().toString();
        } else {
            RenderItem itemRen = minecraft.func_175599_af();
            ItemModelMesher mesher = itemRen.func_175037_a();
            this.texture = ((BakedQuad)mesher.func_178089_a(stack).func_188616_a(null, null, 0L).get(0)).func_187508_a().toString();
        }
        return this.texture;
    }
}

