/*
 * Decompiled with CFR 0.152.
 */
package com.alet.client.gui.controls;

import com.alet.client.gui.controls.GuiGIF;
import com.alet.client.gui.controls.GuiImage;
import com.creativemd.creativecore.common.gui.GuiControl;
import com.creativemd.creativecore.common.gui.GuiRenderHelper;
import com.creativemd.creativecore.common.gui.client.style.Style;
import com.creativemd.creativecore.common.gui.controls.gui.GuiTextBox;
import com.creativemd.creativecore.common.utils.mc.ColorUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.TextFormatting;
import org.lwjgl.util.Color;

public class GuiModifibleTextBox
extends GuiTextBox {
    List<String> listOfText = new ArrayList<String>();
    List<ModifyText> listOfModifyText = new ArrayList<ModifyText>();
    Map<Float[], ModifyText> locationTextMap = new LinkedHashMap<Float[], ModifyText>();
    List<ModifyText> locationImageList = new ArrayList<ModifyText>();
    Map<Float[], ModifyText> locationClickableMap = new LinkedHashMap<Float[], ModifyText>();
    ModifyTextMap map = new ModifyTextMap();
    public static final Pattern FORMATTING_NEWLINE_PATTERN = Pattern.compile("\\{newLines:[-+]?[0-9]*\\.?[0-9]+([eE][-+]?[0-9]+)?\\}");
    public static final Pattern FORMATTING_SCALE_PATTERN = Pattern.compile("\\{scale:[-+]?[0-9]*\\.?[0-9]+([eE][-+]?[0-9]+)?\\}");
    public static final Pattern FORMATTING_ITALIC_PATTERN = Pattern.compile("\\{italic\\}");
    public static final Pattern FORMATTING_BOLD_PATTERN = Pattern.compile("\\{bold\\}");
    public static final Pattern FORMATTING_UNDERLINED_PATTERN = Pattern.compile("\\{underline\\}");
    public static final Pattern FORMATTING_CLICKABLE_PATTERN = Pattern.compile("\\{clickable\\}");
    public static final Pattern FORMATTING_COLOR_PATTERN = Pattern.compile("\\{color:[-+]?[0-9]*\\.?[0-9]+([eE][-+]?[0-9]+)?\\}");
    public static final Pattern FORMATTING_END_PATTERN = Pattern.compile("\\{end\\}");
    public static final Pattern FORMATTING_NUMBER_PATTERN = Pattern.compile("[-+]?[0-9]*\\.?[0-9]+([eE][-+]?[0-9]+)?");
    public static final Pattern FORMATTING_SIMPLE_NUMBER_PATTERN = Pattern.compile("[0-9]+");
    public static final Pattern FORMATTING_DOUBLE_PATTERN = Pattern.compile("[-+]?[0-9]+(\\.+[0-9]+)?");
    public static final Pattern FORMATTING_IMAGE_PATTERN = Pattern.compile("\\{image:[-+]?[0-9]+,[-+]?[0-9]+,[-+]?[0-9]+(\\.+[0-9]+)?,[a-zA-Z.]+\\}");
    public static final Pattern FORMATTING_FILE_PATTERN = Pattern.compile("[a-zA-Z]+\\.[a-zA-Z]+");

    public GuiModifibleTextBox(String name, String text, int x, int y, int width) {
        super(name, text, x, y, width);
        this.textToArray(this.text);
        this.readText();
        this.breakDownText();
        this.positionText();
    }

    private void textToArray(String text) {
        Matcher matcherEnd = FORMATTING_END_PATTERN.matcher(text);
        if (matcherEnd.find()) {
            String foundText = text.substring(0, matcherEnd.end());
            this.listOfText.add(foundText);
            this.textToArray(text.replaceFirst(Pattern.quote(foundText), ""));
        }
    }

    private void readText() {
        for (String text : this.listOfText) {
            Matcher matcherScale = FORMATTING_SCALE_PATTERN.matcher(text);
            Matcher matcherNewLine = FORMATTING_NEWLINE_PATTERN.matcher(text);
            Matcher matcherClickable = FORMATTING_CLICKABLE_PATTERN.matcher(text);
            Matcher matcherBold = FORMATTING_BOLD_PATTERN.matcher(text);
            Matcher matcherItalic = FORMATTING_ITALIC_PATTERN.matcher(text);
            Matcher matcherUnderline = FORMATTING_UNDERLINED_PATTERN.matcher(text);
            Matcher matcherColor = FORMATTING_COLOR_PATTERN.matcher(text);
            Matcher matcherImage = FORMATTING_IMAGE_PATTERN.matcher(text);
            Matcher matcherEnd = FORMATTING_END_PATTERN.matcher(text);
            ModifyText modText = new ModifyText(0.0, -1, false, 0, "");
            if (matcherScale.find()) {
                modText.scale = ModifierAttribute.getScale(matcherScale.group());
                text = text.replaceAll(FORMATTING_SCALE_PATTERN.pattern(), "");
            }
            if (matcherNewLine.find()) {
                modText.newLines = ModifierAttribute.getNewLines(matcherNewLine.group());
                text = text.replaceAll(FORMATTING_NEWLINE_PATTERN.pattern(), "");
            }
            if (matcherClickable.find()) {
                modText.clickable = ModifierAttribute.isClickable(matcherClickable.group());
                text = text.replaceAll(FORMATTING_CLICKABLE_PATTERN.pattern(), "");
            }
            if (matcherColor.find()) {
                modText.color = ModifierAttribute.getColor(matcherColor.group());
                text = text.replaceAll(FORMATTING_COLOR_PATTERN.pattern(), "");
            }
            if (matcherBold.find()) {
                modText.bold = ModifierAttribute.isBold(matcherBold.group());
                text = text.replaceAll(FORMATTING_BOLD_PATTERN.pattern(), "");
            }
            if (matcherItalic.find()) {
                modText.italic = ModifierAttribute.isItalic(matcherItalic.group());
                text = text.replaceAll(FORMATTING_ITALIC_PATTERN.pattern(), "");
            }
            if (matcherUnderline.find()) {
                modText.underline = ModifierAttribute.isUnderline(matcherUnderline.group());
                text = text.replaceAll(FORMATTING_UNDERLINED_PATTERN.pattern(), "");
            }
            if (matcherImage.find()) {
                ImageData data = ModifierAttribute.getImagePos(matcherImage.group());
                modText.imageX = data.x;
                modText.imageY = data.y;
                modText.imageScale = data.scale;
                modText.imageName = new String(data.imageName);
                text = text.replaceAll(FORMATTING_IMAGE_PATTERN.pattern(), "");
            }
            if (matcherEnd.find()) {
                modText.text = text = text.replaceAll(FORMATTING_END_PATTERN.pattern(), "");
            }
            if (modText.imageName == "") {
                this.listOfModifyText.add(modText);
                continue;
            }
            this.locationImageList.add(modText);
        }
    }

    public void breakDownText() {
        ArrayList<ModifyText> list = new ArrayList<ModifyText>();
        for (ModifyText modText : this.listOfModifyText) {
            boolean flag1 = false;
            if (!modText.clickable) {
                for (String s : modText.text.split("((?<= )|(?= ))")) {
                    ModifyText copy = modText.copy();
                    if (flag1) {
                        copy.newLines = 0;
                    }
                    flag1 = true;
                    list.add(copy.setText(s));
                }
                continue;
            }
            list.add(modText);
        }
        int widthCount = 0;
        int i = 0;
        for (ModifyText modText : list) {
            double scale = modText.scale;
            i += modText.newLines;
            if (modText.newLines != 0) {
                widthCount = 0;
            }
            if ((widthCount = (int)((double)widthCount + (double)font.func_78256_a(modText.text) * scale)) >= this.width + 10) {
                if (modText.text.equals(" ")) {
                    modText.text = "";
                }
                widthCount = (int)((double)font.func_78256_a(modText.text) * scale);
                ++i;
            }
            if (modText.bold) {
                modText.text = TextFormatting.BOLD + modText.text + TextFormatting.RESET;
            }
            if (modText.italic) {
                modText.text = TextFormatting.ITALIC + modText.text + TextFormatting.RESET;
            }
            if (modText.underline) {
                modText.text = TextFormatting.UNDERLINE + modText.text + TextFormatting.RESET;
            }
            this.map.add(i, modText);
        }
    }

    private void positionText() {
        Iterator itr = this.map.entrySet().iterator();
        float y = 0.0f;
        while (itr.hasNext()) {
            Map.Entry entry = itr.next();
            int key = (Integer)entry.getKey();
            int x = 0;
            if (this.map.maxNewLine(key) != 1 && this.map.maxNewLine(key) != 0) {
                y += (float)(this.map.maxNewLine(key) - 1) * this.map.maxHeight(key);
            }
            List modTextList = (List)entry.getValue();
            for (ModifyText modText : modTextList) {
                float textHeight = (float)((double)GuiModifibleTextBox.font.field_78288_b * modText.scale);
                float maxTextHeight = this.map.maxHeight(key);
                float addY = textHeight - maxTextHeight;
                if (modText.clickable) {
                    this.locationClickableMap.put(new Float[]{Float.valueOf((float)((double)x / modText.scale)), Float.valueOf((float)((double)(y - addY) / modText.scale))}, modText);
                } else {
                    this.locationTextMap.put(new Float[]{Float.valueOf((float)((double)x / modText.scale)), Float.valueOf((float)((double)(y - addY) / modText.scale))}, modText);
                }
                x = (int)((double)x + (double)font.func_78256_a(modText.text) * modText.scale);
            }
            y += this.map.maxHeight(key) + 1.0f;
        }
        this.height = (int)y + 9;
    }

    public boolean isMouseOverClickable(int posX, int posY) {
        for (Map.Entry<Float[], ModifyText> entry : this.locationClickableMap.entrySet()) {
            float x = entry.getKey()[0].floatValue();
            float y = entry.getKey()[1].floatValue();
            ModifyText modText = entry.getValue();
            modText.mouseOver = (float)posX >= x && (double)posX < (double)x + (double)(font.func_78256_a(modText.text) + 5) * modText.scale && (float)posY >= y + 5.0f && (double)posY < (double)(y + 2.0f) + (double)GuiModifibleTextBox.font.field_78288_b * modText.scale;
        }
        return false;
    }

    public boolean isMouseOver(int posX, int posY) {
        boolean results = super.isMouseOver(posX, posY);
        this.isMouseOverClickable(posX, posY);
        return results;
    }

    public void addImages() {
        for (ModifyText text : this.locationImageList) {
            String fileType = text.imageName.split("\\.")[1];
            if (fileType.equals("png") || fileType.equals("jpeg")) {
                this.getParent().addControl((GuiControl)new GuiImage("", "assets/alet/images/" + text.imageName, text.imageX, text.imageY, text.imageScale));
            } else if (fileType.equals("gif")) {
                this.getParent().addControl((GuiControl)new GuiGIF("", "assets/alet/images/" + text.imageName, text.imageX, text.imageY, text.imageScale));
            }
            this.getParent().refreshControls();
        }
    }

    public void mouseReleased(int x, int y, int button) {
        for (ModifyText modText : this.locationClickableMap.values()) {
            if (!modText.mouseOver) continue;
            GuiModifibleTextBox.playSound((SoundEvent)SoundEvents.field_187909_gi);
            this.clickedOn(modText.text);
            modText.mouseOver = false;
        }
    }

    public void clickedOn(String text) {
    }

    protected void renderContent(GuiRenderHelper helper, Style style, int width, int height) {
        ModifyText modText;
        float y;
        float x;
        for (Map.Entry<Float[], ModifyText> entry : this.locationTextMap.entrySet()) {
            x = entry.getKey()[0].floatValue();
            y = entry.getKey()[1].floatValue();
            modText = entry.getValue();
            GlStateManager.func_179094_E();
            GlStateManager.func_179139_a((double)modText.scale, (double)modText.scale, (double)1.0);
            font.func_175065_a(modText.text, x, y, modText.color, true);
            GlStateManager.func_179121_F();
        }
        for (Map.Entry<Float[], ModifyText> entry : this.locationClickableMap.entrySet()) {
            x = entry.getKey()[0].floatValue();
            y = entry.getKey()[1].floatValue();
            modText = entry.getValue();
            modText.text = modText.text.replaceAll("_", " ");
            GlStateManager.func_179094_E();
            GlStateManager.func_179139_a((double)modText.scale, (double)modText.scale, (double)1.0);
            if (modText.mouseOver) {
                font.func_175065_a(modText.text, x, y, -16740609, true);
            } else {
                font.func_175065_a(modText.text, x, y, modText.color, true);
            }
            GlStateManager.func_179121_F();
        }
    }

    public boolean hasBackground() {
        return false;
    }

    public boolean hasBorder() {
        return false;
    }

    private class ModifyTextMap<K, V>
    extends LinkedHashMap<Integer, List<ModifyText>> {
        private ModifyTextMap() {
        }

        public void add(int key, ModifyText singleValue) {
            if (this.containsKey(key)) {
                ((List)this.get(key)).add(singleValue);
            } else {
                ArrayList<ModifyText> modText = new ArrayList<ModifyText>();
                modText.add(singleValue);
                this.put(key, modText);
            }
        }

        public int maxNewLine(int key) {
            int max = 0;
            for (ModifyText modText : (List)this.get(key)) {
                max = Math.max(modText.newLines, max);
            }
            return max;
        }

        public float maxHeight(int key) {
            float max = GuiControl.font.field_78288_b;
            for (ModifyText modText : (List)this.get(key)) {
                max = (float)Math.max(modText.scale * (double)GuiControl.font.field_78288_b, (double)max);
            }
            return max;
        }
    }

    private class ModifyText {
        public double scale = 0.0;
        public int color = -1;
        public boolean clickable = false;
        public boolean italic = false;
        public boolean underline = false;
        public boolean bold = false;
        public String text = "";
        public int newLines = 0;
        public boolean mouseOver = false;
        public int imageX = 0;
        public int imageY = 0;
        public double imageScale = 0.0;
        public String imageName = "";

        public ModifyText() {
        }

        public ModifyText(double scale, int color, boolean clickable, int newLines, String text) {
            this.scale = scale;
            this.color = color;
            this.clickable = clickable;
            this.text = text;
            this.newLines = newLines;
        }

        public ModifyText setText(String text) {
            this.text = text;
            return this;
        }

        public ModifyText copy() {
            ModifyText copy = new ModifyText(this.scale, this.color, this.clickable, this.newLines, this.text);
            copy.bold = this.bold;
            copy.italic = this.italic;
            copy.underline = this.underline;
            return copy;
        }

        public boolean equals(Object obj) {
            ModifyText text = (ModifyText)ModifyText.class.cast(obj);
            return this.scale == text.scale && this.clickable == text.clickable && this.color == text.color && this.newLines == text.newLines && this.text.equals(text.text);
        }

        public String toString() {
            return this.text + ": {scale:" + this.scale + "},{color:" + this.color + "},{clickable:" + this.clickable + "},{newLines:" + this.newLines + "}";
        }
    }

    private static class ImageData {
        public int x;
        public int y;
        public double scale;
        public String imageName;

        public ImageData(int x, int y, double scale, String imageName) {
            this.x = x;
            this.y = y;
            this.scale = scale;
            this.imageName = imageName;
        }
    }

    public static final class ModifierAttribute {
        public static String scale(double scale) {
            return "{scale:" + scale + "}";
        }

        public static String color(int color) {
            return "{color:" + color + "}";
        }

        public static String color(Color color) {
            return "{color:" + ColorUtils.RGBAToInt((Color)color) + "}";
        }

        public static String bold() {
            return "{bold}";
        }

        public static String italic() {
            return "{italic}";
        }

        public static String underline() {
            return "{underline}";
        }

        public static String clickable() {
            return "{clickable}";
        }

        public static String end() {
            return "{end}";
        }

        public static String newLines(int numberOf) {
            return "{newLines:" + numberOf + "}";
        }

        public static String tab() {
            return ModifierAttribute.scale(1.0) + "     " + ModifierAttribute.end();
        }

        public static String addText(double scale, int color, boolean clickable, int newLines, String text, boolean italic, boolean bold, boolean underline) {
            String attribute = italic ? ModifierAttribute.italic() : "";
            attribute = attribute + (bold ? ModifierAttribute.bold() : "");
            attribute = attribute + (underline ? ModifierAttribute.underline() : "");
            String click = clickable ? ModifierAttribute.clickable() : "";
            return ModifierAttribute.scale(scale) + click + ModifierAttribute.color(color) + ModifierAttribute.newLines(newLines) + attribute + text + ModifierAttribute.end();
        }

        public static String addTitle(String text, int line) {
            return ModifierAttribute.addText(2.0, -1, false, line, text, false, true, false);
        }

        public static String addSubTitle(String text, int line) {
            return ModifierAttribute.addText(1.5, -1, false, line, text, false, true, false);
        }

        public static String addSecondSubTitle(String text, int line) {
            return ModifierAttribute.addText(1.2, -1, false, line, text, false, true, false);
        }

        public static String addDefaultText(String text, int line) {
            return ModifierAttribute.addText(1.0, -1, false, line, text, false, false, false);
        }

        public static String addDefintionText(String text) {
            return ModifierAttribute.addText(1.1, 65535, false, 0, text, false, true, false);
        }

        public static String addDefintionText(String text, int line) {
            return ModifierAttribute.addText(1.1, 65535, false, line, text, false, true, false);
        }

        public static String addClickableText(String text) {
            return ModifierAttribute.addText(1.0, -1, true, 0, text, true, true, true);
        }

        public static double getScale(String scale) {
            Matcher matcher = FORMATTING_NUMBER_PATTERN.matcher(scale);
            matcher.find();
            String s = matcher.group();
            return Double.parseDouble(s);
        }

        public static int getColor(String color) {
            Matcher matcher = FORMATTING_NUMBER_PATTERN.matcher(color);
            matcher.find();
            String s = matcher.group();
            return Integer.parseInt(s);
        }

        public static int getNewLines(String newLines) {
            Matcher matcher = FORMATTING_NUMBER_PATTERN.matcher(newLines);
            matcher.find();
            String s = matcher.group();
            return Integer.parseInt(s);
        }

        public static boolean isClickable(String clickable) {
            Matcher matcher = FORMATTING_CLICKABLE_PATTERN.matcher(clickable);
            return matcher.find();
        }

        public static boolean isBold(String clickable) {
            Matcher matcher = FORMATTING_BOLD_PATTERN.matcher(clickable);
            return matcher.find();
        }

        public static boolean isItalic(String clickable) {
            Matcher matcher = FORMATTING_ITALIC_PATTERN.matcher(clickable);
            return matcher.find();
        }

        public static boolean isUnderline(String clickable) {
            Matcher matcher = FORMATTING_UNDERLINED_PATTERN.matcher(clickable);
            return matcher.find();
        }

        public static ImageData getImagePos(String image) {
            Matcher matcher = FORMATTING_DOUBLE_PATTERN.matcher(image);
            int count = 0;
            double[] pos = new double[3];
            while (matcher.find()) {
                pos[count] = Double.parseDouble(matcher.group());
                ++count;
            }
            Matcher m = FORMATTING_DOUBLE_PATTERN.matcher(image);
            matcher = FORMATTING_FILE_PATTERN.matcher(image);
            matcher.find();
            String imageName = matcher.group();
            ImageData data = new ImageData((int)pos[0], (int)pos[1], pos[2], imageName);
            return data;
        }
    }
}

