/*
 * Decompiled with CFR 0.152.
 */
package com.alet.client.gui.controls;

import com.alet.client.gui.controls.GuiFontImage;
import com.alet.client.gui.controls.GuiGlyphSelector;
import com.alet.client.gui.controls.GuiLongTextField;
import com.creativemd.creativecore.common.gui.controls.gui.GuiComboBox;
import com.creativemd.creativecore.common.gui.controls.gui.GuiComboBoxExtension;
import java.awt.Font;
import java.awt.font.TextAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class GuiGlythSelectorExtension
extends GuiComboBoxExtension {
    public String fontr;
    public Map<TextAttribute, Object> textAttributeMap;

    public GuiGlythSelectorExtension(String name, int x, int y, int width, int height, GuiGlyphSelector fontSelector, String font, Map<TextAttribute, Object> textAttributeMap) {
        super(name, (GuiComboBox)fontSelector, x, y, width, height, new ArrayList());
        this.fontr = font;
        this.textAttributeMap = textAttributeMap;
        this.reloadControls();
    }

    public List<Character> collectGlyphs() {
        Font f = new Font(this.fontr, 1, 48);
        ArrayList<Character> glyphs = new ArrayList<Character>();
        for (int c = 0; c <= 65535; ++c) {
            if (!f.canDisplay(Character.toChars(c)[0]) || !Character.isValidCodePoint(c)) continue;
            glyphs.add(Character.valueOf(Character.toChars(c)[0]));
        }
        return glyphs;
    }

    public void reloadControls() {
        if (this.fontr != null) {
            List<Character> glyphs = this.collectGlyphs();
            int rowMax = glyphs.size() / 5;
            int counter = 0;
            for (int r = 0; r <= rowMax; ++r) {
                for (int c = 0; c <= 6 && counter < glyphs.size(); ++counter, ++c) {
                    this.controls.add(new GuiFontImage(glyphs.get(counter).charValue() + "", glyphs.get(counter) + "", c * 13 + 2, r * 13 + 2, this.fontr, this.textAttributeMap, 32, -16777216, 0.0){

                        @Override
                        public void onClicked(int x, int y, int button) {
                            GuiLongTextField text = (GuiLongTextField)this.getParent().getParent().get("input");
                            if (text != null) {
                                int codePoint = Integer.parseInt(this.name);
                                text.text = text.text + (char)codePoint;
                            }
                        }
                    });
                }
            }
        }
    }
}

