/*
 * Decompiled with CFR 0.152.
 */
package com.alet.client.gui.controls;

import com.alet.client.gui.controls.GuiBezierCurve;
import com.creativemd.creativecore.common.gui.GuiControl;
import com.creativemd.creativecore.common.gui.GuiRenderHelper;
import com.creativemd.creativecore.common.gui.client.style.Style;
import com.creativemd.creativecore.common.gui.container.GuiParent;
import com.creativemd.creativecore.common.gui.event.ControlEvent;
import com.creativemd.creativecore.common.gui.event.gui.GuiControlChangedEvent;
import com.creativemd.creativecore.common.gui.event.gui.GuiControlClickEvent;
import com.creativemd.creativecore.common.utils.math.SmoothValue;
import com.n247s.api.eventapi.eventsystem.CustomEventSubscribe;
import java.util.ArrayList;
import net.minecraft.util.math.MathHelper;

public class GuiDragablePanel
extends GuiParent {
    public SmoothValue scrolledX = new SmoothValue(200L);
    public SmoothValue scrolledY = new SmoothValue(200L);
    public SmoothValue zoom = new SmoothValue(200L, 1.0);
    public double startScrollX;
    public double startScrollY;
    public int dragX;
    public int dragY;
    public boolean scrolling;
    public boolean somethingSelected = false;
    public boolean selected = false;
    public int maxWidth;
    public int maxHeight;

    public GuiDragablePanel(String name, int x, int y, int width, int height, int maxWidth, int maxHeight) {
        super(name, x, y, width, height);
        this.maxWidth = maxWidth;
        this.maxHeight = maxHeight;
    }

    public float getScaleFactor() {
        return (float)this.zoom.current();
    }

    public double getOffsetX() {
        return -this.scrolledX.current();
    }

    public double getOffsetY() {
        return -this.scrolledY.current();
    }

    public boolean mouseScrolled(int x, int y, int scrolled) {
        if (!super.mouseScrolled(x, y, scrolled)) {
            this.zoom.set(MathHelper.func_151237_a((double)(this.zoom.aimed() + (double)scrolled * 0.04), (double)0.1, (double)2.0));
        }
        return true;
    }

    @CustomEventSubscribe
    public void update(GuiControlChangedEvent event) {
        System.out.println(event);
    }

    public boolean mousePressed(int x, int y, int button) {
        boolean results = super.mousePressed(x, y, button);
        boolean bl = this.somethingSelected = this.controlOver(x, y, button, this.controls, GuiBezierCurve.class) != null;
        if (button == 2) {
            this.zoom.set(1.0);
            this.scrolledX.set(0.0);
            this.scrolledY.set(0.0);
            return true;
        }
        if (!results) {
            this.scrolling = true;
            this.dragX = x;
            this.dragY = y;
            this.startScrollX = this.scrolledX.current();
            this.startScrollY = this.scrolledY.current();
        }
        this.raiseEvent((ControlEvent)new GuiControlClickEvent((GuiControl)this, x, y, button));
        return results;
    }

    public GuiControl controlOver(int x, int y, int button, ArrayList<GuiControl> controls, Class<? extends GuiControl> exclude) {
        for (GuiControl control : controls) {
            GuiControl found;
            if (!control.getClass().isAssignableFrom(exclude) && control.isMouseOver()) {
                return control;
            }
            if (!(control instanceof GuiParent) || (found = this.controlOver(x, y, button, ((GuiParent)control).controls, exclude)) == null) continue;
            return found;
        }
        return null;
    }

    public void mouseDragged(int x, int y, int button, long time) {
        if (!this.somethingSelected && this.isMouseOver() && this.controlOver(x, y, button, this.controls, GuiBezierCurve.class) == null && !this.selected && this.scrolling) {
            this.scrolledX.set(MathHelper.func_151237_a((double)((double)(this.dragX - x) + this.startScrollX), (double)0.0, (double)this.maxWidth));
            this.scrolledY.set(MathHelper.func_151237_a((double)((double)(this.dragY - y) + this.startScrollY), (double)0.0, (double)this.maxHeight));
        }
        super.mouseDragged(x, y, button, time);
    }

    protected void renderContent(GuiRenderHelper helper, Style style, int width, int height) {
        this.scrolledX.tick();
        this.scrolledY.tick();
        this.zoom.tick();
    }

    public void mouseReleased(int x, int y, int button) {
        super.mouseReleased(x, y, button);
        this.scrolling = false;
        this.somethingSelected = false;
    }
}

