/*
 * Decompiled with CFR 0.152.
 */
package com.alet.client.gui.controls;

import com.alet.client.gui.controls.programmable.nodes.GuiNodeValue;
import com.alet.common.utils.RenderUtils;
import com.creativemd.creativecore.common.gui.CoreControl;
import com.creativemd.creativecore.common.gui.GuiControl;
import com.creativemd.creativecore.common.gui.GuiRenderHelper;
import com.creativemd.creativecore.common.gui.client.style.Style;
import com.creativemd.creativecore.common.gui.container.GuiParent;
import javax.vecmath.Point2i;

public class GuiBezierCurve
extends GuiParent {
    public Point2i p0 = new Point2i(0, 0);
    public Point2i p1 = new Point2i(0, 0);
    public Point2i p2 = new Point2i(0, 0);
    public Point2i p3 = new Point2i(0, 0);
    public GuiControl p0LockOn;
    public GuiControl p3LockOn;
    public int backColor;

    public GuiBezierCurve(String name, GuiControl p0LockOn, GuiControl p3LockOn, int width, int height, int backColor) {
        super(name, 0, 0, width, height);
        this.p0LockOn = p0LockOn;
        this.p3LockOn = p3LockOn;
        this.backColor = backColor;
    }

    public GuiBezierCurve(String name, int x, int y, int width, int height) {
        super(name, x, y, width, height);
    }

    protected void renderContent(GuiRenderHelper helper, Style style, int width, int height) {
        int xOffSet2;
        int multi = 20;
        GuiNodeValue node1 = (GuiNodeValue)this.p0LockOn;
        GuiNodeValue node2 = (GuiNodeValue)this.p3LockOn;
        if (this.p0LockOn != null && this.p3LockOn == null) {
            int xOffSet1 = node1.isSender() ? node1.width - 2 : -5;
            this.p0.x = this.p0LockOn.posX + this.p0LockOn.getParent().posX + xOffSet1;
            this.p0.y = this.p0LockOn.posY + this.p0LockOn.getParent().posY;
            this.p3.x = (int)this.getMousePos().field_72450_a;
            this.p3.y = (int)this.getMousePos().field_72448_b;
        } else if (this.p3LockOn != null && this.p0LockOn == null) {
            xOffSet2 = node2.isSender() ? node2.width - 2 : -5;
            this.p0.x = (int)this.getMousePos().field_72450_a;
            this.p0.y = (int)this.getMousePos().field_72448_b;
            this.p3.x = this.p3LockOn.posX + this.p3LockOn.getParent().posX + xOffSet2;
            this.p3.y = this.p3LockOn.posY + this.p3LockOn.getParent().posY;
        } else {
            xOffSet2 = node2.isSender() ? node2.width - 2 : -5;
            int xOffSet1 = node1.isSender() ? node1.width - 2 : -5;
            this.p0.x = this.p0LockOn.posX + this.p0LockOn.getParent().posX + xOffSet1;
            this.p0.y = this.p0LockOn.posY + this.p0LockOn.getParent().posY;
            this.p3.x = this.p3LockOn.posX + this.p3LockOn.getParent().posX + xOffSet2;
            this.p3.y = this.p3LockOn.posY + this.p3LockOn.getParent().posY;
        }
        int centerX = this.p0.x - this.p3.x;
        this.p1.x = centerX / 2 + this.p3.x;
        this.p1.y = this.p0.y;
        this.p2.x = centerX / 2 + this.p3.x;
        this.p2.y = this.p3.y;
        RenderUtils.drawCubicBezier(new Point2i((this.p0.x + 4) * multi, (this.p0.y + 4) * multi), new Point2i(this.p1.x * multi, (this.p1.y + 4) * multi), new Point2i(this.p2.x * multi, (this.p2.y + 4) * multi), new Point2i((this.p3.x + 4) * multi, (this.p3.y + 4) * multi), this.backColor);
    }

    public boolean hasBackground() {
        return false;
    }

    public boolean hasBorder() {
        return false;
    }

    private class GuiDragNode
    extends GuiControl {
        boolean selected;

        public GuiDragNode(String name, int x, int y) {
            super(name, x, y, 1, 1);
            this.selected = false;
        }

        public boolean hasBackground() {
            return false;
        }

        public boolean hasBorder() {
            return false;
        }

        public boolean mousePressed(int x, int y, int button) {
            boolean results = this.isMouseOver();
            if (results) {
                this.selected = true;
                this.getGui().moveControlToTop((CoreControl)this);
            }
            return results;
        }

        public void mouseReleased(int x, int y, int button) {
            this.selected = false;
        }

        public void mouseDragged(int x, int y, int button, long time) {
            if (this.selected && x < this.getParent().width - 7 && x > 2 && y < this.getParent().height - 7 && y > 2) {
                this.posX = x - this.width / 2;
                this.posY = y - this.height / 2;
            }
        }

        protected void renderContent(GuiRenderHelper helper, Style style, int width, int height) {
            if (this.name.equals("p0")) {
                helper.drawRect(0.0, 0.0, 3.0, 3.0, -65536);
            }
            if (this.name.equals("p1")) {
                helper.drawRect(0.0, 0.0, 3.0, 3.0, -16711936);
            }
            if (this.name.equals("p2")) {
                helper.drawRect(0.0, 0.0, 3.0, 3.0, -23296);
            }
            if (this.name.equals("p3")) {
                helper.drawRect(0.0, 0.0, 3.0, 3.0, -16776961);
            }
        }
    }
}

